/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.opentelemetry.trace;

import com.google.api.client.util.Preconditions;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.rpc.FixedTransportChannelProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.opentelemetry.trace.CloudTraceClient;
import com.google.cloud.opentelemetry.trace.CloudTraceClientImpl;
import com.google.cloud.opentelemetry.trace.TraceConfiguration;
import com.google.cloud.opentelemetry.trace.TraceTranslator;
import com.google.cloud.opentelemetry.trace.TraceVersions;
import com.google.cloud.trace.v2.TraceServiceClient;
import com.google.cloud.trace.v2.TraceServiceSettings;
import com.google.cloud.trace.v2.stub.TraceServiceStub;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.cloudtrace.v2.AttributeValue;
import com.google.devtools.cloudtrace.v2.ProjectName;
import com.google.devtools.cloudtrace.v2.Span;
import io.grpc.ManagedChannelBuilder;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.threeten.bp.Duration;

public class TraceExporter
implements SpanExporter {
    private final CloudTraceClient cloudTraceClient;
    private final ProjectName projectName;
    private final String projectId;
    private final TraceTranslator translator;
    private static final Map<String, String> HEADERS = Map.of("User-Agent", "opentelemetry-operations-java/" + TraceVersions.EXPORTER_VERSION);
    private static final HeaderProvider HEADER_PROVIDER = () -> HEADERS;

    public static TraceExporter createWithDefaultConfiguration() throws IOException {
        TraceConfiguration configuration = TraceConfiguration.builder().build();
        return TraceExporter.createWithConfiguration(configuration);
    }

    public static TraceExporter createWithConfiguration(TraceConfiguration configuration) throws IOException {
        String projectId = configuration.getProjectId();
        TraceServiceStub stub = configuration.getTraceServiceStub();
        if (stub == null) {
            TraceServiceSettings.Builder builder = TraceServiceSettings.newBuilder();
            builder.batchWriteSpansSettings().setSimpleTimeoutNoRetries(Duration.ofMillis(configuration.getDeadline().toMillis()));
            if (configuration.getInsecureEndpoint()) {
                builder.setCredentialsProvider(NoCredentialsProvider.create());
                builder.setTransportChannelProvider(FixedTransportChannelProvider.create(GrpcTransportChannel.create(((ManagedChannelBuilder)ManagedChannelBuilder.forTarget(configuration.getTraceServiceEndpoint()).usePlaintext()).build())));
            } else {
                Credentials credentials = configuration.getCredentials() == null ? GoogleCredentials.getApplicationDefault() : configuration.getCredentials();
                builder.setCredentialsProvider(FixedCredentialsProvider.create(Preconditions.checkNotNull(credentials, "credentials")));
                builder.setEndpoint(configuration.getTraceServiceEndpoint());
                builder.setHeaderProvider(HEADER_PROVIDER);
            }
            return new TraceExporter(projectId, new CloudTraceClientImpl(TraceServiceClient.create(builder.build())), configuration.getAttributeMapping(), configuration.getFixedAttributes());
        }
        return TraceExporter.createWithClient(projectId, new CloudTraceClientImpl(TraceServiceClient.create(stub)), configuration.getAttributeMapping(), configuration.getFixedAttributes());
    }

    private static TraceExporter createWithClient(String projectId, CloudTraceClient cloudTraceClient, ImmutableMap<String, String> attributeMappings, Map<String, AttributeValue> fixedAttributes) {
        return new TraceExporter(projectId, cloudTraceClient, attributeMappings, fixedAttributes);
    }

    TraceExporter(String projectId, CloudTraceClient cloudTraceClient, ImmutableMap<String, String> attributeMappings, Map<String, AttributeValue> fixedAttributes) {
        this.projectId = projectId;
        this.cloudTraceClient = cloudTraceClient;
        this.projectName = ProjectName.of(projectId);
        this.translator = new TraceTranslator(attributeMappings, fixedAttributes);
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode export(Collection<SpanData> spanDataList) {
        ArrayList<Span> spans = new ArrayList<Span>(spanDataList.size());
        for (SpanData spanData : spanDataList) {
            spans.add(this.translator.generateSpan(spanData, this.projectId));
        }
        this.cloudTraceClient.batchWriteSpans(this.projectName, spans);
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        this.cloudTraceClient.shutdown();
        return CompletableResultCode.ofSuccess();
    }
}

