/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.opentelemetry.trace;

import com.google.auth.Credentials;
import com.google.auto.value.AutoValue;
import com.google.cloud.ServiceOptions;
import com.google.cloud.opentelemetry.trace.AutoValue_TraceConfiguration;
import com.google.cloud.trace.v2.stub.TraceServiceStub;
import com.google.cloud.trace.v2.stub.TraceServiceStubSettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.cloudtrace.v2.AttributeValue;
import java.time.Duration;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
public abstract class TraceConfiguration {
    private static final String DEFAULT_PROJECT_ID = Strings.nullToEmpty(ServiceOptions.getDefaultProjectId());
    @VisibleForTesting
    static final Duration DEFAULT_DEADLINE = Duration.ofSeconds(10L, 0L);
    @VisibleForTesting
    static final ImmutableMap<String, String> DEFAULT_ATTRIBUTE_MAPPING = ImmutableMap.builder().put("http.host", "/http/host").put("http.method", "/http/method").put("http.target", "/http/path").put("http.status_code", "/http/status_code").put("http.url", "/http/url").put("http.request_content_length", "/http/request/size").put("http.response_content_length", "/http/response/size").put("http.scheme", "/http/client_protocol").put("http.route", "/http/route").put("http.user_agent", "/http/user_agent").put("exception.type", "/error/name").put("exception.message", "/error/message").put("thread.id", "/tid").build();

    TraceConfiguration() {
    }

    @Nullable
    public abstract Credentials getCredentials();

    public abstract String getProjectId();

    @Nullable
    @Deprecated
    public abstract TraceServiceStub getTraceServiceStub();

    @Nullable
    public abstract String getTraceServiceEndpoint();

    public abstract Map<String, AttributeValue> getFixedAttributes();

    public abstract ImmutableMap<String, String> getAttributeMapping();

    public abstract Duration getDeadline();

    @VisibleForTesting
    abstract boolean getInsecureEndpoint();

    public static Builder builder() {
        return new AutoValue_TraceConfiguration.Builder().setProjectId(DEFAULT_PROJECT_ID).setFixedAttributes(Collections.emptyMap()).setDeadline(DEFAULT_DEADLINE).setTraceServiceEndpoint(TraceServiceStubSettings.getDefaultEndpoint()).setInsecureEndpoint(false).setAttributeMapping(DEFAULT_ATTRIBUTE_MAPPING);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @VisibleForTesting
        static final Duration ZERO = Duration.ZERO;

        Builder() {
        }

        public abstract Builder setCredentials(Credentials var1);

        public abstract Builder setProjectId(String var1);

        @Deprecated
        public abstract Builder setTraceServiceStub(TraceServiceStub var1);

        public abstract Builder setTraceServiceEndpoint(String var1);

        public abstract Builder setFixedAttributes(Map<String, AttributeValue> var1);

        public abstract Builder setAttributeMapping(ImmutableMap<String, String> var1);

        public abstract ImmutableMap.Builder<String, String> attributeMappingBuilder();

        public final Builder addAttributeMapping(String otelKey, String gcpKey) {
            this.attributeMappingBuilder().put(otelKey, gcpKey);
            return this;
        }

        public abstract Builder setDeadline(Duration var1);

        abstract String getProjectId();

        abstract Map<String, AttributeValue> getFixedAttributes();

        abstract Duration getDeadline();

        @VisibleForTesting
        abstract Builder setInsecureEndpoint(boolean var1);

        abstract TraceConfiguration autoBuild();

        public TraceConfiguration build() {
            this.setFixedAttributes(Collections.unmodifiableMap(new LinkedHashMap<String, AttributeValue>(this.getFixedAttributes())));
            Preconditions.checkArgument(!Strings.isNullOrEmpty(this.getProjectId()), "Cannot find a project ID from either configurations or application default.");
            for (Map.Entry<String, AttributeValue> fixedAttribute : this.getFixedAttributes().entrySet()) {
                Preconditions.checkNotNull(fixedAttribute.getKey(), "attribute key");
                Preconditions.checkNotNull(fixedAttribute.getValue(), "attribute value");
            }
            Preconditions.checkArgument(this.getDeadline().compareTo(ZERO) > 0, "Deadline must be positive.");
            return this.autoBuild();
        }
    }
}

