/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.opentelemetry.metric;

import com.google.auth.Credentials;
import com.google.cloud.opentelemetry.metric.MetricConfiguration;
import com.google.cloud.opentelemetry.metric.MetricDescriptorStrategy;
import com.google.common.annotations.VisibleForTesting;
import java.time.Duration;
import javax.annotation.Nullable;

final class AutoValue_MetricConfiguration
extends MetricConfiguration {
    private final Credentials credentials;
    private final String projectId;
    private final String prefix;
    private final Duration deadline;
    private final MetricDescriptorStrategy descriptorStrategy;
    private final String metricServiceEndpoint;
    private final boolean insecureEndpoint;

    private AutoValue_MetricConfiguration(@Nullable Credentials credentials, String projectId, String prefix, Duration deadline, MetricDescriptorStrategy descriptorStrategy, @Nullable String metricServiceEndpoint, boolean insecureEndpoint) {
        this.credentials = credentials;
        this.projectId = projectId;
        this.prefix = prefix;
        this.deadline = deadline;
        this.descriptorStrategy = descriptorStrategy;
        this.metricServiceEndpoint = metricServiceEndpoint;
        this.insecureEndpoint = insecureEndpoint;
    }

    @Override
    @Nullable
    public Credentials getCredentials() {
        return this.credentials;
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public Duration getDeadline() {
        return this.deadline;
    }

    @Override
    public MetricDescriptorStrategy getDescriptorStrategy() {
        return this.descriptorStrategy;
    }

    @Override
    @Nullable
    public String getMetricServiceEndpoint() {
        return this.metricServiceEndpoint;
    }

    @Override
    @VisibleForTesting
    boolean getInsecureEndpoint() {
        return this.insecureEndpoint;
    }

    public String toString() {
        return "MetricConfiguration{credentials=" + String.valueOf(this.credentials) + ", projectId=" + this.projectId + ", prefix=" + this.prefix + ", deadline=" + String.valueOf(this.deadline) + ", descriptorStrategy=" + String.valueOf(this.descriptorStrategy) + ", metricServiceEndpoint=" + this.metricServiceEndpoint + ", insecureEndpoint=" + this.insecureEndpoint + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MetricConfiguration) {
            MetricConfiguration that = (MetricConfiguration)o;
            return (this.credentials == null ? that.getCredentials() == null : this.credentials.equals(that.getCredentials())) && this.projectId.equals(that.getProjectId()) && this.prefix.equals(that.getPrefix()) && this.deadline.equals(that.getDeadline()) && this.descriptorStrategy.equals(that.getDescriptorStrategy()) && (this.metricServiceEndpoint == null ? that.getMetricServiceEndpoint() == null : this.metricServiceEndpoint.equals(that.getMetricServiceEndpoint())) && this.insecureEndpoint == that.getInsecureEndpoint();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.credentials == null ? 0 : this.credentials.hashCode();
        h$ *= 1000003;
        h$ ^= this.projectId.hashCode();
        h$ *= 1000003;
        h$ ^= this.prefix.hashCode();
        h$ *= 1000003;
        h$ ^= this.deadline.hashCode();
        h$ *= 1000003;
        h$ ^= this.descriptorStrategy.hashCode();
        h$ *= 1000003;
        h$ ^= this.metricServiceEndpoint == null ? 0 : this.metricServiceEndpoint.hashCode();
        h$ *= 1000003;
        return h$ ^= this.insecureEndpoint ? 1231 : 1237;
    }

    static final class Builder
    extends MetricConfiguration.Builder {
        private Credentials credentials;
        private String projectId;
        private String prefix;
        private Duration deadline;
        private MetricDescriptorStrategy descriptorStrategy;
        private String metricServiceEndpoint;
        private boolean insecureEndpoint;
        private byte set$0;

        Builder() {
        }

        @Override
        public MetricConfiguration.Builder setCredentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        @Override
        public MetricConfiguration.Builder setProjectId(String projectId) {
            if (projectId == null) {
                throw new NullPointerException("Null projectId");
            }
            this.projectId = projectId;
            return this;
        }

        @Override
        String getProjectId() {
            if (this.projectId == null) {
                throw new IllegalStateException("Property \"projectId\" has not been set");
            }
            return this.projectId;
        }

        @Override
        public MetricConfiguration.Builder setPrefix(String prefix) {
            if (prefix == null) {
                throw new NullPointerException("Null prefix");
            }
            this.prefix = prefix;
            return this;
        }

        @Override
        public MetricConfiguration.Builder setDeadline(Duration deadline) {
            if (deadline == null) {
                throw new NullPointerException("Null deadline");
            }
            this.deadline = deadline;
            return this;
        }

        @Override
        Duration getDeadline() {
            if (this.deadline == null) {
                throw new IllegalStateException("Property \"deadline\" has not been set");
            }
            return this.deadline;
        }

        @Override
        public MetricConfiguration.Builder setDescriptorStrategy(MetricDescriptorStrategy descriptorStrategy) {
            if (descriptorStrategy == null) {
                throw new NullPointerException("Null descriptorStrategy");
            }
            this.descriptorStrategy = descriptorStrategy;
            return this;
        }

        @Override
        public MetricConfiguration.Builder setMetricServiceEndpoint(String metricServiceEndpoint) {
            this.metricServiceEndpoint = metricServiceEndpoint;
            return this;
        }

        @Override
        MetricConfiguration.Builder setInsecureEndpoint(boolean insecureEndpoint) {
            this.insecureEndpoint = insecureEndpoint;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        MetricConfiguration autoBuild() {
            if (this.set$0 != 1 || this.projectId == null || this.prefix == null || this.deadline == null || this.descriptorStrategy == null) {
                StringBuilder missing = new StringBuilder();
                if (this.projectId == null) {
                    missing.append(" projectId");
                }
                if (this.prefix == null) {
                    missing.append(" prefix");
                }
                if (this.deadline == null) {
                    missing.append(" deadline");
                }
                if (this.descriptorStrategy == null) {
                    missing.append(" descriptorStrategy");
                }
                if ((this.set$0 & 1) == 0) {
                    missing.append(" insecureEndpoint");
                }
                throw new IllegalStateException("Missing required properties:" + String.valueOf(missing));
            }
            return new AutoValue_MetricConfiguration(this.credentials, this.projectId, this.prefix, this.deadline, this.descriptorStrategy, this.metricServiceEndpoint, this.insecureEndpoint);
        }
    }
}

