/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.opentelemetry.detectors;

import com.google.cloud.opentelemetry.detection.DetectedPlatform;
import com.google.cloud.opentelemetry.detection.GCPPlatformDetector;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ResourceProvider;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.ResourceAttributes;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;

public class GCPResource
implements ResourceProvider {
    private static final Logger LOGGER = Logger.getLogger(GCPResource.class.getSimpleName());
    private final GCPPlatformDetector detector;

    GCPResource(GCPPlatformDetector detector) {
        this.detector = detector;
    }

    public GCPResource() {
        this.detector = GCPPlatformDetector.DEFAULT_INSTANCE;
    }

    public Attributes getAttributes() {
        DetectedPlatform detectedPlatform = this.detector.detectPlatform();
        if (detectedPlatform.getSupportedPlatform() == GCPPlatformDetector.SupportedPlatform.UNKNOWN_PLATFORM) {
            return Attributes.empty();
        }
        AttributesBuilder attrBuilder = Attributes.builder();
        attrBuilder.put(ResourceAttributes.CLOUD_PROVIDER, (Object)"gcp");
        attrBuilder.put(ResourceAttributes.CLOUD_ACCOUNT_ID, (Object)detectedPlatform.getProjectId());
        switch (detectedPlatform.getSupportedPlatform()) {
            case GOOGLE_KUBERNETES_ENGINE: {
                this.addGKEAttributes(attrBuilder, detectedPlatform.getAttributes());
                break;
            }
            case GOOGLE_CLOUD_RUN: {
                this.addGCRAttributes(attrBuilder, detectedPlatform.getAttributes());
                break;
            }
            case GOOGLE_CLOUD_FUNCTIONS: {
                this.addGCFAttributes(attrBuilder, detectedPlatform.getAttributes());
                break;
            }
            case GOOGLE_APP_ENGINE: {
                this.addGAEAttributes(attrBuilder, detectedPlatform.getAttributes());
                break;
            }
            case GOOGLE_COMPUTE_ENGINE: {
                this.addGCEAttributes(attrBuilder, detectedPlatform.getAttributes());
                break;
            }
        }
        return attrBuilder.build();
    }

    public Resource createResource(ConfigProperties config) {
        return Resource.create((Attributes)this.getAttributes());
    }

    private void addGCEAttributes(AttributesBuilder attrBuilder, Map<String, String> attributesMap) {
        attrBuilder.put(ResourceAttributes.CLOUD_PLATFORM, (Object)"gcp_compute_engine");
        Optional.ofNullable(attributesMap.get("availability_zone")).ifPresent(zone -> attrBuilder.put(ResourceAttributes.CLOUD_AVAILABILITY_ZONE, zone));
        Optional.ofNullable(attributesMap.get("cloud_region")).ifPresent(region -> attrBuilder.put(ResourceAttributes.CLOUD_REGION, region));
        Optional.ofNullable(attributesMap.get("instance_id")).ifPresent(instanceId -> attrBuilder.put(ResourceAttributes.HOST_ID, instanceId));
        Optional.ofNullable(attributesMap.get("instance_name")).ifPresent(instanceName -> {
            attrBuilder.put(ResourceAttributes.HOST_NAME, instanceName);
            attrBuilder.put(ResourceAttributes.GCP_GCE_INSTANCE_NAME, instanceName);
        });
        Optional.ofNullable(attributesMap.get("instance_hostname")).ifPresent(instanceHostname -> attrBuilder.put(ResourceAttributes.GCP_GCE_INSTANCE_HOSTNAME, instanceHostname));
        Optional.ofNullable(attributesMap.get("machine_type")).ifPresent(machineType -> attrBuilder.put(ResourceAttributes.HOST_TYPE, machineType));
    }

    private void addGKEAttributes(AttributesBuilder attrBuilder, Map<String, String> attributesMap) {
        attrBuilder.put(ResourceAttributes.CLOUD_PLATFORM, (Object)"gcp_kubernetes_engine");
        Optional.ofNullable(attributesMap.get("gke_cluster_name")).ifPresent(clusterName -> attrBuilder.put(ResourceAttributes.K8S_CLUSTER_NAME, clusterName));
        Optional.ofNullable(attributesMap.get("instance_id")).ifPresent(hostId -> attrBuilder.put(ResourceAttributes.HOST_ID, hostId));
        Optional.ofNullable(attributesMap.get("gke_cluster_location_type")).ifPresent(locationType -> {
            if (attributesMap.get("gke_cluster_location") != null) {
                switch (locationType) {
                    case "REGION": {
                        attrBuilder.put(ResourceAttributes.CLOUD_REGION, (Object)((String)attributesMap.get("gke_cluster_location")));
                        break;
                    }
                    case "ZONE": {
                        attrBuilder.put(ResourceAttributes.CLOUD_AVAILABILITY_ZONE, (Object)((String)attributesMap.get("gke_cluster_location")));
                    }
                    default: {
                        LOGGER.severe(String.format("Unrecognized format for cluster location: %s", attributesMap.get("gke_cluster_location")));
                    }
                }
            }
        });
    }

    private void addGCRAttributes(AttributesBuilder attrBuilder, Map<String, String> attributesMap) {
        attrBuilder.put(ResourceAttributes.CLOUD_PLATFORM, (Object)"gcp_cloud_run");
        this.addCommonAttributesForServerlessCompute(attrBuilder, attributesMap);
    }

    private void addGCFAttributes(AttributesBuilder attrBuilder, Map<String, String> attributesMap) {
        attrBuilder.put(ResourceAttributes.CLOUD_PLATFORM, (Object)"gcp_cloud_functions");
        this.addCommonAttributesForServerlessCompute(attrBuilder, attributesMap);
    }

    private void addGAEAttributes(AttributesBuilder attrBuilder, Map<String, String> attributesMap) {
        attrBuilder.put(ResourceAttributes.CLOUD_PLATFORM, (Object)"gcp_app_engine");
        Optional.ofNullable(attributesMap.get("gae_module_name")).ifPresent(appName -> attrBuilder.put(ResourceAttributes.FAAS_NAME, appName));
        Optional.ofNullable(attributesMap.get("gae_app_version")).ifPresent(appVersion -> attrBuilder.put(ResourceAttributes.FAAS_VERSION, appVersion));
        Optional.ofNullable(attributesMap.get("instance_id")).ifPresent(appInstanceId -> attrBuilder.put(ResourceAttributes.FAAS_INSTANCE, appInstanceId));
        Optional.ofNullable(attributesMap.get("cloud_region")).ifPresent(cloudRegion -> attrBuilder.put(ResourceAttributes.CLOUD_REGION, cloudRegion));
        Optional.ofNullable(attributesMap.get("availability_zone")).ifPresent(cloudAvailabilityZone -> attrBuilder.put(ResourceAttributes.CLOUD_AVAILABILITY_ZONE, cloudAvailabilityZone));
    }

    private void addCommonAttributesForServerlessCompute(AttributesBuilder attrBuilder, Map<String, String> attributesMap) {
        Optional.ofNullable(attributesMap.get("serverless_compute_name")).ifPresent(name -> attrBuilder.put(ResourceAttributes.FAAS_NAME, name));
        Optional.ofNullable(attributesMap.get("serverless_compute_revision")).ifPresent(revision -> attrBuilder.put(ResourceAttributes.FAAS_VERSION, revision));
        Optional.ofNullable(attributesMap.get("instance_id")).ifPresent(instanceId -> attrBuilder.put(ResourceAttributes.FAAS_INSTANCE, instanceId));
        Optional.ofNullable(attributesMap.get("availability_zone")).ifPresent(zone -> attrBuilder.put(ResourceAttributes.CLOUD_AVAILABILITY_ZONE, zone));
        Optional.ofNullable(attributesMap.get("cloud_region")).ifPresent(region -> attrBuilder.put(ResourceAttributes.CLOUD_REGION, region));
    }
}

