/*
 * Decompiled with CFR 0.152.
 */
package com.google.iam.v2beta.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v2beta.CreatePolicyRequest;
import com.google.iam.v2beta.DeletePolicyRequest;
import com.google.iam.v2beta.GetPolicyRequest;
import com.google.iam.v2beta.ListPoliciesRequest;
import com.google.iam.v2beta.ListPoliciesResponse;
import com.google.iam.v2beta.PoliciesClient;
import com.google.iam.v2beta.Policy;
import com.google.iam.v2beta.PolicyOperationMetadata;
import com.google.iam.v2beta.UpdatePolicyRequest;
import com.google.iam.v2beta.stub.GrpcPoliciesStub;
import com.google.iam.v2beta.stub.HttpJsonPoliciesStub;
import com.google.iam.v2beta.stub.PoliciesStub;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class PoliciesStubSettings
extends StubSettings<PoliciesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListPoliciesRequest, ListPoliciesResponse, PoliciesClient.ListPoliciesPagedResponse> listPoliciesSettings;
    private final UnaryCallSettings<GetPolicyRequest, Policy> getPolicySettings;
    private final UnaryCallSettings<CreatePolicyRequest, Operation> createPolicySettings;
    private final OperationCallSettings<CreatePolicyRequest, Policy, PolicyOperationMetadata> createPolicyOperationSettings;
    private final UnaryCallSettings<UpdatePolicyRequest, Operation> updatePolicySettings;
    private final OperationCallSettings<UpdatePolicyRequest, Policy, PolicyOperationMetadata> updatePolicyOperationSettings;
    private final UnaryCallSettings<DeletePolicyRequest, Operation> deletePolicySettings;
    private final OperationCallSettings<DeletePolicyRequest, Policy, PolicyOperationMetadata> deletePolicyOperationSettings;
    private static final PagedListDescriptor<ListPoliciesRequest, ListPoliciesResponse, Policy> LIST_POLICIES_PAGE_STR_DESC = new PagedListDescriptor<ListPoliciesRequest, ListPoliciesResponse, Policy>(){

        public String emptyToken() {
            return "";
        }

        public ListPoliciesRequest injectToken(ListPoliciesRequest payload, String token) {
            return ListPoliciesRequest.newBuilder((ListPoliciesRequest)payload).setPageToken(token).build();
        }

        public ListPoliciesRequest injectPageSize(ListPoliciesRequest payload, int pageSize) {
            return ListPoliciesRequest.newBuilder((ListPoliciesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListPoliciesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListPoliciesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Policy> extractResources(ListPoliciesResponse payload) {
            return payload.getPoliciesList();
        }
    };
    private static final PagedListResponseFactory<ListPoliciesRequest, ListPoliciesResponse, PoliciesClient.ListPoliciesPagedResponse> LIST_POLICIES_PAGE_STR_FACT = new PagedListResponseFactory<ListPoliciesRequest, ListPoliciesResponse, PoliciesClient.ListPoliciesPagedResponse>(){

        public ApiFuture<PoliciesClient.ListPoliciesPagedResponse> getFuturePagedResponse(UnaryCallable<ListPoliciesRequest, ListPoliciesResponse> callable, ListPoliciesRequest request, ApiCallContext context, ApiFuture<ListPoliciesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_POLICIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PoliciesClient.ListPoliciesPagedResponse.createAsync((PageContext<ListPoliciesRequest, ListPoliciesResponse, Policy>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListPoliciesRequest, ListPoliciesResponse, PoliciesClient.ListPoliciesPagedResponse> listPoliciesSettings() {
        return this.listPoliciesSettings;
    }

    public UnaryCallSettings<GetPolicyRequest, Policy> getPolicySettings() {
        return this.getPolicySettings;
    }

    public UnaryCallSettings<CreatePolicyRequest, Operation> createPolicySettings() {
        return this.createPolicySettings;
    }

    public OperationCallSettings<CreatePolicyRequest, Policy, PolicyOperationMetadata> createPolicyOperationSettings() {
        return this.createPolicyOperationSettings;
    }

    public UnaryCallSettings<UpdatePolicyRequest, Operation> updatePolicySettings() {
        return this.updatePolicySettings;
    }

    public OperationCallSettings<UpdatePolicyRequest, Policy, PolicyOperationMetadata> updatePolicyOperationSettings() {
        return this.updatePolicyOperationSettings;
    }

    public UnaryCallSettings<DeletePolicyRequest, Operation> deletePolicySettings() {
        return this.deletePolicySettings;
    }

    public OperationCallSettings<DeletePolicyRequest, Policy, PolicyOperationMetadata> deletePolicyOperationSettings() {
        return this.deletePolicyOperationSettings;
    }

    public PoliciesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcPoliciesStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonPoliciesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "iam";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "iam.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "iam.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return PoliciesStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(PoliciesStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(PoliciesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return PoliciesStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected PoliciesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listPoliciesSettings = settingsBuilder.listPoliciesSettings().build();
        this.getPolicySettings = settingsBuilder.getPolicySettings().build();
        this.createPolicySettings = settingsBuilder.createPolicySettings().build();
        this.createPolicyOperationSettings = settingsBuilder.createPolicyOperationSettings().build();
        this.updatePolicySettings = settingsBuilder.updatePolicySettings().build();
        this.updatePolicyOperationSettings = settingsBuilder.updatePolicyOperationSettings().build();
        this.deletePolicySettings = settingsBuilder.deletePolicySettings().build();
        this.deletePolicyOperationSettings = settingsBuilder.deletePolicyOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<PoliciesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListPoliciesRequest, ListPoliciesResponse, PoliciesClient.ListPoliciesPagedResponse> listPoliciesSettings;
        private final UnaryCallSettings.Builder<GetPolicyRequest, Policy> getPolicySettings;
        private final UnaryCallSettings.Builder<CreatePolicyRequest, Operation> createPolicySettings;
        private final OperationCallSettings.Builder<CreatePolicyRequest, Policy, PolicyOperationMetadata> createPolicyOperationSettings;
        private final UnaryCallSettings.Builder<UpdatePolicyRequest, Operation> updatePolicySettings;
        private final OperationCallSettings.Builder<UpdatePolicyRequest, Policy, PolicyOperationMetadata> updatePolicyOperationSettings;
        private final UnaryCallSettings.Builder<DeletePolicyRequest, Operation> deletePolicySettings;
        private final OperationCallSettings.Builder<DeletePolicyRequest, Policy, PolicyOperationMetadata> deletePolicyOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listPoliciesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_POLICIES_PAGE_STR_FACT);
            this.getPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createPolicyOperationSettings = OperationCallSettings.newBuilder();
            this.updatePolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updatePolicyOperationSettings = OperationCallSettings.newBuilder();
            this.deletePolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deletePolicyOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listPoliciesSettings, this.getPolicySettings, this.createPolicySettings, this.updatePolicySettings, this.deletePolicySettings);
            Builder.initDefaults(this);
        }

        protected Builder(PoliciesStubSettings settings) {
            super((StubSettings)settings);
            this.listPoliciesSettings = settings.listPoliciesSettings.toBuilder();
            this.getPolicySettings = settings.getPolicySettings.toBuilder();
            this.createPolicySettings = settings.createPolicySettings.toBuilder();
            this.createPolicyOperationSettings = settings.createPolicyOperationSettings.toBuilder();
            this.updatePolicySettings = settings.updatePolicySettings.toBuilder();
            this.updatePolicyOperationSettings = settings.updatePolicyOperationSettings.toBuilder();
            this.deletePolicySettings = settings.deletePolicySettings.toBuilder();
            this.deletePolicyOperationSettings = settings.deletePolicyOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listPoliciesSettings, this.getPolicySettings, this.createPolicySettings, this.updatePolicySettings, this.deletePolicySettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(PoliciesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)PoliciesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)PoliciesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(PoliciesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)PoliciesStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)PoliciesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)PoliciesStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(PoliciesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listPoliciesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updatePolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deletePolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createPolicyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Policy.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(PolicyOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updatePolicyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Policy.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(PolicyOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deletePolicyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Policy.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(PolicyOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListPoliciesRequest, ListPoliciesResponse, PoliciesClient.ListPoliciesPagedResponse> listPoliciesSettings() {
            return this.listPoliciesSettings;
        }

        public UnaryCallSettings.Builder<GetPolicyRequest, Policy> getPolicySettings() {
            return this.getPolicySettings;
        }

        public UnaryCallSettings.Builder<CreatePolicyRequest, Operation> createPolicySettings() {
            return this.createPolicySettings;
        }

        public OperationCallSettings.Builder<CreatePolicyRequest, Policy, PolicyOperationMetadata> createPolicyOperationSettings() {
            return this.createPolicyOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdatePolicyRequest, Operation> updatePolicySettings() {
            return this.updatePolicySettings;
        }

        public OperationCallSettings.Builder<UpdatePolicyRequest, Policy, PolicyOperationMetadata> updatePolicyOperationSettings() {
            return this.updatePolicyOperationSettings;
        }

        public UnaryCallSettings.Builder<DeletePolicyRequest, Operation> deletePolicySettings() {
            return this.deletePolicySettings;
        }

        public OperationCallSettings.Builder<DeletePolicyRequest, Policy, PolicyOperationMetadata> deletePolicyOperationSettings() {
            return this.deletePolicyOperationSettings;
        }

        public PoliciesStubSettings build() throws IOException {
            return new PoliciesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

