/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.workflows.executions.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.workflows.executions.v1.CancelExecutionRequest;
import com.google.cloud.workflows.executions.v1.CreateExecutionRequest;
import com.google.cloud.workflows.executions.v1.Execution;
import com.google.cloud.workflows.executions.v1.ExecutionsClient;
import com.google.cloud.workflows.executions.v1.GetExecutionRequest;
import com.google.cloud.workflows.executions.v1.ListExecutionsRequest;
import com.google.cloud.workflows.executions.v1.ListExecutionsResponse;
import com.google.cloud.workflows.executions.v1.stub.ExecutionsStub;
import com.google.cloud.workflows.executions.v1.stub.ExecutionsStubSettings;
import com.google.cloud.workflows.executions.v1.stub.GrpcExecutionsCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcExecutionsStub
extends ExecutionsStub {
    private static final MethodDescriptor<ListExecutionsRequest, ListExecutionsResponse> listExecutionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.workflows.executions.v1.Executions/ListExecutions").setRequestMarshaller(ProtoUtils.marshaller((Message)ListExecutionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListExecutionsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateExecutionRequest, Execution> createExecutionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.workflows.executions.v1.Executions/CreateExecution").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateExecutionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Execution.getDefaultInstance())).build();
    private static final MethodDescriptor<GetExecutionRequest, Execution> getExecutionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.workflows.executions.v1.Executions/GetExecution").setRequestMarshaller(ProtoUtils.marshaller((Message)GetExecutionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Execution.getDefaultInstance())).build();
    private static final MethodDescriptor<CancelExecutionRequest, Execution> cancelExecutionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.workflows.executions.v1.Executions/CancelExecution").setRequestMarshaller(ProtoUtils.marshaller((Message)CancelExecutionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Execution.getDefaultInstance())).build();
    private final UnaryCallable<ListExecutionsRequest, ListExecutionsResponse> listExecutionsCallable;
    private final UnaryCallable<ListExecutionsRequest, ExecutionsClient.ListExecutionsPagedResponse> listExecutionsPagedCallable;
    private final UnaryCallable<CreateExecutionRequest, Execution> createExecutionCallable;
    private final UnaryCallable<GetExecutionRequest, Execution> getExecutionCallable;
    private final UnaryCallable<CancelExecutionRequest, Execution> cancelExecutionCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcExecutionsStub create(ExecutionsStubSettings settings) throws IOException {
        return new GrpcExecutionsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcExecutionsStub create(ClientContext clientContext) throws IOException {
        return new GrpcExecutionsStub(ExecutionsStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcExecutionsStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcExecutionsStub(ExecutionsStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcExecutionsStub(ExecutionsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcExecutionsCallableFactory());
    }

    protected GrpcExecutionsStub(ExecutionsStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listExecutionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listExecutionsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListExecutionsRequest>(){

            public Map<String, String> extract(ListExecutionsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings createExecutionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createExecutionMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CreateExecutionRequest>(){

            public Map<String, String> extract(CreateExecutionRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getExecutionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getExecutionMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetExecutionRequest>(){

            public Map<String, String> extract(GetExecutionRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings cancelExecutionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(cancelExecutionMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CancelExecutionRequest>(){

            public Map<String, String> extract(CancelExecutionRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        this.listExecutionsCallable = callableFactory.createUnaryCallable(listExecutionsTransportSettings, settings.listExecutionsSettings(), clientContext);
        this.listExecutionsPagedCallable = callableFactory.createPagedCallable(listExecutionsTransportSettings, settings.listExecutionsSettings(), clientContext);
        this.createExecutionCallable = callableFactory.createUnaryCallable(createExecutionTransportSettings, settings.createExecutionSettings(), clientContext);
        this.getExecutionCallable = callableFactory.createUnaryCallable(getExecutionTransportSettings, settings.getExecutionSettings(), clientContext);
        this.cancelExecutionCallable = callableFactory.createUnaryCallable(cancelExecutionTransportSettings, settings.cancelExecutionSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListExecutionsRequest, ListExecutionsResponse> listExecutionsCallable() {
        return this.listExecutionsCallable;
    }

    @Override
    public UnaryCallable<ListExecutionsRequest, ExecutionsClient.ListExecutionsPagedResponse> listExecutionsPagedCallable() {
        return this.listExecutionsPagedCallable;
    }

    @Override
    public UnaryCallable<CreateExecutionRequest, Execution> createExecutionCallable() {
        return this.createExecutionCallable;
    }

    @Override
    public UnaryCallable<GetExecutionRequest, Execution> getExecutionCallable() {
        return this.getExecutionCallable;
    }

    @Override
    public UnaryCallable<CancelExecutionRequest, Execution> cancelExecutionCallable() {
        return this.cancelExecutionCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

