/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.visionai.v1.AcquireLeaseRequest;
import com.google.cloud.visionai.v1.Lease;
import com.google.cloud.visionai.v1.ReceiveEventsRequest;
import com.google.cloud.visionai.v1.ReceiveEventsResponse;
import com.google.cloud.visionai.v1.ReceivePacketsRequest;
import com.google.cloud.visionai.v1.ReceivePacketsResponse;
import com.google.cloud.visionai.v1.ReleaseLeaseRequest;
import com.google.cloud.visionai.v1.ReleaseLeaseResponse;
import com.google.cloud.visionai.v1.RenewLeaseRequest;
import com.google.cloud.visionai.v1.SendPacketsRequest;
import com.google.cloud.visionai.v1.SendPacketsResponse;
import com.google.cloud.visionai.v1.stub.GrpcStreamingServiceCallableFactory;
import com.google.cloud.visionai.v1.stub.StreamingServiceStub;
import com.google.cloud.visionai.v1.stub.StreamingServiceStubSettings;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcStreamingServiceStub
extends StreamingServiceStub {
    private static final MethodDescriptor<SendPacketsRequest, SendPacketsResponse> sendPacketsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.BIDI_STREAMING).setFullMethodName("google.cloud.visionai.v1.StreamingService/SendPackets").setRequestMarshaller(ProtoUtils.marshaller((Message)SendPacketsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SendPacketsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ReceivePacketsRequest, ReceivePacketsResponse> receivePacketsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.BIDI_STREAMING).setFullMethodName("google.cloud.visionai.v1.StreamingService/ReceivePackets").setRequestMarshaller(ProtoUtils.marshaller((Message)ReceivePacketsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ReceivePacketsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ReceiveEventsRequest, ReceiveEventsResponse> receiveEventsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.BIDI_STREAMING).setFullMethodName("google.cloud.visionai.v1.StreamingService/ReceiveEvents").setRequestMarshaller(ProtoUtils.marshaller((Message)ReceiveEventsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ReceiveEventsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<AcquireLeaseRequest, Lease> acquireLeaseMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.visionai.v1.StreamingService/AcquireLease").setRequestMarshaller(ProtoUtils.marshaller((Message)AcquireLeaseRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Lease.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<RenewLeaseRequest, Lease> renewLeaseMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.visionai.v1.StreamingService/RenewLease").setRequestMarshaller(ProtoUtils.marshaller((Message)RenewLeaseRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Lease.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ReleaseLeaseRequest, ReleaseLeaseResponse> releaseLeaseMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.visionai.v1.StreamingService/ReleaseLease").setRequestMarshaller(ProtoUtils.marshaller((Message)ReleaseLeaseRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ReleaseLeaseResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final BidiStreamingCallable<SendPacketsRequest, SendPacketsResponse> sendPacketsCallable;
    private final BidiStreamingCallable<ReceivePacketsRequest, ReceivePacketsResponse> receivePacketsCallable;
    private final BidiStreamingCallable<ReceiveEventsRequest, ReceiveEventsResponse> receiveEventsCallable;
    private final UnaryCallable<AcquireLeaseRequest, Lease> acquireLeaseCallable;
    private final UnaryCallable<RenewLeaseRequest, Lease> renewLeaseCallable;
    private final UnaryCallable<ReleaseLeaseRequest, ReleaseLeaseResponse> releaseLeaseCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcStreamingServiceStub create(StreamingServiceStubSettings settings) throws IOException {
        return new GrpcStreamingServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcStreamingServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcStreamingServiceStub(StreamingServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcStreamingServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcStreamingServiceStub(StreamingServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcStreamingServiceStub(StreamingServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcStreamingServiceCallableFactory());
    }

    protected GrpcStreamingServiceStub(StreamingServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings sendPacketsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(sendPacketsMethodDescriptor).build();
        GrpcCallSettings receivePacketsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(receivePacketsMethodDescriptor).build();
        GrpcCallSettings receiveEventsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(receiveEventsMethodDescriptor).build();
        GrpcCallSettings acquireLeaseTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(acquireLeaseMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("series", String.valueOf(request.getSeries()));
            return builder.build();
        }).build();
        GrpcCallSettings renewLeaseTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(renewLeaseMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("series", String.valueOf(request.getSeries()));
            return builder.build();
        }).build();
        GrpcCallSettings releaseLeaseTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(releaseLeaseMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("series", String.valueOf(request.getSeries()));
            return builder.build();
        }).build();
        this.sendPacketsCallable = callableFactory.createBidiStreamingCallable(sendPacketsTransportSettings, settings.sendPacketsSettings(), clientContext);
        this.receivePacketsCallable = callableFactory.createBidiStreamingCallable(receivePacketsTransportSettings, settings.receivePacketsSettings(), clientContext);
        this.receiveEventsCallable = callableFactory.createBidiStreamingCallable(receiveEventsTransportSettings, settings.receiveEventsSettings(), clientContext);
        this.acquireLeaseCallable = callableFactory.createUnaryCallable(acquireLeaseTransportSettings, settings.acquireLeaseSettings(), clientContext);
        this.renewLeaseCallable = callableFactory.createUnaryCallable(renewLeaseTransportSettings, settings.renewLeaseSettings(), clientContext);
        this.releaseLeaseCallable = callableFactory.createUnaryCallable(releaseLeaseTransportSettings, settings.releaseLeaseSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public BidiStreamingCallable<SendPacketsRequest, SendPacketsResponse> sendPacketsCallable() {
        return this.sendPacketsCallable;
    }

    @Override
    public BidiStreamingCallable<ReceivePacketsRequest, ReceivePacketsResponse> receivePacketsCallable() {
        return this.receivePacketsCallable;
    }

    @Override
    public BidiStreamingCallable<ReceiveEventsRequest, ReceiveEventsResponse> receiveEventsCallable() {
        return this.receiveEventsCallable;
    }

    @Override
    public UnaryCallable<AcquireLeaseRequest, Lease> acquireLeaseCallable() {
        return this.acquireLeaseCallable;
    }

    @Override
    public UnaryCallable<RenewLeaseRequest, Lease> renewLeaseCallable() {
        return this.renewLeaseCallable;
    }

    @Override
    public UnaryCallable<ReleaseLeaseRequest, ReleaseLeaseResponse> releaseLeaseCallable() {
        return this.releaseLeaseCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

