/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.visionai.v1.HealthCheckRequest;
import com.google.cloud.visionai.v1.HealthCheckResponse;
import com.google.cloud.visionai.v1.stub.GrpcHealthCheckServiceStub;
import com.google.cloud.visionai.v1.stub.HealthCheckServiceStub;
import com.google.cloud.visionai.v1.stub.HttpJsonHealthCheckServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class HealthCheckServiceStubSettings
extends StubSettings<HealthCheckServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<HealthCheckRequest, HealthCheckResponse> healthCheckSettings;

    public UnaryCallSettings<HealthCheckRequest, HealthCheckResponse> healthCheckSettings() {
        return this.healthCheckSettings;
    }

    public HealthCheckServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcHealthCheckServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonHealthCheckServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "visionai";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "visionai.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "visionai.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return HealthCheckServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(HealthCheckServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(HealthCheckServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return HealthCheckServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected HealthCheckServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.healthCheckSettings = settingsBuilder.healthCheckSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<HealthCheckServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<HealthCheckRequest, HealthCheckResponse> healthCheckSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.healthCheckSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.healthCheckSettings);
            Builder.initDefaults(this);
        }

        protected Builder(HealthCheckServiceStubSettings settings) {
            super((StubSettings)settings);
            this.healthCheckSettings = settings.healthCheckSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.healthCheckSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(HealthCheckServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)HealthCheckServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)HealthCheckServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(HealthCheckServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)HealthCheckServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)HealthCheckServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)HealthCheckServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(HealthCheckServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.healthCheckSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<HealthCheckRequest, HealthCheckResponse> healthCheckSettings() {
            return this.healthCheckSettings;
        }

        public HealthCheckServiceStubSettings build() throws IOException {
            return new HealthCheckServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

