/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vision.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.core.PropertiesProvider;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.grpc.GrpcTransport;
import com.google.api.gax.grpc.GrpcTransportProvider;
import com.google.api.gax.grpc.InstantiatingChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.SimpleCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.vision.v1.BatchAnnotateImagesRequest;
import com.google.cloud.vision.v1.BatchAnnotateImagesResponse;
import com.google.cloud.vision.v1.stub.GrpcImageAnnotatorStub;
import com.google.cloud.vision.v1.stub.ImageAnnotatorStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import io.grpc.Status;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class ImageAnnotatorSettings
extends ClientSettings {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private static final String DEFAULT_GAPIC_NAME = "gapic";
    private static final String DEFAULT_GAPIC_VERSION = "";
    private static final String PROPERTIES_FILE = "/com/google/cloud/vision/project.properties";
    private static final String META_VERSION_KEY = "artifact.version";
    private static String gapicVersion;
    private final SimpleCallSettings<BatchAnnotateImagesRequest, BatchAnnotateImagesResponse> batchAnnotateImagesSettings;

    public SimpleCallSettings<BatchAnnotateImagesRequest, BatchAnnotateImagesResponse> batchAnnotateImagesSettings() {
        return this.batchAnnotateImagesSettings;
    }

    public ImageAnnotatorStub createStub() throws IOException {
        if (this.getTransportProvider().getTransportName().equals(GrpcTransport.getGrpcTransportName())) {
            return GrpcImageAnnotatorStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "vision.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingChannelProvider.Builder defaultGrpcChannelProviderBuilder() {
        return InstantiatingChannelProvider.newBuilder().setEndpoint(ImageAnnotatorSettings.getDefaultEndpoint()).setGeneratorHeader(DEFAULT_GAPIC_NAME, ImageAnnotatorSettings.getGapicVersion());
    }

    public static GrpcTransportProvider.Builder defaultGrpcTransportProviderBuilder() {
        return GrpcTransportProvider.newBuilder().setChannelProvider((ChannelProvider)ImageAnnotatorSettings.defaultGrpcChannelProviderBuilder().build());
    }

    public static TransportProvider defaultTransportProvider() {
        return ImageAnnotatorSettings.defaultGrpcTransportProviderBuilder().build();
    }

    private static String getGapicVersion() {
        if (gapicVersion == null) {
            gapicVersion = PropertiesProvider.loadProperty(ImageAnnotatorSettings.class, (String)PROPERTIES_FILE, (String)META_VERSION_KEY);
            gapicVersion = gapicVersion == null ? DEFAULT_GAPIC_VERSION : gapicVersion;
        }
        return gapicVersion;
    }

    public static Builder defaultBuilder() {
        return Builder.createDefault();
    }

    public static Builder defaultBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ImageAnnotatorSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder.getExecutorProvider(), settingsBuilder.getTransportProvider(), settingsBuilder.getCredentialsProvider(), settingsBuilder.getClock());
        this.batchAnnotateImagesSettings = settingsBuilder.batchAnnotateImagesSettings().build();
    }

    public static class Builder
    extends ClientSettings.Builder {
        private final ImmutableList<UnaryCallSettings.Builder> unaryMethodSettingsBuilders;
        private final SimpleCallSettings.Builder<BatchAnnotateImagesRequest, BatchAnnotateImagesResponse> batchAnnotateImagesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        private Builder() {
            this((ClientContext)null);
        }

        private Builder(ClientContext clientContext) {
            super(clientContext);
            this.batchAnnotateImagesSettings = SimpleCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.batchAnnotateImagesSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportProvider(ImageAnnotatorSettings.defaultTransportProvider());
            builder.setCredentialsProvider((CredentialsProvider)ImageAnnotatorSettings.defaultCredentialsProviderBuilder().build());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.batchAnnotateImagesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        private Builder(ImageAnnotatorSettings settings) {
            super((ClientSettings)settings);
            this.batchAnnotateImagesSettings = settings.batchAnnotateImagesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.batchAnnotateImagesSettings);
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            super.setExecutorProvider(executorProvider);
            return this;
        }

        public Builder setTransportProvider(TransportProvider transportProvider) {
            super.setTransportProvider(transportProvider);
            return this;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            super.setCredentialsProvider(credentialsProvider);
            return this;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder, Void> settingsUpdater) throws Exception {
            super.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public SimpleCallSettings.Builder<BatchAnnotateImagesRequest, BatchAnnotateImagesResponse> batchAnnotateImagesSettings() {
            return this.batchAnnotateImagesSettings;
        }

        public ImageAnnotatorSettings build() throws IOException {
            return new ImageAnnotatorSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode[]{GrpcStatusCode.of((Status.Code)Status.Code.DEADLINE_EXCEEDED), GrpcStatusCode.of((Status.Code)Status.Code.UNAVAILABLE)})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

