/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.videointelligence.v1beta1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.OperationFuture;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.videointelligence.v1beta1.AnnotateVideoProgress;
import com.google.cloud.videointelligence.v1beta1.AnnotateVideoRequest;
import com.google.cloud.videointelligence.v1beta1.AnnotateVideoResponse;
import com.google.cloud.videointelligence.v1beta1.Feature;
import com.google.cloud.videointelligence.v1beta1.VideoContext;
import com.google.cloud.videointelligence.v1beta1.VideoIntelligenceServiceSettings;
import com.google.cloud.videointelligence.v1beta1.stub.VideoIntelligenceServiceStub;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class VideoIntelligenceServiceClient
implements BackgroundResource {
    private final VideoIntelligenceServiceSettings settings;
    private final VideoIntelligenceServiceStub stub;
    private final OperationsClient operationsClient;

    public static final VideoIntelligenceServiceClient create() throws IOException {
        return VideoIntelligenceServiceClient.create(VideoIntelligenceServiceSettings.defaultBuilder().build());
    }

    public static final VideoIntelligenceServiceClient create(VideoIntelligenceServiceSettings settings) throws IOException {
        return new VideoIntelligenceServiceClient(settings);
    }

    public static final VideoIntelligenceServiceClient create(VideoIntelligenceServiceStub stub) {
        return new VideoIntelligenceServiceClient(stub);
    }

    protected VideoIntelligenceServiceClient(VideoIntelligenceServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = settings.createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected VideoIntelligenceServiceClient(VideoIntelligenceServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final VideoIntelligenceServiceSettings getSettings() {
        return this.settings;
    }

    public VideoIntelligenceServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final OperationFuture<AnnotateVideoResponse, AnnotateVideoProgress, Operation> annotateVideoAsync(String inputUri, List<Feature> features, VideoContext videoContext, String outputUri, String locationId) {
        AnnotateVideoRequest request = AnnotateVideoRequest.newBuilder().setInputUri(inputUri).addAllFeatures(features).setVideoContext(videoContext).setOutputUri(outputUri).setLocationId(locationId).build();
        return this.annotateVideoAsync(request);
    }

    public final OperationFuture<AnnotateVideoResponse, AnnotateVideoProgress, Operation> annotateVideoAsync(AnnotateVideoRequest request) {
        return this.annotateVideoOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<AnnotateVideoRequest, AnnotateVideoResponse, AnnotateVideoProgress, Operation> annotateVideoOperationCallable() {
        return this.stub.annotateVideoOperationCallable();
    }

    public final UnaryCallable<AnnotateVideoRequest, Operation> annotateVideoCallable() {
        return this.stub.annotateVideoCallable();
    }

    public final void close() throws Exception {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

