/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vectorsearch.v1beta;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.vectorsearch.v1beta.AggregateDataObjectsRequest;
import com.google.cloud.vectorsearch.v1beta.AggregateDataObjectsResponse;
import com.google.cloud.vectorsearch.v1beta.BatchSearchDataObjectsRequest;
import com.google.cloud.vectorsearch.v1beta.BatchSearchDataObjectsResponse;
import com.google.cloud.vectorsearch.v1beta.DataObject;
import com.google.cloud.vectorsearch.v1beta.DataObjectSearchServiceSettings;
import com.google.cloud.vectorsearch.v1beta.QueryDataObjectsRequest;
import com.google.cloud.vectorsearch.v1beta.QueryDataObjectsResponse;
import com.google.cloud.vectorsearch.v1beta.SearchDataObjectsRequest;
import com.google.cloud.vectorsearch.v1beta.SearchDataObjectsResponse;
import com.google.cloud.vectorsearch.v1beta.SearchResult;
import com.google.cloud.vectorsearch.v1beta.stub.DataObjectSearchServiceStub;
import com.google.cloud.vectorsearch.v1beta.stub.DataObjectSearchServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class DataObjectSearchServiceClient
implements BackgroundResource {
    private final DataObjectSearchServiceSettings settings;
    private final DataObjectSearchServiceStub stub;

    public static final DataObjectSearchServiceClient create() throws IOException {
        return DataObjectSearchServiceClient.create(DataObjectSearchServiceSettings.newBuilder().build());
    }

    public static final DataObjectSearchServiceClient create(DataObjectSearchServiceSettings settings) throws IOException {
        return new DataObjectSearchServiceClient(settings);
    }

    public static final DataObjectSearchServiceClient create(DataObjectSearchServiceStub stub) {
        return new DataObjectSearchServiceClient(stub);
    }

    protected DataObjectSearchServiceClient(DataObjectSearchServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DataObjectSearchServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected DataObjectSearchServiceClient(DataObjectSearchServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final DataObjectSearchServiceSettings getSettings() {
        return this.settings;
    }

    public DataObjectSearchServiceStub getStub() {
        return this.stub;
    }

    public final SearchDataObjectsPagedResponse searchDataObjects(SearchDataObjectsRequest request) {
        return (SearchDataObjectsPagedResponse)((Object)this.searchDataObjectsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchDataObjectsRequest, SearchDataObjectsPagedResponse> searchDataObjectsPagedCallable() {
        return this.stub.searchDataObjectsPagedCallable();
    }

    public final UnaryCallable<SearchDataObjectsRequest, SearchDataObjectsResponse> searchDataObjectsCallable() {
        return this.stub.searchDataObjectsCallable();
    }

    public final QueryDataObjectsPagedResponse queryDataObjects(QueryDataObjectsRequest request) {
        return (QueryDataObjectsPagedResponse)((Object)this.queryDataObjectsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<QueryDataObjectsRequest, QueryDataObjectsPagedResponse> queryDataObjectsPagedCallable() {
        return this.stub.queryDataObjectsPagedCallable();
    }

    public final UnaryCallable<QueryDataObjectsRequest, QueryDataObjectsResponse> queryDataObjectsCallable() {
        return this.stub.queryDataObjectsCallable();
    }

    public final AggregateDataObjectsResponse aggregateDataObjects(AggregateDataObjectsRequest request) {
        return (AggregateDataObjectsResponse)this.aggregateDataObjectsCallable().call((Object)request);
    }

    public final UnaryCallable<AggregateDataObjectsRequest, AggregateDataObjectsResponse> aggregateDataObjectsCallable() {
        return this.stub.aggregateDataObjectsCallable();
    }

    public final BatchSearchDataObjectsResponse batchSearchDataObjects(BatchSearchDataObjectsRequest request) {
        return (BatchSearchDataObjectsResponse)this.batchSearchDataObjectsCallable().call((Object)request);
    }

    public final UnaryCallable<BatchSearchDataObjectsRequest, BatchSearchDataObjectsResponse> batchSearchDataObjectsCallable() {
        return this.stub.batchSearchDataObjectsCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class QueryDataObjectsFixedSizeCollection
    extends AbstractFixedSizeCollection<QueryDataObjectsRequest, QueryDataObjectsResponse, DataObject, QueryDataObjectsPage, QueryDataObjectsFixedSizeCollection> {
        private QueryDataObjectsFixedSizeCollection(List<QueryDataObjectsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static QueryDataObjectsFixedSizeCollection createEmptyCollection() {
            return new QueryDataObjectsFixedSizeCollection(null, 0);
        }

        protected QueryDataObjectsFixedSizeCollection createCollection(List<QueryDataObjectsPage> pages, int collectionSize) {
            return new QueryDataObjectsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class QueryDataObjectsPage
    extends AbstractPage<QueryDataObjectsRequest, QueryDataObjectsResponse, DataObject, QueryDataObjectsPage> {
        private QueryDataObjectsPage(PageContext<QueryDataObjectsRequest, QueryDataObjectsResponse, DataObject> context, QueryDataObjectsResponse response) {
            super(context, (Object)response);
        }

        private static QueryDataObjectsPage createEmptyPage() {
            return new QueryDataObjectsPage(null, null);
        }

        protected QueryDataObjectsPage createPage(PageContext<QueryDataObjectsRequest, QueryDataObjectsResponse, DataObject> context, QueryDataObjectsResponse response) {
            return new QueryDataObjectsPage(context, response);
        }

        public ApiFuture<QueryDataObjectsPage> createPageAsync(PageContext<QueryDataObjectsRequest, QueryDataObjectsResponse, DataObject> context, ApiFuture<QueryDataObjectsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class QueryDataObjectsPagedResponse
    extends AbstractPagedListResponse<QueryDataObjectsRequest, QueryDataObjectsResponse, DataObject, QueryDataObjectsPage, QueryDataObjectsFixedSizeCollection> {
        public static ApiFuture<QueryDataObjectsPagedResponse> createAsync(PageContext<QueryDataObjectsRequest, QueryDataObjectsResponse, DataObject> context, ApiFuture<QueryDataObjectsResponse> futureResponse) {
            ApiFuture<QueryDataObjectsPage> futurePage = QueryDataObjectsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new QueryDataObjectsPagedResponse((QueryDataObjectsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private QueryDataObjectsPagedResponse(QueryDataObjectsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)QueryDataObjectsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class SearchDataObjectsFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchDataObjectsRequest, SearchDataObjectsResponse, SearchResult, SearchDataObjectsPage, SearchDataObjectsFixedSizeCollection> {
        private SearchDataObjectsFixedSizeCollection(List<SearchDataObjectsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchDataObjectsFixedSizeCollection createEmptyCollection() {
            return new SearchDataObjectsFixedSizeCollection(null, 0);
        }

        protected SearchDataObjectsFixedSizeCollection createCollection(List<SearchDataObjectsPage> pages, int collectionSize) {
            return new SearchDataObjectsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchDataObjectsPage
    extends AbstractPage<SearchDataObjectsRequest, SearchDataObjectsResponse, SearchResult, SearchDataObjectsPage> {
        private SearchDataObjectsPage(PageContext<SearchDataObjectsRequest, SearchDataObjectsResponse, SearchResult> context, SearchDataObjectsResponse response) {
            super(context, (Object)response);
        }

        private static SearchDataObjectsPage createEmptyPage() {
            return new SearchDataObjectsPage(null, null);
        }

        protected SearchDataObjectsPage createPage(PageContext<SearchDataObjectsRequest, SearchDataObjectsResponse, SearchResult> context, SearchDataObjectsResponse response) {
            return new SearchDataObjectsPage(context, response);
        }

        public ApiFuture<SearchDataObjectsPage> createPageAsync(PageContext<SearchDataObjectsRequest, SearchDataObjectsResponse, SearchResult> context, ApiFuture<SearchDataObjectsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchDataObjectsPagedResponse
    extends AbstractPagedListResponse<SearchDataObjectsRequest, SearchDataObjectsResponse, SearchResult, SearchDataObjectsPage, SearchDataObjectsFixedSizeCollection> {
        public static ApiFuture<SearchDataObjectsPagedResponse> createAsync(PageContext<SearchDataObjectsRequest, SearchDataObjectsResponse, SearchResult> context, ApiFuture<SearchDataObjectsResponse> futureResponse) {
            ApiFuture<SearchDataObjectsPage> futurePage = SearchDataObjectsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SearchDataObjectsPagedResponse((SearchDataObjectsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SearchDataObjectsPagedResponse(SearchDataObjectsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchDataObjectsFixedSizeCollection.createEmptyCollection());
        }
    }
}

