/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vectorsearch.v1beta.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.vectorsearch.v1beta.BatchCreateDataObjectsRequest;
import com.google.cloud.vectorsearch.v1beta.BatchCreateDataObjectsResponse;
import com.google.cloud.vectorsearch.v1beta.BatchDeleteDataObjectsRequest;
import com.google.cloud.vectorsearch.v1beta.BatchUpdateDataObjectsRequest;
import com.google.cloud.vectorsearch.v1beta.BatchUpdateDataObjectsResponse;
import com.google.cloud.vectorsearch.v1beta.CreateDataObjectRequest;
import com.google.cloud.vectorsearch.v1beta.DataObject;
import com.google.cloud.vectorsearch.v1beta.DataObjectServiceClient;
import com.google.cloud.vectorsearch.v1beta.DeleteDataObjectRequest;
import com.google.cloud.vectorsearch.v1beta.GetDataObjectRequest;
import com.google.cloud.vectorsearch.v1beta.UpdateDataObjectRequest;
import com.google.cloud.vectorsearch.v1beta.stub.DataObjectServiceStub;
import com.google.cloud.vectorsearch.v1beta.stub.GrpcDataObjectServiceStub;
import com.google.cloud.vectorsearch.v1beta.stub.HttpJsonDataObjectServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@BetaApi
public class DataObjectServiceStubSettings
extends StubSettings<DataObjectServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateDataObjectRequest, DataObject> createDataObjectSettings;
    private final UnaryCallSettings<BatchCreateDataObjectsRequest, BatchCreateDataObjectsResponse> batchCreateDataObjectsSettings;
    private final UnaryCallSettings<GetDataObjectRequest, DataObject> getDataObjectSettings;
    private final UnaryCallSettings<UpdateDataObjectRequest, DataObject> updateDataObjectSettings;
    private final UnaryCallSettings<BatchUpdateDataObjectsRequest, BatchUpdateDataObjectsResponse> batchUpdateDataObjectsSettings;
    private final UnaryCallSettings<DeleteDataObjectRequest, Empty> deleteDataObjectSettings;
    private final UnaryCallSettings<BatchDeleteDataObjectsRequest, Empty> batchDeleteDataObjectsSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, DataObjectServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, DataObjectServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, DataObjectServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<DataObjectServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataObjectServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateDataObjectRequest, DataObject> createDataObjectSettings() {
        return this.createDataObjectSettings;
    }

    public UnaryCallSettings<BatchCreateDataObjectsRequest, BatchCreateDataObjectsResponse> batchCreateDataObjectsSettings() {
        return this.batchCreateDataObjectsSettings;
    }

    public UnaryCallSettings<GetDataObjectRequest, DataObject> getDataObjectSettings() {
        return this.getDataObjectSettings;
    }

    public UnaryCallSettings<UpdateDataObjectRequest, DataObject> updateDataObjectSettings() {
        return this.updateDataObjectSettings;
    }

    public UnaryCallSettings<BatchUpdateDataObjectsRequest, BatchUpdateDataObjectsResponse> batchUpdateDataObjectsSettings() {
        return this.batchUpdateDataObjectsSettings;
    }

    public UnaryCallSettings<DeleteDataObjectRequest, Empty> deleteDataObjectSettings() {
        return this.deleteDataObjectSettings;
    }

    public UnaryCallSettings<BatchDeleteDataObjectsRequest, Empty> batchDeleteDataObjectsSettings() {
        return this.batchDeleteDataObjectsSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, DataObjectServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public DataObjectServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDataObjectServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDataObjectServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "vectorsearch";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "vectorsearch.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "vectorsearch.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DataObjectServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DataObjectServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DataObjectServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return DataObjectServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DataObjectServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createDataObjectSettings = settingsBuilder.createDataObjectSettings().build();
        this.batchCreateDataObjectsSettings = settingsBuilder.batchCreateDataObjectsSettings().build();
        this.getDataObjectSettings = settingsBuilder.getDataObjectSettings().build();
        this.updateDataObjectSettings = settingsBuilder.updateDataObjectSettings().build();
        this.batchUpdateDataObjectsSettings = settingsBuilder.batchUpdateDataObjectsSettings().build();
        this.deleteDataObjectSettings = settingsBuilder.deleteDataObjectSettings().build();
        this.batchDeleteDataObjectsSettings = settingsBuilder.batchDeleteDataObjectsSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DataObjectServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateDataObjectRequest, DataObject> createDataObjectSettings;
        private final UnaryCallSettings.Builder<BatchCreateDataObjectsRequest, BatchCreateDataObjectsResponse> batchCreateDataObjectsSettings;
        private final UnaryCallSettings.Builder<GetDataObjectRequest, DataObject> getDataObjectSettings;
        private final UnaryCallSettings.Builder<UpdateDataObjectRequest, DataObject> updateDataObjectSettings;
        private final UnaryCallSettings.Builder<BatchUpdateDataObjectsRequest, BatchUpdateDataObjectsResponse> batchUpdateDataObjectsSettings;
        private final UnaryCallSettings.Builder<DeleteDataObjectRequest, Empty> deleteDataObjectSettings;
        private final UnaryCallSettings.Builder<BatchDeleteDataObjectsRequest, Empty> batchDeleteDataObjectsSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, DataObjectServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createDataObjectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchCreateDataObjectsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getDataObjectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDataObjectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchUpdateDataObjectsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDataObjectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchDeleteDataObjectsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createDataObjectSettings, this.batchCreateDataObjectsSettings, this.getDataObjectSettings, this.updateDataObjectSettings, this.batchUpdateDataObjectsSettings, this.deleteDataObjectSettings, this.batchDeleteDataObjectsSettings, this.listLocationsSettings, this.getLocationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(DataObjectServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createDataObjectSettings = settings.createDataObjectSettings.toBuilder();
            this.batchCreateDataObjectsSettings = settings.batchCreateDataObjectsSettings.toBuilder();
            this.getDataObjectSettings = settings.getDataObjectSettings.toBuilder();
            this.updateDataObjectSettings = settings.updateDataObjectSettings.toBuilder();
            this.batchUpdateDataObjectsSettings = settings.batchUpdateDataObjectsSettings.toBuilder();
            this.deleteDataObjectSettings = settings.deleteDataObjectSettings.toBuilder();
            this.batchDeleteDataObjectsSettings = settings.batchDeleteDataObjectsSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createDataObjectSettings, this.batchCreateDataObjectsSettings, this.getDataObjectSettings, this.updateDataObjectSettings, this.batchUpdateDataObjectsSettings, this.deleteDataObjectSettings, this.batchDeleteDataObjectsSettings, this.listLocationsSettings, this.getLocationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DataObjectServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DataObjectServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DataObjectServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DataObjectServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)DataObjectServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)DataObjectServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DataObjectServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DataObjectServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createDataObjectSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.batchCreateDataObjectsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params"));
            builder.getDataObjectSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateDataObjectSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.batchUpdateDataObjectsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.deleteDataObjectSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.batchDeleteDataObjectsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateDataObjectRequest, DataObject> createDataObjectSettings() {
            return this.createDataObjectSettings;
        }

        public UnaryCallSettings.Builder<BatchCreateDataObjectsRequest, BatchCreateDataObjectsResponse> batchCreateDataObjectsSettings() {
            return this.batchCreateDataObjectsSettings;
        }

        public UnaryCallSettings.Builder<GetDataObjectRequest, DataObject> getDataObjectSettings() {
            return this.getDataObjectSettings;
        }

        public UnaryCallSettings.Builder<UpdateDataObjectRequest, DataObject> updateDataObjectSettings() {
            return this.updateDataObjectSettings;
        }

        public UnaryCallSettings.Builder<BatchUpdateDataObjectsRequest, BatchUpdateDataObjectsResponse> batchUpdateDataObjectsSettings() {
            return this.batchUpdateDataObjectsSettings;
        }

        public UnaryCallSettings.Builder<DeleteDataObjectRequest, Empty> deleteDataObjectSettings() {
            return this.deleteDataObjectSettings;
        }

        public UnaryCallSettings.Builder<BatchDeleteDataObjectsRequest, Empty> batchDeleteDataObjectsSettings() {
            return this.batchDeleteDataObjectsSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, DataObjectServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public DataObjectServiceStubSettings build() throws IOException {
            return new DataObjectServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_2_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_3_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"no_retry_2_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(300000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(300000L)).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build();
            definitions.put((Object)"no_retry_3_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

