/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.translate.v3;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.translate.v3.BatchTranslateDocumentMetadata;
import com.google.cloud.translate.v3.BatchTranslateDocumentRequest;
import com.google.cloud.translate.v3.BatchTranslateDocumentResponse;
import com.google.cloud.translate.v3.BatchTranslateMetadata;
import com.google.cloud.translate.v3.BatchTranslateResponse;
import com.google.cloud.translate.v3.BatchTranslateTextRequest;
import com.google.cloud.translate.v3.CreateGlossaryMetadata;
import com.google.cloud.translate.v3.CreateGlossaryRequest;
import com.google.cloud.translate.v3.DeleteGlossaryMetadata;
import com.google.cloud.translate.v3.DeleteGlossaryRequest;
import com.google.cloud.translate.v3.DeleteGlossaryResponse;
import com.google.cloud.translate.v3.DetectLanguageRequest;
import com.google.cloud.translate.v3.DetectLanguageResponse;
import com.google.cloud.translate.v3.GetGlossaryRequest;
import com.google.cloud.translate.v3.GetSupportedLanguagesRequest;
import com.google.cloud.translate.v3.Glossary;
import com.google.cloud.translate.v3.GlossaryName;
import com.google.cloud.translate.v3.ListGlossariesRequest;
import com.google.cloud.translate.v3.ListGlossariesResponse;
import com.google.cloud.translate.v3.LocationName;
import com.google.cloud.translate.v3.SupportedLanguages;
import com.google.cloud.translate.v3.TranslateDocumentRequest;
import com.google.cloud.translate.v3.TranslateDocumentResponse;
import com.google.cloud.translate.v3.TranslateTextRequest;
import com.google.cloud.translate.v3.TranslateTextResponse;
import com.google.cloud.translate.v3.TranslationServiceSettings;
import com.google.cloud.translate.v3.stub.TranslationServiceStub;
import com.google.cloud.translate.v3.stub.TranslationServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class TranslationServiceClient
implements BackgroundResource {
    private final TranslationServiceSettings settings;
    private final TranslationServiceStub stub;
    private final OperationsClient operationsClient;

    public static final TranslationServiceClient create() throws IOException {
        return TranslationServiceClient.create(TranslationServiceSettings.newBuilder().build());
    }

    public static final TranslationServiceClient create(TranslationServiceSettings settings) throws IOException {
        return new TranslationServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final TranslationServiceClient create(TranslationServiceStub stub) {
        return new TranslationServiceClient(stub);
    }

    protected TranslationServiceClient(TranslationServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TranslationServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected TranslationServiceClient(TranslationServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final TranslationServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public TranslationServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final TranslateTextResponse translateText(LocationName parent, String targetLanguageCode, List<String> contents) {
        TranslateTextRequest request = TranslateTextRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTargetLanguageCode(targetLanguageCode).addAllContents(contents).build();
        return this.translateText(request);
    }

    public final TranslateTextResponse translateText(String parent, String targetLanguageCode, List<String> contents) {
        TranslateTextRequest request = TranslateTextRequest.newBuilder().setParent(parent).setTargetLanguageCode(targetLanguageCode).addAllContents(contents).build();
        return this.translateText(request);
    }

    public final TranslateTextResponse translateText(LocationName parent, String model, String mimeType, String sourceLanguageCode, String targetLanguageCode, List<String> contents) {
        TranslateTextRequest request = TranslateTextRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setModel(model).setMimeType(mimeType).setSourceLanguageCode(sourceLanguageCode).setTargetLanguageCode(targetLanguageCode).addAllContents(contents).build();
        return this.translateText(request);
    }

    public final TranslateTextResponse translateText(String parent, String model, String mimeType, String sourceLanguageCode, String targetLanguageCode, List<String> contents) {
        TranslateTextRequest request = TranslateTextRequest.newBuilder().setParent(parent).setModel(model).setMimeType(mimeType).setSourceLanguageCode(sourceLanguageCode).setTargetLanguageCode(targetLanguageCode).addAllContents(contents).build();
        return this.translateText(request);
    }

    public final TranslateTextResponse translateText(TranslateTextRequest request) {
        return (TranslateTextResponse)this.translateTextCallable().call((Object)request);
    }

    public final UnaryCallable<TranslateTextRequest, TranslateTextResponse> translateTextCallable() {
        return this.stub.translateTextCallable();
    }

    public final DetectLanguageResponse detectLanguage(LocationName parent, String model, String mimeType, String content) {
        DetectLanguageRequest request = DetectLanguageRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setModel(model).setMimeType(mimeType).setContent(content).build();
        return this.detectLanguage(request);
    }

    public final DetectLanguageResponse detectLanguage(String parent, String model, String mimeType, String content) {
        DetectLanguageRequest request = DetectLanguageRequest.newBuilder().setParent(parent).setModel(model).setMimeType(mimeType).setContent(content).build();
        return this.detectLanguage(request);
    }

    public final DetectLanguageResponse detectLanguage(DetectLanguageRequest request) {
        return (DetectLanguageResponse)this.detectLanguageCallable().call((Object)request);
    }

    public final UnaryCallable<DetectLanguageRequest, DetectLanguageResponse> detectLanguageCallable() {
        return this.stub.detectLanguageCallable();
    }

    public final SupportedLanguages getSupportedLanguages(LocationName parent, String model, String displayLanguageCode) {
        GetSupportedLanguagesRequest request = GetSupportedLanguagesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setModel(model).setDisplayLanguageCode(displayLanguageCode).build();
        return this.getSupportedLanguages(request);
    }

    public final SupportedLanguages getSupportedLanguages(String parent, String model, String displayLanguageCode) {
        GetSupportedLanguagesRequest request = GetSupportedLanguagesRequest.newBuilder().setParent(parent).setModel(model).setDisplayLanguageCode(displayLanguageCode).build();
        return this.getSupportedLanguages(request);
    }

    public final SupportedLanguages getSupportedLanguages(GetSupportedLanguagesRequest request) {
        return (SupportedLanguages)this.getSupportedLanguagesCallable().call((Object)request);
    }

    public final UnaryCallable<GetSupportedLanguagesRequest, SupportedLanguages> getSupportedLanguagesCallable() {
        return this.stub.getSupportedLanguagesCallable();
    }

    public final TranslateDocumentResponse translateDocument(TranslateDocumentRequest request) {
        return (TranslateDocumentResponse)this.translateDocumentCallable().call((Object)request);
    }

    public final UnaryCallable<TranslateDocumentRequest, TranslateDocumentResponse> translateDocumentCallable() {
        return this.stub.translateDocumentCallable();
    }

    public final OperationFuture<BatchTranslateResponse, BatchTranslateMetadata> batchTranslateTextAsync(BatchTranslateTextRequest request) {
        return this.batchTranslateTextOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BatchTranslateTextRequest, BatchTranslateResponse, BatchTranslateMetadata> batchTranslateTextOperationCallable() {
        return this.stub.batchTranslateTextOperationCallable();
    }

    public final UnaryCallable<BatchTranslateTextRequest, Operation> batchTranslateTextCallable() {
        return this.stub.batchTranslateTextCallable();
    }

    public final OperationFuture<BatchTranslateDocumentResponse, BatchTranslateDocumentMetadata> batchTranslateDocumentAsync(BatchTranslateDocumentRequest request) {
        return this.batchTranslateDocumentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BatchTranslateDocumentRequest, BatchTranslateDocumentResponse, BatchTranslateDocumentMetadata> batchTranslateDocumentOperationCallable() {
        return this.stub.batchTranslateDocumentOperationCallable();
    }

    public final UnaryCallable<BatchTranslateDocumentRequest, Operation> batchTranslateDocumentCallable() {
        return this.stub.batchTranslateDocumentCallable();
    }

    public final OperationFuture<Glossary, CreateGlossaryMetadata> createGlossaryAsync(LocationName parent, Glossary glossary) {
        CreateGlossaryRequest request = CreateGlossaryRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setGlossary(glossary).build();
        return this.createGlossaryAsync(request);
    }

    public final OperationFuture<Glossary, CreateGlossaryMetadata> createGlossaryAsync(String parent, Glossary glossary) {
        CreateGlossaryRequest request = CreateGlossaryRequest.newBuilder().setParent(parent).setGlossary(glossary).build();
        return this.createGlossaryAsync(request);
    }

    public final OperationFuture<Glossary, CreateGlossaryMetadata> createGlossaryAsync(CreateGlossaryRequest request) {
        return this.createGlossaryOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateGlossaryRequest, Glossary, CreateGlossaryMetadata> createGlossaryOperationCallable() {
        return this.stub.createGlossaryOperationCallable();
    }

    public final UnaryCallable<CreateGlossaryRequest, Operation> createGlossaryCallable() {
        return this.stub.createGlossaryCallable();
    }

    public final ListGlossariesPagedResponse listGlossaries(LocationName parent) {
        ListGlossariesRequest request = ListGlossariesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listGlossaries(request);
    }

    public final ListGlossariesPagedResponse listGlossaries(String parent) {
        ListGlossariesRequest request = ListGlossariesRequest.newBuilder().setParent(parent).build();
        return this.listGlossaries(request);
    }

    public final ListGlossariesPagedResponse listGlossaries(ListGlossariesRequest request) {
        return (ListGlossariesPagedResponse)((Object)this.listGlossariesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGlossariesRequest, ListGlossariesPagedResponse> listGlossariesPagedCallable() {
        return this.stub.listGlossariesPagedCallable();
    }

    public final UnaryCallable<ListGlossariesRequest, ListGlossariesResponse> listGlossariesCallable() {
        return this.stub.listGlossariesCallable();
    }

    public final Glossary getGlossary(GlossaryName name) {
        GetGlossaryRequest request = GetGlossaryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getGlossary(request);
    }

    public final Glossary getGlossary(String name) {
        GetGlossaryRequest request = GetGlossaryRequest.newBuilder().setName(name).build();
        return this.getGlossary(request);
    }

    public final Glossary getGlossary(GetGlossaryRequest request) {
        return (Glossary)this.getGlossaryCallable().call((Object)request);
    }

    public final UnaryCallable<GetGlossaryRequest, Glossary> getGlossaryCallable() {
        return this.stub.getGlossaryCallable();
    }

    public final OperationFuture<DeleteGlossaryResponse, DeleteGlossaryMetadata> deleteGlossaryAsync(GlossaryName name) {
        DeleteGlossaryRequest request = DeleteGlossaryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteGlossaryAsync(request);
    }

    public final OperationFuture<DeleteGlossaryResponse, DeleteGlossaryMetadata> deleteGlossaryAsync(String name) {
        DeleteGlossaryRequest request = DeleteGlossaryRequest.newBuilder().setName(name).build();
        return this.deleteGlossaryAsync(request);
    }

    public final OperationFuture<DeleteGlossaryResponse, DeleteGlossaryMetadata> deleteGlossaryAsync(DeleteGlossaryRequest request) {
        return this.deleteGlossaryOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteGlossaryRequest, DeleteGlossaryResponse, DeleteGlossaryMetadata> deleteGlossaryOperationCallable() {
        return this.stub.deleteGlossaryOperationCallable();
    }

    public final UnaryCallable<DeleteGlossaryRequest, Operation> deleteGlossaryCallable() {
        return this.stub.deleteGlossaryCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListGlossariesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGlossariesRequest, ListGlossariesResponse, Glossary, ListGlossariesPage, ListGlossariesFixedSizeCollection> {
        private ListGlossariesFixedSizeCollection(List<ListGlossariesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListGlossariesFixedSizeCollection createEmptyCollection() {
            return new ListGlossariesFixedSizeCollection(null, 0);
        }

        protected ListGlossariesFixedSizeCollection createCollection(List<ListGlossariesPage> pages, int collectionSize) {
            return new ListGlossariesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListGlossariesPage
    extends AbstractPage<ListGlossariesRequest, ListGlossariesResponse, Glossary, ListGlossariesPage> {
        private ListGlossariesPage(PageContext<ListGlossariesRequest, ListGlossariesResponse, Glossary> context, ListGlossariesResponse response) {
            super(context, (Object)response);
        }

        private static ListGlossariesPage createEmptyPage() {
            return new ListGlossariesPage(null, null);
        }

        protected ListGlossariesPage createPage(PageContext<ListGlossariesRequest, ListGlossariesResponse, Glossary> context, ListGlossariesResponse response) {
            return new ListGlossariesPage(context, response);
        }

        public ApiFuture<ListGlossariesPage> createPageAsync(PageContext<ListGlossariesRequest, ListGlossariesResponse, Glossary> context, ApiFuture<ListGlossariesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListGlossariesPagedResponse
    extends AbstractPagedListResponse<ListGlossariesRequest, ListGlossariesResponse, Glossary, ListGlossariesPage, ListGlossariesFixedSizeCollection> {
        public static ApiFuture<ListGlossariesPagedResponse> createAsync(PageContext<ListGlossariesRequest, ListGlossariesResponse, Glossary> context, ApiFuture<ListGlossariesResponse> futureResponse) {
            ApiFuture<ListGlossariesPage> futurePage = ListGlossariesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListGlossariesPagedResponse((ListGlossariesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListGlossariesPagedResponse(ListGlossariesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListGlossariesFixedSizeCollection.createEmptyCollection());
        }
    }
}

