/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.translate.spi;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson.JacksonFactory;
import com.google.api.services.translate.Translate;
import com.google.api.services.translate.model.DetectionsListResponse;
import com.google.api.services.translate.model.DetectionsResourceItems;
import com.google.api.services.translate.model.LanguagesListResponse;
import com.google.api.services.translate.model.LanguagesResource;
import com.google.api.services.translate.model.TranslationsListResponse;
import com.google.api.services.translate.model.TranslationsResource;
import com.google.cloud.translate.TranslateException;
import com.google.cloud.translate.TranslateOptions;
import com.google.cloud.translate.spi.TranslateRpc;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class DefaultTranslateRpc
implements TranslateRpc {
    private final TranslateOptions options;
    private final Translate translate;

    public DefaultTranslateRpc(TranslateOptions options) {
        HttpTransport transport = options.httpTransportFactory().create();
        HttpRequestInitializer initializer = options.httpRequestInitializer();
        this.options = options;
        this.translate = new Translate.Builder(transport, (JsonFactory)new JacksonFactory(), initializer).setRootUrl(options.host()).setApplicationName(options.applicationName()).build();
    }

    private static TranslateException translate(IOException exception) {
        return new TranslateException(exception);
    }

    @Override
    public List<List<DetectionsResourceItems>> detect(List<String> texts) {
        try {
            List detections = ((DetectionsListResponse)this.translate.detections().list(texts).setKey(this.options.apiKey()).execute()).getDetections();
            return detections != null ? detections : ImmutableList.of();
        }
        catch (IOException ex) {
            throw DefaultTranslateRpc.translate(ex);
        }
    }

    @Override
    public List<LanguagesResource> listSupportedLanguages(Map<TranslateRpc.Option, ?> optionMap) {
        try {
            List languages = ((LanguagesListResponse)this.translate.languages().list().setKey(this.options.apiKey()).setTarget((String)MoreObjects.firstNonNull((Object)TranslateRpc.Option.TARGET_LANGUAGE.getString(optionMap), (Object)this.options.targetLanguage())).execute()).getLanguages();
            return languages != null ? languages : ImmutableList.of();
        }
        catch (IOException ex) {
            throw DefaultTranslateRpc.translate(ex);
        }
    }

    @Override
    public List<TranslationsResource> translate(List<String> texts, Map<TranslateRpc.Option, ?> optionMap) {
        try {
            String targetLanguage = (String)MoreObjects.firstNonNull((Object)TranslateRpc.Option.TARGET_LANGUAGE.getString(optionMap), (Object)this.options.targetLanguage());
            final String sourceLanguage = TranslateRpc.Option.SOURCE_LANGUAGE.getString(optionMap);
            List translations = ((TranslationsListResponse)this.translate.translations().list(texts, targetLanguage).setSource(sourceLanguage).setKey(this.options.apiKey()).execute()).getTranslations();
            return Lists.transform((List)(translations != null ? translations : ImmutableList.of()), (Function)new Function<TranslationsResource, TranslationsResource>(){

                public TranslationsResource apply(TranslationsResource translationsResource) {
                    if (translationsResource.getDetectedSourceLanguage() == null) {
                        translationsResource.setDetectedSourceLanguage(sourceLanguage);
                    }
                    return translationsResource;
                }
            });
        }
        catch (IOException ex) {
            throw DefaultTranslateRpc.translate(ex);
        }
    }
}

