/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.translate;

import com.google.cloud.AuthCredentials;
import com.google.cloud.HttpServiceOptions;
import com.google.cloud.translate.Translate;
import com.google.cloud.translate.TranslateFactory;
import com.google.cloud.translate.TranslateImpl;
import com.google.cloud.translate.spi.DefaultTranslateRpc;
import com.google.cloud.translate.spi.TranslateRpc;
import com.google.cloud.translate.spi.TranslateRpcFactory;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Locale;
import java.util.Set;

public class TranslateOptions
extends HttpServiceOptions<Translate, TranslateRpc, TranslateOptions> {
    private static final long serialVersionUID = 5997441123713672886L;
    private static final String API_KEY_ENV_NAME = "GOOGLE_API_KEY";
    private static final Set<String> SCOPES = ImmutableSet.of();
    private final String apiKey;
    private final String targetLanguage;

    private TranslateOptions(Builder builder) {
        super(TranslateFactory.class, TranslateRpcFactory.class, (HttpServiceOptions.Builder)builder);
        this.apiKey = builder.apiKey != null ? builder.apiKey : this.defaultApiKey();
        Preconditions.checkArgument((this.apiKey != null ? 1 : 0) != 0, (Object)"An API key is required for this service but could not be determined from the builder or the environment. Please set an API key using the builder.");
        this.targetLanguage = (String)MoreObjects.firstNonNull((Object)builder.targetLanguage, (Object)Locale.ENGLISH.getLanguage());
    }

    protected TranslateFactory defaultServiceFactory() {
        return DefaultTranslateFactory.INSTANCE;
    }

    protected TranslateRpcFactory defaultRpcFactory() {
        return DefaultTranslateRpcFactory.INSTANCE;
    }

    protected boolean projectIdRequired() {
        return false;
    }

    protected Set<String> scopes() {
        return SCOPES;
    }

    protected String defaultApiKey() {
        return System.getProperty(API_KEY_ENV_NAME, System.getenv(API_KEY_ENV_NAME));
    }

    public String apiKey() {
        return this.apiKey;
    }

    public String targetLanguage() {
        return this.targetLanguage;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public int hashCode() {
        return this.baseHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TranslateOptions)) {
            return false;
        }
        TranslateOptions options = (TranslateOptions)((Object)obj);
        return this.baseEquals(options) && this.apiKey.equals(options.apiKey) && this.targetLanguage.equals(options.targetLanguage);
    }

    public static TranslateOptions defaultInstance() {
        return TranslateOptions.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends HttpServiceOptions.Builder<Translate, TranslateRpc, TranslateOptions, Builder> {
        private String apiKey;
        private String targetLanguage;

        private Builder() {
        }

        private Builder(TranslateOptions options) {
            super((HttpServiceOptions)options);
            this.apiKey = options.apiKey;
        }

        public Builder projectId(String projectId) {
            super.projectId(projectId);
            return (Builder)this.self();
        }

        public Builder authCredentials(AuthCredentials authCredentials) {
            super.authCredentials(authCredentials);
            return (Builder)this.self();
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder targetLanguage(String targetLanguage) {
            this.targetLanguage = targetLanguage;
            return (Builder)this.self();
        }

        public TranslateOptions build() {
            this.authCredentials(AuthCredentials.noAuth());
            return new TranslateOptions(this);
        }
    }

    public static class DefaultTranslateRpcFactory
    implements TranslateRpcFactory {
        private static final TranslateRpcFactory INSTANCE = new DefaultTranslateRpcFactory();

        public TranslateRpc create(TranslateOptions options) {
            return new DefaultTranslateRpc(options);
        }
    }

    public static class DefaultTranslateFactory
    implements TranslateFactory {
        private static final TranslateFactory INSTANCE = new DefaultTranslateFactory();

        public Translate create(TranslateOptions options) {
            return new TranslateImpl(options);
        }
    }
}

