/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tpu.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.tpu.v1.AcceleratorType;
import com.google.cloud.tpu.v1.AcceleratorTypeName;
import com.google.cloud.tpu.v1.CreateNodeRequest;
import com.google.cloud.tpu.v1.DeleteNodeRequest;
import com.google.cloud.tpu.v1.GetAcceleratorTypeRequest;
import com.google.cloud.tpu.v1.GetNodeRequest;
import com.google.cloud.tpu.v1.GetTensorFlowVersionRequest;
import com.google.cloud.tpu.v1.ListAcceleratorTypesRequest;
import com.google.cloud.tpu.v1.ListAcceleratorTypesResponse;
import com.google.cloud.tpu.v1.ListNodesRequest;
import com.google.cloud.tpu.v1.ListNodesResponse;
import com.google.cloud.tpu.v1.ListTensorFlowVersionsRequest;
import com.google.cloud.tpu.v1.ListTensorFlowVersionsResponse;
import com.google.cloud.tpu.v1.LocationName;
import com.google.cloud.tpu.v1.Node;
import com.google.cloud.tpu.v1.NodeName;
import com.google.cloud.tpu.v1.OperationMetadata;
import com.google.cloud.tpu.v1.ReimageNodeRequest;
import com.google.cloud.tpu.v1.StartNodeRequest;
import com.google.cloud.tpu.v1.StopNodeRequest;
import com.google.cloud.tpu.v1.TensorFlowVersion;
import com.google.cloud.tpu.v1.TensorFlowVersionName;
import com.google.cloud.tpu.v1.TpuSettings;
import com.google.cloud.tpu.v1.stub.TpuStub;
import com.google.cloud.tpu.v1.stub.TpuStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class TpuClient
implements BackgroundResource {
    private final TpuSettings settings;
    private final TpuStub stub;
    private final OperationsClient operationsClient;

    public static final TpuClient create() throws IOException {
        return TpuClient.create(TpuSettings.newBuilder().build());
    }

    public static final TpuClient create(TpuSettings settings) throws IOException {
        return new TpuClient(settings);
    }

    public static final TpuClient create(TpuStub stub) {
        return new TpuClient(stub);
    }

    protected TpuClient(TpuSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TpuStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected TpuClient(TpuStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final TpuSettings getSettings() {
        return this.settings;
    }

    public TpuStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListNodesPagedResponse listNodes(LocationName parent) {
        ListNodesRequest request = ListNodesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listNodes(request);
    }

    public final ListNodesPagedResponse listNodes(String parent) {
        ListNodesRequest request = ListNodesRequest.newBuilder().setParent(parent).build();
        return this.listNodes(request);
    }

    public final ListNodesPagedResponse listNodes(ListNodesRequest request) {
        return (ListNodesPagedResponse)((Object)this.listNodesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListNodesRequest, ListNodesPagedResponse> listNodesPagedCallable() {
        return this.stub.listNodesPagedCallable();
    }

    public final UnaryCallable<ListNodesRequest, ListNodesResponse> listNodesCallable() {
        return this.stub.listNodesCallable();
    }

    public final Node getNode(NodeName name) {
        GetNodeRequest request = GetNodeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getNode(request);
    }

    public final Node getNode(String name) {
        GetNodeRequest request = GetNodeRequest.newBuilder().setName(name).build();
        return this.getNode(request);
    }

    public final Node getNode(GetNodeRequest request) {
        return (Node)this.getNodeCallable().call((Object)request);
    }

    public final UnaryCallable<GetNodeRequest, Node> getNodeCallable() {
        return this.stub.getNodeCallable();
    }

    public final OperationFuture<Node, OperationMetadata> createNodeAsync(LocationName parent, Node node, String nodeId) {
        CreateNodeRequest request = CreateNodeRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setNode(node).setNodeId(nodeId).build();
        return this.createNodeAsync(request);
    }

    public final OperationFuture<Node, OperationMetadata> createNodeAsync(String parent, Node node, String nodeId) {
        CreateNodeRequest request = CreateNodeRequest.newBuilder().setParent(parent).setNode(node).setNodeId(nodeId).build();
        return this.createNodeAsync(request);
    }

    public final OperationFuture<Node, OperationMetadata> createNodeAsync(CreateNodeRequest request) {
        return this.createNodeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateNodeRequest, Node, OperationMetadata> createNodeOperationCallable() {
        return this.stub.createNodeOperationCallable();
    }

    public final UnaryCallable<CreateNodeRequest, Operation> createNodeCallable() {
        return this.stub.createNodeCallable();
    }

    public final OperationFuture<Node, OperationMetadata> deleteNodeAsync(NodeName name) {
        DeleteNodeRequest request = DeleteNodeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteNodeAsync(request);
    }

    public final OperationFuture<Node, OperationMetadata> deleteNodeAsync(String name) {
        DeleteNodeRequest request = DeleteNodeRequest.newBuilder().setName(name).build();
        return this.deleteNodeAsync(request);
    }

    public final OperationFuture<Node, OperationMetadata> deleteNodeAsync(DeleteNodeRequest request) {
        return this.deleteNodeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteNodeRequest, Node, OperationMetadata> deleteNodeOperationCallable() {
        return this.stub.deleteNodeOperationCallable();
    }

    public final UnaryCallable<DeleteNodeRequest, Operation> deleteNodeCallable() {
        return this.stub.deleteNodeCallable();
    }

    public final OperationFuture<Node, OperationMetadata> reimageNodeAsync(ReimageNodeRequest request) {
        return this.reimageNodeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ReimageNodeRequest, Node, OperationMetadata> reimageNodeOperationCallable() {
        return this.stub.reimageNodeOperationCallable();
    }

    public final UnaryCallable<ReimageNodeRequest, Operation> reimageNodeCallable() {
        return this.stub.reimageNodeCallable();
    }

    public final OperationFuture<Node, OperationMetadata> stopNodeAsync(StopNodeRequest request) {
        return this.stopNodeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<StopNodeRequest, Node, OperationMetadata> stopNodeOperationCallable() {
        return this.stub.stopNodeOperationCallable();
    }

    public final UnaryCallable<StopNodeRequest, Operation> stopNodeCallable() {
        return this.stub.stopNodeCallable();
    }

    public final OperationFuture<Node, OperationMetadata> startNodeAsync(StartNodeRequest request) {
        return this.startNodeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<StartNodeRequest, Node, OperationMetadata> startNodeOperationCallable() {
        return this.stub.startNodeOperationCallable();
    }

    public final UnaryCallable<StartNodeRequest, Operation> startNodeCallable() {
        return this.stub.startNodeCallable();
    }

    public final ListTensorFlowVersionsPagedResponse listTensorFlowVersions(TensorFlowVersionName parent) {
        ListTensorFlowVersionsRequest request = ListTensorFlowVersionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTensorFlowVersions(request);
    }

    public final ListTensorFlowVersionsPagedResponse listTensorFlowVersions(String parent) {
        ListTensorFlowVersionsRequest request = ListTensorFlowVersionsRequest.newBuilder().setParent(parent).build();
        return this.listTensorFlowVersions(request);
    }

    public final ListTensorFlowVersionsPagedResponse listTensorFlowVersions(ListTensorFlowVersionsRequest request) {
        return (ListTensorFlowVersionsPagedResponse)((Object)this.listTensorFlowVersionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTensorFlowVersionsRequest, ListTensorFlowVersionsPagedResponse> listTensorFlowVersionsPagedCallable() {
        return this.stub.listTensorFlowVersionsPagedCallable();
    }

    public final UnaryCallable<ListTensorFlowVersionsRequest, ListTensorFlowVersionsResponse> listTensorFlowVersionsCallable() {
        return this.stub.listTensorFlowVersionsCallable();
    }

    public final TensorFlowVersion getTensorFlowVersion(TensorFlowVersionName name) {
        GetTensorFlowVersionRequest request = GetTensorFlowVersionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTensorFlowVersion(request);
    }

    public final TensorFlowVersion getTensorFlowVersion(String name) {
        GetTensorFlowVersionRequest request = GetTensorFlowVersionRequest.newBuilder().setName(name).build();
        return this.getTensorFlowVersion(request);
    }

    public final TensorFlowVersion getTensorFlowVersion(GetTensorFlowVersionRequest request) {
        return (TensorFlowVersion)this.getTensorFlowVersionCallable().call((Object)request);
    }

    public final UnaryCallable<GetTensorFlowVersionRequest, TensorFlowVersion> getTensorFlowVersionCallable() {
        return this.stub.getTensorFlowVersionCallable();
    }

    public final ListAcceleratorTypesPagedResponse listAcceleratorTypes(AcceleratorTypeName parent) {
        ListAcceleratorTypesRequest request = ListAcceleratorTypesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAcceleratorTypes(request);
    }

    public final ListAcceleratorTypesPagedResponse listAcceleratorTypes(String parent) {
        ListAcceleratorTypesRequest request = ListAcceleratorTypesRequest.newBuilder().setParent(parent).build();
        return this.listAcceleratorTypes(request);
    }

    public final ListAcceleratorTypesPagedResponse listAcceleratorTypes(ListAcceleratorTypesRequest request) {
        return (ListAcceleratorTypesPagedResponse)((Object)this.listAcceleratorTypesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAcceleratorTypesRequest, ListAcceleratorTypesPagedResponse> listAcceleratorTypesPagedCallable() {
        return this.stub.listAcceleratorTypesPagedCallable();
    }

    public final UnaryCallable<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse> listAcceleratorTypesCallable() {
        return this.stub.listAcceleratorTypesCallable();
    }

    public final AcceleratorType getAcceleratorType(AcceleratorTypeName name) {
        GetAcceleratorTypeRequest request = GetAcceleratorTypeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAcceleratorType(request);
    }

    public final AcceleratorType getAcceleratorType(String name) {
        GetAcceleratorTypeRequest request = GetAcceleratorTypeRequest.newBuilder().setName(name).build();
        return this.getAcceleratorType(request);
    }

    public final AcceleratorType getAcceleratorType(GetAcceleratorTypeRequest request) {
        return (AcceleratorType)this.getAcceleratorTypeCallable().call((Object)request);
    }

    public final UnaryCallable<GetAcceleratorTypeRequest, AcceleratorType> getAcceleratorTypeCallable() {
        return this.stub.getAcceleratorTypeCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListAcceleratorTypesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse, AcceleratorType, ListAcceleratorTypesPage, ListAcceleratorTypesFixedSizeCollection> {
        private ListAcceleratorTypesFixedSizeCollection(List<ListAcceleratorTypesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAcceleratorTypesFixedSizeCollection createEmptyCollection() {
            return new ListAcceleratorTypesFixedSizeCollection(null, 0);
        }

        protected ListAcceleratorTypesFixedSizeCollection createCollection(List<ListAcceleratorTypesPage> pages, int collectionSize) {
            return new ListAcceleratorTypesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAcceleratorTypesPage
    extends AbstractPage<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse, AcceleratorType, ListAcceleratorTypesPage> {
        private ListAcceleratorTypesPage(PageContext<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse, AcceleratorType> context, ListAcceleratorTypesResponse response) {
            super(context, (Object)response);
        }

        private static ListAcceleratorTypesPage createEmptyPage() {
            return new ListAcceleratorTypesPage(null, null);
        }

        protected ListAcceleratorTypesPage createPage(PageContext<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse, AcceleratorType> context, ListAcceleratorTypesResponse response) {
            return new ListAcceleratorTypesPage(context, response);
        }

        public ApiFuture<ListAcceleratorTypesPage> createPageAsync(PageContext<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse, AcceleratorType> context, ApiFuture<ListAcceleratorTypesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAcceleratorTypesPagedResponse
    extends AbstractPagedListResponse<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse, AcceleratorType, ListAcceleratorTypesPage, ListAcceleratorTypesFixedSizeCollection> {
        public static ApiFuture<ListAcceleratorTypesPagedResponse> createAsync(PageContext<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse, AcceleratorType> context, ApiFuture<ListAcceleratorTypesResponse> futureResponse) {
            ApiFuture<ListAcceleratorTypesPage> futurePage = ListAcceleratorTypesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAcceleratorTypesPagedResponse((ListAcceleratorTypesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAcceleratorTypesPagedResponse(ListAcceleratorTypesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAcceleratorTypesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListTensorFlowVersionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTensorFlowVersionsRequest, ListTensorFlowVersionsResponse, TensorFlowVersion, ListTensorFlowVersionsPage, ListTensorFlowVersionsFixedSizeCollection> {
        private ListTensorFlowVersionsFixedSizeCollection(List<ListTensorFlowVersionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTensorFlowVersionsFixedSizeCollection createEmptyCollection() {
            return new ListTensorFlowVersionsFixedSizeCollection(null, 0);
        }

        protected ListTensorFlowVersionsFixedSizeCollection createCollection(List<ListTensorFlowVersionsPage> pages, int collectionSize) {
            return new ListTensorFlowVersionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTensorFlowVersionsPage
    extends AbstractPage<ListTensorFlowVersionsRequest, ListTensorFlowVersionsResponse, TensorFlowVersion, ListTensorFlowVersionsPage> {
        private ListTensorFlowVersionsPage(PageContext<ListTensorFlowVersionsRequest, ListTensorFlowVersionsResponse, TensorFlowVersion> context, ListTensorFlowVersionsResponse response) {
            super(context, (Object)response);
        }

        private static ListTensorFlowVersionsPage createEmptyPage() {
            return new ListTensorFlowVersionsPage(null, null);
        }

        protected ListTensorFlowVersionsPage createPage(PageContext<ListTensorFlowVersionsRequest, ListTensorFlowVersionsResponse, TensorFlowVersion> context, ListTensorFlowVersionsResponse response) {
            return new ListTensorFlowVersionsPage(context, response);
        }

        public ApiFuture<ListTensorFlowVersionsPage> createPageAsync(PageContext<ListTensorFlowVersionsRequest, ListTensorFlowVersionsResponse, TensorFlowVersion> context, ApiFuture<ListTensorFlowVersionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTensorFlowVersionsPagedResponse
    extends AbstractPagedListResponse<ListTensorFlowVersionsRequest, ListTensorFlowVersionsResponse, TensorFlowVersion, ListTensorFlowVersionsPage, ListTensorFlowVersionsFixedSizeCollection> {
        public static ApiFuture<ListTensorFlowVersionsPagedResponse> createAsync(PageContext<ListTensorFlowVersionsRequest, ListTensorFlowVersionsResponse, TensorFlowVersion> context, ApiFuture<ListTensorFlowVersionsResponse> futureResponse) {
            ApiFuture<ListTensorFlowVersionsPage> futurePage = ListTensorFlowVersionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTensorFlowVersionsPagedResponse((ListTensorFlowVersionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTensorFlowVersionsPagedResponse(ListTensorFlowVersionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTensorFlowVersionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListNodesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNodesRequest, ListNodesResponse, Node, ListNodesPage, ListNodesFixedSizeCollection> {
        private ListNodesFixedSizeCollection(List<ListNodesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNodesFixedSizeCollection createEmptyCollection() {
            return new ListNodesFixedSizeCollection(null, 0);
        }

        protected ListNodesFixedSizeCollection createCollection(List<ListNodesPage> pages, int collectionSize) {
            return new ListNodesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNodesPage
    extends AbstractPage<ListNodesRequest, ListNodesResponse, Node, ListNodesPage> {
        private ListNodesPage(PageContext<ListNodesRequest, ListNodesResponse, Node> context, ListNodesResponse response) {
            super(context, (Object)response);
        }

        private static ListNodesPage createEmptyPage() {
            return new ListNodesPage(null, null);
        }

        protected ListNodesPage createPage(PageContext<ListNodesRequest, ListNodesResponse, Node> context, ListNodesResponse response) {
            return new ListNodesPage(context, response);
        }

        public ApiFuture<ListNodesPage> createPageAsync(PageContext<ListNodesRequest, ListNodesResponse, Node> context, ApiFuture<ListNodesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListNodesPagedResponse
    extends AbstractPagedListResponse<ListNodesRequest, ListNodesResponse, Node, ListNodesPage, ListNodesFixedSizeCollection> {
        public static ApiFuture<ListNodesPagedResponse> createAsync(PageContext<ListNodesRequest, ListNodesResponse, Node> context, ApiFuture<ListNodesResponse> futureResponse) {
            ApiFuture<ListNodesPage> futurePage = ListNodesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListNodesPagedResponse((ListNodesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListNodesPagedResponse(ListNodesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListNodesFixedSizeCollection.createEmptyCollection());
        }
    }
}

