/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tpu.v2.stub;

import com.google.api.HttpRule;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.tpu.v2.AcceleratorType;
import com.google.cloud.tpu.v2.CreateNodeRequest;
import com.google.cloud.tpu.v2.DeleteNodeRequest;
import com.google.cloud.tpu.v2.GenerateServiceIdentityRequest;
import com.google.cloud.tpu.v2.GenerateServiceIdentityResponse;
import com.google.cloud.tpu.v2.GetAcceleratorTypeRequest;
import com.google.cloud.tpu.v2.GetGuestAttributesRequest;
import com.google.cloud.tpu.v2.GetGuestAttributesResponse;
import com.google.cloud.tpu.v2.GetNodeRequest;
import com.google.cloud.tpu.v2.GetRuntimeVersionRequest;
import com.google.cloud.tpu.v2.ListAcceleratorTypesRequest;
import com.google.cloud.tpu.v2.ListAcceleratorTypesResponse;
import com.google.cloud.tpu.v2.ListNodesRequest;
import com.google.cloud.tpu.v2.ListNodesResponse;
import com.google.cloud.tpu.v2.ListRuntimeVersionsRequest;
import com.google.cloud.tpu.v2.ListRuntimeVersionsResponse;
import com.google.cloud.tpu.v2.Node;
import com.google.cloud.tpu.v2.OperationMetadata;
import com.google.cloud.tpu.v2.RuntimeVersion;
import com.google.cloud.tpu.v2.StartNodeRequest;
import com.google.cloud.tpu.v2.StopNodeRequest;
import com.google.cloud.tpu.v2.TpuClient;
import com.google.cloud.tpu.v2.UpdateNodeRequest;
import com.google.cloud.tpu.v2.stub.HttpJsonTpuCallableFactory;
import com.google.cloud.tpu.v2.stub.TpuStub;
import com.google.cloud.tpu.v2.stub.TpuStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonTpuStub
extends TpuStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Empty.getDescriptor()).add(OperationMetadata.getDescriptor()).add(Node.getDescriptor()).build();
    private static final ApiMethodDescriptor<ListNodesRequest, ListNodesResponse> listNodesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.tpu.v2.Tpu/ListNodes").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*/locations/*}/nodes", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListNodesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetNodeRequest, Node> getNodeMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.tpu.v2.Tpu/GetNode").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/nodes/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Node.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateNodeRequest, Operation> createNodeMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.tpu.v2.Tpu/CreateNode").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*/locations/*}/nodes", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "nodeId", (Object)request.getNodeId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("node", (Message)request.getNode(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteNodeRequest, Operation> deleteNodeMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.tpu.v2.Tpu/DeleteNode").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/nodes/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<StopNodeRequest, Operation> stopNodeMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.tpu.v2.Tpu/StopNode").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/nodes/*}:stop", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<StartNodeRequest, Operation> startNodeMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.tpu.v2.Tpu/StartNode").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/nodes/*}:start", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateNodeRequest, Operation> updateNodeMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.tpu.v2.Tpu/UpdateNode").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{node.name=projects/*/locations/*/nodes/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "node.name", (Object)request.getNode().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("node", (Message)request.getNode(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GenerateServiceIdentityRequest, GenerateServiceIdentityResponse> generateServiceIdentityMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.tpu.v2.Tpu/GenerateServiceIdentity").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*/locations/*}:generateServiceIdentity", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)GenerateServiceIdentityResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse> listAcceleratorTypesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.tpu.v2.Tpu/ListAcceleratorTypes").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*/locations/*}/acceleratorTypes", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListAcceleratorTypesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetAcceleratorTypeRequest, AcceleratorType> getAcceleratorTypeMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.tpu.v2.Tpu/GetAcceleratorType").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/acceleratorTypes/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)AcceleratorType.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListRuntimeVersionsRequest, ListRuntimeVersionsResponse> listRuntimeVersionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.tpu.v2.Tpu/ListRuntimeVersions").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*/locations/*}/runtimeVersions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListRuntimeVersionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetRuntimeVersionRequest, RuntimeVersion> getRuntimeVersionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.tpu.v2.Tpu/GetRuntimeVersion").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/runtimeVersions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)RuntimeVersion.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetGuestAttributesRequest, GetGuestAttributesResponse> getGuestAttributesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.tpu.v2.Tpu/GetGuestAttributes").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/nodes/*}:getGuestAttributes", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)GetGuestAttributesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/ListLocations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*}/locations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListLocationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/GetLocation").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Location.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListNodesRequest, ListNodesResponse> listNodesCallable;
    private final UnaryCallable<ListNodesRequest, TpuClient.ListNodesPagedResponse> listNodesPagedCallable;
    private final UnaryCallable<GetNodeRequest, Node> getNodeCallable;
    private final UnaryCallable<CreateNodeRequest, Operation> createNodeCallable;
    private final OperationCallable<CreateNodeRequest, Node, OperationMetadata> createNodeOperationCallable;
    private final UnaryCallable<DeleteNodeRequest, Operation> deleteNodeCallable;
    private final OperationCallable<DeleteNodeRequest, Empty, OperationMetadata> deleteNodeOperationCallable;
    private final UnaryCallable<StopNodeRequest, Operation> stopNodeCallable;
    private final OperationCallable<StopNodeRequest, Node, OperationMetadata> stopNodeOperationCallable;
    private final UnaryCallable<StartNodeRequest, Operation> startNodeCallable;
    private final OperationCallable<StartNodeRequest, Node, OperationMetadata> startNodeOperationCallable;
    private final UnaryCallable<UpdateNodeRequest, Operation> updateNodeCallable;
    private final OperationCallable<UpdateNodeRequest, Node, OperationMetadata> updateNodeOperationCallable;
    private final UnaryCallable<GenerateServiceIdentityRequest, GenerateServiceIdentityResponse> generateServiceIdentityCallable;
    private final UnaryCallable<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse> listAcceleratorTypesCallable;
    private final UnaryCallable<ListAcceleratorTypesRequest, TpuClient.ListAcceleratorTypesPagedResponse> listAcceleratorTypesPagedCallable;
    private final UnaryCallable<GetAcceleratorTypeRequest, AcceleratorType> getAcceleratorTypeCallable;
    private final UnaryCallable<ListRuntimeVersionsRequest, ListRuntimeVersionsResponse> listRuntimeVersionsCallable;
    private final UnaryCallable<ListRuntimeVersionsRequest, TpuClient.ListRuntimeVersionsPagedResponse> listRuntimeVersionsPagedCallable;
    private final UnaryCallable<GetRuntimeVersionRequest, RuntimeVersion> getRuntimeVersionCallable;
    private final UnaryCallable<GetGuestAttributesRequest, GetGuestAttributesResponse> getGuestAttributesCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, TpuClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonTpuStub create(TpuStubSettings settings) throws IOException {
        return new HttpJsonTpuStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonTpuStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonTpuStub(TpuStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonTpuStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonTpuStub(TpuStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonTpuStub(TpuStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonTpuCallableFactory());
    }

    protected HttpJsonTpuStub(TpuStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.CancelOperation", (Object)HttpRule.newBuilder().setPost("/v2/{name=projects/*/locations/*/operations/*}:cancel").build()).put((Object)"google.longrunning.Operations.DeleteOperation", (Object)HttpRule.newBuilder().setDelete("/v2/{name=projects/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v2/{name=projects/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v2/{name=projects/*/locations/*}/operations").build()).build());
        HttpJsonCallSettings listNodesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listNodesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getNodeTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getNodeMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createNodeTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createNodeMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteNodeTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteNodeMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings stopNodeTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(stopNodeMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings startNodeTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(startNodeMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateNodeTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateNodeMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings generateServiceIdentityTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(generateServiceIdentityMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listAcceleratorTypesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listAcceleratorTypesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getAcceleratorTypeTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getAcceleratorTypeMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listRuntimeVersionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listRuntimeVersionsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getRuntimeVersionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getRuntimeVersionMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getGuestAttributesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getGuestAttributesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listLocationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getLocationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.listNodesCallable = callableFactory.createUnaryCallable(listNodesTransportSettings, settings.listNodesSettings(), clientContext);
        this.listNodesPagedCallable = callableFactory.createPagedCallable(listNodesTransportSettings, settings.listNodesSettings(), clientContext);
        this.getNodeCallable = callableFactory.createUnaryCallable(getNodeTransportSettings, settings.getNodeSettings(), clientContext);
        this.createNodeCallable = callableFactory.createUnaryCallable(createNodeTransportSettings, settings.createNodeSettings(), clientContext);
        this.createNodeOperationCallable = callableFactory.createOperationCallable(createNodeTransportSettings, settings.createNodeOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteNodeCallable = callableFactory.createUnaryCallable(deleteNodeTransportSettings, settings.deleteNodeSettings(), clientContext);
        this.deleteNodeOperationCallable = callableFactory.createOperationCallable(deleteNodeTransportSettings, settings.deleteNodeOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.stopNodeCallable = callableFactory.createUnaryCallable(stopNodeTransportSettings, settings.stopNodeSettings(), clientContext);
        this.stopNodeOperationCallable = callableFactory.createOperationCallable(stopNodeTransportSettings, settings.stopNodeOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.startNodeCallable = callableFactory.createUnaryCallable(startNodeTransportSettings, settings.startNodeSettings(), clientContext);
        this.startNodeOperationCallable = callableFactory.createOperationCallable(startNodeTransportSettings, settings.startNodeOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateNodeCallable = callableFactory.createUnaryCallable(updateNodeTransportSettings, settings.updateNodeSettings(), clientContext);
        this.updateNodeOperationCallable = callableFactory.createOperationCallable(updateNodeTransportSettings, settings.updateNodeOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.generateServiceIdentityCallable = callableFactory.createUnaryCallable(generateServiceIdentityTransportSettings, settings.generateServiceIdentitySettings(), clientContext);
        this.listAcceleratorTypesCallable = callableFactory.createUnaryCallable(listAcceleratorTypesTransportSettings, settings.listAcceleratorTypesSettings(), clientContext);
        this.listAcceleratorTypesPagedCallable = callableFactory.createPagedCallable(listAcceleratorTypesTransportSettings, settings.listAcceleratorTypesSettings(), clientContext);
        this.getAcceleratorTypeCallable = callableFactory.createUnaryCallable(getAcceleratorTypeTransportSettings, settings.getAcceleratorTypeSettings(), clientContext);
        this.listRuntimeVersionsCallable = callableFactory.createUnaryCallable(listRuntimeVersionsTransportSettings, settings.listRuntimeVersionsSettings(), clientContext);
        this.listRuntimeVersionsPagedCallable = callableFactory.createPagedCallable(listRuntimeVersionsTransportSettings, settings.listRuntimeVersionsSettings(), clientContext);
        this.getRuntimeVersionCallable = callableFactory.createUnaryCallable(getRuntimeVersionTransportSettings, settings.getRuntimeVersionSettings(), clientContext);
        this.getGuestAttributesCallable = callableFactory.createUnaryCallable(getGuestAttributesTransportSettings, settings.getGuestAttributesSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listNodesMethodDescriptor);
        methodDescriptors.add(getNodeMethodDescriptor);
        methodDescriptors.add(createNodeMethodDescriptor);
        methodDescriptors.add(deleteNodeMethodDescriptor);
        methodDescriptors.add(stopNodeMethodDescriptor);
        methodDescriptors.add(startNodeMethodDescriptor);
        methodDescriptors.add(updateNodeMethodDescriptor);
        methodDescriptors.add(generateServiceIdentityMethodDescriptor);
        methodDescriptors.add(listAcceleratorTypesMethodDescriptor);
        methodDescriptors.add(getAcceleratorTypeMethodDescriptor);
        methodDescriptors.add(listRuntimeVersionsMethodDescriptor);
        methodDescriptors.add(getRuntimeVersionMethodDescriptor);
        methodDescriptors.add(getGuestAttributesMethodDescriptor);
        methodDescriptors.add(listLocationsMethodDescriptor);
        methodDescriptors.add(getLocationMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<ListNodesRequest, ListNodesResponse> listNodesCallable() {
        return this.listNodesCallable;
    }

    @Override
    public UnaryCallable<ListNodesRequest, TpuClient.ListNodesPagedResponse> listNodesPagedCallable() {
        return this.listNodesPagedCallable;
    }

    @Override
    public UnaryCallable<GetNodeRequest, Node> getNodeCallable() {
        return this.getNodeCallable;
    }

    @Override
    public UnaryCallable<CreateNodeRequest, Operation> createNodeCallable() {
        return this.createNodeCallable;
    }

    @Override
    public OperationCallable<CreateNodeRequest, Node, OperationMetadata> createNodeOperationCallable() {
        return this.createNodeOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteNodeRequest, Operation> deleteNodeCallable() {
        return this.deleteNodeCallable;
    }

    @Override
    public OperationCallable<DeleteNodeRequest, Empty, OperationMetadata> deleteNodeOperationCallable() {
        return this.deleteNodeOperationCallable;
    }

    @Override
    public UnaryCallable<StopNodeRequest, Operation> stopNodeCallable() {
        return this.stopNodeCallable;
    }

    @Override
    public OperationCallable<StopNodeRequest, Node, OperationMetadata> stopNodeOperationCallable() {
        return this.stopNodeOperationCallable;
    }

    @Override
    public UnaryCallable<StartNodeRequest, Operation> startNodeCallable() {
        return this.startNodeCallable;
    }

    @Override
    public OperationCallable<StartNodeRequest, Node, OperationMetadata> startNodeOperationCallable() {
        return this.startNodeOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateNodeRequest, Operation> updateNodeCallable() {
        return this.updateNodeCallable;
    }

    @Override
    public OperationCallable<UpdateNodeRequest, Node, OperationMetadata> updateNodeOperationCallable() {
        return this.updateNodeOperationCallable;
    }

    @Override
    public UnaryCallable<GenerateServiceIdentityRequest, GenerateServiceIdentityResponse> generateServiceIdentityCallable() {
        return this.generateServiceIdentityCallable;
    }

    @Override
    public UnaryCallable<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse> listAcceleratorTypesCallable() {
        return this.listAcceleratorTypesCallable;
    }

    @Override
    public UnaryCallable<ListAcceleratorTypesRequest, TpuClient.ListAcceleratorTypesPagedResponse> listAcceleratorTypesPagedCallable() {
        return this.listAcceleratorTypesPagedCallable;
    }

    @Override
    public UnaryCallable<GetAcceleratorTypeRequest, AcceleratorType> getAcceleratorTypeCallable() {
        return this.getAcceleratorTypeCallable;
    }

    @Override
    public UnaryCallable<ListRuntimeVersionsRequest, ListRuntimeVersionsResponse> listRuntimeVersionsCallable() {
        return this.listRuntimeVersionsCallable;
    }

    @Override
    public UnaryCallable<ListRuntimeVersionsRequest, TpuClient.ListRuntimeVersionsPagedResponse> listRuntimeVersionsPagedCallable() {
        return this.listRuntimeVersionsPagedCallable;
    }

    @Override
    public UnaryCallable<GetRuntimeVersionRequest, RuntimeVersion> getRuntimeVersionCallable() {
        return this.getRuntimeVersionCallable;
    }

    @Override
    public UnaryCallable<GetGuestAttributesRequest, GetGuestAttributesResponse> getGuestAttributesCallable() {
        return this.getGuestAttributesCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, TpuClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

