/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tasks.v2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.tasks.v2.CloudTasksSettings;
import com.google.cloud.tasks.v2.CreateQueueRequest;
import com.google.cloud.tasks.v2.CreateTaskRequest;
import com.google.cloud.tasks.v2.DeleteQueueRequest;
import com.google.cloud.tasks.v2.DeleteTaskRequest;
import com.google.cloud.tasks.v2.GetQueueRequest;
import com.google.cloud.tasks.v2.GetTaskRequest;
import com.google.cloud.tasks.v2.ListQueuesRequest;
import com.google.cloud.tasks.v2.ListQueuesResponse;
import com.google.cloud.tasks.v2.ListTasksRequest;
import com.google.cloud.tasks.v2.ListTasksResponse;
import com.google.cloud.tasks.v2.LocationName;
import com.google.cloud.tasks.v2.PauseQueueRequest;
import com.google.cloud.tasks.v2.PurgeQueueRequest;
import com.google.cloud.tasks.v2.Queue;
import com.google.cloud.tasks.v2.QueueName;
import com.google.cloud.tasks.v2.ResumeQueueRequest;
import com.google.cloud.tasks.v2.RunTaskRequest;
import com.google.cloud.tasks.v2.Task;
import com.google.cloud.tasks.v2.TaskName;
import com.google.cloud.tasks.v2.UpdateQueueRequest;
import com.google.cloud.tasks.v2.stub.CloudTasksStub;
import com.google.cloud.tasks.v2.stub.CloudTasksStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class CloudTasksClient
implements BackgroundResource {
    private final CloudTasksSettings settings;
    private final CloudTasksStub stub;

    public static final CloudTasksClient create() throws IOException {
        return CloudTasksClient.create(CloudTasksSettings.newBuilder().build());
    }

    public static final CloudTasksClient create(CloudTasksSettings settings) throws IOException {
        return new CloudTasksClient(settings);
    }

    public static final CloudTasksClient create(CloudTasksStub stub) {
        return new CloudTasksClient(stub);
    }

    protected CloudTasksClient(CloudTasksSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CloudTasksStubSettings)settings.getStubSettings()).createStub();
    }

    protected CloudTasksClient(CloudTasksStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CloudTasksSettings getSettings() {
        return this.settings;
    }

    public CloudTasksStub getStub() {
        return this.stub;
    }

    public final ListQueuesPagedResponse listQueues(LocationName parent) {
        ListQueuesRequest request = ListQueuesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listQueues(request);
    }

    public final ListQueuesPagedResponse listQueues(String parent) {
        ListQueuesRequest request = ListQueuesRequest.newBuilder().setParent(parent).build();
        return this.listQueues(request);
    }

    public final ListQueuesPagedResponse listQueues(ListQueuesRequest request) {
        return (ListQueuesPagedResponse)((Object)this.listQueuesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListQueuesRequest, ListQueuesPagedResponse> listQueuesPagedCallable() {
        return this.stub.listQueuesPagedCallable();
    }

    public final UnaryCallable<ListQueuesRequest, ListQueuesResponse> listQueuesCallable() {
        return this.stub.listQueuesCallable();
    }

    public final Queue getQueue(QueueName name) {
        GetQueueRequest request = GetQueueRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getQueue(request);
    }

    public final Queue getQueue(String name) {
        GetQueueRequest request = GetQueueRequest.newBuilder().setName(name).build();
        return this.getQueue(request);
    }

    public final Queue getQueue(GetQueueRequest request) {
        return (Queue)this.getQueueCallable().call((Object)request);
    }

    public final UnaryCallable<GetQueueRequest, Queue> getQueueCallable() {
        return this.stub.getQueueCallable();
    }

    public final Queue createQueue(LocationName parent, Queue queue) {
        CreateQueueRequest request = CreateQueueRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setQueue(queue).build();
        return this.createQueue(request);
    }

    public final Queue createQueue(String parent, Queue queue) {
        CreateQueueRequest request = CreateQueueRequest.newBuilder().setParent(parent).setQueue(queue).build();
        return this.createQueue(request);
    }

    public final Queue createQueue(CreateQueueRequest request) {
        return (Queue)this.createQueueCallable().call((Object)request);
    }

    public final UnaryCallable<CreateQueueRequest, Queue> createQueueCallable() {
        return this.stub.createQueueCallable();
    }

    public final Queue updateQueue(Queue queue, FieldMask updateMask) {
        UpdateQueueRequest request = UpdateQueueRequest.newBuilder().setQueue(queue).setUpdateMask(updateMask).build();
        return this.updateQueue(request);
    }

    public final Queue updateQueue(UpdateQueueRequest request) {
        return (Queue)this.updateQueueCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateQueueRequest, Queue> updateQueueCallable() {
        return this.stub.updateQueueCallable();
    }

    public final void deleteQueue(QueueName name) {
        DeleteQueueRequest request = DeleteQueueRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteQueue(request);
    }

    public final void deleteQueue(String name) {
        DeleteQueueRequest request = DeleteQueueRequest.newBuilder().setName(name).build();
        this.deleteQueue(request);
    }

    public final void deleteQueue(DeleteQueueRequest request) {
        this.deleteQueueCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteQueueRequest, Empty> deleteQueueCallable() {
        return this.stub.deleteQueueCallable();
    }

    public final Queue purgeQueue(QueueName name) {
        PurgeQueueRequest request = PurgeQueueRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.purgeQueue(request);
    }

    public final Queue purgeQueue(String name) {
        PurgeQueueRequest request = PurgeQueueRequest.newBuilder().setName(name).build();
        return this.purgeQueue(request);
    }

    public final Queue purgeQueue(PurgeQueueRequest request) {
        return (Queue)this.purgeQueueCallable().call((Object)request);
    }

    public final UnaryCallable<PurgeQueueRequest, Queue> purgeQueueCallable() {
        return this.stub.purgeQueueCallable();
    }

    public final Queue pauseQueue(QueueName name) {
        PauseQueueRequest request = PauseQueueRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.pauseQueue(request);
    }

    public final Queue pauseQueue(String name) {
        PauseQueueRequest request = PauseQueueRequest.newBuilder().setName(name).build();
        return this.pauseQueue(request);
    }

    public final Queue pauseQueue(PauseQueueRequest request) {
        return (Queue)this.pauseQueueCallable().call((Object)request);
    }

    public final UnaryCallable<PauseQueueRequest, Queue> pauseQueueCallable() {
        return this.stub.pauseQueueCallable();
    }

    public final Queue resumeQueue(QueueName name) {
        ResumeQueueRequest request = ResumeQueueRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.resumeQueue(request);
    }

    public final Queue resumeQueue(String name) {
        ResumeQueueRequest request = ResumeQueueRequest.newBuilder().setName(name).build();
        return this.resumeQueue(request);
    }

    public final Queue resumeQueue(ResumeQueueRequest request) {
        return (Queue)this.resumeQueueCallable().call((Object)request);
    }

    public final UnaryCallable<ResumeQueueRequest, Queue> resumeQueueCallable() {
        return this.stub.resumeQueueCallable();
    }

    public final Policy getIamPolicy(ResourceName resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(String resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final Policy getIamPolicy(QueueName queueName) {
        return this.getIamPolicy((ResourceName)queueName);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final Policy setIamPolicy(ResourceName resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(String resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final Policy setIamPolicy(QueueName queue, Policy policy) {
        return this.setIamPolicy((ResourceName)queue, policy);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(ResourceName resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource == null ? null : resource.toString()).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(String resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final TestIamPermissionsResponse testIamPermissions(QueueName queue, List<String> permissions) {
        return this.testIamPermissions((ResourceName)queue, permissions);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final ListTasksPagedResponse listTasks(QueueName parent) {
        ListTasksRequest request = ListTasksRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTasks(request);
    }

    public final ListTasksPagedResponse listTasks(String parent) {
        ListTasksRequest request = ListTasksRequest.newBuilder().setParent(parent).build();
        return this.listTasks(request);
    }

    public final ListTasksPagedResponse listTasks(ListTasksRequest request) {
        return (ListTasksPagedResponse)((Object)this.listTasksPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTasksRequest, ListTasksPagedResponse> listTasksPagedCallable() {
        return this.stub.listTasksPagedCallable();
    }

    public final UnaryCallable<ListTasksRequest, ListTasksResponse> listTasksCallable() {
        return this.stub.listTasksCallable();
    }

    public final Task getTask(TaskName name) {
        GetTaskRequest request = GetTaskRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTask(request);
    }

    public final Task getTask(String name) {
        GetTaskRequest request = GetTaskRequest.newBuilder().setName(name).build();
        return this.getTask(request);
    }

    public final Task getTask(GetTaskRequest request) {
        return (Task)this.getTaskCallable().call((Object)request);
    }

    public final UnaryCallable<GetTaskRequest, Task> getTaskCallable() {
        return this.stub.getTaskCallable();
    }

    public final Task createTask(QueueName parent, Task task) {
        CreateTaskRequest request = CreateTaskRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTask(task).build();
        return this.createTask(request);
    }

    public final Task createTask(String parent, Task task) {
        CreateTaskRequest request = CreateTaskRequest.newBuilder().setParent(parent).setTask(task).build();
        return this.createTask(request);
    }

    public final Task createTask(CreateTaskRequest request) {
        return (Task)this.createTaskCallable().call((Object)request);
    }

    public final UnaryCallable<CreateTaskRequest, Task> createTaskCallable() {
        return this.stub.createTaskCallable();
    }

    public final void deleteTask(TaskName name) {
        DeleteTaskRequest request = DeleteTaskRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteTask(request);
    }

    public final void deleteTask(String name) {
        DeleteTaskRequest request = DeleteTaskRequest.newBuilder().setName(name).build();
        this.deleteTask(request);
    }

    public final void deleteTask(DeleteTaskRequest request) {
        this.deleteTaskCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteTaskRequest, Empty> deleteTaskCallable() {
        return this.stub.deleteTaskCallable();
    }

    public final Task runTask(TaskName name) {
        RunTaskRequest request = RunTaskRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.runTask(request);
    }

    public final Task runTask(String name) {
        RunTaskRequest request = RunTaskRequest.newBuilder().setName(name).build();
        return this.runTask(request);
    }

    public final Task runTask(RunTaskRequest request) {
        return (Task)this.runTaskCallable().call((Object)request);
    }

    public final UnaryCallable<RunTaskRequest, Task> runTaskCallable() {
        return this.stub.runTaskCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListTasksFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTasksRequest, ListTasksResponse, Task, ListTasksPage, ListTasksFixedSizeCollection> {
        private ListTasksFixedSizeCollection(List<ListTasksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTasksFixedSizeCollection createEmptyCollection() {
            return new ListTasksFixedSizeCollection(null, 0);
        }

        protected ListTasksFixedSizeCollection createCollection(List<ListTasksPage> pages, int collectionSize) {
            return new ListTasksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTasksPage
    extends AbstractPage<ListTasksRequest, ListTasksResponse, Task, ListTasksPage> {
        private ListTasksPage(PageContext<ListTasksRequest, ListTasksResponse, Task> context, ListTasksResponse response) {
            super(context, (Object)response);
        }

        private static ListTasksPage createEmptyPage() {
            return new ListTasksPage(null, null);
        }

        protected ListTasksPage createPage(PageContext<ListTasksRequest, ListTasksResponse, Task> context, ListTasksResponse response) {
            return new ListTasksPage(context, response);
        }

        public ApiFuture<ListTasksPage> createPageAsync(PageContext<ListTasksRequest, ListTasksResponse, Task> context, ApiFuture<ListTasksResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTasksPagedResponse
    extends AbstractPagedListResponse<ListTasksRequest, ListTasksResponse, Task, ListTasksPage, ListTasksFixedSizeCollection> {
        public static ApiFuture<ListTasksPagedResponse> createAsync(PageContext<ListTasksRequest, ListTasksResponse, Task> context, ApiFuture<ListTasksResponse> futureResponse) {
            ApiFuture<ListTasksPage> futurePage = ListTasksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTasksPagedResponse((ListTasksPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTasksPagedResponse(ListTasksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTasksFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListQueuesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListQueuesRequest, ListQueuesResponse, Queue, ListQueuesPage, ListQueuesFixedSizeCollection> {
        private ListQueuesFixedSizeCollection(List<ListQueuesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListQueuesFixedSizeCollection createEmptyCollection() {
            return new ListQueuesFixedSizeCollection(null, 0);
        }

        protected ListQueuesFixedSizeCollection createCollection(List<ListQueuesPage> pages, int collectionSize) {
            return new ListQueuesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListQueuesPage
    extends AbstractPage<ListQueuesRequest, ListQueuesResponse, Queue, ListQueuesPage> {
        private ListQueuesPage(PageContext<ListQueuesRequest, ListQueuesResponse, Queue> context, ListQueuesResponse response) {
            super(context, (Object)response);
        }

        private static ListQueuesPage createEmptyPage() {
            return new ListQueuesPage(null, null);
        }

        protected ListQueuesPage createPage(PageContext<ListQueuesRequest, ListQueuesResponse, Queue> context, ListQueuesResponse response) {
            return new ListQueuesPage(context, response);
        }

        public ApiFuture<ListQueuesPage> createPageAsync(PageContext<ListQueuesRequest, ListQueuesResponse, Queue> context, ApiFuture<ListQueuesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListQueuesPagedResponse
    extends AbstractPagedListResponse<ListQueuesRequest, ListQueuesResponse, Queue, ListQueuesPage, ListQueuesFixedSizeCollection> {
        public static ApiFuture<ListQueuesPagedResponse> createAsync(PageContext<ListQueuesRequest, ListQueuesResponse, Queue> context, ApiFuture<ListQueuesResponse> futureResponse) {
            ApiFuture<ListQueuesPage> futurePage = ListQueuesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListQueuesPagedResponse((ListQueuesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListQueuesPagedResponse(ListQueuesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListQueuesFixedSizeCollection.createEmptyCollection());
        }
    }
}

