/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.talent.v4beta1.BatchCreateJobsRequest;
import com.google.cloud.talent.v4beta1.BatchDeleteJobsRequest;
import com.google.cloud.talent.v4beta1.BatchOperationMetadata;
import com.google.cloud.talent.v4beta1.BatchUpdateJobsRequest;
import com.google.cloud.talent.v4beta1.CreateJobRequest;
import com.google.cloud.talent.v4beta1.DeleteJobRequest;
import com.google.cloud.talent.v4beta1.GetJobRequest;
import com.google.cloud.talent.v4beta1.Job;
import com.google.cloud.talent.v4beta1.JobName;
import com.google.cloud.talent.v4beta1.JobOperationResult;
import com.google.cloud.talent.v4beta1.JobServiceSettings;
import com.google.cloud.talent.v4beta1.ListJobsRequest;
import com.google.cloud.talent.v4beta1.ListJobsResponse;
import com.google.cloud.talent.v4beta1.ProjectName;
import com.google.cloud.talent.v4beta1.SearchJobsRequest;
import com.google.cloud.talent.v4beta1.SearchJobsResponse;
import com.google.cloud.talent.v4beta1.TenantName;
import com.google.cloud.talent.v4beta1.UpdateJobRequest;
import com.google.cloud.talent.v4beta1.stub.JobServiceStub;
import com.google.cloud.talent.v4beta1.stub.JobServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class JobServiceClient
implements BackgroundResource {
    private final JobServiceSettings settings;
    private final JobServiceStub stub;
    private final OperationsClient operationsClient;

    public static final JobServiceClient create() throws IOException {
        return JobServiceClient.create(JobServiceSettings.newBuilder().build());
    }

    public static final JobServiceClient create(JobServiceSettings settings) throws IOException {
        return new JobServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final JobServiceClient create(JobServiceStub stub) {
        return new JobServiceClient(stub);
    }

    protected JobServiceClient(JobServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((JobServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected JobServiceClient(JobServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final JobServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public JobServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final Job createJob(ProjectName parent, Job job) {
        CreateJobRequest request = CreateJobRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setJob(job).build();
        return this.createJob(request);
    }

    public final Job createJob(TenantName parent, Job job) {
        CreateJobRequest request = CreateJobRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setJob(job).build();
        return this.createJob(request);
    }

    public final Job createJob(String parent, Job job) {
        CreateJobRequest request = CreateJobRequest.newBuilder().setParent(parent).setJob(job).build();
        return this.createJob(request);
    }

    public final Job createJob(CreateJobRequest request) {
        return (Job)this.createJobCallable().call((Object)request);
    }

    public final UnaryCallable<CreateJobRequest, Job> createJobCallable() {
        return this.stub.createJobCallable();
    }

    public final OperationFuture<JobOperationResult, BatchOperationMetadata> batchCreateJobsAsync(ProjectName parent, List<Job> jobs) {
        BatchCreateJobsRequest request = BatchCreateJobsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllJobs(jobs).build();
        return this.batchCreateJobsAsync(request);
    }

    public final OperationFuture<JobOperationResult, BatchOperationMetadata> batchCreateJobsAsync(TenantName parent, List<Job> jobs) {
        BatchCreateJobsRequest request = BatchCreateJobsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllJobs(jobs).build();
        return this.batchCreateJobsAsync(request);
    }

    public final OperationFuture<JobOperationResult, BatchOperationMetadata> batchCreateJobsAsync(String parent, List<Job> jobs) {
        BatchCreateJobsRequest request = BatchCreateJobsRequest.newBuilder().setParent(parent).addAllJobs(jobs).build();
        return this.batchCreateJobsAsync(request);
    }

    public final OperationFuture<JobOperationResult, BatchOperationMetadata> batchCreateJobsAsync(BatchCreateJobsRequest request) {
        return this.batchCreateJobsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BatchCreateJobsRequest, JobOperationResult, BatchOperationMetadata> batchCreateJobsOperationCallable() {
        return this.stub.batchCreateJobsOperationCallable();
    }

    public final UnaryCallable<BatchCreateJobsRequest, Operation> batchCreateJobsCallable() {
        return this.stub.batchCreateJobsCallable();
    }

    public final Job getJob(JobName name) {
        GetJobRequest request = GetJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getJob(request);
    }

    public final Job getJob(String name) {
        GetJobRequest request = GetJobRequest.newBuilder().setName(name).build();
        return this.getJob(request);
    }

    public final Job getJob(GetJobRequest request) {
        return (Job)this.getJobCallable().call((Object)request);
    }

    public final UnaryCallable<GetJobRequest, Job> getJobCallable() {
        return this.stub.getJobCallable();
    }

    public final Job updateJob(Job job) {
        UpdateJobRequest request = UpdateJobRequest.newBuilder().setJob(job).build();
        return this.updateJob(request);
    }

    public final Job updateJob(UpdateJobRequest request) {
        return (Job)this.updateJobCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateJobRequest, Job> updateJobCallable() {
        return this.stub.updateJobCallable();
    }

    public final OperationFuture<JobOperationResult, BatchOperationMetadata> batchUpdateJobsAsync(ProjectName parent, List<Job> jobs) {
        BatchUpdateJobsRequest request = BatchUpdateJobsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllJobs(jobs).build();
        return this.batchUpdateJobsAsync(request);
    }

    public final OperationFuture<JobOperationResult, BatchOperationMetadata> batchUpdateJobsAsync(TenantName parent, List<Job> jobs) {
        BatchUpdateJobsRequest request = BatchUpdateJobsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllJobs(jobs).build();
        return this.batchUpdateJobsAsync(request);
    }

    public final OperationFuture<JobOperationResult, BatchOperationMetadata> batchUpdateJobsAsync(String parent, List<Job> jobs) {
        BatchUpdateJobsRequest request = BatchUpdateJobsRequest.newBuilder().setParent(parent).addAllJobs(jobs).build();
        return this.batchUpdateJobsAsync(request);
    }

    public final OperationFuture<JobOperationResult, BatchOperationMetadata> batchUpdateJobsAsync(BatchUpdateJobsRequest request) {
        return this.batchUpdateJobsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BatchUpdateJobsRequest, JobOperationResult, BatchOperationMetadata> batchUpdateJobsOperationCallable() {
        return this.stub.batchUpdateJobsOperationCallable();
    }

    public final UnaryCallable<BatchUpdateJobsRequest, Operation> batchUpdateJobsCallable() {
        return this.stub.batchUpdateJobsCallable();
    }

    public final void deleteJob(JobName name) {
        DeleteJobRequest request = DeleteJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteJob(request);
    }

    public final void deleteJob(String name) {
        DeleteJobRequest request = DeleteJobRequest.newBuilder().setName(name).build();
        this.deleteJob(request);
    }

    public final void deleteJob(DeleteJobRequest request) {
        this.deleteJobCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteJobRequest, Empty> deleteJobCallable() {
        return this.stub.deleteJobCallable();
    }

    public final void batchDeleteJobs(ProjectName parent, String filter) {
        BatchDeleteJobsRequest request = BatchDeleteJobsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setFilter(filter).build();
        this.batchDeleteJobs(request);
    }

    public final void batchDeleteJobs(TenantName parent, String filter) {
        BatchDeleteJobsRequest request = BatchDeleteJobsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setFilter(filter).build();
        this.batchDeleteJobs(request);
    }

    public final void batchDeleteJobs(String parent, String filter) {
        BatchDeleteJobsRequest request = BatchDeleteJobsRequest.newBuilder().setParent(parent).setFilter(filter).build();
        this.batchDeleteJobs(request);
    }

    public final void batchDeleteJobs(BatchDeleteJobsRequest request) {
        this.batchDeleteJobsCallable().call((Object)request);
    }

    public final UnaryCallable<BatchDeleteJobsRequest, Empty> batchDeleteJobsCallable() {
        return this.stub.batchDeleteJobsCallable();
    }

    public final ListJobsPagedResponse listJobs(ProjectName parent, String filter) {
        ListJobsRequest request = ListJobsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setFilter(filter).build();
        return this.listJobs(request);
    }

    public final ListJobsPagedResponse listJobs(TenantName parent, String filter) {
        ListJobsRequest request = ListJobsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setFilter(filter).build();
        return this.listJobs(request);
    }

    public final ListJobsPagedResponse listJobs(String parent, String filter) {
        ListJobsRequest request = ListJobsRequest.newBuilder().setParent(parent).setFilter(filter).build();
        return this.listJobs(request);
    }

    public final ListJobsPagedResponse listJobs(ListJobsRequest request) {
        return (ListJobsPagedResponse)((Object)this.listJobsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListJobsRequest, ListJobsPagedResponse> listJobsPagedCallable() {
        return this.stub.listJobsPagedCallable();
    }

    public final UnaryCallable<ListJobsRequest, ListJobsResponse> listJobsCallable() {
        return this.stub.listJobsCallable();
    }

    public final SearchJobsPagedResponse searchJobs(SearchJobsRequest request) {
        return (SearchJobsPagedResponse)((Object)this.searchJobsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchJobsRequest, SearchJobsPagedResponse> searchJobsPagedCallable() {
        return this.stub.searchJobsPagedCallable();
    }

    public final UnaryCallable<SearchJobsRequest, SearchJobsResponse> searchJobsCallable() {
        return this.stub.searchJobsCallable();
    }

    public final SearchJobsForAlertPagedResponse searchJobsForAlert(SearchJobsRequest request) {
        return (SearchJobsForAlertPagedResponse)((Object)this.searchJobsForAlertPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchJobsRequest, SearchJobsForAlertPagedResponse> searchJobsForAlertPagedCallable() {
        return this.stub.searchJobsForAlertPagedCallable();
    }

    public final UnaryCallable<SearchJobsRequest, SearchJobsResponse> searchJobsForAlertCallable() {
        return this.stub.searchJobsForAlertCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class SearchJobsForAlertFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchJobsRequest, SearchJobsResponse, SearchJobsResponse.MatchingJob, SearchJobsForAlertPage, SearchJobsForAlertFixedSizeCollection> {
        private SearchJobsForAlertFixedSizeCollection(List<SearchJobsForAlertPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchJobsForAlertFixedSizeCollection createEmptyCollection() {
            return new SearchJobsForAlertFixedSizeCollection(null, 0);
        }

        protected SearchJobsForAlertFixedSizeCollection createCollection(List<SearchJobsForAlertPage> pages, int collectionSize) {
            return new SearchJobsForAlertFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchJobsForAlertPage
    extends AbstractPage<SearchJobsRequest, SearchJobsResponse, SearchJobsResponse.MatchingJob, SearchJobsForAlertPage> {
        private SearchJobsForAlertPage(PageContext<SearchJobsRequest, SearchJobsResponse, SearchJobsResponse.MatchingJob> context, SearchJobsResponse response) {
            super(context, (Object)response);
        }

        private static SearchJobsForAlertPage createEmptyPage() {
            return new SearchJobsForAlertPage(null, null);
        }

        protected SearchJobsForAlertPage createPage(PageContext<SearchJobsRequest, SearchJobsResponse, SearchJobsResponse.MatchingJob> context, SearchJobsResponse response) {
            return new SearchJobsForAlertPage(context, response);
        }

        public ApiFuture<SearchJobsForAlertPage> createPageAsync(PageContext<SearchJobsRequest, SearchJobsResponse, SearchJobsResponse.MatchingJob> context, ApiFuture<SearchJobsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchJobsForAlertPagedResponse
    extends AbstractPagedListResponse<SearchJobsRequest, SearchJobsResponse, SearchJobsResponse.MatchingJob, SearchJobsForAlertPage, SearchJobsForAlertFixedSizeCollection> {
        public static ApiFuture<SearchJobsForAlertPagedResponse> createAsync(PageContext<SearchJobsRequest, SearchJobsResponse, SearchJobsResponse.MatchingJob> context, ApiFuture<SearchJobsResponse> futureResponse) {
            ApiFuture<SearchJobsForAlertPage> futurePage = SearchJobsForAlertPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SearchJobsForAlertPagedResponse((SearchJobsForAlertPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SearchJobsForAlertPagedResponse(SearchJobsForAlertPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchJobsForAlertFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class SearchJobsFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchJobsRequest, SearchJobsResponse, SearchJobsResponse.MatchingJob, SearchJobsPage, SearchJobsFixedSizeCollection> {
        private SearchJobsFixedSizeCollection(List<SearchJobsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchJobsFixedSizeCollection createEmptyCollection() {
            return new SearchJobsFixedSizeCollection(null, 0);
        }

        protected SearchJobsFixedSizeCollection createCollection(List<SearchJobsPage> pages, int collectionSize) {
            return new SearchJobsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchJobsPage
    extends AbstractPage<SearchJobsRequest, SearchJobsResponse, SearchJobsResponse.MatchingJob, SearchJobsPage> {
        private SearchJobsPage(PageContext<SearchJobsRequest, SearchJobsResponse, SearchJobsResponse.MatchingJob> context, SearchJobsResponse response) {
            super(context, (Object)response);
        }

        private static SearchJobsPage createEmptyPage() {
            return new SearchJobsPage(null, null);
        }

        protected SearchJobsPage createPage(PageContext<SearchJobsRequest, SearchJobsResponse, SearchJobsResponse.MatchingJob> context, SearchJobsResponse response) {
            return new SearchJobsPage(context, response);
        }

        public ApiFuture<SearchJobsPage> createPageAsync(PageContext<SearchJobsRequest, SearchJobsResponse, SearchJobsResponse.MatchingJob> context, ApiFuture<SearchJobsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchJobsPagedResponse
    extends AbstractPagedListResponse<SearchJobsRequest, SearchJobsResponse, SearchJobsResponse.MatchingJob, SearchJobsPage, SearchJobsFixedSizeCollection> {
        public static ApiFuture<SearchJobsPagedResponse> createAsync(PageContext<SearchJobsRequest, SearchJobsResponse, SearchJobsResponse.MatchingJob> context, ApiFuture<SearchJobsResponse> futureResponse) {
            ApiFuture<SearchJobsPage> futurePage = SearchJobsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SearchJobsPagedResponse((SearchJobsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SearchJobsPagedResponse(SearchJobsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchJobsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListJobsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListJobsRequest, ListJobsResponse, Job, ListJobsPage, ListJobsFixedSizeCollection> {
        private ListJobsFixedSizeCollection(List<ListJobsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListJobsFixedSizeCollection createEmptyCollection() {
            return new ListJobsFixedSizeCollection(null, 0);
        }

        protected ListJobsFixedSizeCollection createCollection(List<ListJobsPage> pages, int collectionSize) {
            return new ListJobsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListJobsPage
    extends AbstractPage<ListJobsRequest, ListJobsResponse, Job, ListJobsPage> {
        private ListJobsPage(PageContext<ListJobsRequest, ListJobsResponse, Job> context, ListJobsResponse response) {
            super(context, (Object)response);
        }

        private static ListJobsPage createEmptyPage() {
            return new ListJobsPage(null, null);
        }

        protected ListJobsPage createPage(PageContext<ListJobsRequest, ListJobsResponse, Job> context, ListJobsResponse response) {
            return new ListJobsPage(context, response);
        }

        public ApiFuture<ListJobsPage> createPageAsync(PageContext<ListJobsRequest, ListJobsResponse, Job> context, ApiFuture<ListJobsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListJobsPagedResponse
    extends AbstractPagedListResponse<ListJobsRequest, ListJobsResponse, Job, ListJobsPage, ListJobsFixedSizeCollection> {
        public static ApiFuture<ListJobsPagedResponse> createAsync(PageContext<ListJobsRequest, ListJobsResponse, Job> context, ApiFuture<ListJobsResponse> futureResponse) {
            ApiFuture<ListJobsPage> futurePage = ListJobsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListJobsPagedResponse((ListJobsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListJobsPagedResponse(ListJobsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListJobsFixedSizeCollection.createEmptyCollection());
        }
    }
}

