/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.talent.v4beta1.Application;
import com.google.cloud.talent.v4beta1.ApplicationServiceClient;
import com.google.cloud.talent.v4beta1.CreateApplicationRequest;
import com.google.cloud.talent.v4beta1.DeleteApplicationRequest;
import com.google.cloud.talent.v4beta1.GetApplicationRequest;
import com.google.cloud.talent.v4beta1.ListApplicationsRequest;
import com.google.cloud.talent.v4beta1.ListApplicationsResponse;
import com.google.cloud.talent.v4beta1.UpdateApplicationRequest;
import com.google.cloud.talent.v4beta1.stub.ApplicationServiceStub;
import com.google.cloud.talent.v4beta1.stub.GrpcApplicationServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class ApplicationServiceStubSettings
extends StubSettings<ApplicationServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/jobs").build();
    private final UnaryCallSettings<CreateApplicationRequest, Application> createApplicationSettings;
    private final UnaryCallSettings<GetApplicationRequest, Application> getApplicationSettings;
    private final UnaryCallSettings<UpdateApplicationRequest, Application> updateApplicationSettings;
    private final UnaryCallSettings<DeleteApplicationRequest, Empty> deleteApplicationSettings;
    private final PagedCallSettings<ListApplicationsRequest, ListApplicationsResponse, ApplicationServiceClient.ListApplicationsPagedResponse> listApplicationsSettings;
    private static final PagedListDescriptor<ListApplicationsRequest, ListApplicationsResponse, Application> LIST_APPLICATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListApplicationsRequest, ListApplicationsResponse, Application>(){

        public String emptyToken() {
            return "";
        }

        public ListApplicationsRequest injectToken(ListApplicationsRequest payload, String token) {
            return ListApplicationsRequest.newBuilder((ListApplicationsRequest)payload).setPageToken(token).build();
        }

        public ListApplicationsRequest injectPageSize(ListApplicationsRequest payload, int pageSize) {
            return ListApplicationsRequest.newBuilder((ListApplicationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListApplicationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListApplicationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Application> extractResources(ListApplicationsResponse payload) {
            return payload.getApplicationsList() != null ? payload.getApplicationsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListApplicationsRequest, ListApplicationsResponse, ApplicationServiceClient.ListApplicationsPagedResponse> LIST_APPLICATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListApplicationsRequest, ListApplicationsResponse, ApplicationServiceClient.ListApplicationsPagedResponse>(){

        public ApiFuture<ApplicationServiceClient.ListApplicationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListApplicationsRequest, ListApplicationsResponse> callable, ListApplicationsRequest request, ApiCallContext context, ApiFuture<ListApplicationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_APPLICATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ApplicationServiceClient.ListApplicationsPagedResponse.createAsync((PageContext<ListApplicationsRequest, ListApplicationsResponse, Application>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateApplicationRequest, Application> createApplicationSettings() {
        return this.createApplicationSettings;
    }

    public UnaryCallSettings<GetApplicationRequest, Application> getApplicationSettings() {
        return this.getApplicationSettings;
    }

    public UnaryCallSettings<UpdateApplicationRequest, Application> updateApplicationSettings() {
        return this.updateApplicationSettings;
    }

    public UnaryCallSettings<DeleteApplicationRequest, Empty> deleteApplicationSettings() {
        return this.deleteApplicationSettings;
    }

    public PagedCallSettings<ListApplicationsRequest, ListApplicationsResponse, ApplicationServiceClient.ListApplicationsPagedResponse> listApplicationsSettings() {
        return this.listApplicationsSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ApplicationServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcApplicationServiceStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "jobs.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ApplicationServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ApplicationServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ApplicationServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createApplicationSettings = settingsBuilder.createApplicationSettings().build();
        this.getApplicationSettings = settingsBuilder.getApplicationSettings().build();
        this.updateApplicationSettings = settingsBuilder.updateApplicationSettings().build();
        this.deleteApplicationSettings = settingsBuilder.deleteApplicationSettings().build();
        this.listApplicationsSettings = settingsBuilder.listApplicationsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ApplicationServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateApplicationRequest, Application> createApplicationSettings;
        private final UnaryCallSettings.Builder<GetApplicationRequest, Application> getApplicationSettings;
        private final UnaryCallSettings.Builder<UpdateApplicationRequest, Application> updateApplicationSettings;
        private final UnaryCallSettings.Builder<DeleteApplicationRequest, Empty> deleteApplicationSettings;
        private final PagedCallSettings.Builder<ListApplicationsRequest, ListApplicationsResponse, ApplicationServiceClient.ListApplicationsPagedResponse> listApplicationsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createApplicationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getApplicationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateApplicationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteApplicationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listApplicationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_APPLICATIONS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createApplicationSettings, this.getApplicationSettings, this.updateApplicationSettings, this.deleteApplicationSettings, this.listApplicationsSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ApplicationServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ApplicationServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ApplicationServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ApplicationServiceStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createApplicationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getApplicationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateApplicationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteApplicationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listApplicationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(ApplicationServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createApplicationSettings = settings.createApplicationSettings.toBuilder();
            this.getApplicationSettings = settings.getApplicationSettings.toBuilder();
            this.updateApplicationSettings = settings.updateApplicationSettings.toBuilder();
            this.deleteApplicationSettings = settings.deleteApplicationSettings.toBuilder();
            this.listApplicationsSettings = settings.listApplicationsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createApplicationSettings, this.getApplicationSettings, this.updateApplicationSettings, this.deleteApplicationSettings, this.listApplicationsSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateApplicationRequest, Application> createApplicationSettings() {
            return this.createApplicationSettings;
        }

        public UnaryCallSettings.Builder<GetApplicationRequest, Application> getApplicationSettings() {
            return this.getApplicationSettings;
        }

        public UnaryCallSettings.Builder<UpdateApplicationRequest, Application> updateApplicationSettings() {
            return this.updateApplicationSettings;
        }

        public UnaryCallSettings.Builder<DeleteApplicationRequest, Empty> deleteApplicationSettings() {
            return this.deleteApplicationSettings;
        }

        public PagedCallSettings.Builder<ListApplicationsRequest, ListApplicationsResponse, ApplicationServiceClient.ListApplicationsPagedResponse> listApplicationsSettings() {
            return this.listApplicationsSettings;
        }

        public ApplicationServiceStubSettings build() throws IOException {
            return new ApplicationServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

