/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4beta1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.talent.v4beta1.ParseResumeRequest;
import com.google.cloud.talent.v4beta1.ParseResumeResponse;
import com.google.cloud.talent.v4beta1.ProjectName;
import com.google.cloud.talent.v4beta1.ResumeServiceSettings;
import com.google.cloud.talent.v4beta1.stub.ResumeServiceStub;
import com.google.cloud.talent.v4beta1.stub.ResumeServiceStubSettings;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ResumeServiceClient
implements BackgroundResource {
    private final ResumeServiceSettings settings;
    private final ResumeServiceStub stub;

    public static final ResumeServiceClient create() throws IOException {
        return ResumeServiceClient.create(ResumeServiceSettings.newBuilder().build());
    }

    public static final ResumeServiceClient create(ResumeServiceSettings settings) throws IOException {
        return new ResumeServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ResumeServiceClient create(ResumeServiceStub stub) {
        return new ResumeServiceClient(stub);
    }

    protected ResumeServiceClient(ResumeServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ResumeServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ResumeServiceClient(ResumeServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ResumeServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ResumeServiceStub getStub() {
        return this.stub;
    }

    public final ParseResumeResponse parseResume(ProjectName parent, ByteString resume) {
        ParseResumeRequest request = ParseResumeRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setResume(resume).build();
        return this.parseResume(request);
    }

    public final ParseResumeResponse parseResume(String parent, ByteString resume) {
        ParseResumeRequest request = ParseResumeRequest.newBuilder().setParent(parent).setResume(resume).build();
        return this.parseResume(request);
    }

    public final ParseResumeResponse parseResume(ParseResumeRequest request) {
        return (ParseResumeResponse)this.parseResumeCallable().call((Object)request);
    }

    public final UnaryCallable<ParseResumeRequest, ParseResumeResponse> parseResumeCallable() {
        return this.stub.parseResumeCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

