/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.multipartupload.model;

import com.google.common.base.MoreObjects;
import java.util.Objects;

public final class ListMultipartUploadsRequest {
    private final String bucket;
    private final String delimiter;
    private final String encodingType;
    private final String keyMarker;
    private final Integer maxUploads;
    private final String prefix;
    private final String uploadIdMarker;
    private final String userProject;

    private ListMultipartUploadsRequest(String bucket, String delimiter, String encodingType, String keyMarker, Integer maxUploads, String prefix, String uploadIdMarker, String userProject) {
        this.bucket = bucket;
        this.delimiter = delimiter;
        this.encodingType = encodingType;
        this.keyMarker = keyMarker;
        this.maxUploads = maxUploads;
        this.prefix = prefix;
        this.uploadIdMarker = uploadIdMarker;
        this.userProject = userProject;
    }

    public String bucket() {
        return this.bucket;
    }

    public String delimiter() {
        return this.delimiter;
    }

    public String encodingType() {
        return this.encodingType;
    }

    public String keyMarker() {
        return this.keyMarker;
    }

    public Integer maxUploads() {
        return this.maxUploads;
    }

    public String prefix() {
        return this.prefix;
    }

    public String uploadIdMarker() {
        return this.uploadIdMarker;
    }

    public String userProject() {
        return this.userProject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListMultipartUploadsRequest that = (ListMultipartUploadsRequest)o;
        return Objects.equals(this.bucket, that.bucket) && Objects.equals(this.delimiter, that.delimiter) && Objects.equals(this.encodingType, that.encodingType) && Objects.equals(this.keyMarker, that.keyMarker) && Objects.equals(this.maxUploads, that.maxUploads) && Objects.equals(this.prefix, that.prefix) && Objects.equals(this.uploadIdMarker, that.uploadIdMarker) && Objects.equals(this.userProject, that.userProject);
    }

    public int hashCode() {
        return Objects.hash(this.bucket, this.delimiter, this.encodingType, this.keyMarker, this.maxUploads, this.prefix, this.uploadIdMarker, this.userProject);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bucket", (Object)this.bucket).add("delimiter", (Object)this.delimiter).add("encodingType", (Object)this.encodingType).add("keyMarker", (Object)this.keyMarker).add("maxUploads", (Object)this.maxUploads).add("prefix", (Object)this.prefix).add("uploadIdMarker", (Object)this.uploadIdMarker).add("userProject", (Object)this.userProject).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String bucket;
        private String delimiter;
        private String encodingType;
        private String keyMarker;
        private Integer maxUploads;
        private String prefix;
        private String uploadIdMarker;
        private String userProject;

        private Builder() {
        }

        public Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public Builder encodingType(String encodingType) {
            this.encodingType = encodingType;
            return this;
        }

        public Builder keyMarker(String keyMarker) {
            this.keyMarker = keyMarker;
            return this;
        }

        public Builder maxUploads(Integer maxUploads) {
            this.maxUploads = maxUploads;
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder uploadIdMarker(String uploadIdMarker) {
            this.uploadIdMarker = uploadIdMarker;
            return this;
        }

        public Builder userProject(String userProject) {
            this.userProject = userProject;
            return this;
        }

        public ListMultipartUploadsRequest build() {
            return new ListMultipartUploadsRequest(this.bucket, this.delimiter, this.encodingType, this.keyMarker, this.maxUploads, this.prefix, this.uploadIdMarker, this.userProject);
        }
    }
}

