/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.multipartupload.model;

import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageClass;
import com.google.cloud.storage.multipartupload.model.ObjectLockMode;
import com.google.common.base.MoreObjects;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Objects;

public final class CreateMultipartUploadRequest {
    private final String bucket;
    private final String key;
    private final Storage.PredefinedAcl cannedAcl;
    private final String contentType;
    private final String contentDisposition;
    private final String contentEncoding;
    private final String contentLanguage;
    private final String cacheControl;
    private final Map<String, String> metadata;
    private final StorageClass storageClass;
    private final OffsetDateTime customTime;
    private final String kmsKeyName;
    private final ObjectLockMode objectLockMode;
    private final OffsetDateTime objectLockRetainUntilDate;
    private final String userProject;

    private CreateMultipartUploadRequest(Builder builder) {
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.cannedAcl = builder.cannedAcl;
        this.contentType = builder.contentType;
        this.contentDisposition = builder.contentDisposition;
        this.contentEncoding = builder.contentEncoding;
        this.contentLanguage = builder.contentLanguage;
        this.cacheControl = builder.cacheControl;
        this.metadata = builder.metadata;
        this.storageClass = builder.storageClass;
        this.customTime = builder.customTime;
        this.kmsKeyName = builder.kmsKeyName;
        this.objectLockMode = builder.objectLockMode;
        this.objectLockRetainUntilDate = builder.objectLockRetainUntilDate;
        this.userProject = builder.userProject;
    }

    public String bucket() {
        return this.bucket;
    }

    public String key() {
        return this.key;
    }

    public Storage.PredefinedAcl cannedAcl() {
        return this.cannedAcl;
    }

    public String contentType() {
        return this.contentType;
    }

    public String contentDisposition() {
        return this.contentDisposition;
    }

    public String contentEncoding() {
        return this.contentEncoding;
    }

    public String contentLanguage() {
        return this.contentLanguage;
    }

    public String cacheControl() {
        return this.cacheControl;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public StorageClass storageClass() {
        return this.storageClass;
    }

    public OffsetDateTime customTime() {
        return this.customTime;
    }

    public String kmsKeyName() {
        return this.kmsKeyName;
    }

    public ObjectLockMode objectLockMode() {
        return this.objectLockMode;
    }

    public OffsetDateTime objectLockRetainUntilDate() {
        return this.objectLockRetainUntilDate;
    }

    public String userProject() {
        return this.userProject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateMultipartUploadRequest)) {
            return false;
        }
        CreateMultipartUploadRequest that = (CreateMultipartUploadRequest)o;
        return Objects.equals(this.bucket, that.bucket) && Objects.equals(this.key, that.key) && this.cannedAcl == that.cannedAcl && Objects.equals(this.contentType, that.contentType) && Objects.equals(this.contentDisposition, that.contentDisposition) && Objects.equals(this.contentEncoding, that.contentEncoding) && Objects.equals(this.contentLanguage, that.contentLanguage) && Objects.equals(this.cacheControl, that.cacheControl) && Objects.equals(this.metadata, that.metadata) && Objects.equals((Object)this.storageClass, (Object)that.storageClass) && Objects.equals(this.customTime, that.customTime) && Objects.equals(this.kmsKeyName, that.kmsKeyName) && this.objectLockMode == that.objectLockMode && Objects.equals(this.objectLockRetainUntilDate, that.objectLockRetainUntilDate) && Objects.equals(this.userProject, that.userProject);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bucket, this.key, this.cannedAcl, this.contentType, this.contentDisposition, this.contentEncoding, this.contentLanguage, this.cacheControl, this.metadata, this.storageClass, this.customTime, this.kmsKeyName, this.objectLockMode, this.objectLockRetainUntilDate, this.userProject});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bucket", (Object)this.bucket).add("key", (Object)this.key).add("cannedAcl", (Object)this.cannedAcl).add("contentType", (Object)this.contentType).add("contentDisposition", (Object)this.contentDisposition).add("contentEncoding", (Object)this.contentEncoding).add("contentLanguage", (Object)this.contentLanguage).add("cacheControl", (Object)this.cacheControl).add("metadata", this.metadata).add("storageClass", (Object)this.storageClass).add("customTime", (Object)this.customTime).add("kmsKeyName", (Object)this.kmsKeyName).add("objectLockMode", (Object)this.objectLockMode).add("objectLockRetainUntilDate", (Object)this.objectLockRetainUntilDate).add("userProject", (Object)this.userProject).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String bucket;
        private String key;
        private Storage.PredefinedAcl cannedAcl;
        private String contentType;
        private String contentDisposition;
        private String contentEncoding;
        private String contentLanguage;
        private String cacheControl;
        private Map<String, String> metadata;
        private StorageClass storageClass;
        private OffsetDateTime customTime;
        private String kmsKeyName;
        private ObjectLockMode objectLockMode;
        private OffsetDateTime objectLockRetainUntilDate;
        private String userProject;

        private Builder() {
        }

        public Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder cannedAcl(Storage.PredefinedAcl cannedAcl) {
            this.cannedAcl = cannedAcl;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder contentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        public Builder contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public Builder contentLanguage(String contentLanguage) {
            this.contentLanguage = contentLanguage;
            return this;
        }

        public Builder cacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder storageClass(StorageClass storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        public Builder customTime(OffsetDateTime customTime) {
            this.customTime = customTime;
            return this;
        }

        public Builder kmsKeyName(String kmsKeyName) {
            this.kmsKeyName = kmsKeyName;
            return this;
        }

        public Builder objectLockMode(ObjectLockMode objectLockMode) {
            this.objectLockMode = objectLockMode;
            return this;
        }

        public Builder objectLockRetainUntilDate(OffsetDateTime objectLockRetainUntilDate) {
            this.objectLockRetainUntilDate = objectLockRetainUntilDate;
            return this;
        }

        public Builder userProject(String userProject) {
            this.userProject = userProject;
            return this;
        }

        public CreateMultipartUploadRequest build() {
            return new CreateMultipartUploadRequest(this);
        }
    }
}

