/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.multipartupload.model;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.google.cloud.storage.multipartupload.model.CompletedPart;
import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Objects;

@JacksonXmlRootElement(localName="CompleteMultipartUpload")
public class CompletedMultipartUpload {
    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="Part")
    private final List<CompletedPart> completedPartList;

    private CompletedMultipartUpload(Builder builder) {
        this.completedPartList = builder.parts;
    }

    public List<CompletedPart> parts() {
        return this.completedPartList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompletedMultipartUpload)) {
            return false;
        }
        CompletedMultipartUpload that = (CompletedMultipartUpload)o;
        return Objects.equals(this.completedPartList, that.completedPartList);
    }

    public int hashCode() {
        return Objects.hash(this.completedPartList);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("completedPartList", this.completedPartList).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<CompletedPart> parts;

        private Builder() {
        }

        public Builder parts(List<CompletedPart> completedPartList) {
            this.parts = completedPartList;
            return this;
        }

        public CompletedMultipartUpload build() {
            return new CompletedMultipartUpload(this);
        }
    }
}

