/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.InternalExtensionOnly;
import com.google.cloud.storage.HttpStorageOptions;
import com.google.cloud.storage.MultipartUploadClientImpl;
import com.google.cloud.storage.MultipartUploadHttpRequestManager;
import com.google.cloud.storage.MultipartUploadSettings;
import com.google.cloud.storage.RequestBody;
import com.google.cloud.storage.multipartupload.model.AbortMultipartUploadRequest;
import com.google.cloud.storage.multipartupload.model.AbortMultipartUploadResponse;
import com.google.cloud.storage.multipartupload.model.CompleteMultipartUploadRequest;
import com.google.cloud.storage.multipartupload.model.CompleteMultipartUploadResponse;
import com.google.cloud.storage.multipartupload.model.CreateMultipartUploadRequest;
import com.google.cloud.storage.multipartupload.model.CreateMultipartUploadResponse;
import com.google.cloud.storage.multipartupload.model.ListMultipartUploadsRequest;
import com.google.cloud.storage.multipartupload.model.ListMultipartUploadsResponse;
import com.google.cloud.storage.multipartupload.model.ListPartsRequest;
import com.google.cloud.storage.multipartupload.model.ListPartsResponse;
import com.google.cloud.storage.multipartupload.model.UploadPartRequest;
import com.google.cloud.storage.multipartupload.model.UploadPartResponse;

@InternalExtensionOnly
public abstract class MultipartUploadClient {
    MultipartUploadClient() {
    }

    public abstract CreateMultipartUploadResponse createMultipartUpload(CreateMultipartUploadRequest var1);

    public abstract ListPartsResponse listParts(ListPartsRequest var1);

    public abstract AbortMultipartUploadResponse abortMultipartUpload(AbortMultipartUploadRequest var1);

    public abstract CompleteMultipartUploadResponse completeMultipartUpload(CompleteMultipartUploadRequest var1);

    public abstract UploadPartResponse uploadPart(UploadPartRequest var1, RequestBody var2);

    public abstract ListMultipartUploadsResponse listMultipartUploads(ListMultipartUploadsRequest var1);

    public static MultipartUploadClient create(MultipartUploadSettings config) {
        HttpStorageOptions options = config.getOptions();
        return new MultipartUploadClientImpl(options.createRetrier(), MultipartUploadHttpRequestManager.createFrom(options), options.getRetryAlgorithmManager());
    }
}

