/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiClock;
import com.google.api.core.NanoClock;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.retrying.BasicResultRetryAlgorithm;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.RetryHelper;
import com.google.cloud.storage.Conversions;
import com.google.cloud.storage.HttpStorageOptions;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.spi.v1.HttpRpcContext;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;

final class Retrying {
    Retrying() {
    }

    static <T, U> U run(HttpStorageOptions options, ResultRetryAlgorithm<?> algorithm, Callable<T> c, Function<T, U> f) {
        HttpRpcContext httpRpcContext = HttpRpcContext.getInstance();
        try {
            httpRpcContext.newInvocationId();
            Object result = RetryHelper.runWithRetries(c, (RetrySettings)options.getRetrySettings(), algorithm, (ApiClock)options.getClock());
            U u = result == null ? null : (U)f.apply(result);
            return u;
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.coalesce(e);
        }
        finally {
            httpRpcContext.clearInvocationId();
        }
    }

    static <T, U> U run(RetryingDependencies deps, ResultRetryAlgorithm<?> algorithm, Callable<T> c, Conversions.Decoder<T, U> f) {
        try {
            Object result = RetryHelper.runWithRetries(() -> {
                try {
                    return c.call();
                }
                catch (StorageException se) {
                    throw se;
                }
                catch (Exception e) {
                    throw StorageException.coalesce(e);
                }
            }, (RetrySettings)deps.getRetrySettings(), algorithm, (ApiClock)deps.getClock());
            return result == null ? null : (U)f.decode(result);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.coalesce(e.getCause());
        }
    }

    static @NonNull GrpcCallContext newCallContext() {
        return GrpcCallContext.createDefault().withExtraHeaders((Map)ImmutableMap.of((Object)"x-goog-gcs-idempotency-token", (Object)ImmutableList.of((Object)UUID.randomUUID().toString())));
    }

    static ResultRetryAlgorithm<?> neverRetry() {
        return new BasicResultRetryAlgorithm<Object>(){

            public boolean shouldRetry(Throwable previousThrowable, Object previousResponse) {
                return false;
            }
        };
    }

    static interface RetryingDependencies {
        public RetrySettings getRetrySettings();

        public ApiClock getClock();

        public static RetryingDependencies attemptOnce() {
            return new RetryingDependencies(){

                @Override
                public RetrySettings getRetrySettings() {
                    return RetrySettings.newBuilder().setMaxAttempts(1).build();
                }

                @Override
                public ApiClock getClock() {
                    return NanoClock.getDefaultClock();
                }
            };
        }
    }
}

