/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TransactionRunner;
import com.google.common.util.concurrent.ListenableFuture;

class DatabaseClientImpl
implements DatabaseClient {
    private final SessionPool pool;

    DatabaseClientImpl(SessionPool pool) {
        this.pool = pool;
    }

    @Override
    public Timestamp write(Iterable<Mutation> mutations) throws SpannerException {
        return this.pool.getReadWriteSession().write(mutations);
    }

    @Override
    public Timestamp writeAtLeastOnce(Iterable<Mutation> mutations) throws SpannerException {
        return this.pool.getReadSession().writeAtLeastOnce(mutations);
    }

    @Override
    public ReadContext singleUse() {
        return this.pool.getReadSession().singleUse();
    }

    @Override
    public ReadContext singleUse(TimestampBound bound) {
        return this.pool.getReadSession().singleUse(bound);
    }

    @Override
    public ReadOnlyTransaction singleUseReadOnlyTransaction() {
        return this.pool.getReadSession().singleUseReadOnlyTransaction();
    }

    @Override
    public ReadOnlyTransaction singleUseReadOnlyTransaction(TimestampBound bound) {
        return this.pool.getReadSession().singleUseReadOnlyTransaction(bound);
    }

    @Override
    public ReadOnlyTransaction readOnlyTransaction() {
        return this.pool.getReadSession().readOnlyTransaction();
    }

    @Override
    public ReadOnlyTransaction readOnlyTransaction(TimestampBound bound) {
        return this.pool.getReadSession().readOnlyTransaction(bound);
    }

    @Override
    public TransactionRunner readWriteTransaction() {
        return this.pool.getReadWriteSession().readWriteTransaction();
    }

    ListenableFuture<Void> closeAsync() {
        return this.pool.closeAsync();
    }
}

