/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

SELECT TABLE_CATALOG AS TABLE_CAT, TABLE_SCHEMA AS TABLE_SCHEM, TABLE_NAME, COLUMN_NAME,
  CASE
    WHEN SPANNER_TYPE LIKE 'ARRAY%' THEN 2003
    WHEN SPANNER_TYPE = 'BOOL' THEN 16
    WHEN SPANNER_TYPE LIKE 'BYTES%' THEN -2
    WHEN SPANNER_TYPE = 'DATE' THEN 91
    WHEN SPANNER_TYPE = 'FLOAT64' THEN 8
    WHEN SPANNER_TYPE = 'INT64' THEN -5
    WHEN SPANNER_TYPE = 'NUMERIC' THEN 2
    WHEN SPANNER_TYPE LIKE 'STRING%' THEN -9
    WHEN SPANNER_TYPE = 'JSON' THEN -9
    WHEN SPANNER_TYPE = 'TIMESTAMP' THEN 93
  END AS DATA_TYPE,
  SPANNER_TYPE AS TYPE_NAME,
  CASE
    WHEN STRPOS(SPANNER_TYPE, '(')=0 THEN
      CASE
        WHEN SPANNER_TYPE = 'INT64' OR SPANNER_TYPE = 'ARRAY<INT64>' THEN 19
        WHEN SPANNER_TYPE = 'NUMERIC' OR SPANNER_TYPE = 'ARRAY<NUMERIC>' THEN 15
        WHEN SPANNER_TYPE = 'FLOAT64' OR SPANNER_TYPE = 'ARRAY<FLOAT64>' THEN 15
        WHEN SPANNER_TYPE = 'BOOL' OR SPANNER_TYPE = 'ARRAY<BOOL>' THEN NULL
        WHEN SPANNER_TYPE = 'DATE' OR SPANNER_TYPE = 'ARRAY<DATE>' THEN 10
        WHEN SPANNER_TYPE = 'TIMESTAMP' OR SPANNER_TYPE = 'ARRAY<TIMESTAMP>' THEN 35
        WHEN SPANNER_TYPE = 'JSON' OR SPANNER_TYPE = 'ARRAY<JSON>' THEN 2621440
        ELSE 0
      END
    ELSE CAST(REPLACE(SUBSTR(SPANNER_TYPE, STRPOS(SPANNER_TYPE, '(')+1, STRPOS(SPANNER_TYPE, ')')-STRPOS(SPANNER_TYPE, '(')-1), 'MAX', CASE WHEN UPPER(SPANNER_TYPE) LIKE '%STRING%' THEN '2621440' ELSE '10485760' END) AS INT64)
  END AS COLUMN_SIZE,
  0 AS BUFFER_LENGTH,
  CASE
    WHEN SPANNER_TYPE LIKE '%FLOAT64%' THEN 16
    ELSE NULL
  END AS DECIMAL_DIGITS,
  CASE
    WHEN SPANNER_TYPE LIKE '%INT64%' THEN 10
    WHEN SPANNER_TYPE LIKE '%NUMERIC%' THEN 10
    WHEN SPANNER_TYPE LIKE '%FLOAT64%' THEN 2
    ELSE NULL
  END AS NUM_PREC_RADIX,
  CASE
    WHEN IS_NULLABLE = 'YES' THEN 1
    WHEN IS_NULLABLE = 'NO' THEN 0
    ELSE 2
  END AS NULLABLE,
  NULL AS REMARKS,
  NULL AS COLUMN_DEF,
  0 AS SQL_DATA_TYPE,
  0 AS SQL_DATETIME_SUB,
  CASE
    WHEN (SPANNER_TYPE LIKE 'STRING%' OR SPANNER_TYPE LIKE 'ARRAY<STRING%') THEN
      cast(replace(substr(spanner_type, strpos(spanner_type, '(')+1, strpos(spanner_type,')')-strpos(spanner_type, '(')-1), 'MAX', '2621440') as INT64)
    WHEN (SPANNER_TYPE = 'JSON' OR SPANNER_TYPE = 'ARRAY<JSON>') THEN 2621440
    ELSE NULL
  END AS CHAR_OCTET_LENGTH,
  ORDINAL_POSITION,
  IS_NULLABLE,
  NULL AS SCOPE_CATALOG,
  NULL AS SCOPE_SCHEMA,
  NULL AS SCOPE_TABLE,
  NULL AS SOURCE_DATA_TYPE,
  'NO' AS IS_AUTOINCREMENT,
  CASE
    WHEN (IS_GENERATED = 'NEVER') THEN 'NO'
    ELSE 'YES'
  END AS IS_GENERATEDCOLUMN
FROM INFORMATION_SCHEMA.COLUMNS C
WHERE UPPER(C.TABLE_CATALOG) LIKE ?
  AND UPPER(C.TABLE_SCHEMA) LIKE ?
  AND UPPER(C.TABLE_NAME) LIKE ?
  AND UPPER(C.COLUMN_NAME) LIKE ?
ORDER BY TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME, ORDINAL_POSITION
