/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.jdbc;

import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.jdbc.AbstractJdbcWrapper;
import com.google.cloud.spanner.jdbc.JdbcDataType;
import com.google.cloud.spanner.jdbc.JdbcResultSet;
import com.google.common.base.Preconditions;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

class JdbcResultSetMetaData
extends AbstractJdbcWrapper
implements ResultSetMetaData {
    private static final int DEFAULT_COL_DISPLAY_SIZE_FOR_VARIABLE_LENGTH_COLS = 50;
    private final ResultSet spannerResultSet;
    private final Statement statement;

    JdbcResultSetMetaData(JdbcResultSet jdbcResultSet, Statement statement) {
        Preconditions.checkNotNull((Object)jdbcResultSet);
        this.spannerResultSet = jdbcResultSet.spanner;
        this.statement = statement;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public int getColumnCount() {
        return this.spannerResultSet.getColumnCount();
    }

    @Override
    public boolean isAutoIncrement(int column) {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) {
        int type = this.getColumnType(column);
        return type == -9 || type == -2;
    }

    @Override
    public boolean isSearchable(int column) {
        return true;
    }

    @Override
    public boolean isCurrency(int column) {
        return false;
    }

    @Override
    public int isNullable(int column) {
        return 2;
    }

    @Override
    public boolean isSigned(int column) {
        int type = this.getColumnType(column);
        return type == 8 || type == -5 || type == 2;
    }

    @Override
    public int getColumnDisplaySize(int column) {
        int colType = this.getColumnType(column);
        switch (colType) {
            case 2003: {
                return 50;
            }
            case 16: {
                return 5;
            }
            case -2: {
                int binaryLength = this.getPrecision(column);
                return binaryLength == 0 ? 50 : binaryLength;
            }
            case 91: {
                return 10;
            }
            case 7: {
                return JdbcDataType.FLOAT32.getDefaultColumnDisplaySize();
            }
            case 6: 
            case 8: {
                return 14;
            }
            case -5: {
                return 10;
            }
            case 2: {
                return 14;
            }
            case -9: {
                int length = this.getPrecision(column);
                return length == 0 ? 50 : length;
            }
            case 93: {
                return 16;
            }
        }
        return 10;
    }

    @Override
    public String getColumnLabel(int column) {
        return ((Type.StructField)this.spannerResultSet.getType().getStructFields().get(column - 1)).getName();
    }

    @Override
    public String getColumnName(int column) {
        return ((Type.StructField)this.spannerResultSet.getType().getStructFields().get(column - 1)).getName();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return this.statement.getConnection().getSchema();
    }

    @Override
    public int getPrecision(int column) {
        int colType = this.getColumnType(column);
        switch (colType) {
            case 16: {
                return 1;
            }
            case 91: {
                return 10;
            }
            case 7: {
                return JdbcDataType.FLOAT32.getPrecision();
            }
            case 6: 
            case 8: {
                return 14;
            }
            case -5: 
            case 4: {
                return 10;
            }
            case 2: {
                return 14;
            }
            case 93: {
                return 24;
            }
        }
        return 50;
    }

    @Override
    public int getScale(int column) {
        int colType = this.getColumnType(column);
        if (colType == 7) {
            return JdbcDataType.FLOAT32.getScale();
        }
        if (colType == 8 || colType == 2) {
            return 15;
        }
        return 0;
    }

    @Override
    public String getTableName(int column) {
        return "";
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return this.statement.getConnection().getCatalog();
    }

    @Override
    public int getColumnType(int column) {
        return JdbcResultSetMetaData.extractColumnType(this.spannerResultSet.getColumnType(column - 1));
    }

    @Override
    public String getColumnTypeName(int column) {
        return this.spannerResultSet.getColumnType(column - 1).getCode().name();
    }

    @Override
    public boolean isReadOnly(int column) {
        return false;
    }

    @Override
    public boolean isWritable(int column) {
        return !this.isReadOnly(column);
    }

    @Override
    public boolean isDefinitelyWritable(int column) {
        return false;
    }

    @Override
    public String getColumnClassName(int column) {
        return JdbcResultSetMetaData.getClassName(this.spannerResultSet.getColumnType(column - 1));
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        for (int col = 1; col <= this.getColumnCount(); ++col) {
            res.append("Col ").append(col).append(": ");
            res.append(this.getColumnName(col)).append(" ").append(this.getColumnTypeName(col));
            res.append("\n");
        }
        return res.toString();
    }
}

