/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.shell.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.shell.v1.AddPublicKeyMetadata;
import com.google.cloud.shell.v1.AddPublicKeyRequest;
import com.google.cloud.shell.v1.AddPublicKeyResponse;
import com.google.cloud.shell.v1.AuthorizeEnvironmentMetadata;
import com.google.cloud.shell.v1.AuthorizeEnvironmentRequest;
import com.google.cloud.shell.v1.AuthorizeEnvironmentResponse;
import com.google.cloud.shell.v1.Environment;
import com.google.cloud.shell.v1.GetEnvironmentRequest;
import com.google.cloud.shell.v1.RemovePublicKeyMetadata;
import com.google.cloud.shell.v1.RemovePublicKeyRequest;
import com.google.cloud.shell.v1.RemovePublicKeyResponse;
import com.google.cloud.shell.v1.StartEnvironmentMetadata;
import com.google.cloud.shell.v1.StartEnvironmentRequest;
import com.google.cloud.shell.v1.StartEnvironmentResponse;
import com.google.cloud.shell.v1.stub.CloudShellServiceStub;
import com.google.cloud.shell.v1.stub.GrpcCloudShellServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class CloudShellServiceStubSettings
extends StubSettings<CloudShellServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<GetEnvironmentRequest, Environment> getEnvironmentSettings;
    private final UnaryCallSettings<StartEnvironmentRequest, Operation> startEnvironmentSettings;
    private final OperationCallSettings<StartEnvironmentRequest, StartEnvironmentResponse, StartEnvironmentMetadata> startEnvironmentOperationSettings;
    private final UnaryCallSettings<AuthorizeEnvironmentRequest, Operation> authorizeEnvironmentSettings;
    private final OperationCallSettings<AuthorizeEnvironmentRequest, AuthorizeEnvironmentResponse, AuthorizeEnvironmentMetadata> authorizeEnvironmentOperationSettings;
    private final UnaryCallSettings<AddPublicKeyRequest, Operation> addPublicKeySettings;
    private final OperationCallSettings<AddPublicKeyRequest, AddPublicKeyResponse, AddPublicKeyMetadata> addPublicKeyOperationSettings;
    private final UnaryCallSettings<RemovePublicKeyRequest, Operation> removePublicKeySettings;
    private final OperationCallSettings<RemovePublicKeyRequest, RemovePublicKeyResponse, RemovePublicKeyMetadata> removePublicKeyOperationSettings;

    public UnaryCallSettings<GetEnvironmentRequest, Environment> getEnvironmentSettings() {
        return this.getEnvironmentSettings;
    }

    public UnaryCallSettings<StartEnvironmentRequest, Operation> startEnvironmentSettings() {
        return this.startEnvironmentSettings;
    }

    public OperationCallSettings<StartEnvironmentRequest, StartEnvironmentResponse, StartEnvironmentMetadata> startEnvironmentOperationSettings() {
        return this.startEnvironmentOperationSettings;
    }

    public UnaryCallSettings<AuthorizeEnvironmentRequest, Operation> authorizeEnvironmentSettings() {
        return this.authorizeEnvironmentSettings;
    }

    public OperationCallSettings<AuthorizeEnvironmentRequest, AuthorizeEnvironmentResponse, AuthorizeEnvironmentMetadata> authorizeEnvironmentOperationSettings() {
        return this.authorizeEnvironmentOperationSettings;
    }

    public UnaryCallSettings<AddPublicKeyRequest, Operation> addPublicKeySettings() {
        return this.addPublicKeySettings;
    }

    public OperationCallSettings<AddPublicKeyRequest, AddPublicKeyResponse, AddPublicKeyMetadata> addPublicKeyOperationSettings() {
        return this.addPublicKeyOperationSettings;
    }

    public UnaryCallSettings<RemovePublicKeyRequest, Operation> removePublicKeySettings() {
        return this.removePublicKeySettings;
    }

    public OperationCallSettings<RemovePublicKeyRequest, RemovePublicKeyResponse, RemovePublicKeyMetadata> removePublicKeyOperationSettings() {
        return this.removePublicKeyOperationSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CloudShellServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcCloudShellServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "cloudshell.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "cloudshell.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CloudShellServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CloudShellServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CloudShellServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getEnvironmentSettings = settingsBuilder.getEnvironmentSettings().build();
        this.startEnvironmentSettings = settingsBuilder.startEnvironmentSettings().build();
        this.startEnvironmentOperationSettings = settingsBuilder.startEnvironmentOperationSettings().build();
        this.authorizeEnvironmentSettings = settingsBuilder.authorizeEnvironmentSettings().build();
        this.authorizeEnvironmentOperationSettings = settingsBuilder.authorizeEnvironmentOperationSettings().build();
        this.addPublicKeySettings = settingsBuilder.addPublicKeySettings().build();
        this.addPublicKeyOperationSettings = settingsBuilder.addPublicKeyOperationSettings().build();
        this.removePublicKeySettings = settingsBuilder.removePublicKeySettings().build();
        this.removePublicKeyOperationSettings = settingsBuilder.removePublicKeyOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CloudShellServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetEnvironmentRequest, Environment> getEnvironmentSettings;
        private final UnaryCallSettings.Builder<StartEnvironmentRequest, Operation> startEnvironmentSettings;
        private final OperationCallSettings.Builder<StartEnvironmentRequest, StartEnvironmentResponse, StartEnvironmentMetadata> startEnvironmentOperationSettings;
        private final UnaryCallSettings.Builder<AuthorizeEnvironmentRequest, Operation> authorizeEnvironmentSettings;
        private final OperationCallSettings.Builder<AuthorizeEnvironmentRequest, AuthorizeEnvironmentResponse, AuthorizeEnvironmentMetadata> authorizeEnvironmentOperationSettings;
        private final UnaryCallSettings.Builder<AddPublicKeyRequest, Operation> addPublicKeySettings;
        private final OperationCallSettings.Builder<AddPublicKeyRequest, AddPublicKeyResponse, AddPublicKeyMetadata> addPublicKeyOperationSettings;
        private final UnaryCallSettings.Builder<RemovePublicKeyRequest, Operation> removePublicKeySettings;
        private final OperationCallSettings.Builder<RemovePublicKeyRequest, RemovePublicKeyResponse, RemovePublicKeyMetadata> removePublicKeyOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getEnvironmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.startEnvironmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.startEnvironmentOperationSettings = OperationCallSettings.newBuilder();
            this.authorizeEnvironmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.authorizeEnvironmentOperationSettings = OperationCallSettings.newBuilder();
            this.addPublicKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.addPublicKeyOperationSettings = OperationCallSettings.newBuilder();
            this.removePublicKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.removePublicKeyOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getEnvironmentSettings, this.startEnvironmentSettings, this.authorizeEnvironmentSettings, this.addPublicKeySettings, this.removePublicKeySettings);
            Builder.initDefaults(this);
        }

        protected Builder(CloudShellServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getEnvironmentSettings = settings.getEnvironmentSettings.toBuilder();
            this.startEnvironmentSettings = settings.startEnvironmentSettings.toBuilder();
            this.startEnvironmentOperationSettings = settings.startEnvironmentOperationSettings.toBuilder();
            this.authorizeEnvironmentSettings = settings.authorizeEnvironmentSettings.toBuilder();
            this.authorizeEnvironmentOperationSettings = settings.authorizeEnvironmentOperationSettings.toBuilder();
            this.addPublicKeySettings = settings.addPublicKeySettings.toBuilder();
            this.addPublicKeyOperationSettings = settings.addPublicKeyOperationSettings.toBuilder();
            this.removePublicKeySettings = settings.removePublicKeySettings.toBuilder();
            this.removePublicKeyOperationSettings = settings.removePublicKeyOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getEnvironmentSettings, this.startEnvironmentSettings, this.authorizeEnvironmentSettings, this.addPublicKeySettings, this.removePublicKeySettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CloudShellServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CloudShellServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CloudShellServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(CloudShellServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(CloudShellServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getEnvironmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.startEnvironmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.authorizeEnvironmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.addPublicKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.removePublicKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.startEnvironmentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(StartEnvironmentResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(StartEnvironmentMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.authorizeEnvironmentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AuthorizeEnvironmentResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(AuthorizeEnvironmentMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.addPublicKeyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AddPublicKeyResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(AddPublicKeyMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.removePublicKeyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(RemovePublicKeyResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(RemovePublicKeyMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetEnvironmentRequest, Environment> getEnvironmentSettings() {
            return this.getEnvironmentSettings;
        }

        public UnaryCallSettings.Builder<StartEnvironmentRequest, Operation> startEnvironmentSettings() {
            return this.startEnvironmentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<StartEnvironmentRequest, StartEnvironmentResponse, StartEnvironmentMetadata> startEnvironmentOperationSettings() {
            return this.startEnvironmentOperationSettings;
        }

        public UnaryCallSettings.Builder<AuthorizeEnvironmentRequest, Operation> authorizeEnvironmentSettings() {
            return this.authorizeEnvironmentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<AuthorizeEnvironmentRequest, AuthorizeEnvironmentResponse, AuthorizeEnvironmentMetadata> authorizeEnvironmentOperationSettings() {
            return this.authorizeEnvironmentOperationSettings;
        }

        public UnaryCallSettings.Builder<AddPublicKeyRequest, Operation> addPublicKeySettings() {
            return this.addPublicKeySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<AddPublicKeyRequest, AddPublicKeyResponse, AddPublicKeyMetadata> addPublicKeyOperationSettings() {
            return this.addPublicKeyOperationSettings;
        }

        public UnaryCallSettings.Builder<RemovePublicKeyRequest, Operation> removePublicKeySettings() {
            return this.removePublicKeySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<RemovePublicKeyRequest, RemovePublicKeyResponse, RemovePublicKeyMetadata> removePublicKeyOperationSettings() {
            return this.removePublicKeyOperationSettings;
        }

        public CloudShellServiceStubSettings build() throws IOException {
            return new CloudShellServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.UNKNOWN})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

