/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.servicehealth.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.servicehealth.v1.Event;
import com.google.cloud.servicehealth.v1.EventName;
import com.google.cloud.servicehealth.v1.GetEventRequest;
import com.google.cloud.servicehealth.v1.GetOrganizationEventRequest;
import com.google.cloud.servicehealth.v1.GetOrganizationImpactRequest;
import com.google.cloud.servicehealth.v1.ListEventsRequest;
import com.google.cloud.servicehealth.v1.ListEventsResponse;
import com.google.cloud.servicehealth.v1.ListOrganizationEventsRequest;
import com.google.cloud.servicehealth.v1.ListOrganizationEventsResponse;
import com.google.cloud.servicehealth.v1.ListOrganizationImpactsRequest;
import com.google.cloud.servicehealth.v1.ListOrganizationImpactsResponse;
import com.google.cloud.servicehealth.v1.LocationName;
import com.google.cloud.servicehealth.v1.OrganizationEvent;
import com.google.cloud.servicehealth.v1.OrganizationEventName;
import com.google.cloud.servicehealth.v1.OrganizationImpact;
import com.google.cloud.servicehealth.v1.OrganizationImpactName;
import com.google.cloud.servicehealth.v1.OrganizationLocationName;
import com.google.cloud.servicehealth.v1.ServiceHealthSettings;
import com.google.cloud.servicehealth.v1.stub.ServiceHealthStub;
import com.google.cloud.servicehealth.v1.stub.ServiceHealthStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ServiceHealthClient
implements BackgroundResource {
    private final ServiceHealthSettings settings;
    private final ServiceHealthStub stub;

    public static final ServiceHealthClient create() throws IOException {
        return ServiceHealthClient.create(ServiceHealthSettings.newBuilder().build());
    }

    public static final ServiceHealthClient create(ServiceHealthSettings settings) throws IOException {
        return new ServiceHealthClient(settings);
    }

    public static final ServiceHealthClient create(ServiceHealthStub stub) {
        return new ServiceHealthClient(stub);
    }

    protected ServiceHealthClient(ServiceHealthSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ServiceHealthStubSettings)settings.getStubSettings()).createStub();
    }

    protected ServiceHealthClient(ServiceHealthStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ServiceHealthSettings getSettings() {
        return this.settings;
    }

    public ServiceHealthStub getStub() {
        return this.stub;
    }

    public final ListEventsPagedResponse listEvents(LocationName parent) {
        ListEventsRequest request = ListEventsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listEvents(request);
    }

    public final ListEventsPagedResponse listEvents(String parent) {
        ListEventsRequest request = ListEventsRequest.newBuilder().setParent(parent).build();
        return this.listEvents(request);
    }

    public final ListEventsPagedResponse listEvents(ListEventsRequest request) {
        return (ListEventsPagedResponse)((Object)this.listEventsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEventsRequest, ListEventsPagedResponse> listEventsPagedCallable() {
        return this.stub.listEventsPagedCallable();
    }

    public final UnaryCallable<ListEventsRequest, ListEventsResponse> listEventsCallable() {
        return this.stub.listEventsCallable();
    }

    public final Event getEvent(EventName name) {
        GetEventRequest request = GetEventRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getEvent(request);
    }

    public final Event getEvent(String name) {
        GetEventRequest request = GetEventRequest.newBuilder().setName(name).build();
        return this.getEvent(request);
    }

    public final Event getEvent(GetEventRequest request) {
        return (Event)this.getEventCallable().call((Object)request);
    }

    public final UnaryCallable<GetEventRequest, Event> getEventCallable() {
        return this.stub.getEventCallable();
    }

    public final ListOrganizationEventsPagedResponse listOrganizationEvents(OrganizationLocationName parent) {
        ListOrganizationEventsRequest request = ListOrganizationEventsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listOrganizationEvents(request);
    }

    public final ListOrganizationEventsPagedResponse listOrganizationEvents(String parent) {
        ListOrganizationEventsRequest request = ListOrganizationEventsRequest.newBuilder().setParent(parent).build();
        return this.listOrganizationEvents(request);
    }

    public final ListOrganizationEventsPagedResponse listOrganizationEvents(ListOrganizationEventsRequest request) {
        return (ListOrganizationEventsPagedResponse)((Object)this.listOrganizationEventsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListOrganizationEventsRequest, ListOrganizationEventsPagedResponse> listOrganizationEventsPagedCallable() {
        return this.stub.listOrganizationEventsPagedCallable();
    }

    public final UnaryCallable<ListOrganizationEventsRequest, ListOrganizationEventsResponse> listOrganizationEventsCallable() {
        return this.stub.listOrganizationEventsCallable();
    }

    public final OrganizationEvent getOrganizationEvent(OrganizationEventName name) {
        GetOrganizationEventRequest request = GetOrganizationEventRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getOrganizationEvent(request);
    }

    public final OrganizationEvent getOrganizationEvent(String name) {
        GetOrganizationEventRequest request = GetOrganizationEventRequest.newBuilder().setName(name).build();
        return this.getOrganizationEvent(request);
    }

    public final OrganizationEvent getOrganizationEvent(GetOrganizationEventRequest request) {
        return (OrganizationEvent)this.getOrganizationEventCallable().call((Object)request);
    }

    public final UnaryCallable<GetOrganizationEventRequest, OrganizationEvent> getOrganizationEventCallable() {
        return this.stub.getOrganizationEventCallable();
    }

    public final ListOrganizationImpactsPagedResponse listOrganizationImpacts(OrganizationLocationName parent) {
        ListOrganizationImpactsRequest request = ListOrganizationImpactsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listOrganizationImpacts(request);
    }

    public final ListOrganizationImpactsPagedResponse listOrganizationImpacts(String parent) {
        ListOrganizationImpactsRequest request = ListOrganizationImpactsRequest.newBuilder().setParent(parent).build();
        return this.listOrganizationImpacts(request);
    }

    public final ListOrganizationImpactsPagedResponse listOrganizationImpacts(ListOrganizationImpactsRequest request) {
        return (ListOrganizationImpactsPagedResponse)((Object)this.listOrganizationImpactsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListOrganizationImpactsRequest, ListOrganizationImpactsPagedResponse> listOrganizationImpactsPagedCallable() {
        return this.stub.listOrganizationImpactsPagedCallable();
    }

    public final UnaryCallable<ListOrganizationImpactsRequest, ListOrganizationImpactsResponse> listOrganizationImpactsCallable() {
        return this.stub.listOrganizationImpactsCallable();
    }

    public final OrganizationImpact getOrganizationImpact(OrganizationImpactName name) {
        GetOrganizationImpactRequest request = GetOrganizationImpactRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getOrganizationImpact(request);
    }

    public final OrganizationImpact getOrganizationImpact(String name) {
        GetOrganizationImpactRequest request = GetOrganizationImpactRequest.newBuilder().setName(name).build();
        return this.getOrganizationImpact(request);
    }

    public final OrganizationImpact getOrganizationImpact(GetOrganizationImpactRequest request) {
        return (OrganizationImpact)this.getOrganizationImpactCallable().call((Object)request);
    }

    public final UnaryCallable<GetOrganizationImpactRequest, OrganizationImpact> getOrganizationImpactCallable() {
        return this.stub.getOrganizationImpactCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListOrganizationImpactsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListOrganizationImpactsRequest, ListOrganizationImpactsResponse, OrganizationImpact, ListOrganizationImpactsPage, ListOrganizationImpactsFixedSizeCollection> {
        private ListOrganizationImpactsFixedSizeCollection(List<ListOrganizationImpactsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListOrganizationImpactsFixedSizeCollection createEmptyCollection() {
            return new ListOrganizationImpactsFixedSizeCollection(null, 0);
        }

        protected ListOrganizationImpactsFixedSizeCollection createCollection(List<ListOrganizationImpactsPage> pages, int collectionSize) {
            return new ListOrganizationImpactsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListOrganizationImpactsPage
    extends AbstractPage<ListOrganizationImpactsRequest, ListOrganizationImpactsResponse, OrganizationImpact, ListOrganizationImpactsPage> {
        private ListOrganizationImpactsPage(PageContext<ListOrganizationImpactsRequest, ListOrganizationImpactsResponse, OrganizationImpact> context, ListOrganizationImpactsResponse response) {
            super(context, (Object)response);
        }

        private static ListOrganizationImpactsPage createEmptyPage() {
            return new ListOrganizationImpactsPage(null, null);
        }

        protected ListOrganizationImpactsPage createPage(PageContext<ListOrganizationImpactsRequest, ListOrganizationImpactsResponse, OrganizationImpact> context, ListOrganizationImpactsResponse response) {
            return new ListOrganizationImpactsPage(context, response);
        }

        public ApiFuture<ListOrganizationImpactsPage> createPageAsync(PageContext<ListOrganizationImpactsRequest, ListOrganizationImpactsResponse, OrganizationImpact> context, ApiFuture<ListOrganizationImpactsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListOrganizationImpactsPagedResponse
    extends AbstractPagedListResponse<ListOrganizationImpactsRequest, ListOrganizationImpactsResponse, OrganizationImpact, ListOrganizationImpactsPage, ListOrganizationImpactsFixedSizeCollection> {
        public static ApiFuture<ListOrganizationImpactsPagedResponse> createAsync(PageContext<ListOrganizationImpactsRequest, ListOrganizationImpactsResponse, OrganizationImpact> context, ApiFuture<ListOrganizationImpactsResponse> futureResponse) {
            ApiFuture<ListOrganizationImpactsPage> futurePage = ListOrganizationImpactsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListOrganizationImpactsPagedResponse((ListOrganizationImpactsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListOrganizationImpactsPagedResponse(ListOrganizationImpactsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListOrganizationImpactsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListOrganizationEventsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListOrganizationEventsRequest, ListOrganizationEventsResponse, OrganizationEvent, ListOrganizationEventsPage, ListOrganizationEventsFixedSizeCollection> {
        private ListOrganizationEventsFixedSizeCollection(List<ListOrganizationEventsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListOrganizationEventsFixedSizeCollection createEmptyCollection() {
            return new ListOrganizationEventsFixedSizeCollection(null, 0);
        }

        protected ListOrganizationEventsFixedSizeCollection createCollection(List<ListOrganizationEventsPage> pages, int collectionSize) {
            return new ListOrganizationEventsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListOrganizationEventsPage
    extends AbstractPage<ListOrganizationEventsRequest, ListOrganizationEventsResponse, OrganizationEvent, ListOrganizationEventsPage> {
        private ListOrganizationEventsPage(PageContext<ListOrganizationEventsRequest, ListOrganizationEventsResponse, OrganizationEvent> context, ListOrganizationEventsResponse response) {
            super(context, (Object)response);
        }

        private static ListOrganizationEventsPage createEmptyPage() {
            return new ListOrganizationEventsPage(null, null);
        }

        protected ListOrganizationEventsPage createPage(PageContext<ListOrganizationEventsRequest, ListOrganizationEventsResponse, OrganizationEvent> context, ListOrganizationEventsResponse response) {
            return new ListOrganizationEventsPage(context, response);
        }

        public ApiFuture<ListOrganizationEventsPage> createPageAsync(PageContext<ListOrganizationEventsRequest, ListOrganizationEventsResponse, OrganizationEvent> context, ApiFuture<ListOrganizationEventsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListOrganizationEventsPagedResponse
    extends AbstractPagedListResponse<ListOrganizationEventsRequest, ListOrganizationEventsResponse, OrganizationEvent, ListOrganizationEventsPage, ListOrganizationEventsFixedSizeCollection> {
        public static ApiFuture<ListOrganizationEventsPagedResponse> createAsync(PageContext<ListOrganizationEventsRequest, ListOrganizationEventsResponse, OrganizationEvent> context, ApiFuture<ListOrganizationEventsResponse> futureResponse) {
            ApiFuture<ListOrganizationEventsPage> futurePage = ListOrganizationEventsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListOrganizationEventsPagedResponse((ListOrganizationEventsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListOrganizationEventsPagedResponse(ListOrganizationEventsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListOrganizationEventsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListEventsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEventsRequest, ListEventsResponse, Event, ListEventsPage, ListEventsFixedSizeCollection> {
        private ListEventsFixedSizeCollection(List<ListEventsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEventsFixedSizeCollection createEmptyCollection() {
            return new ListEventsFixedSizeCollection(null, 0);
        }

        protected ListEventsFixedSizeCollection createCollection(List<ListEventsPage> pages, int collectionSize) {
            return new ListEventsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEventsPage
    extends AbstractPage<ListEventsRequest, ListEventsResponse, Event, ListEventsPage> {
        private ListEventsPage(PageContext<ListEventsRequest, ListEventsResponse, Event> context, ListEventsResponse response) {
            super(context, (Object)response);
        }

        private static ListEventsPage createEmptyPage() {
            return new ListEventsPage(null, null);
        }

        protected ListEventsPage createPage(PageContext<ListEventsRequest, ListEventsResponse, Event> context, ListEventsResponse response) {
            return new ListEventsPage(context, response);
        }

        public ApiFuture<ListEventsPage> createPageAsync(PageContext<ListEventsRequest, ListEventsResponse, Event> context, ApiFuture<ListEventsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEventsPagedResponse
    extends AbstractPagedListResponse<ListEventsRequest, ListEventsResponse, Event, ListEventsPage, ListEventsFixedSizeCollection> {
        public static ApiFuture<ListEventsPagedResponse> createAsync(PageContext<ListEventsRequest, ListEventsResponse, Event> context, ApiFuture<ListEventsResponse> futureResponse) {
            ApiFuture<ListEventsPage> futurePage = ListEventsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListEventsPagedResponse((ListEventsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListEventsPagedResponse(ListEventsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEventsFixedSizeCollection.createEmptyCollection());
        }
    }
}

