/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.servicehealth.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.servicehealth.v1.Event;
import com.google.cloud.servicehealth.v1.GetEventRequest;
import com.google.cloud.servicehealth.v1.GetOrganizationEventRequest;
import com.google.cloud.servicehealth.v1.GetOrganizationImpactRequest;
import com.google.cloud.servicehealth.v1.ListEventsRequest;
import com.google.cloud.servicehealth.v1.ListEventsResponse;
import com.google.cloud.servicehealth.v1.ListOrganizationEventsRequest;
import com.google.cloud.servicehealth.v1.ListOrganizationEventsResponse;
import com.google.cloud.servicehealth.v1.ListOrganizationImpactsRequest;
import com.google.cloud.servicehealth.v1.ListOrganizationImpactsResponse;
import com.google.cloud.servicehealth.v1.OrganizationEvent;
import com.google.cloud.servicehealth.v1.OrganizationImpact;
import com.google.cloud.servicehealth.v1.ServiceHealthClient;
import com.google.cloud.servicehealth.v1.stub.HttpJsonServiceHealthCallableFactory;
import com.google.cloud.servicehealth.v1.stub.ServiceHealthStub;
import com.google.cloud.servicehealth.v1.stub.ServiceHealthStubSettings;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonServiceHealthStub
extends ServiceHealthStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<ListEventsRequest, ListEventsResponse> listEventsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.servicehealth.v1.ServiceHealth/ListEvents").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/events", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "view", (Object)request.getViewValue());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListEventsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetEventRequest, Event> getEventMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.servicehealth.v1.ServiceHealth/GetEvent").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/events/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Event.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListOrganizationEventsRequest, ListOrganizationEventsResponse> listOrganizationEventsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.servicehealth.v1.ServiceHealth/ListOrganizationEvents").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=organizations/*/locations/*}/organizationEvents", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "view", (Object)request.getViewValue());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListOrganizationEventsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetOrganizationEventRequest, OrganizationEvent> getOrganizationEventMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.servicehealth.v1.ServiceHealth/GetOrganizationEvent").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=organizations/*/locations/*/organizationEvents/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)OrganizationEvent.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListOrganizationImpactsRequest, ListOrganizationImpactsResponse> listOrganizationImpactsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.servicehealth.v1.ServiceHealth/ListOrganizationImpacts").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=organizations/*/locations/*}/organizationImpacts", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListOrganizationImpactsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetOrganizationImpactRequest, OrganizationImpact> getOrganizationImpactMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.servicehealth.v1.ServiceHealth/GetOrganizationImpact").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=organizations/*/locations/*/organizationImpacts/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)OrganizationImpact.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/ListLocations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*}/locations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListLocationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/GetLocation").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Location.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListEventsRequest, ListEventsResponse> listEventsCallable;
    private final UnaryCallable<ListEventsRequest, ServiceHealthClient.ListEventsPagedResponse> listEventsPagedCallable;
    private final UnaryCallable<GetEventRequest, Event> getEventCallable;
    private final UnaryCallable<ListOrganizationEventsRequest, ListOrganizationEventsResponse> listOrganizationEventsCallable;
    private final UnaryCallable<ListOrganizationEventsRequest, ServiceHealthClient.ListOrganizationEventsPagedResponse> listOrganizationEventsPagedCallable;
    private final UnaryCallable<GetOrganizationEventRequest, OrganizationEvent> getOrganizationEventCallable;
    private final UnaryCallable<ListOrganizationImpactsRequest, ListOrganizationImpactsResponse> listOrganizationImpactsCallable;
    private final UnaryCallable<ListOrganizationImpactsRequest, ServiceHealthClient.ListOrganizationImpactsPagedResponse> listOrganizationImpactsPagedCallable;
    private final UnaryCallable<GetOrganizationImpactRequest, OrganizationImpact> getOrganizationImpactCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, ServiceHealthClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonServiceHealthStub create(ServiceHealthStubSettings settings) throws IOException {
        return new HttpJsonServiceHealthStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonServiceHealthStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonServiceHealthStub(ServiceHealthStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonServiceHealthStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonServiceHealthStub(ServiceHealthStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonServiceHealthStub(ServiceHealthStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonServiceHealthCallableFactory());
    }

    protected HttpJsonServiceHealthStub(ServiceHealthStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings listEventsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listEventsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getEventTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getEventMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listOrganizationEventsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listOrganizationEventsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getOrganizationEventTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getOrganizationEventMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listOrganizationImpactsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listOrganizationImpactsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getOrganizationImpactTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getOrganizationImpactMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listLocationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getLocationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listEventsCallable = callableFactory.createUnaryCallable(listEventsTransportSettings, settings.listEventsSettings(), clientContext);
        this.listEventsPagedCallable = callableFactory.createPagedCallable(listEventsTransportSettings, settings.listEventsSettings(), clientContext);
        this.getEventCallable = callableFactory.createUnaryCallable(getEventTransportSettings, settings.getEventSettings(), clientContext);
        this.listOrganizationEventsCallable = callableFactory.createUnaryCallable(listOrganizationEventsTransportSettings, settings.listOrganizationEventsSettings(), clientContext);
        this.listOrganizationEventsPagedCallable = callableFactory.createPagedCallable(listOrganizationEventsTransportSettings, settings.listOrganizationEventsSettings(), clientContext);
        this.getOrganizationEventCallable = callableFactory.createUnaryCallable(getOrganizationEventTransportSettings, settings.getOrganizationEventSettings(), clientContext);
        this.listOrganizationImpactsCallable = callableFactory.createUnaryCallable(listOrganizationImpactsTransportSettings, settings.listOrganizationImpactsSettings(), clientContext);
        this.listOrganizationImpactsPagedCallable = callableFactory.createPagedCallable(listOrganizationImpactsTransportSettings, settings.listOrganizationImpactsSettings(), clientContext);
        this.getOrganizationImpactCallable = callableFactory.createUnaryCallable(getOrganizationImpactTransportSettings, settings.getOrganizationImpactSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listEventsMethodDescriptor);
        methodDescriptors.add(getEventMethodDescriptor);
        methodDescriptors.add(listOrganizationEventsMethodDescriptor);
        methodDescriptors.add(getOrganizationEventMethodDescriptor);
        methodDescriptors.add(listOrganizationImpactsMethodDescriptor);
        methodDescriptors.add(getOrganizationImpactMethodDescriptor);
        methodDescriptors.add(listLocationsMethodDescriptor);
        methodDescriptors.add(getLocationMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<ListEventsRequest, ListEventsResponse> listEventsCallable() {
        return this.listEventsCallable;
    }

    @Override
    public UnaryCallable<ListEventsRequest, ServiceHealthClient.ListEventsPagedResponse> listEventsPagedCallable() {
        return this.listEventsPagedCallable;
    }

    @Override
    public UnaryCallable<GetEventRequest, Event> getEventCallable() {
        return this.getEventCallable;
    }

    @Override
    public UnaryCallable<ListOrganizationEventsRequest, ListOrganizationEventsResponse> listOrganizationEventsCallable() {
        return this.listOrganizationEventsCallable;
    }

    @Override
    public UnaryCallable<ListOrganizationEventsRequest, ServiceHealthClient.ListOrganizationEventsPagedResponse> listOrganizationEventsPagedCallable() {
        return this.listOrganizationEventsPagedCallable;
    }

    @Override
    public UnaryCallable<GetOrganizationEventRequest, OrganizationEvent> getOrganizationEventCallable() {
        return this.getOrganizationEventCallable;
    }

    @Override
    public UnaryCallable<ListOrganizationImpactsRequest, ListOrganizationImpactsResponse> listOrganizationImpactsCallable() {
        return this.listOrganizationImpactsCallable;
    }

    @Override
    public UnaryCallable<ListOrganizationImpactsRequest, ServiceHealthClient.ListOrganizationImpactsPagedResponse> listOrganizationImpactsPagedCallable() {
        return this.listOrganizationImpactsPagedCallable;
    }

    @Override
    public UnaryCallable<GetOrganizationImpactRequest, OrganizationImpact> getOrganizationImpactCallable() {
        return this.getOrganizationImpactCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ServiceHealthClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

