/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.serviceusage.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.serviceusage.v1.BatchEnableServicesRequest;
import com.google.api.serviceusage.v1.BatchEnableServicesResponse;
import com.google.api.serviceusage.v1.BatchGetServicesRequest;
import com.google.api.serviceusage.v1.BatchGetServicesResponse;
import com.google.api.serviceusage.v1.DisableServiceRequest;
import com.google.api.serviceusage.v1.DisableServiceResponse;
import com.google.api.serviceusage.v1.EnableServiceRequest;
import com.google.api.serviceusage.v1.EnableServiceResponse;
import com.google.api.serviceusage.v1.GetServiceRequest;
import com.google.api.serviceusage.v1.ListServicesRequest;
import com.google.api.serviceusage.v1.ListServicesResponse;
import com.google.api.serviceusage.v1.OperationMetadata;
import com.google.api.serviceusage.v1.Service;
import com.google.api.serviceusage.v1.ServiceUsageClient;
import com.google.api.serviceusage.v1.stub.HttpJsonServiceUsageCallableFactory;
import com.google.api.serviceusage.v1.stub.ServiceUsageStub;
import com.google.api.serviceusage.v1.stub.ServiceUsageStubSettings;
import com.google.longrunning.Operation;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonServiceUsageStub
extends ServiceUsageStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(BatchEnableServicesResponse.getDescriptor()).add(OperationMetadata.getDescriptor()).add(DisableServiceResponse.getDescriptor()).add(EnableServiceResponse.getDescriptor()).build();
    private static final ApiMethodDescriptor<EnableServiceRequest, Operation> enableServiceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.api.serviceusage.v1.ServiceUsage/EnableService").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=*/*/services/*}:enable", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DisableServiceRequest, Operation> disableServiceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.api.serviceusage.v1.ServiceUsage/DisableService").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=*/*/services/*}:disable", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GetServiceRequest, Service> getServiceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.api.serviceusage.v1.ServiceUsage/GetService").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=*/*/services/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Service.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListServicesRequest, ListServicesResponse> listServicesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.api.serviceusage.v1.ServiceUsage/ListServices").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=*/*}/services", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListServicesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<BatchEnableServicesRequest, Operation> batchEnableServicesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.api.serviceusage.v1.ServiceUsage/BatchEnableServices").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=*/*}/services:batchEnable", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<BatchGetServicesRequest, BatchGetServicesResponse> batchGetServicesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.api.serviceusage.v1.ServiceUsage/BatchGetServices").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=*/*}/services:batchGet", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "names", (Object)request.getNamesList());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)BatchGetServicesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<EnableServiceRequest, Operation> enableServiceCallable;
    private final OperationCallable<EnableServiceRequest, EnableServiceResponse, OperationMetadata> enableServiceOperationCallable;
    private final UnaryCallable<DisableServiceRequest, Operation> disableServiceCallable;
    private final OperationCallable<DisableServiceRequest, DisableServiceResponse, OperationMetadata> disableServiceOperationCallable;
    private final UnaryCallable<GetServiceRequest, Service> getServiceCallable;
    private final UnaryCallable<ListServicesRequest, ListServicesResponse> listServicesCallable;
    private final UnaryCallable<ListServicesRequest, ServiceUsageClient.ListServicesPagedResponse> listServicesPagedCallable;
    private final UnaryCallable<BatchEnableServicesRequest, Operation> batchEnableServicesCallable;
    private final OperationCallable<BatchEnableServicesRequest, BatchEnableServicesResponse, OperationMetadata> batchEnableServicesOperationCallable;
    private final UnaryCallable<BatchGetServicesRequest, BatchGetServicesResponse> batchGetServicesCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonServiceUsageStub create(ServiceUsageStubSettings settings) throws IOException {
        return new HttpJsonServiceUsageStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonServiceUsageStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonServiceUsageStub(ServiceUsageStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonServiceUsageStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonServiceUsageStub(ServiceUsageStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonServiceUsageStub(ServiceUsageStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonServiceUsageCallableFactory());
    }

    protected HttpJsonServiceUsageStub(ServiceUsageStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry);
        HttpJsonCallSettings enableServiceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(enableServiceMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings disableServiceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(disableServiceMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getServiceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getServiceMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listServicesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listServicesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings batchEnableServicesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(batchEnableServicesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings batchGetServicesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(batchGetServicesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.enableServiceCallable = callableFactory.createUnaryCallable(enableServiceTransportSettings, settings.enableServiceSettings(), clientContext);
        this.enableServiceOperationCallable = callableFactory.createOperationCallable(enableServiceTransportSettings, settings.enableServiceOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.disableServiceCallable = callableFactory.createUnaryCallable(disableServiceTransportSettings, settings.disableServiceSettings(), clientContext);
        this.disableServiceOperationCallable = callableFactory.createOperationCallable(disableServiceTransportSettings, settings.disableServiceOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getServiceCallable = callableFactory.createUnaryCallable(getServiceTransportSettings, settings.getServiceSettings(), clientContext);
        this.listServicesCallable = callableFactory.createUnaryCallable(listServicesTransportSettings, settings.listServicesSettings(), clientContext);
        this.listServicesPagedCallable = callableFactory.createPagedCallable(listServicesTransportSettings, settings.listServicesSettings(), clientContext);
        this.batchEnableServicesCallable = callableFactory.createUnaryCallable(batchEnableServicesTransportSettings, settings.batchEnableServicesSettings(), clientContext);
        this.batchEnableServicesOperationCallable = callableFactory.createOperationCallable(batchEnableServicesTransportSettings, settings.batchEnableServicesOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.batchGetServicesCallable = callableFactory.createUnaryCallable(batchGetServicesTransportSettings, settings.batchGetServicesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(enableServiceMethodDescriptor);
        methodDescriptors.add(disableServiceMethodDescriptor);
        methodDescriptors.add(getServiceMethodDescriptor);
        methodDescriptors.add(listServicesMethodDescriptor);
        methodDescriptors.add(batchEnableServicesMethodDescriptor);
        methodDescriptors.add(batchGetServicesMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<EnableServiceRequest, Operation> enableServiceCallable() {
        return this.enableServiceCallable;
    }

    @Override
    public OperationCallable<EnableServiceRequest, EnableServiceResponse, OperationMetadata> enableServiceOperationCallable() {
        return this.enableServiceOperationCallable;
    }

    @Override
    public UnaryCallable<DisableServiceRequest, Operation> disableServiceCallable() {
        return this.disableServiceCallable;
    }

    @Override
    public OperationCallable<DisableServiceRequest, DisableServiceResponse, OperationMetadata> disableServiceOperationCallable() {
        return this.disableServiceOperationCallable;
    }

    @Override
    public UnaryCallable<GetServiceRequest, Service> getServiceCallable() {
        return this.getServiceCallable;
    }

    @Override
    public UnaryCallable<ListServicesRequest, ListServicesResponse> listServicesCallable() {
        return this.listServicesCallable;
    }

    @Override
    public UnaryCallable<ListServicesRequest, ServiceUsageClient.ListServicesPagedResponse> listServicesPagedCallable() {
        return this.listServicesPagedCallable;
    }

    @Override
    public UnaryCallable<BatchEnableServicesRequest, Operation> batchEnableServicesCallable() {
        return this.batchEnableServicesCallable;
    }

    @Override
    public OperationCallable<BatchEnableServicesRequest, BatchEnableServicesResponse, OperationMetadata> batchEnableServicesOperationCallable() {
        return this.batchEnableServicesOperationCallable;
    }

    @Override
    public UnaryCallable<BatchGetServicesRequest, BatchGetServicesResponse> batchGetServicesCallable() {
        return this.batchGetServicesCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

