/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.servicecontrol.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.servicecontrol.v1.CheckRequest;
import com.google.api.servicecontrol.v1.CheckResponse;
import com.google.api.servicecontrol.v1.ReportRequest;
import com.google.api.servicecontrol.v1.ReportResponse;
import com.google.api.servicecontrol.v1.stub.GrpcServiceControllerCallableFactory;
import com.google.api.servicecontrol.v1.stub.ServiceControllerStub;
import com.google.api.servicecontrol.v1.stub.ServiceControllerStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcServiceControllerStub
extends ServiceControllerStub {
    private static final MethodDescriptor<CheckRequest, CheckResponse> checkMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.api.servicecontrol.v1.ServiceController/Check").setRequestMarshaller(ProtoUtils.marshaller((Message)CheckRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CheckResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ReportRequest, ReportResponse> reportMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.api.servicecontrol.v1.ServiceController/Report").setRequestMarshaller(ProtoUtils.marshaller((Message)ReportRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ReportResponse.getDefaultInstance())).build();
    private final UnaryCallable<CheckRequest, CheckResponse> checkCallable;
    private final UnaryCallable<ReportRequest, ReportResponse> reportCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcServiceControllerStub create(ServiceControllerStubSettings settings) throws IOException {
        return new GrpcServiceControllerStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcServiceControllerStub create(ClientContext clientContext) throws IOException {
        return new GrpcServiceControllerStub(ServiceControllerStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcServiceControllerStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcServiceControllerStub(ServiceControllerStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcServiceControllerStub(ServiceControllerStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcServiceControllerCallableFactory());
    }

    protected GrpcServiceControllerStub(ServiceControllerStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings checkTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(checkMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"service_name", (Object)String.valueOf(request.getServiceName()));
            return params.build();
        }).build();
        GrpcCallSettings reportTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(reportMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"service_name", (Object)String.valueOf(request.getServiceName()));
            return params.build();
        }).build();
        this.checkCallable = callableFactory.createUnaryCallable(checkTransportSettings, settings.checkSettings(), clientContext);
        this.reportCallable = callableFactory.createUnaryCallable(reportTransportSettings, settings.reportSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CheckRequest, CheckResponse> checkCallable() {
        return this.checkCallable;
    }

    @Override
    public UnaryCallable<ReportRequest, ReportResponse> reportCallable() {
        return this.reportCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

