/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.servicecontrol.v2.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.servicecontrol.v2.CheckRequest;
import com.google.api.servicecontrol.v2.CheckResponse;
import com.google.api.servicecontrol.v2.ReportRequest;
import com.google.api.servicecontrol.v2.ReportResponse;
import com.google.api.servicecontrol.v2.stub.HttpJsonServiceControllerCallableFactory;
import com.google.api.servicecontrol.v2.stub.ServiceControllerStub;
import com.google.api.servicecontrol.v2.stub.ServiceControllerStubSettings;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonServiceControllerStub
extends ServiceControllerStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<CheckRequest, CheckResponse> checkMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.api.servicecontrol.v2.ServiceController/Check").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/services/{serviceName}:check", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "serviceName", (Object)request.getServiceName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearServiceName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)CheckResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ReportRequest, ReportResponse> reportMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.api.servicecontrol.v2.ServiceController/Report").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/services/{serviceName}:report", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "serviceName", (Object)request.getServiceName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearServiceName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ReportResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CheckRequest, CheckResponse> checkCallable;
    private final UnaryCallable<ReportRequest, ReportResponse> reportCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonServiceControllerStub create(ServiceControllerStubSettings settings) throws IOException {
        return new HttpJsonServiceControllerStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonServiceControllerStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonServiceControllerStub(ServiceControllerStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonServiceControllerStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonServiceControllerStub(ServiceControllerStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonServiceControllerStub(ServiceControllerStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonServiceControllerCallableFactory());
    }

    protected HttpJsonServiceControllerStub(ServiceControllerStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings checkTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(checkMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("service_name", String.valueOf(request.getServiceName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings reportTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(reportMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("service_name", String.valueOf(request.getServiceName()));
            return builder.build();
        }).build();
        this.checkCallable = callableFactory.createUnaryCallable(checkTransportSettings, settings.checkSettings(), clientContext);
        this.reportCallable = callableFactory.createUnaryCallable(reportTransportSettings, settings.reportSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(checkMethodDescriptor);
        methodDescriptors.add(reportMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<CheckRequest, CheckResponse> checkCallable() {
        return this.checkCallable;
    }

    @Override
    public UnaryCallable<ReportRequest, ReportResponse> reportCallable() {
        return this.reportCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

