/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.settings.v1beta1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.securitycenter.settings.v1beta1.BatchCalculateEffectiveSettingsRequest;
import com.google.cloud.securitycenter.settings.v1beta1.BatchCalculateEffectiveSettingsResponse;
import com.google.cloud.securitycenter.settings.v1beta1.BatchGetSettingsRequest;
import com.google.cloud.securitycenter.settings.v1beta1.BatchGetSettingsResponse;
import com.google.cloud.securitycenter.settings.v1beta1.CalculateEffectiveComponentSettingsRequest;
import com.google.cloud.securitycenter.settings.v1beta1.CalculateEffectiveSettingsRequest;
import com.google.cloud.securitycenter.settings.v1beta1.ComponentSettings;
import com.google.cloud.securitycenter.settings.v1beta1.ComponentSettingsName;
import com.google.cloud.securitycenter.settings.v1beta1.Detector;
import com.google.cloud.securitycenter.settings.v1beta1.GetComponentSettingsRequest;
import com.google.cloud.securitycenter.settings.v1beta1.GetServiceAccountRequest;
import com.google.cloud.securitycenter.settings.v1beta1.GetSettingsRequest;
import com.google.cloud.securitycenter.settings.v1beta1.ListComponentsRequest;
import com.google.cloud.securitycenter.settings.v1beta1.ListComponentsResponse;
import com.google.cloud.securitycenter.settings.v1beta1.ListDetectorsRequest;
import com.google.cloud.securitycenter.settings.v1beta1.ListDetectorsResponse;
import com.google.cloud.securitycenter.settings.v1beta1.OrganizationName;
import com.google.cloud.securitycenter.settings.v1beta1.ResetComponentSettingsRequest;
import com.google.cloud.securitycenter.settings.v1beta1.ResetSettingsRequest;
import com.google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsServiceSettings;
import com.google.cloud.securitycenter.settings.v1beta1.ServiceAccount;
import com.google.cloud.securitycenter.settings.v1beta1.ServiceAccountName;
import com.google.cloud.securitycenter.settings.v1beta1.Settings;
import com.google.cloud.securitycenter.settings.v1beta1.SettingsName;
import com.google.cloud.securitycenter.settings.v1beta1.UpdateComponentSettingsRequest;
import com.google.cloud.securitycenter.settings.v1beta1.UpdateSettingsRequest;
import com.google.cloud.securitycenter.settings.v1beta1.stub.SecurityCenterSettingsServiceStub;
import com.google.cloud.securitycenter.settings.v1beta1.stub.SecurityCenterSettingsServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class SecurityCenterSettingsServiceClient
implements BackgroundResource {
    private final SecurityCenterSettingsServiceSettings settings;
    private final SecurityCenterSettingsServiceStub stub;

    public static final SecurityCenterSettingsServiceClient create() throws IOException {
        return SecurityCenterSettingsServiceClient.create(SecurityCenterSettingsServiceSettings.newBuilder().build());
    }

    public static final SecurityCenterSettingsServiceClient create(SecurityCenterSettingsServiceSettings settings) throws IOException {
        return new SecurityCenterSettingsServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final SecurityCenterSettingsServiceClient create(SecurityCenterSettingsServiceStub stub) {
        return new SecurityCenterSettingsServiceClient(stub);
    }

    protected SecurityCenterSettingsServiceClient(SecurityCenterSettingsServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SecurityCenterSettingsServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected SecurityCenterSettingsServiceClient(SecurityCenterSettingsServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SecurityCenterSettingsServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public SecurityCenterSettingsServiceStub getStub() {
        return this.stub;
    }

    public final ServiceAccount getServiceAccount(ServiceAccountName name) {
        GetServiceAccountRequest request = GetServiceAccountRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getServiceAccount(request);
    }

    public final ServiceAccount getServiceAccount(String name) {
        GetServiceAccountRequest request = GetServiceAccountRequest.newBuilder().setName(name).build();
        return this.getServiceAccount(request);
    }

    public final ServiceAccount getServiceAccount(GetServiceAccountRequest request) {
        return (ServiceAccount)this.getServiceAccountCallable().call((Object)request);
    }

    public final UnaryCallable<GetServiceAccountRequest, ServiceAccount> getServiceAccountCallable() {
        return this.stub.getServiceAccountCallable();
    }

    public final Settings getSettings(SettingsName name) {
        GetSettingsRequest request = GetSettingsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSettings(request);
    }

    public final Settings getSettings(String name) {
        GetSettingsRequest request = GetSettingsRequest.newBuilder().setName(name).build();
        return this.getSettings(request);
    }

    public final Settings getSettings(GetSettingsRequest request) {
        return (Settings)this.getSettingsCallable().call((Object)request);
    }

    public final UnaryCallable<GetSettingsRequest, Settings> getSettingsCallable() {
        return this.stub.getSettingsCallable();
    }

    public final Settings updateSettings(Settings settings, FieldMask updateMask) {
        UpdateSettingsRequest request = UpdateSettingsRequest.newBuilder().setSettings(settings).setUpdateMask(updateMask).build();
        return this.updateSettings(request);
    }

    public final Settings updateSettings(UpdateSettingsRequest request) {
        return (Settings)this.updateSettingsCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateSettingsRequest, Settings> updateSettingsCallable() {
        return this.stub.updateSettingsCallable();
    }

    public final void resetSettings(ResetSettingsRequest request) {
        this.resetSettingsCallable().call((Object)request);
    }

    public final UnaryCallable<ResetSettingsRequest, Empty> resetSettingsCallable() {
        return this.stub.resetSettingsCallable();
    }

    public final BatchGetSettingsResponse batchGetSettings(BatchGetSettingsRequest request) {
        return (BatchGetSettingsResponse)this.batchGetSettingsCallable().call((Object)request);
    }

    public final UnaryCallable<BatchGetSettingsRequest, BatchGetSettingsResponse> batchGetSettingsCallable() {
        return this.stub.batchGetSettingsCallable();
    }

    public final Settings calculateEffectiveSettings(SettingsName name) {
        CalculateEffectiveSettingsRequest request = CalculateEffectiveSettingsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.calculateEffectiveSettings(request);
    }

    public final Settings calculateEffectiveSettings(String name) {
        CalculateEffectiveSettingsRequest request = CalculateEffectiveSettingsRequest.newBuilder().setName(name).build();
        return this.calculateEffectiveSettings(request);
    }

    public final Settings calculateEffectiveSettings(CalculateEffectiveSettingsRequest request) {
        return (Settings)this.calculateEffectiveSettingsCallable().call((Object)request);
    }

    public final UnaryCallable<CalculateEffectiveSettingsRequest, Settings> calculateEffectiveSettingsCallable() {
        return this.stub.calculateEffectiveSettingsCallable();
    }

    public final BatchCalculateEffectiveSettingsResponse batchCalculateEffectiveSettings(BatchCalculateEffectiveSettingsRequest request) {
        return (BatchCalculateEffectiveSettingsResponse)this.batchCalculateEffectiveSettingsCallable().call((Object)request);
    }

    public final UnaryCallable<BatchCalculateEffectiveSettingsRequest, BatchCalculateEffectiveSettingsResponse> batchCalculateEffectiveSettingsCallable() {
        return this.stub.batchCalculateEffectiveSettingsCallable();
    }

    public final ComponentSettings getComponentSettings(ComponentSettingsName name) {
        GetComponentSettingsRequest request = GetComponentSettingsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getComponentSettings(request);
    }

    public final ComponentSettings getComponentSettings(String name) {
        GetComponentSettingsRequest request = GetComponentSettingsRequest.newBuilder().setName(name).build();
        return this.getComponentSettings(request);
    }

    public final ComponentSettings getComponentSettings(GetComponentSettingsRequest request) {
        return (ComponentSettings)this.getComponentSettingsCallable().call((Object)request);
    }

    public final UnaryCallable<GetComponentSettingsRequest, ComponentSettings> getComponentSettingsCallable() {
        return this.stub.getComponentSettingsCallable();
    }

    public final ComponentSettings updateComponentSettings(ComponentSettings componentSettings, FieldMask updateMask) {
        UpdateComponentSettingsRequest request = UpdateComponentSettingsRequest.newBuilder().setComponentSettings(componentSettings).setUpdateMask(updateMask).build();
        return this.updateComponentSettings(request);
    }

    public final ComponentSettings updateComponentSettings(UpdateComponentSettingsRequest request) {
        return (ComponentSettings)this.updateComponentSettingsCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateComponentSettingsRequest, ComponentSettings> updateComponentSettingsCallable() {
        return this.stub.updateComponentSettingsCallable();
    }

    public final void resetComponentSettings(ResetComponentSettingsRequest request) {
        this.resetComponentSettingsCallable().call((Object)request);
    }

    public final UnaryCallable<ResetComponentSettingsRequest, Empty> resetComponentSettingsCallable() {
        return this.stub.resetComponentSettingsCallable();
    }

    public final ComponentSettings calculateEffectiveComponentSettings(ComponentSettingsName name) {
        CalculateEffectiveComponentSettingsRequest request = CalculateEffectiveComponentSettingsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.calculateEffectiveComponentSettings(request);
    }

    public final ComponentSettings calculateEffectiveComponentSettings(String name) {
        CalculateEffectiveComponentSettingsRequest request = CalculateEffectiveComponentSettingsRequest.newBuilder().setName(name).build();
        return this.calculateEffectiveComponentSettings(request);
    }

    public final ComponentSettings calculateEffectiveComponentSettings(CalculateEffectiveComponentSettingsRequest request) {
        return (ComponentSettings)this.calculateEffectiveComponentSettingsCallable().call((Object)request);
    }

    public final UnaryCallable<CalculateEffectiveComponentSettingsRequest, ComponentSettings> calculateEffectiveComponentSettingsCallable() {
        return this.stub.calculateEffectiveComponentSettingsCallable();
    }

    public final ListDetectorsPagedResponse listDetectors(OrganizationName parent) {
        ListDetectorsRequest request = ListDetectorsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDetectors(request);
    }

    public final ListDetectorsPagedResponse listDetectors(String parent) {
        ListDetectorsRequest request = ListDetectorsRequest.newBuilder().setParent(parent).build();
        return this.listDetectors(request);
    }

    public final ListDetectorsPagedResponse listDetectors(ListDetectorsRequest request) {
        return (ListDetectorsPagedResponse)((Object)this.listDetectorsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDetectorsRequest, ListDetectorsPagedResponse> listDetectorsPagedCallable() {
        return this.stub.listDetectorsPagedCallable();
    }

    public final UnaryCallable<ListDetectorsRequest, ListDetectorsResponse> listDetectorsCallable() {
        return this.stub.listDetectorsCallable();
    }

    public final ListComponentsPagedResponse listComponents(OrganizationName parent) {
        ListComponentsRequest request = ListComponentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listComponents(request);
    }

    public final ListComponentsPagedResponse listComponents(String parent) {
        ListComponentsRequest request = ListComponentsRequest.newBuilder().setParent(parent).build();
        return this.listComponents(request);
    }

    public final ListComponentsPagedResponse listComponents(ListComponentsRequest request) {
        return (ListComponentsPagedResponse)((Object)this.listComponentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListComponentsRequest, ListComponentsPagedResponse> listComponentsPagedCallable() {
        return this.stub.listComponentsPagedCallable();
    }

    public final UnaryCallable<ListComponentsRequest, ListComponentsResponse> listComponentsCallable() {
        return this.stub.listComponentsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListComponentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListComponentsRequest, ListComponentsResponse, String, ListComponentsPage, ListComponentsFixedSizeCollection> {
        private ListComponentsFixedSizeCollection(List<ListComponentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListComponentsFixedSizeCollection createEmptyCollection() {
            return new ListComponentsFixedSizeCollection(null, 0);
        }

        protected ListComponentsFixedSizeCollection createCollection(List<ListComponentsPage> pages, int collectionSize) {
            return new ListComponentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListComponentsPage
    extends AbstractPage<ListComponentsRequest, ListComponentsResponse, String, ListComponentsPage> {
        private ListComponentsPage(PageContext<ListComponentsRequest, ListComponentsResponse, String> context, ListComponentsResponse response) {
            super(context, (Object)response);
        }

        private static ListComponentsPage createEmptyPage() {
            return new ListComponentsPage(null, null);
        }

        protected ListComponentsPage createPage(PageContext<ListComponentsRequest, ListComponentsResponse, String> context, ListComponentsResponse response) {
            return new ListComponentsPage(context, response);
        }

        public ApiFuture<ListComponentsPage> createPageAsync(PageContext<ListComponentsRequest, ListComponentsResponse, String> context, ApiFuture<ListComponentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListComponentsPagedResponse
    extends AbstractPagedListResponse<ListComponentsRequest, ListComponentsResponse, String, ListComponentsPage, ListComponentsFixedSizeCollection> {
        public static ApiFuture<ListComponentsPagedResponse> createAsync(PageContext<ListComponentsRequest, ListComponentsResponse, String> context, ApiFuture<ListComponentsResponse> futureResponse) {
            ApiFuture<ListComponentsPage> futurePage = ListComponentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListComponentsPage, ListComponentsPagedResponse>(){

                public ListComponentsPagedResponse apply(ListComponentsPage input) {
                    return new ListComponentsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListComponentsPagedResponse(ListComponentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListComponentsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDetectorsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDetectorsRequest, ListDetectorsResponse, Detector, ListDetectorsPage, ListDetectorsFixedSizeCollection> {
        private ListDetectorsFixedSizeCollection(List<ListDetectorsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDetectorsFixedSizeCollection createEmptyCollection() {
            return new ListDetectorsFixedSizeCollection(null, 0);
        }

        protected ListDetectorsFixedSizeCollection createCollection(List<ListDetectorsPage> pages, int collectionSize) {
            return new ListDetectorsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDetectorsPage
    extends AbstractPage<ListDetectorsRequest, ListDetectorsResponse, Detector, ListDetectorsPage> {
        private ListDetectorsPage(PageContext<ListDetectorsRequest, ListDetectorsResponse, Detector> context, ListDetectorsResponse response) {
            super(context, (Object)response);
        }

        private static ListDetectorsPage createEmptyPage() {
            return new ListDetectorsPage(null, null);
        }

        protected ListDetectorsPage createPage(PageContext<ListDetectorsRequest, ListDetectorsResponse, Detector> context, ListDetectorsResponse response) {
            return new ListDetectorsPage(context, response);
        }

        public ApiFuture<ListDetectorsPage> createPageAsync(PageContext<ListDetectorsRequest, ListDetectorsResponse, Detector> context, ApiFuture<ListDetectorsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDetectorsPagedResponse
    extends AbstractPagedListResponse<ListDetectorsRequest, ListDetectorsResponse, Detector, ListDetectorsPage, ListDetectorsFixedSizeCollection> {
        public static ApiFuture<ListDetectorsPagedResponse> createAsync(PageContext<ListDetectorsRequest, ListDetectorsResponse, Detector> context, ApiFuture<ListDetectorsResponse> futureResponse) {
            ApiFuture<ListDetectorsPage> futurePage = ListDetectorsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListDetectorsPage, ListDetectorsPagedResponse>(){

                public ListDetectorsPagedResponse apply(ListDetectorsPage input) {
                    return new ListDetectorsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListDetectorsPagedResponse(ListDetectorsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDetectorsFixedSizeCollection.createEmptyCollection());
        }
    }
}

