/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securesourcemanager.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.securesourcemanager.v1.BatchCreatePullRequestCommentsRequest;
import com.google.cloud.securesourcemanager.v1.BatchCreatePullRequestCommentsResponse;
import com.google.cloud.securesourcemanager.v1.BranchRule;
import com.google.cloud.securesourcemanager.v1.BranchRuleName;
import com.google.cloud.securesourcemanager.v1.CloseIssueRequest;
import com.google.cloud.securesourcemanager.v1.ClosePullRequestRequest;
import com.google.cloud.securesourcemanager.v1.CreateBranchRuleRequest;
import com.google.cloud.securesourcemanager.v1.CreateHookRequest;
import com.google.cloud.securesourcemanager.v1.CreateInstanceRequest;
import com.google.cloud.securesourcemanager.v1.CreateIssueCommentRequest;
import com.google.cloud.securesourcemanager.v1.CreateIssueRequest;
import com.google.cloud.securesourcemanager.v1.CreatePullRequestCommentRequest;
import com.google.cloud.securesourcemanager.v1.CreatePullRequestRequest;
import com.google.cloud.securesourcemanager.v1.CreateRepositoryRequest;
import com.google.cloud.securesourcemanager.v1.DeleteBranchRuleRequest;
import com.google.cloud.securesourcemanager.v1.DeleteHookRequest;
import com.google.cloud.securesourcemanager.v1.DeleteInstanceRequest;
import com.google.cloud.securesourcemanager.v1.DeleteIssueCommentRequest;
import com.google.cloud.securesourcemanager.v1.DeleteIssueRequest;
import com.google.cloud.securesourcemanager.v1.DeletePullRequestCommentRequest;
import com.google.cloud.securesourcemanager.v1.DeleteRepositoryRequest;
import com.google.cloud.securesourcemanager.v1.FetchBlobRequest;
import com.google.cloud.securesourcemanager.v1.FetchBlobResponse;
import com.google.cloud.securesourcemanager.v1.FetchTreeRequest;
import com.google.cloud.securesourcemanager.v1.FetchTreeResponse;
import com.google.cloud.securesourcemanager.v1.FileDiff;
import com.google.cloud.securesourcemanager.v1.GetBranchRuleRequest;
import com.google.cloud.securesourcemanager.v1.GetHookRequest;
import com.google.cloud.securesourcemanager.v1.GetInstanceRequest;
import com.google.cloud.securesourcemanager.v1.GetIssueCommentRequest;
import com.google.cloud.securesourcemanager.v1.GetIssueRequest;
import com.google.cloud.securesourcemanager.v1.GetPullRequestCommentRequest;
import com.google.cloud.securesourcemanager.v1.GetPullRequestRequest;
import com.google.cloud.securesourcemanager.v1.GetRepositoryRequest;
import com.google.cloud.securesourcemanager.v1.Hook;
import com.google.cloud.securesourcemanager.v1.HookName;
import com.google.cloud.securesourcemanager.v1.Instance;
import com.google.cloud.securesourcemanager.v1.InstanceName;
import com.google.cloud.securesourcemanager.v1.Issue;
import com.google.cloud.securesourcemanager.v1.IssueComment;
import com.google.cloud.securesourcemanager.v1.IssueCommentName;
import com.google.cloud.securesourcemanager.v1.IssueName;
import com.google.cloud.securesourcemanager.v1.ListBranchRulesRequest;
import com.google.cloud.securesourcemanager.v1.ListBranchRulesResponse;
import com.google.cloud.securesourcemanager.v1.ListHooksRequest;
import com.google.cloud.securesourcemanager.v1.ListHooksResponse;
import com.google.cloud.securesourcemanager.v1.ListInstancesRequest;
import com.google.cloud.securesourcemanager.v1.ListInstancesResponse;
import com.google.cloud.securesourcemanager.v1.ListIssueCommentsRequest;
import com.google.cloud.securesourcemanager.v1.ListIssueCommentsResponse;
import com.google.cloud.securesourcemanager.v1.ListIssuesRequest;
import com.google.cloud.securesourcemanager.v1.ListIssuesResponse;
import com.google.cloud.securesourcemanager.v1.ListPullRequestCommentsRequest;
import com.google.cloud.securesourcemanager.v1.ListPullRequestCommentsResponse;
import com.google.cloud.securesourcemanager.v1.ListPullRequestFileDiffsRequest;
import com.google.cloud.securesourcemanager.v1.ListPullRequestFileDiffsResponse;
import com.google.cloud.securesourcemanager.v1.ListPullRequestsRequest;
import com.google.cloud.securesourcemanager.v1.ListPullRequestsResponse;
import com.google.cloud.securesourcemanager.v1.ListRepositoriesRequest;
import com.google.cloud.securesourcemanager.v1.ListRepositoriesResponse;
import com.google.cloud.securesourcemanager.v1.LocationName;
import com.google.cloud.securesourcemanager.v1.MergePullRequestRequest;
import com.google.cloud.securesourcemanager.v1.OpenIssueRequest;
import com.google.cloud.securesourcemanager.v1.OpenPullRequestRequest;
import com.google.cloud.securesourcemanager.v1.OperationMetadata;
import com.google.cloud.securesourcemanager.v1.PullRequest;
import com.google.cloud.securesourcemanager.v1.PullRequestComment;
import com.google.cloud.securesourcemanager.v1.PullRequestCommentName;
import com.google.cloud.securesourcemanager.v1.PullRequestName;
import com.google.cloud.securesourcemanager.v1.Repository;
import com.google.cloud.securesourcemanager.v1.RepositoryName;
import com.google.cloud.securesourcemanager.v1.ResolvePullRequestCommentsRequest;
import com.google.cloud.securesourcemanager.v1.ResolvePullRequestCommentsResponse;
import com.google.cloud.securesourcemanager.v1.SecureSourceManagerSettings;
import com.google.cloud.securesourcemanager.v1.TreeEntry;
import com.google.cloud.securesourcemanager.v1.UnresolvePullRequestCommentsRequest;
import com.google.cloud.securesourcemanager.v1.UnresolvePullRequestCommentsResponse;
import com.google.cloud.securesourcemanager.v1.UpdateBranchRuleRequest;
import com.google.cloud.securesourcemanager.v1.UpdateHookRequest;
import com.google.cloud.securesourcemanager.v1.UpdateIssueCommentRequest;
import com.google.cloud.securesourcemanager.v1.UpdateIssueRequest;
import com.google.cloud.securesourcemanager.v1.UpdatePullRequestCommentRequest;
import com.google.cloud.securesourcemanager.v1.UpdatePullRequestRequest;
import com.google.cloud.securesourcemanager.v1.UpdateRepositoryRequest;
import com.google.cloud.securesourcemanager.v1.stub.SecureSourceManagerStub;
import com.google.cloud.securesourcemanager.v1.stub.SecureSourceManagerStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class SecureSourceManagerClient
implements BackgroundResource {
    private final SecureSourceManagerSettings settings;
    private final SecureSourceManagerStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final SecureSourceManagerClient create() throws IOException {
        return SecureSourceManagerClient.create(SecureSourceManagerSettings.newBuilder().build());
    }

    public static final SecureSourceManagerClient create(SecureSourceManagerSettings settings) throws IOException {
        return new SecureSourceManagerClient(settings);
    }

    public static final SecureSourceManagerClient create(SecureSourceManagerStub stub) {
        return new SecureSourceManagerClient(stub);
    }

    protected SecureSourceManagerClient(SecureSourceManagerSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SecureSourceManagerStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected SecureSourceManagerClient(SecureSourceManagerStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final SecureSourceManagerSettings getSettings() {
        return this.settings;
    }

    public SecureSourceManagerStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListInstancesPagedResponse listInstances(LocationName parent) {
        ListInstancesRequest request = ListInstancesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listInstances(request);
    }

    public final ListInstancesPagedResponse listInstances(String parent) {
        ListInstancesRequest request = ListInstancesRequest.newBuilder().setParent(parent).build();
        return this.listInstances(request);
    }

    public final ListInstancesPagedResponse listInstances(ListInstancesRequest request) {
        return (ListInstancesPagedResponse)((Object)this.listInstancesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInstancesRequest, ListInstancesPagedResponse> listInstancesPagedCallable() {
        return this.stub.listInstancesPagedCallable();
    }

    public final UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable() {
        return this.stub.listInstancesCallable();
    }

    public final Instance getInstance(InstanceName name) {
        GetInstanceRequest request = GetInstanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getInstance(request);
    }

    public final Instance getInstance(String name) {
        GetInstanceRequest request = GetInstanceRequest.newBuilder().setName(name).build();
        return this.getInstance(request);
    }

    public final Instance getInstance(GetInstanceRequest request) {
        return (Instance)this.getInstanceCallable().call((Object)request);
    }

    public final UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable() {
        return this.stub.getInstanceCallable();
    }

    public final OperationFuture<Instance, OperationMetadata> createInstanceAsync(LocationName parent, Instance instance, String instanceId) {
        CreateInstanceRequest request = CreateInstanceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setInstance(instance).setInstanceId(instanceId).build();
        return this.createInstanceAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> createInstanceAsync(String parent, Instance instance, String instanceId) {
        CreateInstanceRequest request = CreateInstanceRequest.newBuilder().setParent(parent).setInstance(instance).setInstanceId(instanceId).build();
        return this.createInstanceAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> createInstanceAsync(CreateInstanceRequest request) {
        return this.createInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationCallable() {
        return this.stub.createInstanceOperationCallable();
    }

    public final UnaryCallable<CreateInstanceRequest, Operation> createInstanceCallable() {
        return this.stub.createInstanceCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteInstanceAsync(InstanceName name) {
        DeleteInstanceRequest request = DeleteInstanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteInstanceAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteInstanceAsync(String name) {
        DeleteInstanceRequest request = DeleteInstanceRequest.newBuilder().setName(name).build();
        return this.deleteInstanceAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteInstanceAsync(DeleteInstanceRequest request) {
        return this.deleteInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationCallable() {
        return this.stub.deleteInstanceOperationCallable();
    }

    public final UnaryCallable<DeleteInstanceRequest, Operation> deleteInstanceCallable() {
        return this.stub.deleteInstanceCallable();
    }

    public final ListRepositoriesPagedResponse listRepositories(LocationName parent) {
        ListRepositoriesRequest request = ListRepositoriesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRepositories(request);
    }

    public final ListRepositoriesPagedResponse listRepositories(String parent) {
        ListRepositoriesRequest request = ListRepositoriesRequest.newBuilder().setParent(parent).build();
        return this.listRepositories(request);
    }

    public final ListRepositoriesPagedResponse listRepositories(ListRepositoriesRequest request) {
        return (ListRepositoriesPagedResponse)((Object)this.listRepositoriesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRepositoriesRequest, ListRepositoriesPagedResponse> listRepositoriesPagedCallable() {
        return this.stub.listRepositoriesPagedCallable();
    }

    public final UnaryCallable<ListRepositoriesRequest, ListRepositoriesResponse> listRepositoriesCallable() {
        return this.stub.listRepositoriesCallable();
    }

    public final Repository getRepository(RepositoryName name) {
        GetRepositoryRequest request = GetRepositoryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRepository(request);
    }

    public final Repository getRepository(String name) {
        GetRepositoryRequest request = GetRepositoryRequest.newBuilder().setName(name).build();
        return this.getRepository(request);
    }

    public final Repository getRepository(GetRepositoryRequest request) {
        return (Repository)this.getRepositoryCallable().call((Object)request);
    }

    public final UnaryCallable<GetRepositoryRequest, Repository> getRepositoryCallable() {
        return this.stub.getRepositoryCallable();
    }

    public final OperationFuture<Repository, OperationMetadata> createRepositoryAsync(LocationName parent, Repository repository, String repositoryId) {
        CreateRepositoryRequest request = CreateRepositoryRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setRepository(repository).setRepositoryId(repositoryId).build();
        return this.createRepositoryAsync(request);
    }

    public final OperationFuture<Repository, OperationMetadata> createRepositoryAsync(String parent, Repository repository, String repositoryId) {
        CreateRepositoryRequest request = CreateRepositoryRequest.newBuilder().setParent(parent).setRepository(repository).setRepositoryId(repositoryId).build();
        return this.createRepositoryAsync(request);
    }

    public final OperationFuture<Repository, OperationMetadata> createRepositoryAsync(CreateRepositoryRequest request) {
        return this.createRepositoryOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateRepositoryRequest, Repository, OperationMetadata> createRepositoryOperationCallable() {
        return this.stub.createRepositoryOperationCallable();
    }

    public final UnaryCallable<CreateRepositoryRequest, Operation> createRepositoryCallable() {
        return this.stub.createRepositoryCallable();
    }

    public final OperationFuture<Repository, OperationMetadata> updateRepositoryAsync(Repository repository, FieldMask updateMask) {
        UpdateRepositoryRequest request = UpdateRepositoryRequest.newBuilder().setRepository(repository).setUpdateMask(updateMask).build();
        return this.updateRepositoryAsync(request);
    }

    public final OperationFuture<Repository, OperationMetadata> updateRepositoryAsync(UpdateRepositoryRequest request) {
        return this.updateRepositoryOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateRepositoryRequest, Repository, OperationMetadata> updateRepositoryOperationCallable() {
        return this.stub.updateRepositoryOperationCallable();
    }

    public final UnaryCallable<UpdateRepositoryRequest, Operation> updateRepositoryCallable() {
        return this.stub.updateRepositoryCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRepositoryAsync(RepositoryName name) {
        DeleteRepositoryRequest request = DeleteRepositoryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteRepositoryAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRepositoryAsync(String name) {
        DeleteRepositoryRequest request = DeleteRepositoryRequest.newBuilder().setName(name).build();
        return this.deleteRepositoryAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRepositoryAsync(DeleteRepositoryRequest request) {
        return this.deleteRepositoryOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteRepositoryRequest, Empty, OperationMetadata> deleteRepositoryOperationCallable() {
        return this.stub.deleteRepositoryOperationCallable();
    }

    public final UnaryCallable<DeleteRepositoryRequest, Operation> deleteRepositoryCallable() {
        return this.stub.deleteRepositoryCallable();
    }

    public final ListHooksPagedResponse listHooks(RepositoryName parent) {
        ListHooksRequest request = ListHooksRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listHooks(request);
    }

    public final ListHooksPagedResponse listHooks(String parent) {
        ListHooksRequest request = ListHooksRequest.newBuilder().setParent(parent).build();
        return this.listHooks(request);
    }

    public final ListHooksPagedResponse listHooks(ListHooksRequest request) {
        return (ListHooksPagedResponse)((Object)this.listHooksPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListHooksRequest, ListHooksPagedResponse> listHooksPagedCallable() {
        return this.stub.listHooksPagedCallable();
    }

    public final UnaryCallable<ListHooksRequest, ListHooksResponse> listHooksCallable() {
        return this.stub.listHooksCallable();
    }

    public final Hook getHook(HookName name) {
        GetHookRequest request = GetHookRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getHook(request);
    }

    public final Hook getHook(String name) {
        GetHookRequest request = GetHookRequest.newBuilder().setName(name).build();
        return this.getHook(request);
    }

    public final Hook getHook(GetHookRequest request) {
        return (Hook)this.getHookCallable().call((Object)request);
    }

    public final UnaryCallable<GetHookRequest, Hook> getHookCallable() {
        return this.stub.getHookCallable();
    }

    public final OperationFuture<Hook, OperationMetadata> createHookAsync(RepositoryName parent, Hook hook, String hookId) {
        CreateHookRequest request = CreateHookRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setHook(hook).setHookId(hookId).build();
        return this.createHookAsync(request);
    }

    public final OperationFuture<Hook, OperationMetadata> createHookAsync(String parent, Hook hook, String hookId) {
        CreateHookRequest request = CreateHookRequest.newBuilder().setParent(parent).setHook(hook).setHookId(hookId).build();
        return this.createHookAsync(request);
    }

    public final OperationFuture<Hook, OperationMetadata> createHookAsync(CreateHookRequest request) {
        return this.createHookOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateHookRequest, Hook, OperationMetadata> createHookOperationCallable() {
        return this.stub.createHookOperationCallable();
    }

    public final UnaryCallable<CreateHookRequest, Operation> createHookCallable() {
        return this.stub.createHookCallable();
    }

    public final OperationFuture<Hook, OperationMetadata> updateHookAsync(Hook hook, FieldMask updateMask) {
        UpdateHookRequest request = UpdateHookRequest.newBuilder().setHook(hook).setUpdateMask(updateMask).build();
        return this.updateHookAsync(request);
    }

    public final OperationFuture<Hook, OperationMetadata> updateHookAsync(UpdateHookRequest request) {
        return this.updateHookOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateHookRequest, Hook, OperationMetadata> updateHookOperationCallable() {
        return this.stub.updateHookOperationCallable();
    }

    public final UnaryCallable<UpdateHookRequest, Operation> updateHookCallable() {
        return this.stub.updateHookCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteHookAsync(HookName name) {
        DeleteHookRequest request = DeleteHookRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteHookAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteHookAsync(String name) {
        DeleteHookRequest request = DeleteHookRequest.newBuilder().setName(name).build();
        return this.deleteHookAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteHookAsync(DeleteHookRequest request) {
        return this.deleteHookOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteHookRequest, Empty, OperationMetadata> deleteHookOperationCallable() {
        return this.stub.deleteHookOperationCallable();
    }

    public final UnaryCallable<DeleteHookRequest, Operation> deleteHookCallable() {
        return this.stub.deleteHookCallable();
    }

    public final Policy getIamPolicyRepo(ResourceName resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.getIamPolicyRepo(request);
    }

    public final Policy getIamPolicyRepo(String resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicyRepo(request);
    }

    public final Policy getIamPolicyRepo(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyRepoCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyRepoCallable() {
        return this.stub.getIamPolicyRepoCallable();
    }

    public final Policy setIamPolicyRepo(ResourceName resource) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.setIamPolicyRepo(request);
    }

    public final Policy setIamPolicyRepo(String resource) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.setIamPolicyRepo(request);
    }

    public final Policy setIamPolicyRepo(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyRepoCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyRepoCallable() {
        return this.stub.setIamPolicyRepoCallable();
    }

    public final TestIamPermissionsResponse testIamPermissionsRepo(ResourceName resource) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.testIamPermissionsRepo(request);
    }

    public final TestIamPermissionsResponse testIamPermissionsRepo(String resource) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).build();
        return this.testIamPermissionsRepo(request);
    }

    public final TestIamPermissionsResponse testIamPermissionsRepo(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsRepoCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsRepoCallable() {
        return this.stub.testIamPermissionsRepoCallable();
    }

    public final OperationFuture<BranchRule, OperationMetadata> createBranchRuleAsync(RepositoryName parent, BranchRule branchRule, String branchRuleId) {
        CreateBranchRuleRequest request = CreateBranchRuleRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setBranchRule(branchRule).setBranchRuleId(branchRuleId).build();
        return this.createBranchRuleAsync(request);
    }

    public final OperationFuture<BranchRule, OperationMetadata> createBranchRuleAsync(String parent, BranchRule branchRule, String branchRuleId) {
        CreateBranchRuleRequest request = CreateBranchRuleRequest.newBuilder().setParent(parent).setBranchRule(branchRule).setBranchRuleId(branchRuleId).build();
        return this.createBranchRuleAsync(request);
    }

    public final OperationFuture<BranchRule, OperationMetadata> createBranchRuleAsync(CreateBranchRuleRequest request) {
        return this.createBranchRuleOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateBranchRuleRequest, BranchRule, OperationMetadata> createBranchRuleOperationCallable() {
        return this.stub.createBranchRuleOperationCallable();
    }

    public final UnaryCallable<CreateBranchRuleRequest, Operation> createBranchRuleCallable() {
        return this.stub.createBranchRuleCallable();
    }

    public final ListBranchRulesPagedResponse listBranchRules(RepositoryName parent) {
        ListBranchRulesRequest request = ListBranchRulesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listBranchRules(request);
    }

    public final ListBranchRulesPagedResponse listBranchRules(String parent) {
        ListBranchRulesRequest request = ListBranchRulesRequest.newBuilder().setParent(parent).build();
        return this.listBranchRules(request);
    }

    public final ListBranchRulesPagedResponse listBranchRules(ListBranchRulesRequest request) {
        return (ListBranchRulesPagedResponse)((Object)this.listBranchRulesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListBranchRulesRequest, ListBranchRulesPagedResponse> listBranchRulesPagedCallable() {
        return this.stub.listBranchRulesPagedCallable();
    }

    public final UnaryCallable<ListBranchRulesRequest, ListBranchRulesResponse> listBranchRulesCallable() {
        return this.stub.listBranchRulesCallable();
    }

    public final BranchRule getBranchRule(BranchRuleName name) {
        GetBranchRuleRequest request = GetBranchRuleRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getBranchRule(request);
    }

    public final BranchRule getBranchRule(String name) {
        GetBranchRuleRequest request = GetBranchRuleRequest.newBuilder().setName(name).build();
        return this.getBranchRule(request);
    }

    public final BranchRule getBranchRule(GetBranchRuleRequest request) {
        return (BranchRule)this.getBranchRuleCallable().call((Object)request);
    }

    public final UnaryCallable<GetBranchRuleRequest, BranchRule> getBranchRuleCallable() {
        return this.stub.getBranchRuleCallable();
    }

    public final OperationFuture<BranchRule, OperationMetadata> updateBranchRuleAsync(BranchRule branchRule, FieldMask updateMask) {
        UpdateBranchRuleRequest request = UpdateBranchRuleRequest.newBuilder().setBranchRule(branchRule).setUpdateMask(updateMask).build();
        return this.updateBranchRuleAsync(request);
    }

    public final OperationFuture<BranchRule, OperationMetadata> updateBranchRuleAsync(UpdateBranchRuleRequest request) {
        return this.updateBranchRuleOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateBranchRuleRequest, BranchRule, OperationMetadata> updateBranchRuleOperationCallable() {
        return this.stub.updateBranchRuleOperationCallable();
    }

    public final UnaryCallable<UpdateBranchRuleRequest, Operation> updateBranchRuleCallable() {
        return this.stub.updateBranchRuleCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteBranchRuleAsync(BranchRuleName name) {
        DeleteBranchRuleRequest request = DeleteBranchRuleRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteBranchRuleAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteBranchRuleAsync(String name) {
        DeleteBranchRuleRequest request = DeleteBranchRuleRequest.newBuilder().setName(name).build();
        return this.deleteBranchRuleAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteBranchRuleAsync(DeleteBranchRuleRequest request) {
        return this.deleteBranchRuleOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteBranchRuleRequest, Empty, OperationMetadata> deleteBranchRuleOperationCallable() {
        return this.stub.deleteBranchRuleOperationCallable();
    }

    public final UnaryCallable<DeleteBranchRuleRequest, Operation> deleteBranchRuleCallable() {
        return this.stub.deleteBranchRuleCallable();
    }

    public final OperationFuture<PullRequest, OperationMetadata> createPullRequestAsync(RepositoryName parent, PullRequest pullRequest) {
        CreatePullRequestRequest request = CreatePullRequestRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPullRequest(pullRequest).build();
        return this.createPullRequestAsync(request);
    }

    public final OperationFuture<PullRequest, OperationMetadata> createPullRequestAsync(String parent, PullRequest pullRequest) {
        CreatePullRequestRequest request = CreatePullRequestRequest.newBuilder().setParent(parent).setPullRequest(pullRequest).build();
        return this.createPullRequestAsync(request);
    }

    public final OperationFuture<PullRequest, OperationMetadata> createPullRequestAsync(CreatePullRequestRequest request) {
        return this.createPullRequestOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreatePullRequestRequest, PullRequest, OperationMetadata> createPullRequestOperationCallable() {
        return this.stub.createPullRequestOperationCallable();
    }

    public final UnaryCallable<CreatePullRequestRequest, Operation> createPullRequestCallable() {
        return this.stub.createPullRequestCallable();
    }

    public final PullRequest getPullRequest(PullRequestName name) {
        GetPullRequestRequest request = GetPullRequestRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPullRequest(request);
    }

    public final PullRequest getPullRequest(String name) {
        GetPullRequestRequest request = GetPullRequestRequest.newBuilder().setName(name).build();
        return this.getPullRequest(request);
    }

    public final PullRequest getPullRequest(GetPullRequestRequest request) {
        return (PullRequest)this.getPullRequestCallable().call((Object)request);
    }

    public final UnaryCallable<GetPullRequestRequest, PullRequest> getPullRequestCallable() {
        return this.stub.getPullRequestCallable();
    }

    public final ListPullRequestsPagedResponse listPullRequests(RepositoryName parent) {
        ListPullRequestsRequest request = ListPullRequestsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPullRequests(request);
    }

    public final ListPullRequestsPagedResponse listPullRequests(String parent) {
        ListPullRequestsRequest request = ListPullRequestsRequest.newBuilder().setParent(parent).build();
        return this.listPullRequests(request);
    }

    public final ListPullRequestsPagedResponse listPullRequests(ListPullRequestsRequest request) {
        return (ListPullRequestsPagedResponse)((Object)this.listPullRequestsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPullRequestsRequest, ListPullRequestsPagedResponse> listPullRequestsPagedCallable() {
        return this.stub.listPullRequestsPagedCallable();
    }

    public final UnaryCallable<ListPullRequestsRequest, ListPullRequestsResponse> listPullRequestsCallable() {
        return this.stub.listPullRequestsCallable();
    }

    public final OperationFuture<PullRequest, OperationMetadata> updatePullRequestAsync(PullRequest pullRequest, FieldMask updateMask) {
        UpdatePullRequestRequest request = UpdatePullRequestRequest.newBuilder().setPullRequest(pullRequest).setUpdateMask(updateMask).build();
        return this.updatePullRequestAsync(request);
    }

    public final OperationFuture<PullRequest, OperationMetadata> updatePullRequestAsync(UpdatePullRequestRequest request) {
        return this.updatePullRequestOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdatePullRequestRequest, PullRequest, OperationMetadata> updatePullRequestOperationCallable() {
        return this.stub.updatePullRequestOperationCallable();
    }

    public final UnaryCallable<UpdatePullRequestRequest, Operation> updatePullRequestCallable() {
        return this.stub.updatePullRequestCallable();
    }

    public final OperationFuture<PullRequest, OperationMetadata> mergePullRequestAsync(PullRequestName name) {
        MergePullRequestRequest request = MergePullRequestRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.mergePullRequestAsync(request);
    }

    public final OperationFuture<PullRequest, OperationMetadata> mergePullRequestAsync(String name) {
        MergePullRequestRequest request = MergePullRequestRequest.newBuilder().setName(name).build();
        return this.mergePullRequestAsync(request);
    }

    public final OperationFuture<PullRequest, OperationMetadata> mergePullRequestAsync(MergePullRequestRequest request) {
        return this.mergePullRequestOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<MergePullRequestRequest, PullRequest, OperationMetadata> mergePullRequestOperationCallable() {
        return this.stub.mergePullRequestOperationCallable();
    }

    public final UnaryCallable<MergePullRequestRequest, Operation> mergePullRequestCallable() {
        return this.stub.mergePullRequestCallable();
    }

    public final OperationFuture<PullRequest, OperationMetadata> openPullRequestAsync(PullRequestName name) {
        OpenPullRequestRequest request = OpenPullRequestRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.openPullRequestAsync(request);
    }

    public final OperationFuture<PullRequest, OperationMetadata> openPullRequestAsync(String name) {
        OpenPullRequestRequest request = OpenPullRequestRequest.newBuilder().setName(name).build();
        return this.openPullRequestAsync(request);
    }

    public final OperationFuture<PullRequest, OperationMetadata> openPullRequestAsync(OpenPullRequestRequest request) {
        return this.openPullRequestOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<OpenPullRequestRequest, PullRequest, OperationMetadata> openPullRequestOperationCallable() {
        return this.stub.openPullRequestOperationCallable();
    }

    public final UnaryCallable<OpenPullRequestRequest, Operation> openPullRequestCallable() {
        return this.stub.openPullRequestCallable();
    }

    public final OperationFuture<PullRequest, OperationMetadata> closePullRequestAsync(PullRequestName name) {
        ClosePullRequestRequest request = ClosePullRequestRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.closePullRequestAsync(request);
    }

    public final OperationFuture<PullRequest, OperationMetadata> closePullRequestAsync(String name) {
        ClosePullRequestRequest request = ClosePullRequestRequest.newBuilder().setName(name).build();
        return this.closePullRequestAsync(request);
    }

    public final OperationFuture<PullRequest, OperationMetadata> closePullRequestAsync(ClosePullRequestRequest request) {
        return this.closePullRequestOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ClosePullRequestRequest, PullRequest, OperationMetadata> closePullRequestOperationCallable() {
        return this.stub.closePullRequestOperationCallable();
    }

    public final UnaryCallable<ClosePullRequestRequest, Operation> closePullRequestCallable() {
        return this.stub.closePullRequestCallable();
    }

    public final ListPullRequestFileDiffsPagedResponse listPullRequestFileDiffs(PullRequestName name) {
        ListPullRequestFileDiffsRequest request = ListPullRequestFileDiffsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.listPullRequestFileDiffs(request);
    }

    public final ListPullRequestFileDiffsPagedResponse listPullRequestFileDiffs(String name) {
        ListPullRequestFileDiffsRequest request = ListPullRequestFileDiffsRequest.newBuilder().setName(name).build();
        return this.listPullRequestFileDiffs(request);
    }

    public final ListPullRequestFileDiffsPagedResponse listPullRequestFileDiffs(ListPullRequestFileDiffsRequest request) {
        return (ListPullRequestFileDiffsPagedResponse)((Object)this.listPullRequestFileDiffsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPullRequestFileDiffsRequest, ListPullRequestFileDiffsPagedResponse> listPullRequestFileDiffsPagedCallable() {
        return this.stub.listPullRequestFileDiffsPagedCallable();
    }

    public final UnaryCallable<ListPullRequestFileDiffsRequest, ListPullRequestFileDiffsResponse> listPullRequestFileDiffsCallable() {
        return this.stub.listPullRequestFileDiffsCallable();
    }

    public final FetchTreePagedResponse fetchTree(FetchTreeRequest request) {
        return (FetchTreePagedResponse)((Object)this.fetchTreePagedCallable().call((Object)request));
    }

    public final UnaryCallable<FetchTreeRequest, FetchTreePagedResponse> fetchTreePagedCallable() {
        return this.stub.fetchTreePagedCallable();
    }

    public final UnaryCallable<FetchTreeRequest, FetchTreeResponse> fetchTreeCallable() {
        return this.stub.fetchTreeCallable();
    }

    public final FetchBlobResponse fetchBlob(FetchBlobRequest request) {
        return (FetchBlobResponse)this.fetchBlobCallable().call((Object)request);
    }

    public final UnaryCallable<FetchBlobRequest, FetchBlobResponse> fetchBlobCallable() {
        return this.stub.fetchBlobCallable();
    }

    public final OperationFuture<Issue, OperationMetadata> createIssueAsync(RepositoryName parent, Issue issue) {
        CreateIssueRequest request = CreateIssueRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setIssue(issue).build();
        return this.createIssueAsync(request);
    }

    public final OperationFuture<Issue, OperationMetadata> createIssueAsync(String parent, Issue issue) {
        CreateIssueRequest request = CreateIssueRequest.newBuilder().setParent(parent).setIssue(issue).build();
        return this.createIssueAsync(request);
    }

    public final OperationFuture<Issue, OperationMetadata> createIssueAsync(CreateIssueRequest request) {
        return this.createIssueOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateIssueRequest, Issue, OperationMetadata> createIssueOperationCallable() {
        return this.stub.createIssueOperationCallable();
    }

    public final UnaryCallable<CreateIssueRequest, Operation> createIssueCallable() {
        return this.stub.createIssueCallable();
    }

    public final Issue getIssue(IssueName name) {
        GetIssueRequest request = GetIssueRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getIssue(request);
    }

    public final Issue getIssue(String name) {
        GetIssueRequest request = GetIssueRequest.newBuilder().setName(name).build();
        return this.getIssue(request);
    }

    public final Issue getIssue(GetIssueRequest request) {
        return (Issue)this.getIssueCallable().call((Object)request);
    }

    public final UnaryCallable<GetIssueRequest, Issue> getIssueCallable() {
        return this.stub.getIssueCallable();
    }

    public final ListIssuesPagedResponse listIssues(RepositoryName parent) {
        ListIssuesRequest request = ListIssuesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listIssues(request);
    }

    public final ListIssuesPagedResponse listIssues(String parent) {
        ListIssuesRequest request = ListIssuesRequest.newBuilder().setParent(parent).build();
        return this.listIssues(request);
    }

    public final ListIssuesPagedResponse listIssues(ListIssuesRequest request) {
        return (ListIssuesPagedResponse)((Object)this.listIssuesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListIssuesRequest, ListIssuesPagedResponse> listIssuesPagedCallable() {
        return this.stub.listIssuesPagedCallable();
    }

    public final UnaryCallable<ListIssuesRequest, ListIssuesResponse> listIssuesCallable() {
        return this.stub.listIssuesCallable();
    }

    public final OperationFuture<Issue, OperationMetadata> updateIssueAsync(Issue issue, FieldMask updateMask) {
        UpdateIssueRequest request = UpdateIssueRequest.newBuilder().setIssue(issue).setUpdateMask(updateMask).build();
        return this.updateIssueAsync(request);
    }

    public final OperationFuture<Issue, OperationMetadata> updateIssueAsync(UpdateIssueRequest request) {
        return this.updateIssueOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateIssueRequest, Issue, OperationMetadata> updateIssueOperationCallable() {
        return this.stub.updateIssueOperationCallable();
    }

    public final UnaryCallable<UpdateIssueRequest, Operation> updateIssueCallable() {
        return this.stub.updateIssueCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteIssueAsync(IssueName name) {
        DeleteIssueRequest request = DeleteIssueRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteIssueAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteIssueAsync(String name) {
        DeleteIssueRequest request = DeleteIssueRequest.newBuilder().setName(name).build();
        return this.deleteIssueAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteIssueAsync(DeleteIssueRequest request) {
        return this.deleteIssueOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteIssueRequest, Empty, OperationMetadata> deleteIssueOperationCallable() {
        return this.stub.deleteIssueOperationCallable();
    }

    public final UnaryCallable<DeleteIssueRequest, Operation> deleteIssueCallable() {
        return this.stub.deleteIssueCallable();
    }

    public final OperationFuture<Issue, OperationMetadata> openIssueAsync(IssueName name) {
        OpenIssueRequest request = OpenIssueRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.openIssueAsync(request);
    }

    public final OperationFuture<Issue, OperationMetadata> openIssueAsync(String name) {
        OpenIssueRequest request = OpenIssueRequest.newBuilder().setName(name).build();
        return this.openIssueAsync(request);
    }

    public final OperationFuture<Issue, OperationMetadata> openIssueAsync(OpenIssueRequest request) {
        return this.openIssueOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<OpenIssueRequest, Issue, OperationMetadata> openIssueOperationCallable() {
        return this.stub.openIssueOperationCallable();
    }

    public final UnaryCallable<OpenIssueRequest, Operation> openIssueCallable() {
        return this.stub.openIssueCallable();
    }

    public final OperationFuture<Issue, OperationMetadata> closeIssueAsync(IssueName name) {
        CloseIssueRequest request = CloseIssueRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.closeIssueAsync(request);
    }

    public final OperationFuture<Issue, OperationMetadata> closeIssueAsync(String name) {
        CloseIssueRequest request = CloseIssueRequest.newBuilder().setName(name).build();
        return this.closeIssueAsync(request);
    }

    public final OperationFuture<Issue, OperationMetadata> closeIssueAsync(CloseIssueRequest request) {
        return this.closeIssueOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CloseIssueRequest, Issue, OperationMetadata> closeIssueOperationCallable() {
        return this.stub.closeIssueOperationCallable();
    }

    public final UnaryCallable<CloseIssueRequest, Operation> closeIssueCallable() {
        return this.stub.closeIssueCallable();
    }

    public final PullRequestComment getPullRequestComment(PullRequestCommentName name) {
        GetPullRequestCommentRequest request = GetPullRequestCommentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPullRequestComment(request);
    }

    public final PullRequestComment getPullRequestComment(String name) {
        GetPullRequestCommentRequest request = GetPullRequestCommentRequest.newBuilder().setName(name).build();
        return this.getPullRequestComment(request);
    }

    public final PullRequestComment getPullRequestComment(GetPullRequestCommentRequest request) {
        return (PullRequestComment)this.getPullRequestCommentCallable().call((Object)request);
    }

    public final UnaryCallable<GetPullRequestCommentRequest, PullRequestComment> getPullRequestCommentCallable() {
        return this.stub.getPullRequestCommentCallable();
    }

    public final ListPullRequestCommentsPagedResponse listPullRequestComments(PullRequestName parent) {
        ListPullRequestCommentsRequest request = ListPullRequestCommentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPullRequestComments(request);
    }

    public final ListPullRequestCommentsPagedResponse listPullRequestComments(String parent) {
        ListPullRequestCommentsRequest request = ListPullRequestCommentsRequest.newBuilder().setParent(parent).build();
        return this.listPullRequestComments(request);
    }

    public final ListPullRequestCommentsPagedResponse listPullRequestComments(ListPullRequestCommentsRequest request) {
        return (ListPullRequestCommentsPagedResponse)((Object)this.listPullRequestCommentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPullRequestCommentsRequest, ListPullRequestCommentsPagedResponse> listPullRequestCommentsPagedCallable() {
        return this.stub.listPullRequestCommentsPagedCallable();
    }

    public final UnaryCallable<ListPullRequestCommentsRequest, ListPullRequestCommentsResponse> listPullRequestCommentsCallable() {
        return this.stub.listPullRequestCommentsCallable();
    }

    public final OperationFuture<PullRequestComment, OperationMetadata> createPullRequestCommentAsync(PullRequestName parent, PullRequestComment pullRequestComment) {
        CreatePullRequestCommentRequest request = CreatePullRequestCommentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPullRequestComment(pullRequestComment).build();
        return this.createPullRequestCommentAsync(request);
    }

    public final OperationFuture<PullRequestComment, OperationMetadata> createPullRequestCommentAsync(String parent, PullRequestComment pullRequestComment) {
        CreatePullRequestCommentRequest request = CreatePullRequestCommentRequest.newBuilder().setParent(parent).setPullRequestComment(pullRequestComment).build();
        return this.createPullRequestCommentAsync(request);
    }

    public final OperationFuture<PullRequestComment, OperationMetadata> createPullRequestCommentAsync(CreatePullRequestCommentRequest request) {
        return this.createPullRequestCommentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreatePullRequestCommentRequest, PullRequestComment, OperationMetadata> createPullRequestCommentOperationCallable() {
        return this.stub.createPullRequestCommentOperationCallable();
    }

    public final UnaryCallable<CreatePullRequestCommentRequest, Operation> createPullRequestCommentCallable() {
        return this.stub.createPullRequestCommentCallable();
    }

    public final OperationFuture<PullRequestComment, OperationMetadata> updatePullRequestCommentAsync(PullRequestComment pullRequestComment, FieldMask updateMask) {
        UpdatePullRequestCommentRequest request = UpdatePullRequestCommentRequest.newBuilder().setPullRequestComment(pullRequestComment).setUpdateMask(updateMask).build();
        return this.updatePullRequestCommentAsync(request);
    }

    public final OperationFuture<PullRequestComment, OperationMetadata> updatePullRequestCommentAsync(UpdatePullRequestCommentRequest request) {
        return this.updatePullRequestCommentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdatePullRequestCommentRequest, PullRequestComment, OperationMetadata> updatePullRequestCommentOperationCallable() {
        return this.stub.updatePullRequestCommentOperationCallable();
    }

    public final UnaryCallable<UpdatePullRequestCommentRequest, Operation> updatePullRequestCommentCallable() {
        return this.stub.updatePullRequestCommentCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deletePullRequestCommentAsync(PullRequestCommentName name) {
        DeletePullRequestCommentRequest request = DeletePullRequestCommentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deletePullRequestCommentAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deletePullRequestCommentAsync(String name) {
        DeletePullRequestCommentRequest request = DeletePullRequestCommentRequest.newBuilder().setName(name).build();
        return this.deletePullRequestCommentAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deletePullRequestCommentAsync(DeletePullRequestCommentRequest request) {
        return this.deletePullRequestCommentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeletePullRequestCommentRequest, Empty, OperationMetadata> deletePullRequestCommentOperationCallable() {
        return this.stub.deletePullRequestCommentOperationCallable();
    }

    public final UnaryCallable<DeletePullRequestCommentRequest, Operation> deletePullRequestCommentCallable() {
        return this.stub.deletePullRequestCommentCallable();
    }

    public final OperationFuture<BatchCreatePullRequestCommentsResponse, OperationMetadata> batchCreatePullRequestCommentsAsync(PullRequestName parent, List<CreatePullRequestCommentRequest> requests) {
        BatchCreatePullRequestCommentsRequest request = BatchCreatePullRequestCommentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllRequests(requests).build();
        return this.batchCreatePullRequestCommentsAsync(request);
    }

    public final OperationFuture<BatchCreatePullRequestCommentsResponse, OperationMetadata> batchCreatePullRequestCommentsAsync(String parent, List<CreatePullRequestCommentRequest> requests) {
        BatchCreatePullRequestCommentsRequest request = BatchCreatePullRequestCommentsRequest.newBuilder().setParent(parent).addAllRequests(requests).build();
        return this.batchCreatePullRequestCommentsAsync(request);
    }

    public final OperationFuture<BatchCreatePullRequestCommentsResponse, OperationMetadata> batchCreatePullRequestCommentsAsync(BatchCreatePullRequestCommentsRequest request) {
        return this.batchCreatePullRequestCommentsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BatchCreatePullRequestCommentsRequest, BatchCreatePullRequestCommentsResponse, OperationMetadata> batchCreatePullRequestCommentsOperationCallable() {
        return this.stub.batchCreatePullRequestCommentsOperationCallable();
    }

    public final UnaryCallable<BatchCreatePullRequestCommentsRequest, Operation> batchCreatePullRequestCommentsCallable() {
        return this.stub.batchCreatePullRequestCommentsCallable();
    }

    public final OperationFuture<ResolvePullRequestCommentsResponse, OperationMetadata> resolvePullRequestCommentsAsync(PullRequestName parent, List<String> names) {
        ResolvePullRequestCommentsRequest request = ResolvePullRequestCommentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllNames(names).build();
        return this.resolvePullRequestCommentsAsync(request);
    }

    public final OperationFuture<ResolvePullRequestCommentsResponse, OperationMetadata> resolvePullRequestCommentsAsync(String parent, List<String> names) {
        ResolvePullRequestCommentsRequest request = ResolvePullRequestCommentsRequest.newBuilder().setParent(parent).addAllNames(names).build();
        return this.resolvePullRequestCommentsAsync(request);
    }

    public final OperationFuture<ResolvePullRequestCommentsResponse, OperationMetadata> resolvePullRequestCommentsAsync(ResolvePullRequestCommentsRequest request) {
        return this.resolvePullRequestCommentsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ResolvePullRequestCommentsRequest, ResolvePullRequestCommentsResponse, OperationMetadata> resolvePullRequestCommentsOperationCallable() {
        return this.stub.resolvePullRequestCommentsOperationCallable();
    }

    public final UnaryCallable<ResolvePullRequestCommentsRequest, Operation> resolvePullRequestCommentsCallable() {
        return this.stub.resolvePullRequestCommentsCallable();
    }

    public final OperationFuture<UnresolvePullRequestCommentsResponse, OperationMetadata> unresolvePullRequestCommentsAsync(PullRequestName parent, List<String> names) {
        UnresolvePullRequestCommentsRequest request = UnresolvePullRequestCommentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllNames(names).build();
        return this.unresolvePullRequestCommentsAsync(request);
    }

    public final OperationFuture<UnresolvePullRequestCommentsResponse, OperationMetadata> unresolvePullRequestCommentsAsync(String parent, List<String> names) {
        UnresolvePullRequestCommentsRequest request = UnresolvePullRequestCommentsRequest.newBuilder().setParent(parent).addAllNames(names).build();
        return this.unresolvePullRequestCommentsAsync(request);
    }

    public final OperationFuture<UnresolvePullRequestCommentsResponse, OperationMetadata> unresolvePullRequestCommentsAsync(UnresolvePullRequestCommentsRequest request) {
        return this.unresolvePullRequestCommentsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UnresolvePullRequestCommentsRequest, UnresolvePullRequestCommentsResponse, OperationMetadata> unresolvePullRequestCommentsOperationCallable() {
        return this.stub.unresolvePullRequestCommentsOperationCallable();
    }

    public final UnaryCallable<UnresolvePullRequestCommentsRequest, Operation> unresolvePullRequestCommentsCallable() {
        return this.stub.unresolvePullRequestCommentsCallable();
    }

    public final OperationFuture<IssueComment, OperationMetadata> createIssueCommentAsync(IssueName parent, IssueComment issueComment) {
        CreateIssueCommentRequest request = CreateIssueCommentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setIssueComment(issueComment).build();
        return this.createIssueCommentAsync(request);
    }

    public final OperationFuture<IssueComment, OperationMetadata> createIssueCommentAsync(String parent, IssueComment issueComment) {
        CreateIssueCommentRequest request = CreateIssueCommentRequest.newBuilder().setParent(parent).setIssueComment(issueComment).build();
        return this.createIssueCommentAsync(request);
    }

    public final OperationFuture<IssueComment, OperationMetadata> createIssueCommentAsync(CreateIssueCommentRequest request) {
        return this.createIssueCommentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateIssueCommentRequest, IssueComment, OperationMetadata> createIssueCommentOperationCallable() {
        return this.stub.createIssueCommentOperationCallable();
    }

    public final UnaryCallable<CreateIssueCommentRequest, Operation> createIssueCommentCallable() {
        return this.stub.createIssueCommentCallable();
    }

    public final IssueComment getIssueComment(IssueCommentName name) {
        GetIssueCommentRequest request = GetIssueCommentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getIssueComment(request);
    }

    public final IssueComment getIssueComment(String name) {
        GetIssueCommentRequest request = GetIssueCommentRequest.newBuilder().setName(name).build();
        return this.getIssueComment(request);
    }

    public final IssueComment getIssueComment(GetIssueCommentRequest request) {
        return (IssueComment)this.getIssueCommentCallable().call((Object)request);
    }

    public final UnaryCallable<GetIssueCommentRequest, IssueComment> getIssueCommentCallable() {
        return this.stub.getIssueCommentCallable();
    }

    public final ListIssueCommentsPagedResponse listIssueComments(IssueName parent) {
        ListIssueCommentsRequest request = ListIssueCommentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listIssueComments(request);
    }

    public final ListIssueCommentsPagedResponse listIssueComments(String parent) {
        ListIssueCommentsRequest request = ListIssueCommentsRequest.newBuilder().setParent(parent).build();
        return this.listIssueComments(request);
    }

    public final ListIssueCommentsPagedResponse listIssueComments(ListIssueCommentsRequest request) {
        return (ListIssueCommentsPagedResponse)((Object)this.listIssueCommentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListIssueCommentsRequest, ListIssueCommentsPagedResponse> listIssueCommentsPagedCallable() {
        return this.stub.listIssueCommentsPagedCallable();
    }

    public final UnaryCallable<ListIssueCommentsRequest, ListIssueCommentsResponse> listIssueCommentsCallable() {
        return this.stub.listIssueCommentsCallable();
    }

    public final OperationFuture<IssueComment, OperationMetadata> updateIssueCommentAsync(IssueComment issueComment, FieldMask updateMask) {
        UpdateIssueCommentRequest request = UpdateIssueCommentRequest.newBuilder().setIssueComment(issueComment).setUpdateMask(updateMask).build();
        return this.updateIssueCommentAsync(request);
    }

    public final OperationFuture<IssueComment, OperationMetadata> updateIssueCommentAsync(UpdateIssueCommentRequest request) {
        return this.updateIssueCommentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateIssueCommentRequest, IssueComment, OperationMetadata> updateIssueCommentOperationCallable() {
        return this.stub.updateIssueCommentOperationCallable();
    }

    public final UnaryCallable<UpdateIssueCommentRequest, Operation> updateIssueCommentCallable() {
        return this.stub.updateIssueCommentCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteIssueCommentAsync(IssueCommentName name) {
        DeleteIssueCommentRequest request = DeleteIssueCommentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteIssueCommentAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteIssueCommentAsync(String name) {
        DeleteIssueCommentRequest request = DeleteIssueCommentRequest.newBuilder().setName(name).build();
        return this.deleteIssueCommentAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteIssueCommentAsync(DeleteIssueCommentRequest request) {
        return this.deleteIssueCommentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteIssueCommentRequest, Empty, OperationMetadata> deleteIssueCommentOperationCallable() {
        return this.stub.deleteIssueCommentOperationCallable();
    }

    public final UnaryCallable<DeleteIssueCommentRequest, Operation> deleteIssueCommentCallable() {
        return this.stub.deleteIssueCommentCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListIssueCommentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListIssueCommentsRequest, ListIssueCommentsResponse, IssueComment, ListIssueCommentsPage, ListIssueCommentsFixedSizeCollection> {
        private ListIssueCommentsFixedSizeCollection(List<ListIssueCommentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListIssueCommentsFixedSizeCollection createEmptyCollection() {
            return new ListIssueCommentsFixedSizeCollection(null, 0);
        }

        protected ListIssueCommentsFixedSizeCollection createCollection(List<ListIssueCommentsPage> pages, int collectionSize) {
            return new ListIssueCommentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListIssueCommentsPage
    extends AbstractPage<ListIssueCommentsRequest, ListIssueCommentsResponse, IssueComment, ListIssueCommentsPage> {
        private ListIssueCommentsPage(PageContext<ListIssueCommentsRequest, ListIssueCommentsResponse, IssueComment> context, ListIssueCommentsResponse response) {
            super(context, (Object)response);
        }

        private static ListIssueCommentsPage createEmptyPage() {
            return new ListIssueCommentsPage(null, null);
        }

        protected ListIssueCommentsPage createPage(PageContext<ListIssueCommentsRequest, ListIssueCommentsResponse, IssueComment> context, ListIssueCommentsResponse response) {
            return new ListIssueCommentsPage(context, response);
        }

        public ApiFuture<ListIssueCommentsPage> createPageAsync(PageContext<ListIssueCommentsRequest, ListIssueCommentsResponse, IssueComment> context, ApiFuture<ListIssueCommentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListIssueCommentsPagedResponse
    extends AbstractPagedListResponse<ListIssueCommentsRequest, ListIssueCommentsResponse, IssueComment, ListIssueCommentsPage, ListIssueCommentsFixedSizeCollection> {
        public static ApiFuture<ListIssueCommentsPagedResponse> createAsync(PageContext<ListIssueCommentsRequest, ListIssueCommentsResponse, IssueComment> context, ApiFuture<ListIssueCommentsResponse> futureResponse) {
            ApiFuture<ListIssueCommentsPage> futurePage = ListIssueCommentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListIssueCommentsPagedResponse((ListIssueCommentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListIssueCommentsPagedResponse(ListIssueCommentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListIssueCommentsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPullRequestCommentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPullRequestCommentsRequest, ListPullRequestCommentsResponse, PullRequestComment, ListPullRequestCommentsPage, ListPullRequestCommentsFixedSizeCollection> {
        private ListPullRequestCommentsFixedSizeCollection(List<ListPullRequestCommentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPullRequestCommentsFixedSizeCollection createEmptyCollection() {
            return new ListPullRequestCommentsFixedSizeCollection(null, 0);
        }

        protected ListPullRequestCommentsFixedSizeCollection createCollection(List<ListPullRequestCommentsPage> pages, int collectionSize) {
            return new ListPullRequestCommentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPullRequestCommentsPage
    extends AbstractPage<ListPullRequestCommentsRequest, ListPullRequestCommentsResponse, PullRequestComment, ListPullRequestCommentsPage> {
        private ListPullRequestCommentsPage(PageContext<ListPullRequestCommentsRequest, ListPullRequestCommentsResponse, PullRequestComment> context, ListPullRequestCommentsResponse response) {
            super(context, (Object)response);
        }

        private static ListPullRequestCommentsPage createEmptyPage() {
            return new ListPullRequestCommentsPage(null, null);
        }

        protected ListPullRequestCommentsPage createPage(PageContext<ListPullRequestCommentsRequest, ListPullRequestCommentsResponse, PullRequestComment> context, ListPullRequestCommentsResponse response) {
            return new ListPullRequestCommentsPage(context, response);
        }

        public ApiFuture<ListPullRequestCommentsPage> createPageAsync(PageContext<ListPullRequestCommentsRequest, ListPullRequestCommentsResponse, PullRequestComment> context, ApiFuture<ListPullRequestCommentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPullRequestCommentsPagedResponse
    extends AbstractPagedListResponse<ListPullRequestCommentsRequest, ListPullRequestCommentsResponse, PullRequestComment, ListPullRequestCommentsPage, ListPullRequestCommentsFixedSizeCollection> {
        public static ApiFuture<ListPullRequestCommentsPagedResponse> createAsync(PageContext<ListPullRequestCommentsRequest, ListPullRequestCommentsResponse, PullRequestComment> context, ApiFuture<ListPullRequestCommentsResponse> futureResponse) {
            ApiFuture<ListPullRequestCommentsPage> futurePage = ListPullRequestCommentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPullRequestCommentsPagedResponse((ListPullRequestCommentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPullRequestCommentsPagedResponse(ListPullRequestCommentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPullRequestCommentsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListIssuesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListIssuesRequest, ListIssuesResponse, Issue, ListIssuesPage, ListIssuesFixedSizeCollection> {
        private ListIssuesFixedSizeCollection(List<ListIssuesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListIssuesFixedSizeCollection createEmptyCollection() {
            return new ListIssuesFixedSizeCollection(null, 0);
        }

        protected ListIssuesFixedSizeCollection createCollection(List<ListIssuesPage> pages, int collectionSize) {
            return new ListIssuesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListIssuesPage
    extends AbstractPage<ListIssuesRequest, ListIssuesResponse, Issue, ListIssuesPage> {
        private ListIssuesPage(PageContext<ListIssuesRequest, ListIssuesResponse, Issue> context, ListIssuesResponse response) {
            super(context, (Object)response);
        }

        private static ListIssuesPage createEmptyPage() {
            return new ListIssuesPage(null, null);
        }

        protected ListIssuesPage createPage(PageContext<ListIssuesRequest, ListIssuesResponse, Issue> context, ListIssuesResponse response) {
            return new ListIssuesPage(context, response);
        }

        public ApiFuture<ListIssuesPage> createPageAsync(PageContext<ListIssuesRequest, ListIssuesResponse, Issue> context, ApiFuture<ListIssuesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListIssuesPagedResponse
    extends AbstractPagedListResponse<ListIssuesRequest, ListIssuesResponse, Issue, ListIssuesPage, ListIssuesFixedSizeCollection> {
        public static ApiFuture<ListIssuesPagedResponse> createAsync(PageContext<ListIssuesRequest, ListIssuesResponse, Issue> context, ApiFuture<ListIssuesResponse> futureResponse) {
            ApiFuture<ListIssuesPage> futurePage = ListIssuesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListIssuesPagedResponse((ListIssuesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListIssuesPagedResponse(ListIssuesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListIssuesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class FetchTreeFixedSizeCollection
    extends AbstractFixedSizeCollection<FetchTreeRequest, FetchTreeResponse, TreeEntry, FetchTreePage, FetchTreeFixedSizeCollection> {
        private FetchTreeFixedSizeCollection(List<FetchTreePage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static FetchTreeFixedSizeCollection createEmptyCollection() {
            return new FetchTreeFixedSizeCollection(null, 0);
        }

        protected FetchTreeFixedSizeCollection createCollection(List<FetchTreePage> pages, int collectionSize) {
            return new FetchTreeFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class FetchTreePage
    extends AbstractPage<FetchTreeRequest, FetchTreeResponse, TreeEntry, FetchTreePage> {
        private FetchTreePage(PageContext<FetchTreeRequest, FetchTreeResponse, TreeEntry> context, FetchTreeResponse response) {
            super(context, (Object)response);
        }

        private static FetchTreePage createEmptyPage() {
            return new FetchTreePage(null, null);
        }

        protected FetchTreePage createPage(PageContext<FetchTreeRequest, FetchTreeResponse, TreeEntry> context, FetchTreeResponse response) {
            return new FetchTreePage(context, response);
        }

        public ApiFuture<FetchTreePage> createPageAsync(PageContext<FetchTreeRequest, FetchTreeResponse, TreeEntry> context, ApiFuture<FetchTreeResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class FetchTreePagedResponse
    extends AbstractPagedListResponse<FetchTreeRequest, FetchTreeResponse, TreeEntry, FetchTreePage, FetchTreeFixedSizeCollection> {
        public static ApiFuture<FetchTreePagedResponse> createAsync(PageContext<FetchTreeRequest, FetchTreeResponse, TreeEntry> context, ApiFuture<FetchTreeResponse> futureResponse) {
            ApiFuture<FetchTreePage> futurePage = FetchTreePage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new FetchTreePagedResponse((FetchTreePage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private FetchTreePagedResponse(FetchTreePage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)FetchTreeFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPullRequestFileDiffsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPullRequestFileDiffsRequest, ListPullRequestFileDiffsResponse, FileDiff, ListPullRequestFileDiffsPage, ListPullRequestFileDiffsFixedSizeCollection> {
        private ListPullRequestFileDiffsFixedSizeCollection(List<ListPullRequestFileDiffsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPullRequestFileDiffsFixedSizeCollection createEmptyCollection() {
            return new ListPullRequestFileDiffsFixedSizeCollection(null, 0);
        }

        protected ListPullRequestFileDiffsFixedSizeCollection createCollection(List<ListPullRequestFileDiffsPage> pages, int collectionSize) {
            return new ListPullRequestFileDiffsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPullRequestFileDiffsPage
    extends AbstractPage<ListPullRequestFileDiffsRequest, ListPullRequestFileDiffsResponse, FileDiff, ListPullRequestFileDiffsPage> {
        private ListPullRequestFileDiffsPage(PageContext<ListPullRequestFileDiffsRequest, ListPullRequestFileDiffsResponse, FileDiff> context, ListPullRequestFileDiffsResponse response) {
            super(context, (Object)response);
        }

        private static ListPullRequestFileDiffsPage createEmptyPage() {
            return new ListPullRequestFileDiffsPage(null, null);
        }

        protected ListPullRequestFileDiffsPage createPage(PageContext<ListPullRequestFileDiffsRequest, ListPullRequestFileDiffsResponse, FileDiff> context, ListPullRequestFileDiffsResponse response) {
            return new ListPullRequestFileDiffsPage(context, response);
        }

        public ApiFuture<ListPullRequestFileDiffsPage> createPageAsync(PageContext<ListPullRequestFileDiffsRequest, ListPullRequestFileDiffsResponse, FileDiff> context, ApiFuture<ListPullRequestFileDiffsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPullRequestFileDiffsPagedResponse
    extends AbstractPagedListResponse<ListPullRequestFileDiffsRequest, ListPullRequestFileDiffsResponse, FileDiff, ListPullRequestFileDiffsPage, ListPullRequestFileDiffsFixedSizeCollection> {
        public static ApiFuture<ListPullRequestFileDiffsPagedResponse> createAsync(PageContext<ListPullRequestFileDiffsRequest, ListPullRequestFileDiffsResponse, FileDiff> context, ApiFuture<ListPullRequestFileDiffsResponse> futureResponse) {
            ApiFuture<ListPullRequestFileDiffsPage> futurePage = ListPullRequestFileDiffsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPullRequestFileDiffsPagedResponse((ListPullRequestFileDiffsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPullRequestFileDiffsPagedResponse(ListPullRequestFileDiffsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPullRequestFileDiffsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPullRequestsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPullRequestsRequest, ListPullRequestsResponse, PullRequest, ListPullRequestsPage, ListPullRequestsFixedSizeCollection> {
        private ListPullRequestsFixedSizeCollection(List<ListPullRequestsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPullRequestsFixedSizeCollection createEmptyCollection() {
            return new ListPullRequestsFixedSizeCollection(null, 0);
        }

        protected ListPullRequestsFixedSizeCollection createCollection(List<ListPullRequestsPage> pages, int collectionSize) {
            return new ListPullRequestsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPullRequestsPage
    extends AbstractPage<ListPullRequestsRequest, ListPullRequestsResponse, PullRequest, ListPullRequestsPage> {
        private ListPullRequestsPage(PageContext<ListPullRequestsRequest, ListPullRequestsResponse, PullRequest> context, ListPullRequestsResponse response) {
            super(context, (Object)response);
        }

        private static ListPullRequestsPage createEmptyPage() {
            return new ListPullRequestsPage(null, null);
        }

        protected ListPullRequestsPage createPage(PageContext<ListPullRequestsRequest, ListPullRequestsResponse, PullRequest> context, ListPullRequestsResponse response) {
            return new ListPullRequestsPage(context, response);
        }

        public ApiFuture<ListPullRequestsPage> createPageAsync(PageContext<ListPullRequestsRequest, ListPullRequestsResponse, PullRequest> context, ApiFuture<ListPullRequestsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPullRequestsPagedResponse
    extends AbstractPagedListResponse<ListPullRequestsRequest, ListPullRequestsResponse, PullRequest, ListPullRequestsPage, ListPullRequestsFixedSizeCollection> {
        public static ApiFuture<ListPullRequestsPagedResponse> createAsync(PageContext<ListPullRequestsRequest, ListPullRequestsResponse, PullRequest> context, ApiFuture<ListPullRequestsResponse> futureResponse) {
            ApiFuture<ListPullRequestsPage> futurePage = ListPullRequestsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPullRequestsPagedResponse((ListPullRequestsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPullRequestsPagedResponse(ListPullRequestsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPullRequestsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListBranchRulesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBranchRulesRequest, ListBranchRulesResponse, BranchRule, ListBranchRulesPage, ListBranchRulesFixedSizeCollection> {
        private ListBranchRulesFixedSizeCollection(List<ListBranchRulesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListBranchRulesFixedSizeCollection createEmptyCollection() {
            return new ListBranchRulesFixedSizeCollection(null, 0);
        }

        protected ListBranchRulesFixedSizeCollection createCollection(List<ListBranchRulesPage> pages, int collectionSize) {
            return new ListBranchRulesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListBranchRulesPage
    extends AbstractPage<ListBranchRulesRequest, ListBranchRulesResponse, BranchRule, ListBranchRulesPage> {
        private ListBranchRulesPage(PageContext<ListBranchRulesRequest, ListBranchRulesResponse, BranchRule> context, ListBranchRulesResponse response) {
            super(context, (Object)response);
        }

        private static ListBranchRulesPage createEmptyPage() {
            return new ListBranchRulesPage(null, null);
        }

        protected ListBranchRulesPage createPage(PageContext<ListBranchRulesRequest, ListBranchRulesResponse, BranchRule> context, ListBranchRulesResponse response) {
            return new ListBranchRulesPage(context, response);
        }

        public ApiFuture<ListBranchRulesPage> createPageAsync(PageContext<ListBranchRulesRequest, ListBranchRulesResponse, BranchRule> context, ApiFuture<ListBranchRulesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListBranchRulesPagedResponse
    extends AbstractPagedListResponse<ListBranchRulesRequest, ListBranchRulesResponse, BranchRule, ListBranchRulesPage, ListBranchRulesFixedSizeCollection> {
        public static ApiFuture<ListBranchRulesPagedResponse> createAsync(PageContext<ListBranchRulesRequest, ListBranchRulesResponse, BranchRule> context, ApiFuture<ListBranchRulesResponse> futureResponse) {
            ApiFuture<ListBranchRulesPage> futurePage = ListBranchRulesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListBranchRulesPagedResponse((ListBranchRulesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListBranchRulesPagedResponse(ListBranchRulesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListBranchRulesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListHooksFixedSizeCollection
    extends AbstractFixedSizeCollection<ListHooksRequest, ListHooksResponse, Hook, ListHooksPage, ListHooksFixedSizeCollection> {
        private ListHooksFixedSizeCollection(List<ListHooksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListHooksFixedSizeCollection createEmptyCollection() {
            return new ListHooksFixedSizeCollection(null, 0);
        }

        protected ListHooksFixedSizeCollection createCollection(List<ListHooksPage> pages, int collectionSize) {
            return new ListHooksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListHooksPage
    extends AbstractPage<ListHooksRequest, ListHooksResponse, Hook, ListHooksPage> {
        private ListHooksPage(PageContext<ListHooksRequest, ListHooksResponse, Hook> context, ListHooksResponse response) {
            super(context, (Object)response);
        }

        private static ListHooksPage createEmptyPage() {
            return new ListHooksPage(null, null);
        }

        protected ListHooksPage createPage(PageContext<ListHooksRequest, ListHooksResponse, Hook> context, ListHooksResponse response) {
            return new ListHooksPage(context, response);
        }

        public ApiFuture<ListHooksPage> createPageAsync(PageContext<ListHooksRequest, ListHooksResponse, Hook> context, ApiFuture<ListHooksResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListHooksPagedResponse
    extends AbstractPagedListResponse<ListHooksRequest, ListHooksResponse, Hook, ListHooksPage, ListHooksFixedSizeCollection> {
        public static ApiFuture<ListHooksPagedResponse> createAsync(PageContext<ListHooksRequest, ListHooksResponse, Hook> context, ApiFuture<ListHooksResponse> futureResponse) {
            ApiFuture<ListHooksPage> futurePage = ListHooksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListHooksPagedResponse((ListHooksPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListHooksPagedResponse(ListHooksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListHooksFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListRepositoriesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRepositoriesRequest, ListRepositoriesResponse, Repository, ListRepositoriesPage, ListRepositoriesFixedSizeCollection> {
        private ListRepositoriesFixedSizeCollection(List<ListRepositoriesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRepositoriesFixedSizeCollection createEmptyCollection() {
            return new ListRepositoriesFixedSizeCollection(null, 0);
        }

        protected ListRepositoriesFixedSizeCollection createCollection(List<ListRepositoriesPage> pages, int collectionSize) {
            return new ListRepositoriesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRepositoriesPage
    extends AbstractPage<ListRepositoriesRequest, ListRepositoriesResponse, Repository, ListRepositoriesPage> {
        private ListRepositoriesPage(PageContext<ListRepositoriesRequest, ListRepositoriesResponse, Repository> context, ListRepositoriesResponse response) {
            super(context, (Object)response);
        }

        private static ListRepositoriesPage createEmptyPage() {
            return new ListRepositoriesPage(null, null);
        }

        protected ListRepositoriesPage createPage(PageContext<ListRepositoriesRequest, ListRepositoriesResponse, Repository> context, ListRepositoriesResponse response) {
            return new ListRepositoriesPage(context, response);
        }

        public ApiFuture<ListRepositoriesPage> createPageAsync(PageContext<ListRepositoriesRequest, ListRepositoriesResponse, Repository> context, ApiFuture<ListRepositoriesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRepositoriesPagedResponse
    extends AbstractPagedListResponse<ListRepositoriesRequest, ListRepositoriesResponse, Repository, ListRepositoriesPage, ListRepositoriesFixedSizeCollection> {
        public static ApiFuture<ListRepositoriesPagedResponse> createAsync(PageContext<ListRepositoriesRequest, ListRepositoriesResponse, Repository> context, ApiFuture<ListRepositoriesResponse> futureResponse) {
            ApiFuture<ListRepositoriesPage> futurePage = ListRepositoriesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRepositoriesPagedResponse((ListRepositoriesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRepositoriesPagedResponse(ListRepositoriesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRepositoriesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListInstancesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage, ListInstancesFixedSizeCollection> {
        private ListInstancesFixedSizeCollection(List<ListInstancesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInstancesFixedSizeCollection createEmptyCollection() {
            return new ListInstancesFixedSizeCollection(null, 0);
        }

        protected ListInstancesFixedSizeCollection createCollection(List<ListInstancesPage> pages, int collectionSize) {
            return new ListInstancesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInstancesPage
    extends AbstractPage<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage> {
        private ListInstancesPage(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ListInstancesResponse response) {
            super(context, (Object)response);
        }

        private static ListInstancesPage createEmptyPage() {
            return new ListInstancesPage(null, null);
        }

        protected ListInstancesPage createPage(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ListInstancesResponse response) {
            return new ListInstancesPage(context, response);
        }

        public ApiFuture<ListInstancesPage> createPageAsync(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ApiFuture<ListInstancesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInstancesPagedResponse
    extends AbstractPagedListResponse<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage, ListInstancesFixedSizeCollection> {
        public static ApiFuture<ListInstancesPagedResponse> createAsync(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ApiFuture<ListInstancesResponse> futureResponse) {
            ApiFuture<ListInstancesPage> futurePage = ListInstancesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListInstancesPagedResponse((ListInstancesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListInstancesPagedResponse(ListInstancesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInstancesFixedSizeCollection.createEmptyCollection());
        }
    }
}

