/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.run.v2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.run.v2.ExecutionName;
import com.google.cloud.run.v2.GetTaskRequest;
import com.google.cloud.run.v2.ListTasksRequest;
import com.google.cloud.run.v2.ListTasksResponse;
import com.google.cloud.run.v2.Task;
import com.google.cloud.run.v2.TaskName;
import com.google.cloud.run.v2.TasksSettings;
import com.google.cloud.run.v2.stub.TasksStub;
import com.google.cloud.run.v2.stub.TasksStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class TasksClient
implements BackgroundResource {
    private final TasksSettings settings;
    private final TasksStub stub;

    public static final TasksClient create() throws IOException {
        return TasksClient.create(TasksSettings.newBuilder().build());
    }

    public static final TasksClient create(TasksSettings settings) throws IOException {
        return new TasksClient(settings);
    }

    public static final TasksClient create(TasksStub stub) {
        return new TasksClient(stub);
    }

    protected TasksClient(TasksSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TasksStubSettings)settings.getStubSettings()).createStub();
    }

    protected TasksClient(TasksStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final TasksSettings getSettings() {
        return this.settings;
    }

    public TasksStub getStub() {
        return this.stub;
    }

    public final Task getTask(TaskName name) {
        GetTaskRequest request = GetTaskRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTask(request);
    }

    public final Task getTask(String name) {
        GetTaskRequest request = GetTaskRequest.newBuilder().setName(name).build();
        return this.getTask(request);
    }

    public final Task getTask(GetTaskRequest request) {
        return (Task)this.getTaskCallable().call((Object)request);
    }

    public final UnaryCallable<GetTaskRequest, Task> getTaskCallable() {
        return this.stub.getTaskCallable();
    }

    public final ListTasksPagedResponse listTasks(ExecutionName parent) {
        ListTasksRequest request = ListTasksRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTasks(request);
    }

    public final ListTasksPagedResponse listTasks(String parent) {
        ListTasksRequest request = ListTasksRequest.newBuilder().setParent(parent).build();
        return this.listTasks(request);
    }

    public final ListTasksPagedResponse listTasks(ListTasksRequest request) {
        return (ListTasksPagedResponse)((Object)this.listTasksPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTasksRequest, ListTasksPagedResponse> listTasksPagedCallable() {
        return this.stub.listTasksPagedCallable();
    }

    public final UnaryCallable<ListTasksRequest, ListTasksResponse> listTasksCallable() {
        return this.stub.listTasksCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListTasksFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTasksRequest, ListTasksResponse, Task, ListTasksPage, ListTasksFixedSizeCollection> {
        private ListTasksFixedSizeCollection(List<ListTasksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTasksFixedSizeCollection createEmptyCollection() {
            return new ListTasksFixedSizeCollection(null, 0);
        }

        protected ListTasksFixedSizeCollection createCollection(List<ListTasksPage> pages, int collectionSize) {
            return new ListTasksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTasksPage
    extends AbstractPage<ListTasksRequest, ListTasksResponse, Task, ListTasksPage> {
        private ListTasksPage(PageContext<ListTasksRequest, ListTasksResponse, Task> context, ListTasksResponse response) {
            super(context, (Object)response);
        }

        private static ListTasksPage createEmptyPage() {
            return new ListTasksPage(null, null);
        }

        protected ListTasksPage createPage(PageContext<ListTasksRequest, ListTasksResponse, Task> context, ListTasksResponse response) {
            return new ListTasksPage(context, response);
        }

        public ApiFuture<ListTasksPage> createPageAsync(PageContext<ListTasksRequest, ListTasksResponse, Task> context, ApiFuture<ListTasksResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTasksPagedResponse
    extends AbstractPagedListResponse<ListTasksRequest, ListTasksResponse, Task, ListTasksPage, ListTasksFixedSizeCollection> {
        public static ApiFuture<ListTasksPagedResponse> createAsync(PageContext<ListTasksRequest, ListTasksResponse, Task> context, ApiFuture<ListTasksResponse> futureResponse) {
            ApiFuture<ListTasksPage> futurePage = ListTasksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTasksPagedResponse((ListTasksPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTasksPagedResponse(ListTasksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTasksFixedSizeCollection.createEmptyCollection());
        }
    }
}

