/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2alpha;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2alpha.Branch;
import com.google.cloud.retail.v2alpha.BranchName;
import com.google.cloud.retail.v2alpha.BranchServiceSettings;
import com.google.cloud.retail.v2alpha.CatalogName;
import com.google.cloud.retail.v2alpha.GetBranchRequest;
import com.google.cloud.retail.v2alpha.ListBranchesRequest;
import com.google.cloud.retail.v2alpha.ListBranchesResponse;
import com.google.cloud.retail.v2alpha.stub.BranchServiceStub;
import com.google.cloud.retail.v2alpha.stub.BranchServiceStubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class BranchServiceClient
implements BackgroundResource {
    private final BranchServiceSettings settings;
    private final BranchServiceStub stub;

    public static final BranchServiceClient create() throws IOException {
        return BranchServiceClient.create(BranchServiceSettings.newBuilder().build());
    }

    public static final BranchServiceClient create(BranchServiceSettings settings) throws IOException {
        return new BranchServiceClient(settings);
    }

    public static final BranchServiceClient create(BranchServiceStub stub) {
        return new BranchServiceClient(stub);
    }

    protected BranchServiceClient(BranchServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((BranchServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected BranchServiceClient(BranchServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final BranchServiceSettings getSettings() {
        return this.settings;
    }

    public BranchServiceStub getStub() {
        return this.stub;
    }

    public final ListBranchesResponse listBranches(CatalogName parent) {
        ListBranchesRequest request = ListBranchesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listBranches(request);
    }

    public final ListBranchesResponse listBranches(String parent) {
        ListBranchesRequest request = ListBranchesRequest.newBuilder().setParent(parent).build();
        return this.listBranches(request);
    }

    public final ListBranchesResponse listBranches(ListBranchesRequest request) {
        return (ListBranchesResponse)this.listBranchesCallable().call((Object)request);
    }

    public final UnaryCallable<ListBranchesRequest, ListBranchesResponse> listBranchesCallable() {
        return this.stub.listBranchesCallable();
    }

    public final Branch getBranch(BranchName name) {
        GetBranchRequest request = GetBranchRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getBranch(request);
    }

    public final Branch getBranch(String name) {
        GetBranchRequest request = GetBranchRequest.newBuilder().setName(name).build();
        return this.getBranch(request);
    }

    public final Branch getBranch(GetBranchRequest request) {
        return (Branch)this.getBranchCallable().call((Object)request);
    }

    public final UnaryCallable<GetBranchRequest, Branch> getBranchCallable() {
        return this.stub.getBranchCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

