/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2alpha;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2alpha.AddFulfillmentPlacesMetadata;
import com.google.cloud.retail.v2alpha.AddFulfillmentPlacesRequest;
import com.google.cloud.retail.v2alpha.AddFulfillmentPlacesResponse;
import com.google.cloud.retail.v2alpha.AddLocalInventoriesMetadata;
import com.google.cloud.retail.v2alpha.AddLocalInventoriesRequest;
import com.google.cloud.retail.v2alpha.AddLocalInventoriesResponse;
import com.google.cloud.retail.v2alpha.BranchName;
import com.google.cloud.retail.v2alpha.CreateProductRequest;
import com.google.cloud.retail.v2alpha.DeleteProductRequest;
import com.google.cloud.retail.v2alpha.GetProductRequest;
import com.google.cloud.retail.v2alpha.ImportMetadata;
import com.google.cloud.retail.v2alpha.ImportProductsRequest;
import com.google.cloud.retail.v2alpha.ImportProductsResponse;
import com.google.cloud.retail.v2alpha.ListProductsRequest;
import com.google.cloud.retail.v2alpha.ListProductsResponse;
import com.google.cloud.retail.v2alpha.Product;
import com.google.cloud.retail.v2alpha.ProductName;
import com.google.cloud.retail.v2alpha.ProductServiceSettings;
import com.google.cloud.retail.v2alpha.PurgeProductsMetadata;
import com.google.cloud.retail.v2alpha.PurgeProductsRequest;
import com.google.cloud.retail.v2alpha.PurgeProductsResponse;
import com.google.cloud.retail.v2alpha.RemoveFulfillmentPlacesMetadata;
import com.google.cloud.retail.v2alpha.RemoveFulfillmentPlacesRequest;
import com.google.cloud.retail.v2alpha.RemoveFulfillmentPlacesResponse;
import com.google.cloud.retail.v2alpha.RemoveLocalInventoriesMetadata;
import com.google.cloud.retail.v2alpha.RemoveLocalInventoriesRequest;
import com.google.cloud.retail.v2alpha.RemoveLocalInventoriesResponse;
import com.google.cloud.retail.v2alpha.SetInventoryMetadata;
import com.google.cloud.retail.v2alpha.SetInventoryRequest;
import com.google.cloud.retail.v2alpha.SetInventoryResponse;
import com.google.cloud.retail.v2alpha.UpdateProductRequest;
import com.google.cloud.retail.v2alpha.stub.ProductServiceStub;
import com.google.cloud.retail.v2alpha.stub.ProductServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ProductServiceClient
implements BackgroundResource {
    private final ProductServiceSettings settings;
    private final ProductServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final ProductServiceClient create() throws IOException {
        return ProductServiceClient.create(ProductServiceSettings.newBuilder().build());
    }

    public static final ProductServiceClient create(ProductServiceSettings settings) throws IOException {
        return new ProductServiceClient(settings);
    }

    public static final ProductServiceClient create(ProductServiceStub stub) {
        return new ProductServiceClient(stub);
    }

    protected ProductServiceClient(ProductServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ProductServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected ProductServiceClient(ProductServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final ProductServiceSettings getSettings() {
        return this.settings;
    }

    public ProductServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final Product createProduct(BranchName parent, Product product, String productId) {
        CreateProductRequest request = CreateProductRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setProduct(product).setProductId(productId).build();
        return this.createProduct(request);
    }

    public final Product createProduct(String parent, Product product, String productId) {
        CreateProductRequest request = CreateProductRequest.newBuilder().setParent(parent).setProduct(product).setProductId(productId).build();
        return this.createProduct(request);
    }

    public final Product createProduct(CreateProductRequest request) {
        return (Product)this.createProductCallable().call((Object)request);
    }

    public final UnaryCallable<CreateProductRequest, Product> createProductCallable() {
        return this.stub.createProductCallable();
    }

    public final Product getProduct(ProductName name) {
        GetProductRequest request = GetProductRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getProduct(request);
    }

    public final Product getProduct(String name) {
        GetProductRequest request = GetProductRequest.newBuilder().setName(name).build();
        return this.getProduct(request);
    }

    public final Product getProduct(GetProductRequest request) {
        return (Product)this.getProductCallable().call((Object)request);
    }

    public final UnaryCallable<GetProductRequest, Product> getProductCallable() {
        return this.stub.getProductCallable();
    }

    public final ListProductsPagedResponse listProducts(BranchName parent) {
        ListProductsRequest request = ListProductsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listProducts(request);
    }

    public final ListProductsPagedResponse listProducts(String parent) {
        ListProductsRequest request = ListProductsRequest.newBuilder().setParent(parent).build();
        return this.listProducts(request);
    }

    public final ListProductsPagedResponse listProducts(ListProductsRequest request) {
        return (ListProductsPagedResponse)((Object)this.listProductsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListProductsRequest, ListProductsPagedResponse> listProductsPagedCallable() {
        return this.stub.listProductsPagedCallable();
    }

    public final UnaryCallable<ListProductsRequest, ListProductsResponse> listProductsCallable() {
        return this.stub.listProductsCallable();
    }

    public final Product updateProduct(Product product, FieldMask updateMask) {
        UpdateProductRequest request = UpdateProductRequest.newBuilder().setProduct(product).setUpdateMask(updateMask).build();
        return this.updateProduct(request);
    }

    public final Product updateProduct(UpdateProductRequest request) {
        return (Product)this.updateProductCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateProductRequest, Product> updateProductCallable() {
        return this.stub.updateProductCallable();
    }

    public final void deleteProduct(ProductName name) {
        DeleteProductRequest request = DeleteProductRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteProduct(request);
    }

    public final void deleteProduct(String name) {
        DeleteProductRequest request = DeleteProductRequest.newBuilder().setName(name).build();
        this.deleteProduct(request);
    }

    public final void deleteProduct(DeleteProductRequest request) {
        this.deleteProductCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteProductRequest, Empty> deleteProductCallable() {
        return this.stub.deleteProductCallable();
    }

    public final OperationFuture<PurgeProductsResponse, PurgeProductsMetadata> purgeProductsAsync(PurgeProductsRequest request) {
        return this.purgeProductsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PurgeProductsRequest, PurgeProductsResponse, PurgeProductsMetadata> purgeProductsOperationCallable() {
        return this.stub.purgeProductsOperationCallable();
    }

    public final UnaryCallable<PurgeProductsRequest, Operation> purgeProductsCallable() {
        return this.stub.purgeProductsCallable();
    }

    public final OperationFuture<ImportProductsResponse, ImportMetadata> importProductsAsync(ImportProductsRequest request) {
        return this.importProductsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ImportProductsRequest, ImportProductsResponse, ImportMetadata> importProductsOperationCallable() {
        return this.stub.importProductsOperationCallable();
    }

    public final UnaryCallable<ImportProductsRequest, Operation> importProductsCallable() {
        return this.stub.importProductsCallable();
    }

    public final OperationFuture<SetInventoryResponse, SetInventoryMetadata> setInventoryAsync(Product inventory, FieldMask setMask) {
        SetInventoryRequest request = SetInventoryRequest.newBuilder().setInventory(inventory).setSetMask(setMask).build();
        return this.setInventoryAsync(request);
    }

    public final OperationFuture<SetInventoryResponse, SetInventoryMetadata> setInventoryAsync(SetInventoryRequest request) {
        return this.setInventoryOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SetInventoryRequest, SetInventoryResponse, SetInventoryMetadata> setInventoryOperationCallable() {
        return this.stub.setInventoryOperationCallable();
    }

    public final UnaryCallable<SetInventoryRequest, Operation> setInventoryCallable() {
        return this.stub.setInventoryCallable();
    }

    public final OperationFuture<AddFulfillmentPlacesResponse, AddFulfillmentPlacesMetadata> addFulfillmentPlacesAsync(ProductName product) {
        AddFulfillmentPlacesRequest request = AddFulfillmentPlacesRequest.newBuilder().setProduct(product == null ? null : product.toString()).build();
        return this.addFulfillmentPlacesAsync(request);
    }

    public final OperationFuture<AddFulfillmentPlacesResponse, AddFulfillmentPlacesMetadata> addFulfillmentPlacesAsync(String product) {
        AddFulfillmentPlacesRequest request = AddFulfillmentPlacesRequest.newBuilder().setProduct(product).build();
        return this.addFulfillmentPlacesAsync(request);
    }

    public final OperationFuture<AddFulfillmentPlacesResponse, AddFulfillmentPlacesMetadata> addFulfillmentPlacesAsync(AddFulfillmentPlacesRequest request) {
        return this.addFulfillmentPlacesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<AddFulfillmentPlacesRequest, AddFulfillmentPlacesResponse, AddFulfillmentPlacesMetadata> addFulfillmentPlacesOperationCallable() {
        return this.stub.addFulfillmentPlacesOperationCallable();
    }

    public final UnaryCallable<AddFulfillmentPlacesRequest, Operation> addFulfillmentPlacesCallable() {
        return this.stub.addFulfillmentPlacesCallable();
    }

    public final OperationFuture<RemoveFulfillmentPlacesResponse, RemoveFulfillmentPlacesMetadata> removeFulfillmentPlacesAsync(ProductName product) {
        RemoveFulfillmentPlacesRequest request = RemoveFulfillmentPlacesRequest.newBuilder().setProduct(product == null ? null : product.toString()).build();
        return this.removeFulfillmentPlacesAsync(request);
    }

    public final OperationFuture<RemoveFulfillmentPlacesResponse, RemoveFulfillmentPlacesMetadata> removeFulfillmentPlacesAsync(String product) {
        RemoveFulfillmentPlacesRequest request = RemoveFulfillmentPlacesRequest.newBuilder().setProduct(product).build();
        return this.removeFulfillmentPlacesAsync(request);
    }

    public final OperationFuture<RemoveFulfillmentPlacesResponse, RemoveFulfillmentPlacesMetadata> removeFulfillmentPlacesAsync(RemoveFulfillmentPlacesRequest request) {
        return this.removeFulfillmentPlacesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RemoveFulfillmentPlacesRequest, RemoveFulfillmentPlacesResponse, RemoveFulfillmentPlacesMetadata> removeFulfillmentPlacesOperationCallable() {
        return this.stub.removeFulfillmentPlacesOperationCallable();
    }

    public final UnaryCallable<RemoveFulfillmentPlacesRequest, Operation> removeFulfillmentPlacesCallable() {
        return this.stub.removeFulfillmentPlacesCallable();
    }

    public final OperationFuture<AddLocalInventoriesResponse, AddLocalInventoriesMetadata> addLocalInventoriesAsync(ProductName product) {
        AddLocalInventoriesRequest request = AddLocalInventoriesRequest.newBuilder().setProduct(product == null ? null : product.toString()).build();
        return this.addLocalInventoriesAsync(request);
    }

    public final OperationFuture<AddLocalInventoriesResponse, AddLocalInventoriesMetadata> addLocalInventoriesAsync(String product) {
        AddLocalInventoriesRequest request = AddLocalInventoriesRequest.newBuilder().setProduct(product).build();
        return this.addLocalInventoriesAsync(request);
    }

    public final OperationFuture<AddLocalInventoriesResponse, AddLocalInventoriesMetadata> addLocalInventoriesAsync(AddLocalInventoriesRequest request) {
        return this.addLocalInventoriesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<AddLocalInventoriesRequest, AddLocalInventoriesResponse, AddLocalInventoriesMetadata> addLocalInventoriesOperationCallable() {
        return this.stub.addLocalInventoriesOperationCallable();
    }

    public final UnaryCallable<AddLocalInventoriesRequest, Operation> addLocalInventoriesCallable() {
        return this.stub.addLocalInventoriesCallable();
    }

    public final OperationFuture<RemoveLocalInventoriesResponse, RemoveLocalInventoriesMetadata> removeLocalInventoriesAsync(ProductName product) {
        RemoveLocalInventoriesRequest request = RemoveLocalInventoriesRequest.newBuilder().setProduct(product == null ? null : product.toString()).build();
        return this.removeLocalInventoriesAsync(request);
    }

    public final OperationFuture<RemoveLocalInventoriesResponse, RemoveLocalInventoriesMetadata> removeLocalInventoriesAsync(String product) {
        RemoveLocalInventoriesRequest request = RemoveLocalInventoriesRequest.newBuilder().setProduct(product).build();
        return this.removeLocalInventoriesAsync(request);
    }

    public final OperationFuture<RemoveLocalInventoriesResponse, RemoveLocalInventoriesMetadata> removeLocalInventoriesAsync(RemoveLocalInventoriesRequest request) {
        return this.removeLocalInventoriesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RemoveLocalInventoriesRequest, RemoveLocalInventoriesResponse, RemoveLocalInventoriesMetadata> removeLocalInventoriesOperationCallable() {
        return this.stub.removeLocalInventoriesOperationCallable();
    }

    public final UnaryCallable<RemoveLocalInventoriesRequest, Operation> removeLocalInventoriesCallable() {
        return this.stub.removeLocalInventoriesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListProductsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListProductsRequest, ListProductsResponse, Product, ListProductsPage, ListProductsFixedSizeCollection> {
        private ListProductsFixedSizeCollection(List<ListProductsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListProductsFixedSizeCollection createEmptyCollection() {
            return new ListProductsFixedSizeCollection(null, 0);
        }

        protected ListProductsFixedSizeCollection createCollection(List<ListProductsPage> pages, int collectionSize) {
            return new ListProductsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListProductsPage
    extends AbstractPage<ListProductsRequest, ListProductsResponse, Product, ListProductsPage> {
        private ListProductsPage(PageContext<ListProductsRequest, ListProductsResponse, Product> context, ListProductsResponse response) {
            super(context, (Object)response);
        }

        private static ListProductsPage createEmptyPage() {
            return new ListProductsPage(null, null);
        }

        protected ListProductsPage createPage(PageContext<ListProductsRequest, ListProductsResponse, Product> context, ListProductsResponse response) {
            return new ListProductsPage(context, response);
        }

        public ApiFuture<ListProductsPage> createPageAsync(PageContext<ListProductsRequest, ListProductsResponse, Product> context, ApiFuture<ListProductsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListProductsPagedResponse
    extends AbstractPagedListResponse<ListProductsRequest, ListProductsResponse, Product, ListProductsPage, ListProductsFixedSizeCollection> {
        public static ApiFuture<ListProductsPagedResponse> createAsync(PageContext<ListProductsRequest, ListProductsResponse, Product> context, ApiFuture<ListProductsResponse> futureResponse) {
            ApiFuture<ListProductsPage> futurePage = ListProductsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListProductsPagedResponse((ListProductsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListProductsPagedResponse(ListProductsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListProductsFixedSizeCollection.createEmptyCollection());
        }
    }
}

