/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager.v3.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.resourcemanager.v3.CreateProjectMetadata;
import com.google.cloud.resourcemanager.v3.CreateProjectRequest;
import com.google.cloud.resourcemanager.v3.DeleteProjectMetadata;
import com.google.cloud.resourcemanager.v3.DeleteProjectRequest;
import com.google.cloud.resourcemanager.v3.GetProjectRequest;
import com.google.cloud.resourcemanager.v3.ListProjectsRequest;
import com.google.cloud.resourcemanager.v3.ListProjectsResponse;
import com.google.cloud.resourcemanager.v3.MoveProjectMetadata;
import com.google.cloud.resourcemanager.v3.MoveProjectRequest;
import com.google.cloud.resourcemanager.v3.Project;
import com.google.cloud.resourcemanager.v3.ProjectsClient;
import com.google.cloud.resourcemanager.v3.SearchProjectsRequest;
import com.google.cloud.resourcemanager.v3.SearchProjectsResponse;
import com.google.cloud.resourcemanager.v3.UndeleteProjectMetadata;
import com.google.cloud.resourcemanager.v3.UndeleteProjectRequest;
import com.google.cloud.resourcemanager.v3.UpdateProjectMetadata;
import com.google.cloud.resourcemanager.v3.UpdateProjectRequest;
import com.google.cloud.resourcemanager.v3.stub.GrpcProjectsCallableFactory;
import com.google.cloud.resourcemanager.v3.stub.ProjectsStub;
import com.google.cloud.resourcemanager.v3.stub.ProjectsStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcProjectsStub
extends ProjectsStub {
    private static final MethodDescriptor<GetProjectRequest, Project> getProjectMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.Projects/GetProject").setRequestMarshaller(ProtoUtils.marshaller((Message)GetProjectRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Project.getDefaultInstance())).build();
    private static final MethodDescriptor<ListProjectsRequest, ListProjectsResponse> listProjectsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.Projects/ListProjects").setRequestMarshaller(ProtoUtils.marshaller((Message)ListProjectsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListProjectsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<SearchProjectsRequest, SearchProjectsResponse> searchProjectsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.Projects/SearchProjects").setRequestMarshaller(ProtoUtils.marshaller((Message)SearchProjectsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SearchProjectsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateProjectRequest, Operation> createProjectMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.Projects/CreateProject").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateProjectRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateProjectRequest, Operation> updateProjectMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.Projects/UpdateProject").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateProjectRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<MoveProjectRequest, Operation> moveProjectMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.Projects/MoveProject").setRequestMarshaller(ProtoUtils.marshaller((Message)MoveProjectRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteProjectRequest, Operation> deleteProjectMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.Projects/DeleteProject").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteProjectRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UndeleteProjectRequest, Operation> undeleteProjectMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.Projects/UndeleteProject").setRequestMarshaller(ProtoUtils.marshaller((Message)UndeleteProjectRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.Projects/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.Projects/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.Projects/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).build();
    private final UnaryCallable<GetProjectRequest, Project> getProjectCallable;
    private final UnaryCallable<ListProjectsRequest, ListProjectsResponse> listProjectsCallable;
    private final UnaryCallable<ListProjectsRequest, ProjectsClient.ListProjectsPagedResponse> listProjectsPagedCallable;
    private final UnaryCallable<SearchProjectsRequest, SearchProjectsResponse> searchProjectsCallable;
    private final UnaryCallable<SearchProjectsRequest, ProjectsClient.SearchProjectsPagedResponse> searchProjectsPagedCallable;
    private final UnaryCallable<CreateProjectRequest, Operation> createProjectCallable;
    private final OperationCallable<CreateProjectRequest, Project, CreateProjectMetadata> createProjectOperationCallable;
    private final UnaryCallable<UpdateProjectRequest, Operation> updateProjectCallable;
    private final OperationCallable<UpdateProjectRequest, Project, UpdateProjectMetadata> updateProjectOperationCallable;
    private final UnaryCallable<MoveProjectRequest, Operation> moveProjectCallable;
    private final OperationCallable<MoveProjectRequest, Project, MoveProjectMetadata> moveProjectOperationCallable;
    private final UnaryCallable<DeleteProjectRequest, Operation> deleteProjectCallable;
    private final OperationCallable<DeleteProjectRequest, Project, DeleteProjectMetadata> deleteProjectOperationCallable;
    private final UnaryCallable<UndeleteProjectRequest, Operation> undeleteProjectCallable;
    private final OperationCallable<UndeleteProjectRequest, Project, UndeleteProjectMetadata> undeleteProjectOperationCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcProjectsStub create(ProjectsStubSettings settings) throws IOException {
        return new GrpcProjectsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcProjectsStub create(ClientContext clientContext) throws IOException {
        return new GrpcProjectsStub(ProjectsStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcProjectsStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcProjectsStub(ProjectsStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcProjectsStub(ProjectsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcProjectsCallableFactory());
    }

    protected GrpcProjectsStub(ProjectsStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getProjectTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getProjectMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetProjectRequest>(){

            public Map<String, String> extract(GetProjectRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings listProjectsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listProjectsMethodDescriptor).build();
        GrpcCallSettings searchProjectsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(searchProjectsMethodDescriptor).build();
        GrpcCallSettings createProjectTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createProjectMethodDescriptor).build();
        GrpcCallSettings updateProjectTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateProjectMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<UpdateProjectRequest>(){

            public Map<String, String> extract(UpdateProjectRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"project.name", (Object)String.valueOf(request.getProject().getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings moveProjectTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(moveProjectMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<MoveProjectRequest>(){

            public Map<String, String> extract(MoveProjectRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings deleteProjectTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteProjectMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DeleteProjectRequest>(){

            public Map<String, String> extract(DeleteProjectRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings undeleteProjectTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(undeleteProjectMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<UndeleteProjectRequest>(){

            public Map<String, String> extract(UndeleteProjectRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetIamPolicyRequest>(){

            public Map<String, String> extract(GetIamPolicyRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
                return params.build();
            }
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<SetIamPolicyRequest>(){

            public Map<String, String> extract(SetIamPolicyRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
                return params.build();
            }
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<TestIamPermissionsRequest>(){

            public Map<String, String> extract(TestIamPermissionsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
                return params.build();
            }
        }).build();
        this.getProjectCallable = callableFactory.createUnaryCallable(getProjectTransportSettings, settings.getProjectSettings(), clientContext);
        this.listProjectsCallable = callableFactory.createUnaryCallable(listProjectsTransportSettings, settings.listProjectsSettings(), clientContext);
        this.listProjectsPagedCallable = callableFactory.createPagedCallable(listProjectsTransportSettings, settings.listProjectsSettings(), clientContext);
        this.searchProjectsCallable = callableFactory.createUnaryCallable(searchProjectsTransportSettings, settings.searchProjectsSettings(), clientContext);
        this.searchProjectsPagedCallable = callableFactory.createPagedCallable(searchProjectsTransportSettings, settings.searchProjectsSettings(), clientContext);
        this.createProjectCallable = callableFactory.createUnaryCallable(createProjectTransportSettings, settings.createProjectSettings(), clientContext);
        this.createProjectOperationCallable = callableFactory.createOperationCallable(createProjectTransportSettings, settings.createProjectOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateProjectCallable = callableFactory.createUnaryCallable(updateProjectTransportSettings, settings.updateProjectSettings(), clientContext);
        this.updateProjectOperationCallable = callableFactory.createOperationCallable(updateProjectTransportSettings, settings.updateProjectOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.moveProjectCallable = callableFactory.createUnaryCallable(moveProjectTransportSettings, settings.moveProjectSettings(), clientContext);
        this.moveProjectOperationCallable = callableFactory.createOperationCallable(moveProjectTransportSettings, settings.moveProjectOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteProjectCallable = callableFactory.createUnaryCallable(deleteProjectTransportSettings, settings.deleteProjectSettings(), clientContext);
        this.deleteProjectOperationCallable = callableFactory.createOperationCallable(deleteProjectTransportSettings, settings.deleteProjectOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.undeleteProjectCallable = callableFactory.createUnaryCallable(undeleteProjectTransportSettings, settings.undeleteProjectSettings(), clientContext);
        this.undeleteProjectOperationCallable = callableFactory.createOperationCallable(undeleteProjectTransportSettings, settings.undeleteProjectOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetProjectRequest, Project> getProjectCallable() {
        return this.getProjectCallable;
    }

    @Override
    public UnaryCallable<ListProjectsRequest, ListProjectsResponse> listProjectsCallable() {
        return this.listProjectsCallable;
    }

    @Override
    public UnaryCallable<ListProjectsRequest, ProjectsClient.ListProjectsPagedResponse> listProjectsPagedCallable() {
        return this.listProjectsPagedCallable;
    }

    @Override
    public UnaryCallable<SearchProjectsRequest, SearchProjectsResponse> searchProjectsCallable() {
        return this.searchProjectsCallable;
    }

    @Override
    public UnaryCallable<SearchProjectsRequest, ProjectsClient.SearchProjectsPagedResponse> searchProjectsPagedCallable() {
        return this.searchProjectsPagedCallable;
    }

    @Override
    public UnaryCallable<CreateProjectRequest, Operation> createProjectCallable() {
        return this.createProjectCallable;
    }

    @Override
    public OperationCallable<CreateProjectRequest, Project, CreateProjectMetadata> createProjectOperationCallable() {
        return this.createProjectOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateProjectRequest, Operation> updateProjectCallable() {
        return this.updateProjectCallable;
    }

    @Override
    public OperationCallable<UpdateProjectRequest, Project, UpdateProjectMetadata> updateProjectOperationCallable() {
        return this.updateProjectOperationCallable;
    }

    @Override
    public UnaryCallable<MoveProjectRequest, Operation> moveProjectCallable() {
        return this.moveProjectCallable;
    }

    @Override
    public OperationCallable<MoveProjectRequest, Project, MoveProjectMetadata> moveProjectOperationCallable() {
        return this.moveProjectOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteProjectRequest, Operation> deleteProjectCallable() {
        return this.deleteProjectCallable;
    }

    @Override
    public OperationCallable<DeleteProjectRequest, Project, DeleteProjectMetadata> deleteProjectOperationCallable() {
        return this.deleteProjectOperationCallable;
    }

    @Override
    public UnaryCallable<UndeleteProjectRequest, Operation> undeleteProjectCallable() {
        return this.undeleteProjectCallable;
    }

    @Override
    public OperationCallable<UndeleteProjectRequest, Project, UndeleteProjectMetadata> undeleteProjectOperationCallable() {
        return this.undeleteProjectOperationCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

