/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager.v3.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.resourcemanager.v3.CreateTagBindingMetadata;
import com.google.cloud.resourcemanager.v3.CreateTagBindingRequest;
import com.google.cloud.resourcemanager.v3.DeleteTagBindingMetadata;
import com.google.cloud.resourcemanager.v3.DeleteTagBindingRequest;
import com.google.cloud.resourcemanager.v3.ListTagBindingsRequest;
import com.google.cloud.resourcemanager.v3.ListTagBindingsResponse;
import com.google.cloud.resourcemanager.v3.TagBinding;
import com.google.cloud.resourcemanager.v3.TagBindingsClient;
import com.google.cloud.resourcemanager.v3.stub.GrpcTagBindingsCallableFactory;
import com.google.cloud.resourcemanager.v3.stub.TagBindingsStub;
import com.google.cloud.resourcemanager.v3.stub.TagBindingsStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcTagBindingsStub
extends TagBindingsStub {
    private static final MethodDescriptor<ListTagBindingsRequest, ListTagBindingsResponse> listTagBindingsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.TagBindings/ListTagBindings").setRequestMarshaller(ProtoUtils.marshaller((Message)ListTagBindingsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListTagBindingsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateTagBindingRequest, Operation> createTagBindingMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.TagBindings/CreateTagBinding").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateTagBindingRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteTagBindingRequest, Operation> deleteTagBindingMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.TagBindings/DeleteTagBinding").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteTagBindingRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<ListTagBindingsRequest, ListTagBindingsResponse> listTagBindingsCallable;
    private final UnaryCallable<ListTagBindingsRequest, TagBindingsClient.ListTagBindingsPagedResponse> listTagBindingsPagedCallable;
    private final UnaryCallable<CreateTagBindingRequest, Operation> createTagBindingCallable;
    private final OperationCallable<CreateTagBindingRequest, TagBinding, CreateTagBindingMetadata> createTagBindingOperationCallable;
    private final UnaryCallable<DeleteTagBindingRequest, Operation> deleteTagBindingCallable;
    private final OperationCallable<DeleteTagBindingRequest, Empty, DeleteTagBindingMetadata> deleteTagBindingOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcTagBindingsStub create(TagBindingsStubSettings settings) throws IOException {
        return new GrpcTagBindingsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcTagBindingsStub create(ClientContext clientContext) throws IOException {
        return new GrpcTagBindingsStub(TagBindingsStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcTagBindingsStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcTagBindingsStub(TagBindingsStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcTagBindingsStub(TagBindingsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcTagBindingsCallableFactory());
    }

    protected GrpcTagBindingsStub(TagBindingsStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listTagBindingsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listTagBindingsMethodDescriptor).build();
        GrpcCallSettings createTagBindingTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createTagBindingMethodDescriptor).build();
        GrpcCallSettings deleteTagBindingTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteTagBindingMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DeleteTagBindingRequest>(){

            public Map<String, String> extract(DeleteTagBindingRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        this.listTagBindingsCallable = callableFactory.createUnaryCallable(listTagBindingsTransportSettings, settings.listTagBindingsSettings(), clientContext);
        this.listTagBindingsPagedCallable = callableFactory.createPagedCallable(listTagBindingsTransportSettings, settings.listTagBindingsSettings(), clientContext);
        this.createTagBindingCallable = callableFactory.createUnaryCallable(createTagBindingTransportSettings, settings.createTagBindingSettings(), clientContext);
        this.createTagBindingOperationCallable = callableFactory.createOperationCallable(createTagBindingTransportSettings, settings.createTagBindingOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteTagBindingCallable = callableFactory.createUnaryCallable(deleteTagBindingTransportSettings, settings.deleteTagBindingSettings(), clientContext);
        this.deleteTagBindingOperationCallable = callableFactory.createOperationCallable(deleteTagBindingTransportSettings, settings.deleteTagBindingOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListTagBindingsRequest, ListTagBindingsResponse> listTagBindingsCallable() {
        return this.listTagBindingsCallable;
    }

    @Override
    public UnaryCallable<ListTagBindingsRequest, TagBindingsClient.ListTagBindingsPagedResponse> listTagBindingsPagedCallable() {
        return this.listTagBindingsPagedCallable;
    }

    @Override
    public UnaryCallable<CreateTagBindingRequest, Operation> createTagBindingCallable() {
        return this.createTagBindingCallable;
    }

    @Override
    public OperationCallable<CreateTagBindingRequest, TagBinding, CreateTagBindingMetadata> createTagBindingOperationCallable() {
        return this.createTagBindingOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteTagBindingRequest, Operation> deleteTagBindingCallable() {
        return this.deleteTagBindingCallable;
    }

    @Override
    public OperationCallable<DeleteTagBindingRequest, Empty, DeleteTagBindingMetadata> deleteTagBindingOperationCallable() {
        return this.deleteTagBindingOperationCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

