/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.recommendationengine.v1beta1.stub;

import com.google.api.HttpRule;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.recommendationengine.v1beta1.CatalogItem;
import com.google.cloud.recommendationengine.v1beta1.CatalogServiceClient;
import com.google.cloud.recommendationengine.v1beta1.CreateCatalogItemRequest;
import com.google.cloud.recommendationengine.v1beta1.DeleteCatalogItemRequest;
import com.google.cloud.recommendationengine.v1beta1.GetCatalogItemRequest;
import com.google.cloud.recommendationengine.v1beta1.ImportCatalogItemsRequest;
import com.google.cloud.recommendationengine.v1beta1.ImportCatalogItemsResponse;
import com.google.cloud.recommendationengine.v1beta1.ImportMetadata;
import com.google.cloud.recommendationengine.v1beta1.ListCatalogItemsRequest;
import com.google.cloud.recommendationengine.v1beta1.ListCatalogItemsResponse;
import com.google.cloud.recommendationengine.v1beta1.UpdateCatalogItemRequest;
import com.google.cloud.recommendationengine.v1beta1.stub.CatalogServiceStub;
import com.google.cloud.recommendationengine.v1beta1.stub.CatalogServiceStubSettings;
import com.google.cloud.recommendationengine.v1beta1.stub.HttpJsonCatalogServiceCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonCatalogServiceStub
extends CatalogServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(ImportCatalogItemsResponse.getDescriptor()).add(ImportMetadata.getDescriptor()).build();
    private static final ApiMethodDescriptor<CreateCatalogItemRequest, CatalogItem> createCatalogItemMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.recommendationengine.v1beta1.CatalogService/CreateCatalogItem").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta1/{parent=projects/*/locations/*/catalogs/*}/catalogItems", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("catalogItem", (Message)request.getCatalogItem(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)CatalogItem.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetCatalogItemRequest, CatalogItem> getCatalogItemMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.recommendationengine.v1beta1.CatalogService/GetCatalogItem").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta1/{name=projects/*/locations/*/catalogs/*/catalogItems/**}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)CatalogItem.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListCatalogItemsRequest, ListCatalogItemsResponse> listCatalogItemsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.recommendationengine.v1beta1.CatalogService/ListCatalogItems").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta1/{parent=projects/*/locations/*/catalogs/*}/catalogItems", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListCatalogItemsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateCatalogItemRequest, CatalogItem> updateCatalogItemMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.recommendationengine.v1beta1.CatalogService/UpdateCatalogItem").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta1/{name=projects/*/locations/*/catalogs/*/catalogItems/**}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("catalogItem", (Message)request.getCatalogItem(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)CatalogItem.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteCatalogItemRequest, Empty> deleteCatalogItemMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.recommendationengine.v1beta1.CatalogService/DeleteCatalogItem").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta1/{name=projects/*/locations/*/catalogs/*/catalogItems/**}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ImportCatalogItemsRequest, Operation> importCatalogItemsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.recommendationengine.v1beta1.CatalogService/ImportCatalogItems").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta1/{parent=projects/*/locations/*/catalogs/*}/catalogItems:import", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private final UnaryCallable<CreateCatalogItemRequest, CatalogItem> createCatalogItemCallable;
    private final UnaryCallable<GetCatalogItemRequest, CatalogItem> getCatalogItemCallable;
    private final UnaryCallable<ListCatalogItemsRequest, ListCatalogItemsResponse> listCatalogItemsCallable;
    private final UnaryCallable<ListCatalogItemsRequest, CatalogServiceClient.ListCatalogItemsPagedResponse> listCatalogItemsPagedCallable;
    private final UnaryCallable<UpdateCatalogItemRequest, CatalogItem> updateCatalogItemCallable;
    private final UnaryCallable<DeleteCatalogItemRequest, Empty> deleteCatalogItemCallable;
    private final UnaryCallable<ImportCatalogItemsRequest, Operation> importCatalogItemsCallable;
    private final OperationCallable<ImportCatalogItemsRequest, ImportCatalogItemsResponse, ImportMetadata> importCatalogItemsOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonCatalogServiceStub create(CatalogServiceStubSettings settings) throws IOException {
        return new HttpJsonCatalogServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonCatalogServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonCatalogServiceStub(CatalogServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonCatalogServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonCatalogServiceStub(CatalogServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonCatalogServiceStub(CatalogServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonCatalogServiceCallableFactory());
    }

    protected HttpJsonCatalogServiceStub(CatalogServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v1beta1/{name=projects/*/locations/*/catalogs/*/operations/*}").addAdditionalBindings(HttpRule.newBuilder().setGet("/v1beta1/{name=projects/*/locations/*/catalogs/*/eventStores/*/operations/*}").build()).build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v1beta1/{name=projects/*/locations/*/catalogs/*}/operations").addAdditionalBindings(HttpRule.newBuilder().setGet("/v1beta1/{name=projects/*/locations/*/catalogs/*/eventStores/*}/operations").build()).build()).build());
        HttpJsonCallSettings createCatalogItemTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createCatalogItemMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getCatalogItemTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getCatalogItemMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listCatalogItemsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listCatalogItemsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateCatalogItemTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateCatalogItemMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteCatalogItemTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteCatalogItemMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings importCatalogItemsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(importCatalogItemsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.createCatalogItemCallable = callableFactory.createUnaryCallable(createCatalogItemTransportSettings, settings.createCatalogItemSettings(), clientContext);
        this.getCatalogItemCallable = callableFactory.createUnaryCallable(getCatalogItemTransportSettings, settings.getCatalogItemSettings(), clientContext);
        this.listCatalogItemsCallable = callableFactory.createUnaryCallable(listCatalogItemsTransportSettings, settings.listCatalogItemsSettings(), clientContext);
        this.listCatalogItemsPagedCallable = callableFactory.createPagedCallable(listCatalogItemsTransportSettings, settings.listCatalogItemsSettings(), clientContext);
        this.updateCatalogItemCallable = callableFactory.createUnaryCallable(updateCatalogItemTransportSettings, settings.updateCatalogItemSettings(), clientContext);
        this.deleteCatalogItemCallable = callableFactory.createUnaryCallable(deleteCatalogItemTransportSettings, settings.deleteCatalogItemSettings(), clientContext);
        this.importCatalogItemsCallable = callableFactory.createUnaryCallable(importCatalogItemsTransportSettings, settings.importCatalogItemsSettings(), clientContext);
        this.importCatalogItemsOperationCallable = callableFactory.createOperationCallable(importCatalogItemsTransportSettings, settings.importCatalogItemsOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createCatalogItemMethodDescriptor);
        methodDescriptors.add(getCatalogItemMethodDescriptor);
        methodDescriptors.add(listCatalogItemsMethodDescriptor);
        methodDescriptors.add(updateCatalogItemMethodDescriptor);
        methodDescriptors.add(deleteCatalogItemMethodDescriptor);
        methodDescriptors.add(importCatalogItemsMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<CreateCatalogItemRequest, CatalogItem> createCatalogItemCallable() {
        return this.createCatalogItemCallable;
    }

    @Override
    public UnaryCallable<GetCatalogItemRequest, CatalogItem> getCatalogItemCallable() {
        return this.getCatalogItemCallable;
    }

    @Override
    public UnaryCallable<ListCatalogItemsRequest, ListCatalogItemsResponse> listCatalogItemsCallable() {
        return this.listCatalogItemsCallable;
    }

    @Override
    public UnaryCallable<ListCatalogItemsRequest, CatalogServiceClient.ListCatalogItemsPagedResponse> listCatalogItemsPagedCallable() {
        return this.listCatalogItemsPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateCatalogItemRequest, CatalogItem> updateCatalogItemCallable() {
        return this.updateCatalogItemCallable;
    }

    @Override
    public UnaryCallable<DeleteCatalogItemRequest, Empty> deleteCatalogItemCallable() {
        return this.deleteCatalogItemCallable;
    }

    @Override
    public UnaryCallable<ImportCatalogItemsRequest, Operation> importCatalogItemsCallable() {
        return this.importCatalogItemsCallable;
    }

    @Override
    public OperationCallable<ImportCatalogItemsRequest, ImportCatalogItemsResponse, ImportMetadata> importCatalogItemsOperationCallable() {
        return this.importCatalogItemsOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

