/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.pubsub.v1.SchemaServiceClient;
import com.google.cloud.pubsub.v1.stub.GrpcSchemaServiceStub;
import com.google.cloud.pubsub.v1.stub.HttpJsonSchemaServiceStub;
import com.google.cloud.pubsub.v1.stub.SchemaServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.pubsub.v1.CommitSchemaRequest;
import com.google.pubsub.v1.CreateSchemaRequest;
import com.google.pubsub.v1.DeleteSchemaRequest;
import com.google.pubsub.v1.DeleteSchemaRevisionRequest;
import com.google.pubsub.v1.GetSchemaRequest;
import com.google.pubsub.v1.ListSchemaRevisionsRequest;
import com.google.pubsub.v1.ListSchemaRevisionsResponse;
import com.google.pubsub.v1.ListSchemasRequest;
import com.google.pubsub.v1.ListSchemasResponse;
import com.google.pubsub.v1.RollbackSchemaRequest;
import com.google.pubsub.v1.Schema;
import com.google.pubsub.v1.ValidateMessageRequest;
import com.google.pubsub.v1.ValidateMessageResponse;
import com.google.pubsub.v1.ValidateSchemaRequest;
import com.google.pubsub.v1.ValidateSchemaResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class SchemaServiceStubSettings
extends StubSettings<SchemaServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/pubsub").build();
    private final UnaryCallSettings<CreateSchemaRequest, Schema> createSchemaSettings;
    private final UnaryCallSettings<GetSchemaRequest, Schema> getSchemaSettings;
    private final PagedCallSettings<ListSchemasRequest, ListSchemasResponse, SchemaServiceClient.ListSchemasPagedResponse> listSchemasSettings;
    private final PagedCallSettings<ListSchemaRevisionsRequest, ListSchemaRevisionsResponse, SchemaServiceClient.ListSchemaRevisionsPagedResponse> listSchemaRevisionsSettings;
    private final UnaryCallSettings<CommitSchemaRequest, Schema> commitSchemaSettings;
    private final UnaryCallSettings<RollbackSchemaRequest, Schema> rollbackSchemaSettings;
    private final UnaryCallSettings<DeleteSchemaRevisionRequest, Schema> deleteSchemaRevisionSettings;
    private final UnaryCallSettings<DeleteSchemaRequest, Empty> deleteSchemaSettings;
    private final UnaryCallSettings<ValidateSchemaRequest, ValidateSchemaResponse> validateSchemaSettings;
    private final UnaryCallSettings<ValidateMessageRequest, ValidateMessageResponse> validateMessageSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListSchemasRequest, ListSchemasResponse, Schema> LIST_SCHEMAS_PAGE_STR_DESC = new PagedListDescriptor<ListSchemasRequest, ListSchemasResponse, Schema>(){

        public String emptyToken() {
            return "";
        }

        public ListSchemasRequest injectToken(ListSchemasRequest payload, String token) {
            return ListSchemasRequest.newBuilder((ListSchemasRequest)payload).setPageToken(token).build();
        }

        public ListSchemasRequest injectPageSize(ListSchemasRequest payload, int pageSize) {
            return ListSchemasRequest.newBuilder((ListSchemasRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSchemasRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSchemasResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Schema> extractResources(ListSchemasResponse payload) {
            return payload.getSchemasList() == null ? ImmutableList.of() : payload.getSchemasList();
        }
    };
    private static final PagedListDescriptor<ListSchemaRevisionsRequest, ListSchemaRevisionsResponse, Schema> LIST_SCHEMA_REVISIONS_PAGE_STR_DESC = new PagedListDescriptor<ListSchemaRevisionsRequest, ListSchemaRevisionsResponse, Schema>(){

        public String emptyToken() {
            return "";
        }

        public ListSchemaRevisionsRequest injectToken(ListSchemaRevisionsRequest payload, String token) {
            return ListSchemaRevisionsRequest.newBuilder((ListSchemaRevisionsRequest)payload).setPageToken(token).build();
        }

        public ListSchemaRevisionsRequest injectPageSize(ListSchemaRevisionsRequest payload, int pageSize) {
            return ListSchemaRevisionsRequest.newBuilder((ListSchemaRevisionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSchemaRevisionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSchemaRevisionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Schema> extractResources(ListSchemaRevisionsResponse payload) {
            return payload.getSchemasList() == null ? ImmutableList.of() : payload.getSchemasList();
        }
    };
    private static final PagedListResponseFactory<ListSchemasRequest, ListSchemasResponse, SchemaServiceClient.ListSchemasPagedResponse> LIST_SCHEMAS_PAGE_STR_FACT = new PagedListResponseFactory<ListSchemasRequest, ListSchemasResponse, SchemaServiceClient.ListSchemasPagedResponse>(){

        public ApiFuture<SchemaServiceClient.ListSchemasPagedResponse> getFuturePagedResponse(UnaryCallable<ListSchemasRequest, ListSchemasResponse> callable, ListSchemasRequest request, ApiCallContext context, ApiFuture<ListSchemasResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SCHEMAS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SchemaServiceClient.ListSchemasPagedResponse.createAsync((PageContext<ListSchemasRequest, ListSchemasResponse, Schema>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListSchemaRevisionsRequest, ListSchemaRevisionsResponse, SchemaServiceClient.ListSchemaRevisionsPagedResponse> LIST_SCHEMA_REVISIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListSchemaRevisionsRequest, ListSchemaRevisionsResponse, SchemaServiceClient.ListSchemaRevisionsPagedResponse>(){

        public ApiFuture<SchemaServiceClient.ListSchemaRevisionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListSchemaRevisionsRequest, ListSchemaRevisionsResponse> callable, ListSchemaRevisionsRequest request, ApiCallContext context, ApiFuture<ListSchemaRevisionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SCHEMA_REVISIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SchemaServiceClient.ListSchemaRevisionsPagedResponse.createAsync((PageContext<ListSchemaRevisionsRequest, ListSchemaRevisionsResponse, Schema>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateSchemaRequest, Schema> createSchemaSettings() {
        return this.createSchemaSettings;
    }

    public UnaryCallSettings<GetSchemaRequest, Schema> getSchemaSettings() {
        return this.getSchemaSettings;
    }

    public PagedCallSettings<ListSchemasRequest, ListSchemasResponse, SchemaServiceClient.ListSchemasPagedResponse> listSchemasSettings() {
        return this.listSchemasSettings;
    }

    public PagedCallSettings<ListSchemaRevisionsRequest, ListSchemaRevisionsResponse, SchemaServiceClient.ListSchemaRevisionsPagedResponse> listSchemaRevisionsSettings() {
        return this.listSchemaRevisionsSettings;
    }

    public UnaryCallSettings<CommitSchemaRequest, Schema> commitSchemaSettings() {
        return this.commitSchemaSettings;
    }

    public UnaryCallSettings<RollbackSchemaRequest, Schema> rollbackSchemaSettings() {
        return this.rollbackSchemaSettings;
    }

    public UnaryCallSettings<DeleteSchemaRevisionRequest, Schema> deleteSchemaRevisionSettings() {
        return this.deleteSchemaRevisionSettings;
    }

    public UnaryCallSettings<DeleteSchemaRequest, Empty> deleteSchemaSettings() {
        return this.deleteSchemaSettings;
    }

    public UnaryCallSettings<ValidateSchemaRequest, ValidateSchemaResponse> validateSchemaSettings() {
        return this.validateSchemaSettings;
    }

    public UnaryCallSettings<ValidateMessageRequest, ValidateMessageResponse> validateMessageSettings() {
        return this.validateMessageSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public SchemaServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcSchemaServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonSchemaServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "pubsub.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "pubsub.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return SchemaServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SchemaServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SchemaServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return SchemaServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected SchemaServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createSchemaSettings = settingsBuilder.createSchemaSettings().build();
        this.getSchemaSettings = settingsBuilder.getSchemaSettings().build();
        this.listSchemasSettings = settingsBuilder.listSchemasSettings().build();
        this.listSchemaRevisionsSettings = settingsBuilder.listSchemaRevisionsSettings().build();
        this.commitSchemaSettings = settingsBuilder.commitSchemaSettings().build();
        this.rollbackSchemaSettings = settingsBuilder.rollbackSchemaSettings().build();
        this.deleteSchemaRevisionSettings = settingsBuilder.deleteSchemaRevisionSettings().build();
        this.deleteSchemaSettings = settingsBuilder.deleteSchemaSettings().build();
        this.validateSchemaSettings = settingsBuilder.validateSchemaSettings().build();
        this.validateMessageSettings = settingsBuilder.validateMessageSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<SchemaServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateSchemaRequest, Schema> createSchemaSettings;
        private final UnaryCallSettings.Builder<GetSchemaRequest, Schema> getSchemaSettings;
        private final PagedCallSettings.Builder<ListSchemasRequest, ListSchemasResponse, SchemaServiceClient.ListSchemasPagedResponse> listSchemasSettings;
        private final PagedCallSettings.Builder<ListSchemaRevisionsRequest, ListSchemaRevisionsResponse, SchemaServiceClient.ListSchemaRevisionsPagedResponse> listSchemaRevisionsSettings;
        private final UnaryCallSettings.Builder<CommitSchemaRequest, Schema> commitSchemaSettings;
        private final UnaryCallSettings.Builder<RollbackSchemaRequest, Schema> rollbackSchemaSettings;
        private final UnaryCallSettings.Builder<DeleteSchemaRevisionRequest, Schema> deleteSchemaRevisionSettings;
        private final UnaryCallSettings.Builder<DeleteSchemaRequest, Empty> deleteSchemaSettings;
        private final UnaryCallSettings.Builder<ValidateSchemaRequest, ValidateSchemaResponse> validateSchemaSettings;
        private final UnaryCallSettings.Builder<ValidateMessageRequest, ValidateMessageResponse> validateMessageSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createSchemaSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSchemaSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSchemasSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SCHEMAS_PAGE_STR_FACT);
            this.listSchemaRevisionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SCHEMA_REVISIONS_PAGE_STR_FACT);
            this.commitSchemaSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.rollbackSchemaSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSchemaRevisionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSchemaSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.validateSchemaSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.validateMessageSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSchemaSettings, this.getSchemaSettings, this.listSchemasSettings, this.listSchemaRevisionsSettings, this.commitSchemaSettings, this.rollbackSchemaSettings, this.deleteSchemaRevisionSettings, this.deleteSchemaSettings, this.validateSchemaSettings, this.validateMessageSettings, this.setIamPolicySettings, this.getIamPolicySettings, (Object[])new UnaryCallSettings.Builder[]{this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(SchemaServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createSchemaSettings = settings.createSchemaSettings.toBuilder();
            this.getSchemaSettings = settings.getSchemaSettings.toBuilder();
            this.listSchemasSettings = settings.listSchemasSettings.toBuilder();
            this.listSchemaRevisionsSettings = settings.listSchemaRevisionsSettings.toBuilder();
            this.commitSchemaSettings = settings.commitSchemaSettings.toBuilder();
            this.rollbackSchemaSettings = settings.rollbackSchemaSettings.toBuilder();
            this.deleteSchemaRevisionSettings = settings.deleteSchemaRevisionSettings.toBuilder();
            this.deleteSchemaSettings = settings.deleteSchemaSettings.toBuilder();
            this.validateSchemaSettings = settings.validateSchemaSettings.toBuilder();
            this.validateMessageSettings = settings.validateMessageSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSchemaSettings, this.getSchemaSettings, this.listSchemasSettings, this.listSchemaRevisionsSettings, this.commitSchemaSettings, this.rollbackSchemaSettings, this.deleteSchemaRevisionSettings, this.deleteSchemaSettings, this.validateSchemaSettings, this.validateMessageSettings, this.setIamPolicySettings, this.getIamPolicySettings, (Object[])new UnaryCallSettings.Builder[]{this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(SchemaServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)SchemaServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SchemaServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(SchemaServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(SchemaServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)SchemaServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)SchemaServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SchemaServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(SchemaServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(SchemaServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createSchemaSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_7_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_7_params"));
            builder.getSchemaSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_7_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_7_params"));
            builder.listSchemasSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_7_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_7_params"));
            builder.listSchemaRevisionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_7_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_7_params"));
            builder.commitSchemaSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_7_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_7_params"));
            builder.rollbackSchemaSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_7_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_7_params"));
            builder.deleteSchemaRevisionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_7_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_7_params"));
            builder.deleteSchemaSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_7_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_7_params"));
            builder.validateSchemaSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_7_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_7_params"));
            builder.validateMessageSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_7_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_7_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateSchemaRequest, Schema> createSchemaSettings() {
            return this.createSchemaSettings;
        }

        public UnaryCallSettings.Builder<GetSchemaRequest, Schema> getSchemaSettings() {
            return this.getSchemaSettings;
        }

        public PagedCallSettings.Builder<ListSchemasRequest, ListSchemasResponse, SchemaServiceClient.ListSchemasPagedResponse> listSchemasSettings() {
            return this.listSchemasSettings;
        }

        public PagedCallSettings.Builder<ListSchemaRevisionsRequest, ListSchemaRevisionsResponse, SchemaServiceClient.ListSchemaRevisionsPagedResponse> listSchemaRevisionsSettings() {
            return this.listSchemaRevisionsSettings;
        }

        public UnaryCallSettings.Builder<CommitSchemaRequest, Schema> commitSchemaSettings() {
            return this.commitSchemaSettings;
        }

        public UnaryCallSettings.Builder<RollbackSchemaRequest, Schema> rollbackSchemaSettings() {
            return this.rollbackSchemaSettings;
        }

        public UnaryCallSettings.Builder<DeleteSchemaRevisionRequest, Schema> deleteSchemaRevisionSettings() {
            return this.deleteSchemaRevisionSettings;
        }

        public UnaryCallSettings.Builder<DeleteSchemaRequest, Empty> deleteSchemaSettings() {
            return this.deleteSchemaSettings;
        }

        public UnaryCallSettings.Builder<ValidateSchemaRequest, ValidateSchemaResponse> validateSchemaSettings() {
            return this.validateSchemaSettings;
        }

        public UnaryCallSettings.Builder<ValidateMessageRequest, ValidateMessageResponse> validateMessageSettings() {
            return this.validateMessageSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public SchemaServiceStubSettings build() throws IOException {
            return new SchemaServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_7_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_7_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

