/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.pubsub.v1.SchemaServiceSettings;
import com.google.cloud.pubsub.v1.stub.SchemaServiceStub;
import com.google.cloud.pubsub.v1.stub.SchemaServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.pubsub.v1.CreateSchemaRequest;
import com.google.pubsub.v1.DeleteSchemaRequest;
import com.google.pubsub.v1.GetSchemaRequest;
import com.google.pubsub.v1.ListSchemasRequest;
import com.google.pubsub.v1.ListSchemasResponse;
import com.google.pubsub.v1.ProjectName;
import com.google.pubsub.v1.Schema;
import com.google.pubsub.v1.SchemaName;
import com.google.pubsub.v1.ValidateMessageRequest;
import com.google.pubsub.v1.ValidateMessageResponse;
import com.google.pubsub.v1.ValidateSchemaRequest;
import com.google.pubsub.v1.ValidateSchemaResponse;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class SchemaServiceClient
implements BackgroundResource {
    private final SchemaServiceSettings settings;
    private final SchemaServiceStub stub;

    public static final SchemaServiceClient create() throws IOException {
        return SchemaServiceClient.create(SchemaServiceSettings.newBuilder().build());
    }

    public static final SchemaServiceClient create(SchemaServiceSettings settings) throws IOException {
        return new SchemaServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final SchemaServiceClient create(SchemaServiceStub stub) {
        return new SchemaServiceClient(stub);
    }

    protected SchemaServiceClient(SchemaServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SchemaServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected SchemaServiceClient(SchemaServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SchemaServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public SchemaServiceStub getStub() {
        return this.stub;
    }

    public final Schema createSchema(ProjectName parent, Schema schema, String schemaId) {
        CreateSchemaRequest request = CreateSchemaRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSchema(schema).setSchemaId(schemaId).build();
        return this.createSchema(request);
    }

    public final Schema createSchema(String parent, Schema schema, String schemaId) {
        CreateSchemaRequest request = CreateSchemaRequest.newBuilder().setParent(parent).setSchema(schema).setSchemaId(schemaId).build();
        return this.createSchema(request);
    }

    public final Schema createSchema(CreateSchemaRequest request) {
        return (Schema)this.createSchemaCallable().call((Object)request);
    }

    public final UnaryCallable<CreateSchemaRequest, Schema> createSchemaCallable() {
        return this.stub.createSchemaCallable();
    }

    public final Schema getSchema(SchemaName name) {
        GetSchemaRequest request = GetSchemaRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSchema(request);
    }

    public final Schema getSchema(String name) {
        GetSchemaRequest request = GetSchemaRequest.newBuilder().setName(name).build();
        return this.getSchema(request);
    }

    public final Schema getSchema(GetSchemaRequest request) {
        return (Schema)this.getSchemaCallable().call((Object)request);
    }

    public final UnaryCallable<GetSchemaRequest, Schema> getSchemaCallable() {
        return this.stub.getSchemaCallable();
    }

    public final ListSchemasPagedResponse listSchemas(ProjectName parent) {
        ListSchemasRequest request = ListSchemasRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSchemas(request);
    }

    public final ListSchemasPagedResponse listSchemas(String parent) {
        ListSchemasRequest request = ListSchemasRequest.newBuilder().setParent(parent).build();
        return this.listSchemas(request);
    }

    public final ListSchemasPagedResponse listSchemas(ListSchemasRequest request) {
        return (ListSchemasPagedResponse)((Object)this.listSchemasPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSchemasRequest, ListSchemasPagedResponse> listSchemasPagedCallable() {
        return this.stub.listSchemasPagedCallable();
    }

    public final UnaryCallable<ListSchemasRequest, ListSchemasResponse> listSchemasCallable() {
        return this.stub.listSchemasCallable();
    }

    public final void deleteSchema(SchemaName name) {
        DeleteSchemaRequest request = DeleteSchemaRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteSchema(request);
    }

    public final void deleteSchema(String name) {
        DeleteSchemaRequest request = DeleteSchemaRequest.newBuilder().setName(name).build();
        this.deleteSchema(request);
    }

    public final void deleteSchema(DeleteSchemaRequest request) {
        this.deleteSchemaCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteSchemaRequest, Empty> deleteSchemaCallable() {
        return this.stub.deleteSchemaCallable();
    }

    public final ValidateSchemaResponse validateSchema(ProjectName parent, Schema schema) {
        ValidateSchemaRequest request = ValidateSchemaRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSchema(schema).build();
        return this.validateSchema(request);
    }

    public final ValidateSchemaResponse validateSchema(String parent, Schema schema) {
        ValidateSchemaRequest request = ValidateSchemaRequest.newBuilder().setParent(parent).setSchema(schema).build();
        return this.validateSchema(request);
    }

    public final ValidateSchemaResponse validateSchema(ValidateSchemaRequest request) {
        return (ValidateSchemaResponse)this.validateSchemaCallable().call((Object)request);
    }

    public final UnaryCallable<ValidateSchemaRequest, ValidateSchemaResponse> validateSchemaCallable() {
        return this.stub.validateSchemaCallable();
    }

    public final ValidateMessageResponse validateMessage(ValidateMessageRequest request) {
        return (ValidateMessageResponse)this.validateMessageCallable().call((Object)request);
    }

    public final UnaryCallable<ValidateMessageRequest, ValidateMessageResponse> validateMessageCallable() {
        return this.stub.validateMessageCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListSchemasFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSchemasRequest, ListSchemasResponse, Schema, ListSchemasPage, ListSchemasFixedSizeCollection> {
        private ListSchemasFixedSizeCollection(List<ListSchemasPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSchemasFixedSizeCollection createEmptyCollection() {
            return new ListSchemasFixedSizeCollection(null, 0);
        }

        protected ListSchemasFixedSizeCollection createCollection(List<ListSchemasPage> pages, int collectionSize) {
            return new ListSchemasFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSchemasPage
    extends AbstractPage<ListSchemasRequest, ListSchemasResponse, Schema, ListSchemasPage> {
        private ListSchemasPage(PageContext<ListSchemasRequest, ListSchemasResponse, Schema> context, ListSchemasResponse response) {
            super(context, (Object)response);
        }

        private static ListSchemasPage createEmptyPage() {
            return new ListSchemasPage(null, null);
        }

        protected ListSchemasPage createPage(PageContext<ListSchemasRequest, ListSchemasResponse, Schema> context, ListSchemasResponse response) {
            return new ListSchemasPage(context, response);
        }

        public ApiFuture<ListSchemasPage> createPageAsync(PageContext<ListSchemasRequest, ListSchemasResponse, Schema> context, ApiFuture<ListSchemasResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSchemasPagedResponse
    extends AbstractPagedListResponse<ListSchemasRequest, ListSchemasResponse, Schema, ListSchemasPage, ListSchemasFixedSizeCollection> {
        public static ApiFuture<ListSchemasPagedResponse> createAsync(PageContext<ListSchemasRequest, ListSchemasResponse, Schema> context, ApiFuture<ListSchemasResponse> futureResponse) {
            ApiFuture<ListSchemasPage> futurePage = ListSchemasPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListSchemasPage, ListSchemasPagedResponse>(){

                public ListSchemasPagedResponse apply(ListSchemasPage input) {
                    return new ListSchemasPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListSchemasPagedResponse(ListSchemasPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSchemasFixedSizeCollection.createEmptyCollection());
        }
    }
}

