/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.spi.v1;

import com.google.api.gax.core.ConnectionSettings;
import com.google.api.gax.core.RetrySettings;
import com.google.api.gax.grpc.ApiCallSettings;
import com.google.api.gax.grpc.PageStreamingCallSettings;
import com.google.api.gax.grpc.PageStreamingDescriptor;
import com.google.api.gax.grpc.ServiceApiSettings;
import com.google.api.gax.grpc.SimpleCallSettings;
import com.google.auth.Credentials;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.protobuf.Empty;
import com.google.pubsub.v1.AcknowledgeRequest;
import com.google.pubsub.v1.DeleteSubscriptionRequest;
import com.google.pubsub.v1.GetSubscriptionRequest;
import com.google.pubsub.v1.ListSubscriptionsRequest;
import com.google.pubsub.v1.ListSubscriptionsResponse;
import com.google.pubsub.v1.ModifyAckDeadlineRequest;
import com.google.pubsub.v1.ModifyPushConfigRequest;
import com.google.pubsub.v1.PullRequest;
import com.google.pubsub.v1.PullResponse;
import com.google.pubsub.v1.SubscriberGrpc;
import com.google.pubsub.v1.Subscription;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.joda.time.Duration;

public class SubscriberSettings
extends ServiceApiSettings {
    private static final String DEFAULT_SERVICE_ADDRESS = "pubsub.googleapis.com";
    private static final int DEFAULT_SERVICE_PORT = 443;
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/pubsub").build();
    public static final ConnectionSettings DEFAULT_CONNECTION_SETTINGS = ConnectionSettings.newBuilder().setServiceAddress("pubsub.googleapis.com").setPort(443).provideCredentialsWith(DEFAULT_SERVICE_SCOPES).build();
    private final SimpleCallSettings<Subscription, Subscription> createSubscriptionSettings;
    private final SimpleCallSettings<GetSubscriptionRequest, Subscription> getSubscriptionSettings;
    private final PageStreamingCallSettings<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription> listSubscriptionsSettings;
    private final SimpleCallSettings<DeleteSubscriptionRequest, Empty> deleteSubscriptionSettings;
    private final SimpleCallSettings<ModifyAckDeadlineRequest, Empty> modifyAckDeadlineSettings;
    private final SimpleCallSettings<AcknowledgeRequest, Empty> acknowledgeSettings;
    private final SimpleCallSettings<PullRequest, PullResponse> pullSettings;
    private final SimpleCallSettings<ModifyPushConfigRequest, Empty> modifyPushConfigSettings;
    private static PageStreamingDescriptor<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription> LIST_SUBSCRIPTIONS_PAGE_STR_DESC = new PageStreamingDescriptor<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription>(){

        public Object emptyToken() {
            return "";
        }

        public ListSubscriptionsRequest injectToken(ListSubscriptionsRequest payload, Object token) {
            return ListSubscriptionsRequest.newBuilder((ListSubscriptionsRequest)payload).setPageToken((String)token).build();
        }

        public Object extractNextToken(ListSubscriptionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Subscription> extractResources(ListSubscriptionsResponse payload) {
            return payload.getSubscriptionsList();
        }
    };

    public SimpleCallSettings<Subscription, Subscription> createSubscriptionSettings() {
        return this.createSubscriptionSettings;
    }

    public SimpleCallSettings<GetSubscriptionRequest, Subscription> getSubscriptionSettings() {
        return this.getSubscriptionSettings;
    }

    public PageStreamingCallSettings<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription> listSubscriptionsSettings() {
        return this.listSubscriptionsSettings;
    }

    public SimpleCallSettings<DeleteSubscriptionRequest, Empty> deleteSubscriptionSettings() {
        return this.deleteSubscriptionSettings;
    }

    public SimpleCallSettings<ModifyAckDeadlineRequest, Empty> modifyAckDeadlineSettings() {
        return this.modifyAckDeadlineSettings;
    }

    public SimpleCallSettings<AcknowledgeRequest, Empty> acknowledgeSettings() {
        return this.acknowledgeSettings;
    }

    public SimpleCallSettings<PullRequest, PullResponse> pullSettings() {
        return this.pullSettings;
    }

    public SimpleCallSettings<ModifyPushConfigRequest, Empty> modifyPushConfigSettings() {
        return this.modifyPushConfigSettings;
    }

    public static String getDefaultServiceAddress() {
        return DEFAULT_SERVICE_ADDRESS;
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static ImmutableList<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static Builder defaultBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private SubscriberSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder.getChannelProvider(), settingsBuilder.getExecutorProvider(), settingsBuilder.getGeneratorName(), settingsBuilder.getGeneratorVersion(), settingsBuilder.getClientLibName(), settingsBuilder.getClientLibVersion());
        this.createSubscriptionSettings = settingsBuilder.createSubscriptionSettings().build();
        this.getSubscriptionSettings = settingsBuilder.getSubscriptionSettings().build();
        this.listSubscriptionsSettings = settingsBuilder.listSubscriptionsSettings().build();
        this.deleteSubscriptionSettings = settingsBuilder.deleteSubscriptionSettings().build();
        this.modifyAckDeadlineSettings = settingsBuilder.modifyAckDeadlineSettings().build();
        this.acknowledgeSettings = settingsBuilder.acknowledgeSettings().build();
        this.pullSettings = settingsBuilder.pullSettings().build();
        this.modifyPushConfigSettings = settingsBuilder.modifyPushConfigSettings().build();
    }

    public static class Builder
    extends ServiceApiSettings.Builder {
        private final ImmutableList<ApiCallSettings.Builder> methodSettingsBuilders;
        private SimpleCallSettings.Builder<Subscription, Subscription> createSubscriptionSettings;
        private SimpleCallSettings.Builder<GetSubscriptionRequest, Subscription> getSubscriptionSettings;
        private PageStreamingCallSettings.Builder<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription> listSubscriptionsSettings;
        private SimpleCallSettings.Builder<DeleteSubscriptionRequest, Empty> deleteSubscriptionSettings;
        private SimpleCallSettings.Builder<ModifyAckDeadlineRequest, Empty> modifyAckDeadlineSettings;
        private SimpleCallSettings.Builder<AcknowledgeRequest, Empty> acknowledgeSettings;
        private SimpleCallSettings.Builder<PullRequest, PullResponse> pullSettings;
        private SimpleCallSettings.Builder<ModifyPushConfigRequest, Empty> modifyPushConfigSettings;
        private static final ImmutableMap<String, ImmutableSet<Status.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings.Builder> RETRY_PARAM_DEFINITIONS;

        private Builder() {
            super(DEFAULT_CONNECTION_SETTINGS);
            this.createSubscriptionSettings = SimpleCallSettings.newBuilder((MethodDescriptor)SubscriberGrpc.METHOD_CREATE_SUBSCRIPTION);
            this.getSubscriptionSettings = SimpleCallSettings.newBuilder((MethodDescriptor)SubscriberGrpc.METHOD_GET_SUBSCRIPTION);
            this.listSubscriptionsSettings = PageStreamingCallSettings.newBuilder((MethodDescriptor)SubscriberGrpc.METHOD_LIST_SUBSCRIPTIONS, (PageStreamingDescriptor)LIST_SUBSCRIPTIONS_PAGE_STR_DESC);
            this.deleteSubscriptionSettings = SimpleCallSettings.newBuilder((MethodDescriptor)SubscriberGrpc.METHOD_DELETE_SUBSCRIPTION);
            this.modifyAckDeadlineSettings = SimpleCallSettings.newBuilder((MethodDescriptor)SubscriberGrpc.METHOD_MODIFY_ACK_DEADLINE);
            this.acknowledgeSettings = SimpleCallSettings.newBuilder((MethodDescriptor)SubscriberGrpc.METHOD_ACKNOWLEDGE);
            this.pullSettings = SimpleCallSettings.newBuilder((MethodDescriptor)SubscriberGrpc.METHOD_PULL);
            this.modifyPushConfigSettings = SimpleCallSettings.newBuilder((MethodDescriptor)SubscriberGrpc.METHOD_MODIFY_PUSH_CONFIG);
            this.methodSettingsBuilders = ImmutableList.of(this.createSubscriptionSettings, this.getSubscriptionSettings, this.listSubscriptionsSettings, this.deleteSubscriptionSettings, this.modifyAckDeadlineSettings, this.acknowledgeSettings, this.pullSettings, this.modifyPushConfigSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder();
            builder.createSubscriptionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getSubscriptionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listSubscriptionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteSubscriptionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.modifyAckDeadlineSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.acknowledgeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"messaging"));
            builder.pullSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"messaging"));
            builder.modifyPushConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        private Builder(SubscriberSettings settings) {
            super((ServiceApiSettings)settings);
            this.createSubscriptionSettings = settings.createSubscriptionSettings.toBuilder();
            this.getSubscriptionSettings = settings.getSubscriptionSettings.toBuilder();
            this.listSubscriptionsSettings = settings.listSubscriptionsSettings.toBuilder();
            this.deleteSubscriptionSettings = settings.deleteSubscriptionSettings.toBuilder();
            this.modifyAckDeadlineSettings = settings.modifyAckDeadlineSettings.toBuilder();
            this.acknowledgeSettings = settings.acknowledgeSettings.toBuilder();
            this.pullSettings = settings.pullSettings.toBuilder();
            this.modifyPushConfigSettings = settings.modifyPushConfigSettings.toBuilder();
            this.methodSettingsBuilders = ImmutableList.of(this.createSubscriptionSettings, this.getSubscriptionSettings, this.listSubscriptionsSettings, this.deleteSubscriptionSettings, this.modifyAckDeadlineSettings, this.acknowledgeSettings, this.pullSettings, this.modifyPushConfigSettings);
        }

        protected ConnectionSettings getDefaultConnectionSettings() {
            return DEFAULT_CONNECTION_SETTINGS;
        }

        public Builder provideExecutorWith(ScheduledExecutorService executor, boolean shouldAutoClose) {
            super.provideExecutorWith(executor, shouldAutoClose);
            return this;
        }

        public Builder provideChannelWith(ManagedChannel channel, boolean shouldAutoClose) {
            super.provideChannelWith(channel, shouldAutoClose);
            return this;
        }

        public Builder provideChannelWith(ConnectionSettings settings) {
            super.provideChannelWith(settings);
            return this;
        }

        public Builder provideChannelWith(Credentials credentials) {
            super.provideChannelWith(credentials);
            return this;
        }

        public Builder provideChannelWith(List<String> scopes) {
            super.provideChannelWith(scopes);
            return this;
        }

        public Builder setGeneratorHeader(String name, String version) {
            super.setGeneratorHeader(name, version);
            return this;
        }

        public Builder setClientLibHeader(String name, String version) {
            super.setClientLibHeader(name, version);
            return this;
        }

        public Builder applyToAllApiMethods(ApiCallSettings.Builder apiCallSettings) throws Exception {
            super.applyToAllApiMethods(this.methodSettingsBuilders, apiCallSettings);
            return this;
        }

        public SimpleCallSettings.Builder<Subscription, Subscription> createSubscriptionSettings() {
            return this.createSubscriptionSettings;
        }

        public SimpleCallSettings.Builder<GetSubscriptionRequest, Subscription> getSubscriptionSettings() {
            return this.getSubscriptionSettings;
        }

        public PageStreamingCallSettings.Builder<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription> listSubscriptionsSettings() {
            return this.listSubscriptionsSettings;
        }

        public SimpleCallSettings.Builder<DeleteSubscriptionRequest, Empty> deleteSubscriptionSettings() {
            return this.deleteSubscriptionSettings;
        }

        public SimpleCallSettings.Builder<ModifyAckDeadlineRequest, Empty> modifyAckDeadlineSettings() {
            return this.modifyAckDeadlineSettings;
        }

        public SimpleCallSettings.Builder<AcknowledgeRequest, Empty> acknowledgeSettings() {
            return this.acknowledgeSettings;
        }

        public SimpleCallSettings.Builder<PullRequest, PullResponse> pullSettings() {
            return this.pullSettings;
        }

        public SimpleCallSettings.Builder<ModifyPushConfigRequest, Empty> modifyPushConfigSettings() {
            return this.modifyPushConfigSettings;
        }

        public SubscriberSettings build() throws IOException {
            return new SubscriberSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.DEADLINE_EXCEEDED, Status.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings.Builder settingsBuilder = null;
            settingsBuilder = RetrySettings.newBuilder().setInitialRetryDelay(Duration.millis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.millis((long)60000L)).setInitialRpcTimeout(Duration.millis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.millis((long)60000L)).setTotalTimeout(Duration.millis((long)600000L));
            definitions.put((Object)"default", (Object)settingsBuilder);
            settingsBuilder = RetrySettings.newBuilder().setInitialRetryDelay(Duration.millis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.millis((long)60000L)).setInitialRpcTimeout(Duration.millis((long)12000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.millis((long)12000L)).setTotalTimeout(Duration.millis((long)600000L));
            definitions.put((Object)"messaging", (Object)settingsBuilder);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

