/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.core.AbstractApiService;
import com.google.api.core.ApiClock;
import com.google.api.core.ApiService;
import com.google.api.core.CurrentMillisClock;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.Distribution;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.FixedExecutorProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.pubsub.v1.MessageDispatcher;
import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.cloud.pubsub.v1.PollingSubscriberConnection;
import com.google.cloud.pubsub.v1.StreamingSubscriberConnection;
import com.google.cloud.pubsub.v1.SubscriptionAdminSettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.pubsub.v1.GetSubscriptionRequest;
import com.google.pubsub.v1.SubscriberGrpc;
import com.google.pubsub.v1.Subscription;
import com.google.pubsub.v1.SubscriptionName;
import io.grpc.CallCredentials;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.auth.MoreCallCredentials;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;

public class Subscriber
extends AbstractApiService {
    private static final int THREADS_PER_CHANNEL = 5;
    @VisibleForTesting
    static final int CHANNELS_PER_CORE = 1;
    private static final int MAX_INBOUND_MESSAGE_SIZE = 0x1400000;
    private static final int INITIAL_ACK_DEADLINE_SECONDS = 10;
    private static final int MAX_ACK_DEADLINE_SECONDS = 600;
    static final int MIN_ACK_DEADLINE_SECONDS = 10;
    private static final Duration ACK_DEADLINE_UPDATE_PERIOD = Duration.ofMinutes((long)1L);
    private static final double PERCENTILE_FOR_ACK_DEADLINE_UPDATES = 99.9;
    private static final ScheduledExecutorService SHARED_SYSTEM_EXECUTOR = InstantiatingExecutorProvider.newBuilder().setExecutorThreadCount(6).build().getExecutor();
    private static final Logger logger = Logger.getLogger(Subscriber.class.getName());
    private final SubscriptionName subscriptionName;
    private final String cachedSubscriptionNameString;
    private final FlowControlSettings flowControlSettings;
    private final Duration ackExpirationPadding;
    private final Duration maxAckExtensionPeriod;
    private final ScheduledExecutorService executor;
    @Nullable
    private final ScheduledExecutorService alarmsExecutor;
    private final Distribution ackLatencyDistribution = new Distribution(601);
    private final int numChannels;
    private final FlowController flowController;
    private final ChannelProvider channelProvider;
    private final CredentialsProvider credentialsProvider;
    private final List<ManagedChannel> channels;
    private final MessageReceiver receiver;
    private final List<StreamingSubscriberConnection> streamingSubscriberConnections;
    private final List<PollingSubscriberConnection> pollingSubscriberConnections;
    private final Deque<MessageDispatcher.OutstandingMessageBatch> outstandingMessageBatches = new LinkedList<MessageDispatcher.OutstandingMessageBatch>();
    private final ApiClock clock;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final boolean useStreaming;
    private ScheduledFuture<?> ackDeadlineUpdater;
    private int streamAckDeadlineSeconds;

    private Subscriber(Builder builder) {
        this.receiver = builder.receiver;
        this.flowControlSettings = builder.flowControlSettings;
        this.subscriptionName = builder.subscriptionName;
        this.cachedSubscriptionNameString = this.subscriptionName.toString();
        this.ackExpirationPadding = builder.ackExpirationPadding;
        this.maxAckExtensionPeriod = builder.maxAckExtensionPeriod;
        long streamAckDeadlineMillis = this.ackExpirationPadding.toMillis();
        this.streamAckDeadlineSeconds = Math.max(10, Ints.saturatedCast((long)TimeUnit.MILLISECONDS.toSeconds(streamAckDeadlineMillis)));
        this.clock = builder.clock.isPresent() ? (ApiClock)builder.clock.get() : CurrentMillisClock.getDefaultClock();
        this.flowController = new FlowController(builder.flowControlSettings.toBuilder().setLimitExceededBehavior(FlowController.LimitExceededBehavior.ThrowException).build());
        this.executor = builder.executorProvider.getExecutor();
        if (builder.executorProvider.shouldAutoClose()) {
            this.closeables.add(new AutoCloseable(){

                @Override
                public void close() throws IOException {
                    Subscriber.this.executor.shutdown();
                }
            });
        }
        this.alarmsExecutor = builder.systemExecutorProvider.getExecutor();
        if (builder.systemExecutorProvider.shouldAutoClose()) {
            this.closeables.add(new AutoCloseable(){

                @Override
                public void close() throws IOException {
                    Subscriber.this.alarmsExecutor.shutdown();
                }
            });
        }
        this.channelProvider = builder.channelProvider;
        this.credentialsProvider = builder.credentialsProvider;
        this.numChannels = builder.parallelPullCount;
        this.channels = new ArrayList<ManagedChannel>(this.numChannels);
        this.streamingSubscriberConnections = new ArrayList<StreamingSubscriberConnection>(this.numChannels);
        this.pollingSubscriberConnections = new ArrayList<PollingSubscriberConnection>(this.numChannels);
        this.useStreaming = builder.useStreaming;
    }

    public static Builder defaultBuilder(SubscriptionName subscription, MessageReceiver receiver) {
        return new Builder(subscription, receiver);
    }

    public SubscriptionName getSubscriptionName() {
        return this.subscriptionName;
    }

    public Duration getAckExpirationPadding() {
        return this.ackExpirationPadding;
    }

    public FlowControlSettings getFlowControlSettings() {
        return this.flowControlSettings;
    }

    public ApiService startAsync() {
        return super.startAsync();
    }

    protected void doStart() {
        logger.log(Level.FINE, "Starting subscriber group.");
        try {
            for (int i = 0; i < this.numChannels; ++i) {
                final ManagedChannel channel = this.channelProvider.needsExecutor() ? this.channelProvider.getChannel((Executor)this.executor) : this.channelProvider.getChannel();
                this.channels.add(channel);
                if (!this.channelProvider.shouldAutoClose()) continue;
                this.closeables.add(new AutoCloseable(){

                    @Override
                    public void close() {
                        channel.shutdown();
                    }
                });
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (Subscriber.this.useStreaming) {
                        Subscriber.this.startStreamingConnections();
                    } else {
                        Subscriber.this.startPollingConnections();
                    }
                    Subscriber.this.notifyStarted();
                }
                catch (Throwable t) {
                    Subscriber.this.notifyFailed(t);
                }
            }
        }).start();
    }

    protected void doStop() {
        this.stopAllPollingConnections();
        this.stopAllStreamingConnections();
        try {
            for (AutoCloseable closeable : this.closeables) {
                closeable.close();
            }
            this.notifyStopped();
        }
        catch (Exception e) {
            this.notifyFailed(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startPollingConnections() throws IOException {
        List<PollingSubscriberConnection> list = this.pollingSubscriberConnections;
        synchronized (list) {
            Credentials credentials = this.credentialsProvider.getCredentials();
            CallCredentials callCredentials = credentials == null ? null : MoreCallCredentials.from((Credentials)credentials);
            SubscriberGrpc.SubscriberBlockingStub getSubStub = (SubscriberGrpc.SubscriberBlockingStub)SubscriberGrpc.newBlockingStub((Channel)((Channel)this.channels.get(0))).withDeadlineAfter(PollingSubscriberConnection.DEFAULT_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS);
            if (callCredentials != null) {
                getSubStub = (SubscriberGrpc.SubscriberBlockingStub)getSubStub.withCallCredentials(callCredentials);
            }
            Subscription subscriptionInfo = getSubStub.getSubscription(GetSubscriptionRequest.newBuilder().setSubscription(this.cachedSubscriptionNameString).build());
            for (Channel channel : this.channels) {
                SubscriberGrpc.SubscriberFutureStub stub = SubscriberGrpc.newFutureStub((Channel)channel);
                if (callCredentials != null) {
                    stub = (SubscriberGrpc.SubscriberFutureStub)stub.withCallCredentials(callCredentials);
                }
                this.pollingSubscriberConnections.add(new PollingSubscriberConnection(subscriptionInfo, this.receiver, this.ackExpirationPadding, this.maxAckExtensionPeriod, this.ackLatencyDistribution, stub, this.flowController, this.flowControlSettings.getMaxOutstandingElementCount(), this.outstandingMessageBatches, this.executor, this.alarmsExecutor, this.clock));
            }
            this.startConnections(this.pollingSubscriberConnections, new ApiService.Listener(){

                public void failed(ApiService.State from, Throwable failure) {
                    block2: {
                        Subscriber.this.stopAllPollingConnections();
                        try {
                            Subscriber.this.notifyFailed(failure);
                        }
                        catch (IllegalStateException e) {
                            if (!Subscriber.this.isRunning()) break block2;
                            throw e;
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startStreamingConnections() throws IOException {
        List<StreamingSubscriberConnection> list = this.streamingSubscriberConnections;
        synchronized (list) {
            Credentials credentials = this.credentialsProvider.getCredentials();
            CallCredentials callCredentials = credentials == null ? null : MoreCallCredentials.from((Credentials)credentials);
            for (Channel channel : this.channels) {
                SubscriberGrpc.SubscriberStub stub = SubscriberGrpc.newStub((Channel)channel);
                if (callCredentials != null) {
                    stub = (SubscriberGrpc.SubscriberStub)stub.withCallCredentials(callCredentials);
                }
                this.streamingSubscriberConnections.add(new StreamingSubscriberConnection(this.cachedSubscriptionNameString, this.receiver, this.ackExpirationPadding, this.maxAckExtensionPeriod, this.streamAckDeadlineSeconds, this.ackLatencyDistribution, stub, this.flowController, this.outstandingMessageBatches, this.executor, this.alarmsExecutor, this.clock));
            }
            this.startConnections(this.streamingSubscriberConnections, new ApiService.Listener(){

                public void failed(ApiService.State from, Throwable failure) {
                    block2: {
                        Subscriber.this.stopAllStreamingConnections();
                        try {
                            Subscriber.this.notifyFailed(failure);
                        }
                        catch (IllegalStateException e) {
                            if (!Subscriber.this.isRunning()) break block2;
                            throw e;
                        }
                    }
                }
            });
        }
        this.ackDeadlineUpdater = this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                Subscriber.this.updateAckDeadline();
            }
        }, ACK_DEADLINE_UPDATE_PERIOD.toMillis(), ACK_DEADLINE_UPDATE_PERIOD.toMillis(), TimeUnit.MILLISECONDS);
    }

    private void updateAckDeadline() {
        int possibleStreamAckDeadlineSeconds;
        long ackLatency = this.ackLatencyDistribution.getNthPercentile(99.9);
        if (ackLatency > 0L && this.streamAckDeadlineSeconds != (possibleStreamAckDeadlineSeconds = Math.max(10, Ints.saturatedCast((long)Math.max(ackLatency, this.ackExpirationPadding.getSeconds()))))) {
            this.streamAckDeadlineSeconds = possibleStreamAckDeadlineSeconds;
            logger.log(Level.FINER, "Updating stream deadline to {0} seconds.", this.streamAckDeadlineSeconds);
            for (StreamingSubscriberConnection subscriberConnection : this.streamingSubscriberConnections) {
                subscriberConnection.updateStreamAckDeadline(this.streamAckDeadlineSeconds);
            }
        }
    }

    private void stopAllPollingConnections() {
        this.stopConnections(this.pollingSubscriberConnections);
    }

    private void stopAllStreamingConnections() {
        this.stopConnections(this.streamingSubscriberConnections);
        if (this.ackDeadlineUpdater != null) {
            this.ackDeadlineUpdater.cancel(true);
        }
    }

    private void startConnections(List<? extends ApiService> connections, ApiService.Listener connectionsListener) {
        for (ApiService apiService : connections) {
            apiService.addListener(connectionsListener, (Executor)this.executor);
            apiService.startAsync();
        }
        for (ApiService apiService : connections) {
            apiService.awaitRunning();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopConnections(List<? extends ApiService> connections) {
        ArrayList<? extends ApiService> liveConnections;
        List<? extends ApiService> list = connections;
        synchronized (list) {
            liveConnections = new ArrayList<ApiService>(connections);
            connections.clear();
        }
        for (ApiService apiService : liveConnections) {
            apiService.stopAsync();
        }
        for (ApiService apiService : liveConnections) {
            try {
                apiService.awaitTerminated();
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    static /* synthetic */ ScheduledExecutorService access$1200() {
        return SHARED_SYSTEM_EXECUTOR;
    }

    public static final class Builder {
        private static final Duration MIN_ACK_EXPIRATION_PADDING = Duration.ofMillis((long)100L);
        private static final Duration DEFAULT_ACK_EXPIRATION_PADDING = Duration.ofMillis((long)500L);
        private static final Duration DEFAULT_MAX_ACK_EXTENSION_PERIOD = Duration.ofMinutes((long)60L);
        private static final long DEFAULT_MEMORY_PERCENTAGE = 20L;
        static final ExecutorProvider DEFAULT_EXECUTOR_PROVIDER = InstantiatingExecutorProvider.newBuilder().setExecutorThreadCount(5 * Runtime.getRuntime().availableProcessors()).build();
        SubscriptionName subscriptionName;
        MessageReceiver receiver;
        Duration ackExpirationPadding = DEFAULT_ACK_EXPIRATION_PADDING;
        Duration maxAckExtensionPeriod = DEFAULT_MAX_ACK_EXTENSION_PERIOD;
        FlowControlSettings flowControlSettings = FlowControlSettings.newBuilder().setMaxOutstandingRequestBytes(Long.valueOf(Runtime.getRuntime().maxMemory() * 20L / 100L)).build();
        ExecutorProvider executorProvider = DEFAULT_EXECUTOR_PROVIDER;
        ExecutorProvider systemExecutorProvider = FixedExecutorProvider.create((ScheduledExecutorService)Subscriber.access$1200());
        ChannelProvider channelProvider = SubscriptionAdminSettings.defaultGrpcChannelProviderBuilder().setMaxInboundMessageSize(Integer.valueOf(0x1400000)).build();
        CredentialsProvider credentialsProvider = SubscriptionAdminSettings.defaultCredentialsProviderBuilder().build();
        Optional<ApiClock> clock = Optional.absent();
        boolean useStreaming = true;
        int parallelPullCount = Runtime.getRuntime().availableProcessors() * 1;

        Builder(SubscriptionName subscriptionName, MessageReceiver receiver) {
            this.subscriptionName = subscriptionName;
            this.receiver = receiver;
        }

        public Builder setChannelProvider(ChannelProvider channelProvider) {
            this.channelProvider = (ChannelProvider)Preconditions.checkNotNull((Object)channelProvider);
            return this;
        }

        public Builder setFlowControlSettings(FlowControlSettings flowControlSettings) {
            this.flowControlSettings = (FlowControlSettings)Preconditions.checkNotNull((Object)flowControlSettings);
            return this;
        }

        public Builder setAckExpirationPadding(Duration ackExpirationPadding) {
            Preconditions.checkArgument((ackExpirationPadding.compareTo(MIN_ACK_EXPIRATION_PADDING) >= 0 ? 1 : 0) != 0);
            this.ackExpirationPadding = ackExpirationPadding;
            return this;
        }

        public Builder setMaxAckExtensionPeriod(Duration maxAckExtensionPeriod) {
            Preconditions.checkArgument((maxAckExtensionPeriod.toMillis() >= 0L ? 1 : 0) != 0);
            this.maxAckExtensionPeriod = maxAckExtensionPeriod;
            return this;
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            this.executorProvider = (ExecutorProvider)Preconditions.checkNotNull((Object)executorProvider);
            return this;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = (CredentialsProvider)Preconditions.checkNotNull((Object)credentialsProvider);
            return this;
        }

        public Builder setSystemExecutorProvider(ExecutorProvider executorProvider) {
            this.systemExecutorProvider = (ExecutorProvider)Preconditions.checkNotNull((Object)executorProvider);
            return this;
        }

        public Builder setParallelPullCount(int parallelPullCount) {
            this.parallelPullCount = parallelPullCount;
            return this;
        }

        Builder setClock(ApiClock clock) {
            this.clock = Optional.of((Object)clock);
            return this;
        }

        Builder setUseStreaming(boolean useStreaming) {
            this.useStreaming = useStreaming;
            return this;
        }

        public Subscriber build() {
            return new Subscriber(this);
        }
    }
}

