/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.pubsub.v1.PagedResponseWrappers;
import com.google.cloud.pubsub.v1.TopicAdminSettings;
import com.google.cloud.pubsub.v1.stub.PublisherStub;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.pubsub.v1.DeleteTopicRequest;
import com.google.pubsub.v1.GetTopicRequest;
import com.google.pubsub.v1.ListTopicSubscriptionsRequest;
import com.google.pubsub.v1.ListTopicSubscriptionsResponse;
import com.google.pubsub.v1.ListTopicsRequest;
import com.google.pubsub.v1.ListTopicsResponse;
import com.google.pubsub.v1.ProjectName;
import com.google.pubsub.v1.PublishRequest;
import com.google.pubsub.v1.PublishResponse;
import com.google.pubsub.v1.PubsubMessage;
import com.google.pubsub.v1.Topic;
import com.google.pubsub.v1.TopicName;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class TopicAdminClient
implements BackgroundResource {
    private final TopicAdminSettings settings;
    private final PublisherStub stub;

    public static final TopicAdminClient create() throws IOException {
        return TopicAdminClient.create(TopicAdminSettings.defaultBuilder().build());
    }

    public static final TopicAdminClient create(TopicAdminSettings settings) throws IOException {
        return new TopicAdminClient(settings);
    }

    public static final TopicAdminClient create(PublisherStub stub) {
        return new TopicAdminClient(stub);
    }

    protected TopicAdminClient(TopicAdminSettings settings) throws IOException {
        this.settings = settings;
        this.stub = settings.createStub();
    }

    protected TopicAdminClient(PublisherStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final TopicAdminSettings getSettings() {
        return this.settings;
    }

    public PublisherStub getStub() {
        return this.stub;
    }

    public final Topic createTopic(TopicName name) {
        Topic request = Topic.newBuilder().setNameWithTopicName(name).build();
        return this.createTopic(request);
    }

    private final Topic createTopic(Topic request) {
        return (Topic)this.createTopicCallable().call((Object)request);
    }

    public final UnaryCallable<Topic, Topic> createTopicCallable() {
        return this.stub.createTopicCallable();
    }

    final PublishResponse publish(TopicName topic, List<PubsubMessage> messages) {
        PublishRequest request = PublishRequest.newBuilder().setTopicWithTopicName(topic).addAllMessages(messages).build();
        return this.publish(request);
    }

    final PublishResponse publish(PublishRequest request) {
        return (PublishResponse)this.publishCallable().call((Object)request);
    }

    final UnaryCallable<PublishRequest, PublishResponse> publishCallable() {
        return this.stub.publishCallable();
    }

    public final Topic getTopic(TopicName topic) {
        GetTopicRequest request = GetTopicRequest.newBuilder().setTopicWithTopicName(topic).build();
        return this.getTopic(request);
    }

    private final Topic getTopic(GetTopicRequest request) {
        return (Topic)this.getTopicCallable().call((Object)request);
    }

    public final UnaryCallable<GetTopicRequest, Topic> getTopicCallable() {
        return this.stub.getTopicCallable();
    }

    public final PagedResponseWrappers.ListTopicsPagedResponse listTopics(ProjectName project) {
        ListTopicsRequest request = ListTopicsRequest.newBuilder().setProjectWithProjectName(project).build();
        return this.listTopics(request);
    }

    public final PagedResponseWrappers.ListTopicsPagedResponse listTopics(ListTopicsRequest request) {
        return (PagedResponseWrappers.ListTopicsPagedResponse)((Object)this.listTopicsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTopicsRequest, PagedResponseWrappers.ListTopicsPagedResponse> listTopicsPagedCallable() {
        return this.stub.listTopicsPagedCallable();
    }

    public final UnaryCallable<ListTopicsRequest, ListTopicsResponse> listTopicsCallable() {
        return this.stub.listTopicsCallable();
    }

    public final PagedResponseWrappers.ListTopicSubscriptionsPagedResponse listTopicSubscriptions(TopicName topic) {
        ListTopicSubscriptionsRequest request = ListTopicSubscriptionsRequest.newBuilder().setTopicWithTopicName(topic).build();
        return this.listTopicSubscriptions(request);
    }

    public final PagedResponseWrappers.ListTopicSubscriptionsPagedResponse listTopicSubscriptions(ListTopicSubscriptionsRequest request) {
        return (PagedResponseWrappers.ListTopicSubscriptionsPagedResponse)((Object)this.listTopicSubscriptionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTopicSubscriptionsRequest, PagedResponseWrappers.ListTopicSubscriptionsPagedResponse> listTopicSubscriptionsPagedCallable() {
        return this.stub.listTopicSubscriptionsPagedCallable();
    }

    public final UnaryCallable<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse> listTopicSubscriptionsCallable() {
        return this.stub.listTopicSubscriptionsCallable();
    }

    public final void deleteTopic(TopicName topic) {
        DeleteTopicRequest request = DeleteTopicRequest.newBuilder().setTopicWithTopicName(topic).build();
        this.deleteTopic(request);
    }

    private final void deleteTopic(DeleteTopicRequest request) {
        this.deleteTopicCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteTopicRequest, Empty> deleteTopicCallable() {
        return this.stub.deleteTopicCallable();
    }

    public final Policy setIamPolicy(String resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(String resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicy(request);
    }

    private final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(String resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() throws Exception {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

