/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.atomic.AtomicBoolean;

class MessageWaiter {
    private int pendingMessages = 0;

    MessageWaiter() {
    }

    public synchronized void incrementPendingMessages(int messages) {
        this.pendingMessages += messages;
        if (this.pendingMessages == 0) {
            this.notifyAll();
        }
    }

    public synchronized void waitNoMessages() {
        this.waitNoMessages(new AtomicBoolean());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    synchronized void waitNoMessages(AtomicBoolean waitReached) {
        boolean interrupted = false;
        try {
            while (this.pendingMessages > 0) {
                try {
                    waitReached.set(true);
                    this.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @VisibleForTesting
    public int pendingMessages() {
        return this.pendingMessages;
    }
}

