/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.PropertiesProvider;
import com.google.api.gax.grpc.CallContext;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.ClientSettings;
import com.google.api.gax.grpc.ExecutorProvider;
import com.google.api.gax.grpc.InstantiatingChannelProvider;
import com.google.api.gax.grpc.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.PageContext;
import com.google.api.gax.grpc.PagedCallSettings;
import com.google.api.gax.grpc.PagedListDescriptor;
import com.google.api.gax.grpc.PagedListResponseFactory;
import com.google.api.gax.grpc.SimpleCallSettings;
import com.google.api.gax.grpc.StreamingCallSettings;
import com.google.api.gax.grpc.UnaryCallSettings;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.pubsub.v1.PagedResponseWrappers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.pubsub.v1.AcknowledgeRequest;
import com.google.pubsub.v1.CreateSnapshotRequest;
import com.google.pubsub.v1.DeleteSnapshotRequest;
import com.google.pubsub.v1.DeleteSubscriptionRequest;
import com.google.pubsub.v1.GetSubscriptionRequest;
import com.google.pubsub.v1.ListSnapshotsRequest;
import com.google.pubsub.v1.ListSnapshotsResponse;
import com.google.pubsub.v1.ListSubscriptionsRequest;
import com.google.pubsub.v1.ListSubscriptionsResponse;
import com.google.pubsub.v1.ModifyAckDeadlineRequest;
import com.google.pubsub.v1.ModifyPushConfigRequest;
import com.google.pubsub.v1.PullRequest;
import com.google.pubsub.v1.PullResponse;
import com.google.pubsub.v1.SeekRequest;
import com.google.pubsub.v1.SeekResponse;
import com.google.pubsub.v1.Snapshot;
import com.google.pubsub.v1.StreamingPullRequest;
import com.google.pubsub.v1.StreamingPullResponse;
import com.google.pubsub.v1.Subscription;
import com.google.pubsub.v1.UpdateSubscriptionRequest;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class SubscriptionAdminSettings
extends ClientSettings {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/pubsub").build();
    private static final String DEFAULT_GAPIC_NAME = "gapic";
    private static final String DEFAULT_GAPIC_VERSION = "";
    private static final String PROPERTIES_FILE = "/com/google/cloud/pubsub/project.properties";
    private static final String META_VERSION_KEY = "artifact.version";
    private static String gapicVersion;
    private static final MethodDescriptor<Subscription, Subscription> METHOD_CREATE_SUBSCRIPTION;
    private static final MethodDescriptor<GetSubscriptionRequest, Subscription> METHOD_GET_SUBSCRIPTION;
    private static final MethodDescriptor<UpdateSubscriptionRequest, Subscription> METHOD_UPDATE_SUBSCRIPTION;
    private static final MethodDescriptor<ListSubscriptionsRequest, ListSubscriptionsResponse> METHOD_LIST_SUBSCRIPTIONS;
    private static final MethodDescriptor<DeleteSubscriptionRequest, Empty> METHOD_DELETE_SUBSCRIPTION;
    private static final MethodDescriptor<ModifyAckDeadlineRequest, Empty> METHOD_MODIFY_ACK_DEADLINE;
    private static final MethodDescriptor<AcknowledgeRequest, Empty> METHOD_ACKNOWLEDGE;
    private static final MethodDescriptor<PullRequest, PullResponse> METHOD_PULL;
    private static final MethodDescriptor<StreamingPullRequest, StreamingPullResponse> METHOD_STREAMING_PULL;
    private static final MethodDescriptor<ModifyPushConfigRequest, Empty> METHOD_MODIFY_PUSH_CONFIG;
    private static final MethodDescriptor<ListSnapshotsRequest, ListSnapshotsResponse> METHOD_LIST_SNAPSHOTS;
    private static final MethodDescriptor<CreateSnapshotRequest, Snapshot> METHOD_CREATE_SNAPSHOT;
    private static final MethodDescriptor<DeleteSnapshotRequest, Empty> METHOD_DELETE_SNAPSHOT;
    private static final MethodDescriptor<SeekRequest, SeekResponse> METHOD_SEEK;
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> METHOD_SET_IAM_POLICY;
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> METHOD_GET_IAM_POLICY;
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> METHOD_TEST_IAM_PERMISSIONS;
    private final SimpleCallSettings<Subscription, Subscription> createSubscriptionSettings;
    private final SimpleCallSettings<GetSubscriptionRequest, Subscription> getSubscriptionSettings;
    private final SimpleCallSettings<UpdateSubscriptionRequest, Subscription> updateSubscriptionSettings;
    private final PagedCallSettings<ListSubscriptionsRequest, ListSubscriptionsResponse, PagedResponseWrappers.ListSubscriptionsPagedResponse> listSubscriptionsSettings;
    private final SimpleCallSettings<DeleteSubscriptionRequest, Empty> deleteSubscriptionSettings;
    private final SimpleCallSettings<ModifyAckDeadlineRequest, Empty> modifyAckDeadlineSettings;
    private final SimpleCallSettings<AcknowledgeRequest, Empty> acknowledgeSettings;
    private final SimpleCallSettings<PullRequest, PullResponse> pullSettings;
    private final StreamingCallSettings<StreamingPullRequest, StreamingPullResponse> streamingPullSettings;
    private final SimpleCallSettings<ModifyPushConfigRequest, Empty> modifyPushConfigSettings;
    private final PagedCallSettings<ListSnapshotsRequest, ListSnapshotsResponse, PagedResponseWrappers.ListSnapshotsPagedResponse> listSnapshotsSettings;
    private final SimpleCallSettings<CreateSnapshotRequest, Snapshot> createSnapshotSettings;
    private final SimpleCallSettings<DeleteSnapshotRequest, Empty> deleteSnapshotSettings;
    private final SimpleCallSettings<SeekRequest, SeekResponse> seekSettings;
    private final SimpleCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final SimpleCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final SimpleCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription> LIST_SUBSCRIPTIONS_PAGE_STR_DESC;
    private static final PagedListDescriptor<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot> LIST_SNAPSHOTS_PAGE_STR_DESC;
    private static final PagedListResponseFactory<ListSubscriptionsRequest, ListSubscriptionsResponse, PagedResponseWrappers.ListSubscriptionsPagedResponse> LIST_SUBSCRIPTIONS_PAGE_STR_FACT;
    private static final PagedListResponseFactory<ListSnapshotsRequest, ListSnapshotsResponse, PagedResponseWrappers.ListSnapshotsPagedResponse> LIST_SNAPSHOTS_PAGE_STR_FACT;

    public SimpleCallSettings<Subscription, Subscription> createSubscriptionSettings() {
        return this.createSubscriptionSettings;
    }

    public SimpleCallSettings<GetSubscriptionRequest, Subscription> getSubscriptionSettings() {
        return this.getSubscriptionSettings;
    }

    public SimpleCallSettings<UpdateSubscriptionRequest, Subscription> updateSubscriptionSettings() {
        return this.updateSubscriptionSettings;
    }

    public PagedCallSettings<ListSubscriptionsRequest, ListSubscriptionsResponse, PagedResponseWrappers.ListSubscriptionsPagedResponse> listSubscriptionsSettings() {
        return this.listSubscriptionsSettings;
    }

    public SimpleCallSettings<DeleteSubscriptionRequest, Empty> deleteSubscriptionSettings() {
        return this.deleteSubscriptionSettings;
    }

    public SimpleCallSettings<ModifyAckDeadlineRequest, Empty> modifyAckDeadlineSettings() {
        return this.modifyAckDeadlineSettings;
    }

    public SimpleCallSettings<AcknowledgeRequest, Empty> acknowledgeSettings() {
        return this.acknowledgeSettings;
    }

    public SimpleCallSettings<PullRequest, PullResponse> pullSettings() {
        return this.pullSettings;
    }

    public StreamingCallSettings<StreamingPullRequest, StreamingPullResponse> streamingPullSettings() {
        return this.streamingPullSettings;
    }

    public SimpleCallSettings<ModifyPushConfigRequest, Empty> modifyPushConfigSettings() {
        return this.modifyPushConfigSettings;
    }

    public PagedCallSettings<ListSnapshotsRequest, ListSnapshotsResponse, PagedResponseWrappers.ListSnapshotsPagedResponse> listSnapshotsSettings() {
        return this.listSnapshotsSettings;
    }

    public SimpleCallSettings<CreateSnapshotRequest, Snapshot> createSnapshotSettings() {
        return this.createSnapshotSettings;
    }

    public SimpleCallSettings<DeleteSnapshotRequest, Empty> deleteSnapshotSettings() {
        return this.deleteSnapshotSettings;
    }

    public SimpleCallSettings<SeekRequest, SeekResponse> seekSettings() {
        return this.seekSettings;
    }

    public SimpleCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public SimpleCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public SimpleCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "pubsub.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingChannelProvider.Builder defaultChannelProviderBuilder() {
        return InstantiatingChannelProvider.newBuilder().setEndpoint(SubscriptionAdminSettings.getDefaultEndpoint()).setGeneratorHeader(DEFAULT_GAPIC_NAME, SubscriptionAdminSettings.getGapicVersion());
    }

    private static String getGapicVersion() {
        if (gapicVersion == null) {
            gapicVersion = PropertiesProvider.loadProperty(SubscriptionAdminSettings.class, (String)PROPERTIES_FILE, (String)META_VERSION_KEY);
            gapicVersion = gapicVersion == null ? DEFAULT_GAPIC_VERSION : gapicVersion;
        }
        return gapicVersion;
    }

    public static Builder defaultBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private SubscriptionAdminSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder.getExecutorProvider(), settingsBuilder.getChannelProvider(), settingsBuilder.getCredentialsProvider());
        this.createSubscriptionSettings = settingsBuilder.createSubscriptionSettings().build();
        this.getSubscriptionSettings = settingsBuilder.getSubscriptionSettings().build();
        this.updateSubscriptionSettings = settingsBuilder.updateSubscriptionSettings().build();
        this.listSubscriptionsSettings = settingsBuilder.listSubscriptionsSettings().build();
        this.deleteSubscriptionSettings = settingsBuilder.deleteSubscriptionSettings().build();
        this.modifyAckDeadlineSettings = settingsBuilder.modifyAckDeadlineSettings().build();
        this.acknowledgeSettings = settingsBuilder.acknowledgeSettings().build();
        this.pullSettings = settingsBuilder.pullSettings().build();
        this.streamingPullSettings = settingsBuilder.streamingPullSettings().build();
        this.modifyPushConfigSettings = settingsBuilder.modifyPushConfigSettings().build();
        this.listSnapshotsSettings = settingsBuilder.listSnapshotsSettings().build();
        this.createSnapshotSettings = settingsBuilder.createSnapshotSettings().build();
        this.deleteSnapshotSettings = settingsBuilder.deleteSnapshotSettings().build();
        this.seekSettings = settingsBuilder.seekSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    static {
        METHOD_CREATE_SUBSCRIPTION = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.pubsub.v1.Subscriber/CreateSubscription", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Subscription.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Subscription.getDefaultInstance()));
        METHOD_GET_SUBSCRIPTION = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.pubsub.v1.Subscriber/GetSubscription", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)GetSubscriptionRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Subscription.getDefaultInstance()));
        METHOD_UPDATE_SUBSCRIPTION = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.pubsub.v1.Subscriber/UpdateSubscription", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)UpdateSubscriptionRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Subscription.getDefaultInstance()));
        METHOD_LIST_SUBSCRIPTIONS = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.pubsub.v1.Subscriber/ListSubscriptions", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ListSubscriptionsRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ListSubscriptionsResponse.getDefaultInstance()));
        METHOD_DELETE_SUBSCRIPTION = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.pubsub.v1.Subscriber/DeleteSubscription", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)DeleteSubscriptionRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Empty.getDefaultInstance()));
        METHOD_MODIFY_ACK_DEADLINE = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.pubsub.v1.Subscriber/ModifyAckDeadline", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ModifyAckDeadlineRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Empty.getDefaultInstance()));
        METHOD_ACKNOWLEDGE = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.pubsub.v1.Subscriber/Acknowledge", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)AcknowledgeRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Empty.getDefaultInstance()));
        METHOD_PULL = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.pubsub.v1.Subscriber/Pull", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)PullRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)PullResponse.getDefaultInstance()));
        METHOD_STREAMING_PULL = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.BIDI_STREAMING, (String)"google.pubsub.v1.Subscriber/StreamingPull", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)StreamingPullRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)StreamingPullResponse.getDefaultInstance()));
        METHOD_MODIFY_PUSH_CONFIG = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.pubsub.v1.Subscriber/ModifyPushConfig", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ModifyPushConfigRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Empty.getDefaultInstance()));
        METHOD_LIST_SNAPSHOTS = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.pubsub.v1.Subscriber/ListSnapshots", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ListSnapshotsRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ListSnapshotsResponse.getDefaultInstance()));
        METHOD_CREATE_SNAPSHOT = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.pubsub.v1.Subscriber/CreateSnapshot", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)CreateSnapshotRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Snapshot.getDefaultInstance()));
        METHOD_DELETE_SNAPSHOT = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.pubsub.v1.Subscriber/DeleteSnapshot", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)DeleteSnapshotRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Empty.getDefaultInstance()));
        METHOD_SEEK = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.pubsub.v1.Subscriber/Seek", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)SeekRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)SeekResponse.getDefaultInstance()));
        METHOD_SET_IAM_POLICY = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.iam.v1.IAMPolicy/SetIamPolicy", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Policy.getDefaultInstance()));
        METHOD_GET_IAM_POLICY = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.iam.v1.IAMPolicy/GetIamPolicy", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Policy.getDefaultInstance()));
        METHOD_TEST_IAM_PERMISSIONS = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.iam.v1.IAMPolicy/TestIamPermissions", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance()));
        LIST_SUBSCRIPTIONS_PAGE_STR_DESC = new PagedListDescriptor<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription>(){

            public String emptyToken() {
                return SubscriptionAdminSettings.DEFAULT_GAPIC_VERSION;
            }

            public ListSubscriptionsRequest injectToken(ListSubscriptionsRequest payload, String token) {
                return ListSubscriptionsRequest.newBuilder((ListSubscriptionsRequest)payload).setPageToken(token).build();
            }

            public ListSubscriptionsRequest injectPageSize(ListSubscriptionsRequest payload, int pageSize) {
                return ListSubscriptionsRequest.newBuilder((ListSubscriptionsRequest)payload).setPageSize(pageSize).build();
            }

            public Integer extractPageSize(ListSubscriptionsRequest payload) {
                return payload.getPageSize();
            }

            public String extractNextToken(ListSubscriptionsResponse payload) {
                return payload.getNextPageToken();
            }

            public Iterable<Subscription> extractResources(ListSubscriptionsResponse payload) {
                return payload.getSubscriptionsList();
            }
        };
        LIST_SNAPSHOTS_PAGE_STR_DESC = new PagedListDescriptor<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot>(){

            public String emptyToken() {
                return SubscriptionAdminSettings.DEFAULT_GAPIC_VERSION;
            }

            public ListSnapshotsRequest injectToken(ListSnapshotsRequest payload, String token) {
                return ListSnapshotsRequest.newBuilder((ListSnapshotsRequest)payload).setPageToken(token).build();
            }

            public ListSnapshotsRequest injectPageSize(ListSnapshotsRequest payload, int pageSize) {
                return ListSnapshotsRequest.newBuilder((ListSnapshotsRequest)payload).setPageSize(pageSize).build();
            }

            public Integer extractPageSize(ListSnapshotsRequest payload) {
                return payload.getPageSize();
            }

            public String extractNextToken(ListSnapshotsResponse payload) {
                return payload.getNextPageToken();
            }

            public Iterable<Snapshot> extractResources(ListSnapshotsResponse payload) {
                return payload.getSnapshotsList();
            }
        };
        LIST_SUBSCRIPTIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListSubscriptionsRequest, ListSubscriptionsResponse, PagedResponseWrappers.ListSubscriptionsPagedResponse>(){

            public ApiFuture<PagedResponseWrappers.ListSubscriptionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListSubscriptionsRequest, ListSubscriptionsResponse> callable, ListSubscriptionsRequest request, CallContext context, ApiFuture<ListSubscriptionsResponse> futureResponse) {
                PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SUBSCRIPTIONS_PAGE_STR_DESC, (Object)request, (CallContext)context);
                return PagedResponseWrappers.ListSubscriptionsPagedResponse.createAsync((PageContext<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription>)pageContext, futureResponse);
            }
        };
        LIST_SNAPSHOTS_PAGE_STR_FACT = new PagedListResponseFactory<ListSnapshotsRequest, ListSnapshotsResponse, PagedResponseWrappers.ListSnapshotsPagedResponse>(){

            public ApiFuture<PagedResponseWrappers.ListSnapshotsPagedResponse> getFuturePagedResponse(UnaryCallable<ListSnapshotsRequest, ListSnapshotsResponse> callable, ListSnapshotsRequest request, CallContext context, ApiFuture<ListSnapshotsResponse> futureResponse) {
                PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SNAPSHOTS_PAGE_STR_DESC, (Object)request, (CallContext)context);
                return PagedResponseWrappers.ListSnapshotsPagedResponse.createAsync((PageContext<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot>)pageContext, futureResponse);
            }
        };
    }

    public static class Builder
    extends ClientSettings.Builder {
        private final ImmutableList<UnaryCallSettings.Builder> unaryMethodSettingsBuilders;
        private final SimpleCallSettings.Builder<Subscription, Subscription> createSubscriptionSettings;
        private final SimpleCallSettings.Builder<GetSubscriptionRequest, Subscription> getSubscriptionSettings;
        private final SimpleCallSettings.Builder<UpdateSubscriptionRequest, Subscription> updateSubscriptionSettings;
        private final PagedCallSettings.Builder<ListSubscriptionsRequest, ListSubscriptionsResponse, PagedResponseWrappers.ListSubscriptionsPagedResponse> listSubscriptionsSettings;
        private final SimpleCallSettings.Builder<DeleteSubscriptionRequest, Empty> deleteSubscriptionSettings;
        private final SimpleCallSettings.Builder<ModifyAckDeadlineRequest, Empty> modifyAckDeadlineSettings;
        private final SimpleCallSettings.Builder<AcknowledgeRequest, Empty> acknowledgeSettings;
        private final SimpleCallSettings.Builder<PullRequest, PullResponse> pullSettings;
        private final StreamingCallSettings.Builder<StreamingPullRequest, StreamingPullResponse> streamingPullSettings;
        private final SimpleCallSettings.Builder<ModifyPushConfigRequest, Empty> modifyPushConfigSettings;
        private final PagedCallSettings.Builder<ListSnapshotsRequest, ListSnapshotsResponse, PagedResponseWrappers.ListSnapshotsPagedResponse> listSnapshotsSettings;
        private final SimpleCallSettings.Builder<CreateSnapshotRequest, Snapshot> createSnapshotSettings;
        private final SimpleCallSettings.Builder<DeleteSnapshotRequest, Empty> deleteSnapshotSettings;
        private final SimpleCallSettings.Builder<SeekRequest, SeekResponse> seekSettings;
        private final SimpleCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final SimpleCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final SimpleCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<Status.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings.Builder> RETRY_PARAM_DEFINITIONS;

        private Builder() {
            super(SubscriptionAdminSettings.defaultChannelProviderBuilder().build());
            this.setCredentialsProvider((CredentialsProvider)SubscriptionAdminSettings.defaultCredentialsProviderBuilder().build());
            this.createSubscriptionSettings = SimpleCallSettings.newBuilder((MethodDescriptor)METHOD_CREATE_SUBSCRIPTION);
            this.getSubscriptionSettings = SimpleCallSettings.newBuilder((MethodDescriptor)METHOD_GET_SUBSCRIPTION);
            this.updateSubscriptionSettings = SimpleCallSettings.newBuilder((MethodDescriptor)METHOD_UPDATE_SUBSCRIPTION);
            this.listSubscriptionsSettings = PagedCallSettings.newBuilder((MethodDescriptor)METHOD_LIST_SUBSCRIPTIONS, (PagedListResponseFactory)LIST_SUBSCRIPTIONS_PAGE_STR_FACT);
            this.deleteSubscriptionSettings = SimpleCallSettings.newBuilder((MethodDescriptor)METHOD_DELETE_SUBSCRIPTION);
            this.modifyAckDeadlineSettings = SimpleCallSettings.newBuilder((MethodDescriptor)METHOD_MODIFY_ACK_DEADLINE);
            this.acknowledgeSettings = SimpleCallSettings.newBuilder((MethodDescriptor)METHOD_ACKNOWLEDGE);
            this.pullSettings = SimpleCallSettings.newBuilder((MethodDescriptor)METHOD_PULL);
            this.streamingPullSettings = StreamingCallSettings.newBuilder((MethodDescriptor)METHOD_STREAMING_PULL);
            this.modifyPushConfigSettings = SimpleCallSettings.newBuilder((MethodDescriptor)METHOD_MODIFY_PUSH_CONFIG);
            this.listSnapshotsSettings = PagedCallSettings.newBuilder((MethodDescriptor)METHOD_LIST_SNAPSHOTS, (PagedListResponseFactory)LIST_SNAPSHOTS_PAGE_STR_FACT);
            this.createSnapshotSettings = SimpleCallSettings.newBuilder((MethodDescriptor)METHOD_CREATE_SNAPSHOT);
            this.deleteSnapshotSettings = SimpleCallSettings.newBuilder((MethodDescriptor)METHOD_DELETE_SNAPSHOT);
            this.seekSettings = SimpleCallSettings.newBuilder((MethodDescriptor)METHOD_SEEK);
            this.setIamPolicySettings = SimpleCallSettings.newBuilder((MethodDescriptor)METHOD_SET_IAM_POLICY);
            this.getIamPolicySettings = SimpleCallSettings.newBuilder((MethodDescriptor)METHOD_GET_IAM_POLICY);
            this.testIamPermissionsSettings = SimpleCallSettings.newBuilder((MethodDescriptor)METHOD_TEST_IAM_PERMISSIONS);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSubscriptionSettings, this.getSubscriptionSettings, this.updateSubscriptionSettings, this.listSubscriptionsSettings, this.deleteSubscriptionSettings, this.modifyAckDeadlineSettings, this.acknowledgeSettings, this.pullSettings, this.modifyPushConfigSettings, this.listSnapshotsSettings, this.createSnapshotSettings, this.deleteSnapshotSettings, (Object[])new UnaryCallSettings.Builder[]{this.seekSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder();
            builder.createSubscriptionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getSubscriptionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateSubscriptionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listSubscriptionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteSubscriptionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.modifyAckDeadlineSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.acknowledgeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"messaging"));
            builder.pullSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"pull")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"messaging"));
            builder.modifyPushConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listSnapshotsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createSnapshotSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteSnapshotSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.seekSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        private Builder(SubscriptionAdminSettings settings) {
            super((ClientSettings)settings);
            this.createSubscriptionSettings = settings.createSubscriptionSettings.toBuilder();
            this.getSubscriptionSettings = settings.getSubscriptionSettings.toBuilder();
            this.updateSubscriptionSettings = settings.updateSubscriptionSettings.toBuilder();
            this.listSubscriptionsSettings = settings.listSubscriptionsSettings.toBuilder();
            this.deleteSubscriptionSettings = settings.deleteSubscriptionSettings.toBuilder();
            this.modifyAckDeadlineSettings = settings.modifyAckDeadlineSettings.toBuilder();
            this.acknowledgeSettings = settings.acknowledgeSettings.toBuilder();
            this.pullSettings = settings.pullSettings.toBuilder();
            this.streamingPullSettings = settings.streamingPullSettings.toBuilder();
            this.modifyPushConfigSettings = settings.modifyPushConfigSettings.toBuilder();
            this.listSnapshotsSettings = settings.listSnapshotsSettings.toBuilder();
            this.createSnapshotSettings = settings.createSnapshotSettings.toBuilder();
            this.deleteSnapshotSettings = settings.deleteSnapshotSettings.toBuilder();
            this.seekSettings = settings.seekSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSubscriptionSettings, this.getSubscriptionSettings, this.updateSubscriptionSettings, this.listSubscriptionsSettings, this.deleteSubscriptionSettings, this.modifyAckDeadlineSettings, this.acknowledgeSettings, this.pullSettings, this.modifyPushConfigSettings, this.listSnapshotsSettings, this.createSnapshotSettings, this.deleteSnapshotSettings, (Object[])new UnaryCallSettings.Builder[]{this.seekSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            super.setExecutorProvider(executorProvider);
            return this;
        }

        public Builder setChannelProvider(ChannelProvider channelProvider) {
            super.setChannelProvider(channelProvider);
            return this;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            super.setCredentialsProvider(credentialsProvider);
            return this;
        }

        public Builder applyToAllUnaryMethods(UnaryCallSettings.Builder unaryCallSettings) throws Exception {
            super.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, unaryCallSettings);
            return this;
        }

        public SimpleCallSettings.Builder<Subscription, Subscription> createSubscriptionSettings() {
            return this.createSubscriptionSettings;
        }

        public SimpleCallSettings.Builder<GetSubscriptionRequest, Subscription> getSubscriptionSettings() {
            return this.getSubscriptionSettings;
        }

        public SimpleCallSettings.Builder<UpdateSubscriptionRequest, Subscription> updateSubscriptionSettings() {
            return this.updateSubscriptionSettings;
        }

        public PagedCallSettings.Builder<ListSubscriptionsRequest, ListSubscriptionsResponse, PagedResponseWrappers.ListSubscriptionsPagedResponse> listSubscriptionsSettings() {
            return this.listSubscriptionsSettings;
        }

        public SimpleCallSettings.Builder<DeleteSubscriptionRequest, Empty> deleteSubscriptionSettings() {
            return this.deleteSubscriptionSettings;
        }

        public SimpleCallSettings.Builder<ModifyAckDeadlineRequest, Empty> modifyAckDeadlineSettings() {
            return this.modifyAckDeadlineSettings;
        }

        public SimpleCallSettings.Builder<AcknowledgeRequest, Empty> acknowledgeSettings() {
            return this.acknowledgeSettings;
        }

        public SimpleCallSettings.Builder<PullRequest, PullResponse> pullSettings() {
            return this.pullSettings;
        }

        public StreamingCallSettings.Builder<StreamingPullRequest, StreamingPullResponse> streamingPullSettings() {
            return this.streamingPullSettings;
        }

        public SimpleCallSettings.Builder<ModifyPushConfigRequest, Empty> modifyPushConfigSettings() {
            return this.modifyPushConfigSettings;
        }

        public PagedCallSettings.Builder<ListSnapshotsRequest, ListSnapshotsResponse, PagedResponseWrappers.ListSnapshotsPagedResponse> listSnapshotsSettings() {
            return this.listSnapshotsSettings;
        }

        public SimpleCallSettings.Builder<CreateSnapshotRequest, Snapshot> createSnapshotSettings() {
            return this.createSnapshotSettings;
        }

        public SimpleCallSettings.Builder<DeleteSnapshotRequest, Empty> deleteSnapshotSettings() {
            return this.deleteSnapshotSettings;
        }

        public SimpleCallSettings.Builder<SeekRequest, SeekResponse> seekSettings() {
            return this.seekSettings;
        }

        public SimpleCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public SimpleCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public SimpleCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public SubscriptionAdminSettings build() throws IOException {
            return new SubscriptionAdminSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.DEADLINE_EXCEEDED, Status.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.UNAVAILABLE})));
            definitions.put((Object)"pull", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.CANCELLED, Status.Code.DEADLINE_EXCEEDED, Status.Code.RESOURCE_EXHAUSTED, Status.Code.INTERNAL, Status.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings.Builder settingsBuilder = null;
            settingsBuilder = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)600000L));
            definitions.put((Object)"default", (Object)settingsBuilder);
            settingsBuilder = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)12000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)12000L)).setTotalTimeout(Duration.ofMillis((long)600000L));
            definitions.put((Object)"messaging", (Object)settingsBuilder);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

